static char RcsId[] = "@(#)$Header: dc_hash.c,v 3.2 96/02/27 16:53:09 taurel Exp $";

/* $Log:	dc_hash.c,v $
 * Revision 3.2  96/02/27  16:53:09  16:53:09  taurel (Emmanuel TAUREL)
 * Ported to Solaris.
 * 
 * Revision 3.1  93/10/05  17:36:54  17:36:54  taurel (Emmanuel TAUREL)
 * Fix a bug in the device name string copy.
 * 
 * Revision 3.0  93/05/17  17:35:36  17:35:36  taurel (Emmanuel Taurel)
 * Created during the port of dc system to SUN (without RTDB).
 *  */

#include <API.h>
#include <dcP.h>
#include <string.h>
#include <stdlib.h>

DevVarStringArray host_dc;

db_resource res1[] = {
	{"dev_number",D_LONG_TYPE},
		     };

int res1_size = sizeof(res1) / sizeof(db_resource);
int time_out;


/****************************************************************************
*                                                                           *
*		Code for dc_hash command                                    *
*                        -------                                            *
*                                                                           *
*    Command rule : To remove the data collector system from memory  	    *
*		    The data collector system could be distributed on       *
*		    several hosts. This command will retrieve on which host *
*		    this system is running (with resources) and will run a  *
*		    local command (with remote shell) on ecah host          *
*                                                                           *
*    Synopsis : dc_hash <device name>					    *
*                                                                           *
****************************************************************************/


main(argc,argv)
int argc;
char *argv[];
{
	long error;
	static int dev_num;
	char hostna[32];
	char *tmp;
	int i,l;
	int ind;
	unsigned int diff;
	char dev_name[40];
	char devname[60];

/* Argument test */

	if (argc != 2) {
		fprintf(stderr,"dc_hash usage : dc_hash <device name>\n");
		exit(-1);
			}

/* Check device name validity */

	l = strlen(argv[1]);
	for (i=0;i<l;i++)
		devname[i] = tolower(argv[1][i]);
	devname[l] = 0;

	i = 0;
	NB_CHAR(i,argv[1],'/');
	if (i != 2) {
		fprintf(stderr,"%s : Bad device name\n",argv[0]);
		exit(-1);
		}

/* Import static database */

	if (db_import(&error)) {
		fprintf(stderr,"dc_hash : Can't import static database\n");
		fprintf(stderr,"dc_hash : Check your NETHOST environment variable\n");
		exit(-1);
				}

/* Build device name. It is a function of the host name */

	gethostname(hostna,sizeof(hostna));
	if ((tmp = strchr(hostna,'.')) != NULL) {
		diff = (u_int)(tmp - hostna);
		hostna[diff] = 0;
						}
	strcpy(dev_name,"CLASS/DC/");
	strcat(dev_name,hostna);

/* Retrieve data collector hashing table size */

	res1[0].resource_adr = &dev_num;
	if (db_getresource(dev_name,res1,res1_size,&error)) {
		printf("dc_hash : Can't retrieve resources\n");
		printf("dc_hash : Error code : %d\n",error);
		exit(-1);
								  }

/* Do the hashing */

	ind = hash(devname,dev_num);

	printf("Hashing function result : %d\n",ind);
	printf("Offset (hexa) in the ptrs area to device record : %x\n",ind * sizeof(dc_dev_param));

}
