/*+*******************************************************************

 File:          MachNumbers.h

 Project:       Device Servers with SUN-RPC

 Description:   Include file with the definitions for all 
		software of the machine theory group 

 Author(s):     J. Meyer

 Original:      June 1994


 $Author: chaize $

 $Log:	MachDsNumbers.h,v $
 * Revision 1.7  98/02/06  09:02:28  09:02:28  chaize (Jm.Chaize)
 * base for Unidos dosemeter.
 * 
 * Revision 1.6  97/08/18  16:01:42  16:01:42  taurel (E.Taurel)
 * Added Fbps number
 * 
 * Revision 1.5  96/05/14  08:40:22  08:40:22  meyer (J.Meyer)
 * Added brackets around base definition.
 * 
 * Revision 1.4  96/05/13  10:54:07  10:54:07  meyer (J.Meyer)
 * Added macros.h as include file.
 * 
 * Revision 1.3  96/05/06  18:41:54  18:41:54  meyer (J.Meyer)
 * Fortran compatible include file.
 * 
 * Revision 1.2  96/05/06  18:40:20  18:40:20  meyer (J.Meyer)
 * Fortran compatible include file.
 * 
 * Revision 1.1  94/06/15  16:13:26  16:13:26  meyer (Jens Meyer)
 * Initial revision
 * 

 Copyright (c) 1990 by European Synchrotron Radiation Facility,
		       Grenoble, France

********************************************************************-*/
#include <DserverTeams.h>
#include <macros.h>

#ifndef _MachDsNumbers_h
#define _MachDsNumbers_h


/*------- Device server identification ---------*/

#define	AutoCorBase	(MachTeamNumber + DS_LSHIFT(1,DS_IDENT_SHIFT))
#define	AppliBase	(MachTeamNumber + DS_LSHIFT(2,DS_IDENT_SHIFT))
#define	MessageBase	(MachTeamNumber + DS_LSHIFT(3,DS_IDENT_SHIFT))
#define	FbpsBase	(MachTeamNumber + DS_LSHIFT(4,DS_IDENT_SHIFT))
/* base for Unidos dosemeter (J.M. Chaize) */
#define	UnidosBase	(MachTeamNumber + DS_LSHIFT(5,DS_IDENT_SHIFT))

#endif	/* _MachDsNumbers_h */
