static char RcsId[] = "$Header: /segfs/dserver/classes/main/src/RCS/startup.c,v 8.48 2002/09/04 12:55:53 goetz Rel $";

/*********************************************************************

 File:		startup.c

 Project:	Device Servers

 Description:	Generic startup procedure for any class. The
		startup procedure is the first procedure called
		from main() when the device server starts up.
		All toplevel devices to be created for the device 
		server should be done in startup(). The startup 
		should make use of the database to determine which 
		devices it should create. Initialisation of devices
		is normally done from startup().

 Author(s);	A. Goetz 

 Original:	October 1996

 $Log: startup.c,v $
 Revision 8.48  2002/09/04 12:55:53  goetz
 changed char* to string for tango api in tango_api.cpp

 Revision 8.47  2002/06/27 11:57:00  goetz
 fixed bug in stateless import with database

 Revision 8.46  2002/06/25 07:26:29  goetz
 extended stateless import to host down and all rpc errors

 Revision 8.45  2002/06/18 07:44:02  goetz
 NFILE reduced to 100 for OS9

 Revision 8.44  2002/06/11 17:32:44  goetz
 fixed double declaration of i in tango_api.cpp

 Revision 8.43  2002/06/10 12:09:38  goetz
 added Tango::INIT state to tango_api.cpp

 Revision 8.42  2002/05/30 15:11:43  goetz
 ported to C++ on Windows

 Revision 8.41  2002/04/14 13:07:01  goetz
 ported -nodb option to Windows

 * Revision 8.40  2002/03/18  10:10:57  10:10:57  goetz (Andy Goetz)
 * removed ^M from files which were confusing Ultra C++ compiler
 * 
 * Revision 8.39  2002/03/18  05:48:51  05:48:51  goetz (Andy Goetz)
 * added tango_dev_free() and dev_error_clear(); error message in command_handler
 * 
 Revision 8.38  2002/03/13 07:29:25  goetz
 fixed bug initializing struct _devserver to zero; rpc_protocol=D_UDP

 Revision 8.37  2002/03/11 14:20:20  goetz
 initalise prog_number and config_flags to zero at startup

 Revision 8.36  2002/03/07 15:58:45  goetz
 fixed leak in extract_device_name

 Revision 8.35  2002/03/06 22:08:43  goetz
 made stateless import and reimport work for no database devices

 Revision 8.34  2002/03/06 21:00:08  goetz
 added -nodb option to device_server(); suppressed -m -s; improved dev_cmd_query

 Revision 8.33  2002/03/05 11:52:48  goetz
 added command name to C++ commands_list, asynchronous and events support -nodb

 Revision 8.32  2002/03/03 22:45:06  goetz
 added TACO-lite option i.e. no database

 Revision 8.31  2002/02/28 12:13:06  goetz
 setup_config() and setup_config_multi() now call rpc_nt_init() for Windows

 Revision 8.30  2001/11/12 09:59:59  goetz
 updated C port for Windows 95/98/NT using Visual C++ 6

 Revision 8.29  2001/07/26 05:05:09  goetz
 fixed error in CORBA::is_nil() test

 Revision 8.28  2001/07/25 13:13:15  goetz
 tango cmd_query in_name and out_name left NULL; desc replaces reason for errors

 Revision 8.27  2001/07/25 13:05:39  goetz
 added space to dev_error_str() string; test CORBA::is_nil() for tango database

 Revision 8.26  2001/04/10 14:24:34  goetz
 set timeout on tango devices to 3 seconds

 Revision 8.25  2001/03/20 11:56:39  goetz
 DevCmdNameList searched before database for commands in tango_api.cpp

 Revision 8.24  2001/03/10 16:38:20  goetz
 ported tango_api to TANGO 2

 Revision 8.23  2001/02/28 12:26:48  goetz
 converted TANGO states to TACO states

 Revision 8.22  2001/01/16 10:09:45  goetz
 applied J.Quick's patch for security; removed stderr from DevServerMain.c

 * Revision 8.21  2001/01/15  11:36:40  11:36:40  goetz (Andy Goetz)
 * added check for ds == NULL in all dev_ api routines; changed ds__signal prototype
 * 
 Revision 8.20  2001/01/08 13:14:53  goetz
 added patch by B.Pedersen to support querying events

 Revision 8.19  2000/12/11 12:06:47  goetz
 fixed bugs with TANGO interface returning unsigned values and states

 Revision 8.18  2000/11/12 13:24:03  goetz
 added dynamic error handling; improved TANGO error treatment

 Revision 8.17  1900/09/26 13:36:37  goetz
 tango_dev_putget() and tango_dev_putget_raw() implement immediate reconnection

 * Revision 8.16  2000/09/25  14:50:16  14:50:16  goetz (Andy Goetz)
 * tango_api implements TANGO_HOST, stateless import and reimport
 * 
 * Revision 8.15  20/0./7.  1.:6.:9.  1.:6.:9.  goetz (Andy Goetz)
 * changed from tango database to host mysql, added support for float and double arrays
 * 
 * Revision 8.14  20/0./6.  2.:4.:0.  2.:4.:0.  goetz (Andy Goetz)
 * fixed bug in dev_event_listen() which caused server to crash
 * 
 Revision 8.13  2000/06/02 21:56:53  goetz
 _DEVICE_H now _TANGO_DEVICE_H in Device.H; (char*)taco_tango

 Revision 8.12  2000/06/02 15:58:10  goetz
 dev_event_fire() now device specific; ported to SuSE V6.4

 Revision 8.11  2000/05/31 07:47:57  goetz
 tango_api has local copies of argc and argv, ported to HP-UX

 * Revision 8.10  2000/05/29  21:39:23  21:39:23  goetz (Andrew GOETZ)
 * fixed prototyping problems with C++ on HP-UX
 * 
 * Revision 8.9  2000/05/29  18:13:33  18:13:33  goetz (Andrew GOETZ)
 * fixed bug in dev_import_timeout() which prevented timeouts < 2s
 * 
 Revision 8.8  2000/05/02 15:32:17  goetz
 added prototype for tsleep() for OS9 C++

 * Revision 8.7  2000/05/02  14:19:39  14:19:39  goetz (Andy Goetz)
 * removed check for device server running on different host
 * 
 * Revision 8.6  2000/05/02  13:29:32  13:29:32  goetz (Andy Goetz)
 * added random sleep to gettransient + 3 retries
 * 
 Revision 8.5  2000/03/27 17:13:45  goetz
 declared pmap_getmaps() as external C function for OS9 C++

 Revision 8.4  2000/03/13 14:50:02  goetz
 import timeout now programmable using dev_import_timeout()

 Revision 8.3  2000/03/13 10:31:35  goetz
 added Jens' modifications to fix bug in local putget

 Revision 8.2  2000/03/10 17:01:23  goetz
 dev_synch() now excludes udp clients and new imports

 Revision 8.1  2000/01/18 16:48:52  goetz
 tango_dev_import() now only called in dev_import if -DTANGO

 Revision 8.0  1999/12/28 14:18:31  goetz
 added TANGO support for TACO dev_xxx() calls via -DTANGO for C++

 Revision 7.10  1999/11/25 08:27:13  goetz
 replaced fprintf(stderr) with printf; made startup() C++ compatible

 Revision 7.9  1999/11/22 20:18:59  goetz
 removed const from gettransient() prototype

 Revision 7.8  1999/11/21 20:45:37  goetz
 included all M.Diehl's patches (major changes to gettransient() + main())

 Revision 7.7  1999/11/18 22:29:02  goetz
 fixed event multi-client bug, free client handle after event_listen, timeout in dev_synch()

 Revision 7.6  1999/11/01 19:05:16  goetz
 make local copy of user name returned by getpwuid() in sec_api.c

 Revision 7.5  1999/08/06 17:44:15  goetz
 removed usage of varargs for g++ on solaris and hpux

 * Revision 7.4  99/07/09  05:15:27  05:15:27  goetz (Andy Goetz)
 * added M.Diehl's patch to DevServerSig.c to exit() after calling unregister_server()
 * 
 Revision 7.3  1999/06/07 15:27:03  goetz
 fixed bug with multi-nethost reimport, device name stored with nethost

 Revision 7.2  1999/05/12 15:22:05  goetz
 changed dev_event_fire() to void; fixed bug in dev_event_unlisten()

 * Revision 7.1  99/05/11  15:59:53  15:59:53  goetz (Andy Goetz)
 * replace static declaration of event_client[] array by malloc()
 * 
 Revision 7.0  1999/04/26 07:30:45  goetz
 implemented user events (added event_api.c)

 Revision 6.15  1999/03/27 09:00:23  goetz
 asynch_cleanup() only checks for asynch clients; C++ returns output arguments if DS_WARNING

 * Revision 6.14  99/02/27  15:21:23  15:21:23  goetz (Andy Goetz)
 * fixed reimport bug; disabled reimport for rpc version 1
 * 
 Revision 6.13  1999/02/05 00:50:30  goetz
 fixed reimport socket+memory leak; ported to aCC on HPUX; suppressed rpc errors

 * Revision 6.12  99/01/18  21:39:07  21:39:07  goetz (Andy Goetz)
 * suppressed test for RPC_TIMEDOUT in svc_check()
 * 
 * Revision 6.11  99/01/14  23:14:56  23:14:56  goetz (Andy Goetz)
 * dbase timeout = 4 s; unregister ver. 1; svc_check() handles RPC_TIMEDOUT
 * 
 * Revision 6.10  98/12/22  10:29:50  10:29:50  taurel (E.Taurel)
 * Added support for Solaris and HP C++ native compiler. Remove K_R C support
 * 
 * Revision 6.9  98/12/15  14:05:10  14:05:10  goetz (Andy Goetz)
 * unregister RPC; use pgm no. 1 as flag; dev_pending() checks timeout; extern C prototype
 * 
 * Revision 6.8  98/11/20  14:35:39  14:35:39  goetz (Andy Goetz)
 * unregister API_VERSION (4) correctly now + check return value of svc_register()
 * 
 * Revision 6.7  98/11/20  10:35:05  10:35:05  goetz (Andy Goetz)
 * improved gettrans_ut(); multi-config_flags=0; removde static client_data; fixed linux select() bug; only register pgm # 0,4,5; portmap address == 111
 * 
 * Revision 6.6  98/09/24  09:25:12  09:25:12  goetz (Andy Goetz)
 * fixed stupid type which reintroduced asynchronous memory leak
 * 
 * Revision 6.5  98/08/26  16:20:36  16:20:36  goetz (Andy Goetz)
 * added dynamic NETHOST allocation, fixed bug in db_setup_multi, ported to Irix 6.4
 * 
 * Revision 6.4  98/04/29  10:21:25  10:21:25  goetz (Andy Goetz)
 * asynchronous - memory leak fixed, OS9 bug fixed, stale handle cleanup, pending=300
 * 
 * Revision 6.3  97/12/10  15:28:36  15:28:36  meyer (J.Meyer)
 * Changed select() timeout in rpc_check_host() to 200ms
 * 
 * Revision 6.2  97/12/01  12:59:18  12:59:18  goetz (Andy Goetz)
 * intermediate checkin before opening 5.14.1 branch
 * 
 * Revision 6.1  97/11/20  21:49:28  21:49:28  goetz (Andy Goetz)
 * main() continue even if cannot register asynch rpc
 * 
 * Revision 6.0  97/11/03  17:22:29  17:22:29  goetz (Andy Goetz)
 * merged synchronous and asynchronous branches
 * 
 Revision 5.15  1997/10/24 15:27:02  klotz
 ported to Windows NT 4.0 + NMSDK 5.0 ; tested with TextTalkds ; new DevServerMain.c

 * Revision 5.14  97/09/25  17:36:43  17:36:43  goetz (Andy Goetz)
 * fixed
 * 
 Revision 5.13  1997/09/03 17:34:36  meyer
 Added casting for ucc++ in DevServerSig.c

 * Revision 5.12  97/09/03  15:54:12  15:54:12  meyer (J.Meyer)
 * Changed OS9 signal handling from intercept() to signal().
 * 
 * Revision 5.11  97/08/05  14:19:30  14:19:30  goetz (Andy Goetz)
 * ported to VxWork 5.2, pgm. no. based on CRC, -m suppressed, -ve errors bug fix
 * 
 * Revision 5.10  97/03/14  17:26:12  17:26:12  dserver ()
 * fixed bug with open file handles after free
 * 
 * Revision 5.8.1.4  97/03/14  17:24:51  17:24:51  goetz (Andy Goetz)
 * fixed bug with open file handles after free
 * 
 * Revision 5.9  97/03/13  11:17:14  11:17:14  klotz (W.D. Klotz)
 * first part of NT4.0 port
 * 
 * Revision 5.8  97/01/31  12:06:23  12:06:23  goetz (Andy Goetz)
 * dev_protocol(), Linux+security bug fixes, dev_import() ignores timeout on NULL procedure, svc_run for OS9
 * 
 * Revision 5.7  97/01/14  08:57:20  08:57:20  goetz (Andy Goetz)
 * added stateless to dev_free(),_raw(),_asyn(),_protocol(),_timeout()
 * 
 * Revision 5.6  97/01/12  18:33:40  18:33:40  goetz (Andy Goetz)
 * dev_import() now stateless i.e. import works even if server is not running
 * 
 * Revision 5.5  97/01/08  17:02:29  17:02:29  goetz (Andy Goetz)
 * Ported to Linux (2.0.9)
 * 
 * Revision 5.4  96/11/27  09:58:15  09:58:15  goetz (Andy Goetz)
 * removed rpc admin interface from DevServerMain.c; putenv() suppressed for _UCC
 * 
 * Revision 5.3  96/11/26  16:24:41  16:24:41  goetz (Andy Goetz)
 * fixed bug (i_nethost=0) in dev_import_local()
 * 
 * Revision 5.2  96/11/26  13:31:04  13:31:04  goetz (Andy Goetz)
 * OICDevice (C++ wrapper for OIC) added + fixed multi-nethost memory leaks
 * 
 * Revision 5.1  96/11/04  11:00:09  11:00:09  goetz (Andy Goetz)
 * added multi nethost support
 * 
 * Revision 4.39  96/10/21  16:15:10  16:15:10  taurel (E.Taurel)
 * Check in after port to MICROWARE ISP 2.1,
 * RPC 1.4
 * 
 * Revision 1.1  95/07/27  17:54:57  17:54:57  goetz (Andy Goetz)
 * Initial revision
 * 

 Copyleft (c) 1990 by European Synchrotron Radiation Facility, 
                      Grenoble, France



 *********************************************************************/

#include <Admin.h>
#include <API.h>
#include <DevServer.h>
#include <DevErrors.h>
#include <DevServerP.h>

extern long debug_flag;

/********************/
/* generic startup */
/*******************/

long startup(char *svr_name, long *error)
{

#ifndef __cplusplus
   DevServer ds_list[1];
#else
   Device *ds_list[1];
#endif /* __cplusplus */ 
   int i,status;
/*
 * pointer to list of devices returned by database.
 */ 
   char **dev_list;
   unsigned int dev_no;

/*   debug_flag = (DEBUG_ON_OFF | DBG_TRACE | DBG_DEV_SVR_CLASS | DBG_API);*/


   if (db_getdevlist(svr_name,&dev_list,&dev_no,error))
   {
      printf("startup(): db_getdevlist() failed, error %d\n",*error);
      return(-1);
   }
   else
   {
      printf("following devices found in static database \n\n");
      for (i=0;i<dev_no;i++)
      {
         printf("%s\n",dev_list[i]);
      }
   }

/*
 * create, initialise and export all devices served by this server
 */

   for (i=0; i < dev_no; i++)
   {
#ifndef __cplusplus
      if (ds__create(dev_list[i], devServerClass, &(ds_list[i]),error) != 0)
#else
      if ((ds_list[i] = new Device(dev_list[i],error)) != NULL)
#endif /* __cplusplus */ 
      {
         return(-1);
      }

/*
 * initialise the newly created powersupply
 */ 
  
      if (ds__method_finder(ds_list[i],DevMethodInitialise)(ds_list[i],error) != 0)
      {
         return(-1);
      }

/*
 * now export it to the outside world
 */

      printf("created %s, going to export it\n",dev_list[i]);
      if (dev_export(dev_list[i],ds_list[i],error) != 0)
      {
         return(-1);
      }
      printf("export worked\n");

   }

   printf("left startup and all's OK\n");
   return(0);
}


