//static char RcsId[] = "$Header: /segfs/dserver/classes++/device/include/RCS/Device.H,v 8.48 2002/09/04 12:55:54 goetz Rel $";

//+**********************************************************************
//
// File:		Device.h
//
// Project:	Device Servers in C++
//
// Description:	public include file containing definitions and declarations 
//		for implementing the device server Device base class in C++
//		(DeviceClass).
//
// Author(s):	Andy Goetz
//
// Original:	February 1995
//
// $Revision: 8.48 $
//
// $Date: 2002/09/04 12:55:54 $
//
// $Author: goetz $
//
// $Log: Device.H,v $
// Revision 8.48  2002/09/04 12:55:54  goetz
// changed char* to string for tango api in tango_api.cpp
//
// Revision 8.47  2002/06/27 11:57:01  goetz
// fixed bug in stateless import with database
//
// Revision 8.46  2002/06/25 07:26:30  goetz
// extended stateless import to host down and all rpc errors
//
// Revision 8.45  2002/06/18 07:44:04  goetz
// NFILE reduced to 100 for OS9
//
// Revision 8.44  2002/06/11 17:32:51  goetz
// fixed double declaration of i in tango_api.cpp
//
// Revision 8.43  2002/06/10 12:09:40  goetz
// added Tango::INIT state to tango_api.cpp
//
// Revision 8.42  2002/05/30 15:11:45  goetz
// ported to C++ on Windows
//
// Revision 8.41  2002/04/14 13:13:40  goetz
// ported -nodb option to Windows
//
//Revision 8.40  2002/03/18  10:11:05  10:11:05  goetz (Andy Goetz)
//removed ^M from files which were confusing Ultra C++ compiler
//
//Revision 8.39  2002/03/18  05:48:53  05:48:53  goetz (Andy Goetz)
//added tango_dev_free() and dev_error_clear(); error message in command_handler
//
// Revision 8.38  2002/03/13 07:29:26  goetz
// fixed bug initializing struct _devserver to zero; rpc_protocol=D_UDP
//
// Revision 8.37  2002/03/11 14:20:21  goetz
// initalise prog_number and config_flags to zero at startup
//
// Revision 8.36  2002/03/07 15:58:46  goetz
// fixed leak in extract_device_name
//
// Revision 8.35  2002/03/06 22:08:44  goetz
// made stateless import and reimport work for no database devices
//
// Revision 8.34  2002/03/06 21:00:09  goetz
// added -nodb option to device_server(); suppressed -m -s; improved dev_cmd_query
//
// Revision 8.33  2002/03/05 11:52:49  goetz
// added command name to C++ commands_list, asynchronous and events support -nodb
//
// Revision 8.32  2002/03/03 22:45:13  goetz
// added TACO-lite option i.e. no database
//
// Revision 8.31  2002/02/28 12:13:07  goetz
// setup_config() and setup_config_multi() now call rpc_nt_init() for Windows
//
// Revision 8.30  2001/11/12 10:00:01  goetz
// updated C port for Windows 95/98/NT using Visual C++ 6
//
// Revision 8.29  2001/07/26 05:05:10  goetz
// fixed error in CORBA::is_nil() test
//
// Revision 8.28  2001/07/25 13:13:16  goetz
// tango cmd_query in_name and out_name left NULL; desc replaces reason for errors
//
// Revision 8.27  2001/07/25 13:05:41  goetz
// added space to dev_error_str() string; test CORBA::is_nil() for tango database
//
// Revision 8.26  2001/04/10 14:24:35  goetz
// set timeout on tango devices to 3 seconds
//
// Revision 8.25  2001/03/20 11:56:40  goetz
// DevCmdNameList searched before database for commands in tango_api.cpp
//
// Revision 8.24  2001/03/10 16:38:22  goetz
// ported tango_api to TANGO 2
//
// Revision 8.23  2001/02/28 12:26:50  goetz
// converted TANGO states to TACO states
//
// Revision 8.22  2001/01/16 10:09:46  goetz
// applied J.Quick's patch for security; removed stderr from DevServerMain.c
//
//Revision 8.21  2001/01/15  11:36:44  11:36:44  goetz (Andy Goetz)
//added check for ds == NULL in all dev_ api routines; changed ds__signal prototype
//
// Revision 8.20  2001/01/08 13:14:58  goetz
// added patch by B.Pedersen to support querying events
//
// Revision 8.32  2000/07/28 09:59:52  dserver
// BP: added dev_query_event to get event parameters
//     -> new data struture  for event list in server
//        events have to be registered by the server,
//        similar to commands.
//
// Revision 8.19  2000/12/11 12:06:51  goetz
// fixed bugs with TANGO interface returning unsigned values and states
//
// Revision 8.18  2000/11/12 13:24:05  goetz
// added dynamic error handling; improved TANGO error treatment
//
// Revision 8.17  1900/09/26 13:36:43  goetz
// tango_dev_putget() and tango_dev_putget_raw() implement immediate reconnection
//
//Revision 8.16  2000/09/25  14:50:20  14:50:20  goetz (Andy Goetz)
//tango_api implements TANGO_HOST, stateless import and reimport
//
//Revision 8.15  20/0./7.  1.:6.:9.  1.:6.:9.  goetz (Andy Goetz)
//changed from tango database to host mysql, added support for float and double arrays
//
//Revision 8.14  20/0./6.  2.:4.:0.  2.:4.:0.  goetz (Andy Goetz)
//fixed bug in dev_event_listen() which caused server to crash
//
// Revision 8.13  2000/06/02 21:56:58  goetz
// _DEVICE_H now _TANGO_DEVICE_H in Device.H; (char*)taco_tango
//
// Revision 8.12  2000/06/02 15:58:15  goetz
// dev_event_fire() now device specific; ported to SuSE V6.4
//
// Revision 8.11  2000/05/31 07:48:03  goetz
// tango_api has local copies of argc and argv, ported to HP-UX
//
//Revision 8.10  2000/05/29  21:39:28  21:39:28  goetz (Andrew GOETZ)
//fixed prototyping problems with C++ on HP-UX
//
//Revision 8.9  2000/05/29  18:13:38  18:13:38  goetz (Andrew GOETZ)
//fixed bug in dev_import_timeout() which prevented timeouts < 2s
//
// Revision 8.8  2000/05/02 15:32:22  goetz
// added prototype for tsleep() for OS9 C++
//
//Revision 8.7  2000/05/02  14:19:44  14:19:44  goetz (Andy Goetz)
//removed check for device server running on different host
//
//Revision 8.6  2000/05/02  13:29:38  13:29:38  goetz (Andy Goetz)
//added random sleep to gettransient + 3 retries
//
// Revision 8.5  2000/03/27 17:13:49  goetz
// declared pmap_getmaps() as external C function for OS9 C++
//
// Revision 8.4  2000/03/13 14:50:06  goetz
// import timeout now programmable using dev_import_timeout()
//
// Revision 8.3  2000/03/13 10:33:34  goetz
// *** empty log message ***
//
//+**********************************************************************

#ifndef _TACO_DEVICE_H
#define _TACO_DEVICE_H
		

// Some remarks about the Device class definition
//
// 1 - Members class_name and dev_type should not be defined as static members
//     otherwise, there will be only one copy of them for the device server
//     process and it is not possible to correctly handle device server
//     with several embedded classes
//     Therefore, don't forget to initialize them in the object constructor
//     and not in the class_initialise function which is executed only once
//     for a class.
typedef long DevEvent  ;
//
// 2 - The State and Status member function are declared as public. This is due
//     to the OS-9 C++ compiler. To reuse them in a device derived class
//     (by specifying a pointer to them in the command list), the OS-9 compiler
//     needs the function to be declared as public !!
//


class Device {

//
// private members
//

private :

//
// private virtual functions which should be defined in each new sub-class
//

   static short class_inited;

   virtual long ClassInitialise( long *error );
   virtual long GetResources (char *res_name, long *error); // pure virtual


//
// public members
//

public:

typedef long (Device::* DeviceMemberFunction)(void*, void*, long* );
typedef struct _DeviceCommandListEntry {
                                     DevCommand         cmd;
                                     DeviceMemberFunction  fn;
                                     DevArgType         argin_type;
                                     DevArgType         argout_type;
                                     long               min_access;
                                     char               *cmd_name;
                                    }
               DeviceCommandListEntry;

typedef struct _DeviceCommandListEntry *DeviceCommandList;

typedef struct _DeviceEventListEntry {
                                     DevEvent         	event;
                                     DevArgType         argout_type;
                                     char               *event_name;
                                    }
               DeviceEventListEntry;

typedef struct _DeviceEventListEntry *DeviceEventList;

   virtual long State(void *vargin, void *vargout , long *error);
   virtual long Status(void *vargin, void *vargout, long *error);

// 
// class variables
//
  
   char* class_name;
   char dev_type[24];

   char* name;

   Device (DevString name, long *error);
   virtual ~Device ();
//
// following method is "virtual" which means derived classes can
// override it with their own version
//
   virtual long Command ( long cmd, 
                  void *argin, long argin_type,
                  void *argout, long argout_type, 
                  long *error);
   void  Get_event_number(unsigned int *);
   long  Event_Query(_dev_event_info *,long *);
   long  Get_min_access_right(long,long *,long *);
   void  Get_command_number(unsigned int *);
   void  Get_command_name(unsigned int *, char *);
   long  Command_Query(_dev_cmd_info *,long *);
   DeviceCommandList commands_list;
   DeviceEventList events_list;
   

//
// protected members - accessible only be derived classes
// 

protected:


//
// the following virtual commands must exist in all new sub-classes
//
   virtual long StateMachine( long cmd, long *error);
   long n_events;

   
   long state; // device state
   long n_state; // convenience variable for storing next device state
   long n_commands;
   
};


#define TYPE_DEFAULT		"DevType_Default"
#define TYPE_INIT 		"DevType_"

#endif /* _TACO_DEVICE_H */
