static char RcsId[] = "@(#)$Header: /segfs/dbase/res/clnt/RCS/setacc_cli.c,v 6.16 2002/04/09 13:47:24 goetz Rel $";

/*+*******************************************************************

 File       :   setacc_cli.c

 Project    :   Static database

 Description:   Application Programmers Interface

            :   Interface to access static database

 Author(s)  :   Emmanuel Taurel

 Original   :   January 1991


 * $Log: setacc_cli.c,v $
 * Revision 6.16  2002/04/09 13:47:24  goetz
 * ported to Windows
 *
 * Revision 6.15  2002/03/07 15:47:51  goetz
 * added no database to db_getdevlist(), error DbErr_NoDatabase to others
 *
 * Revision 6.14  2001/09/12 14:53:02  taurel
 * Add db_exp.cpp file with function to get Tango device name in db_getdevexp call (C++ only)
 *
 * Revision 6.13  2001/01/23  14:25:06  14:25:06  taurel (E.Taurel)
 * Remove test on resource length (for String) in the put_resource call
 * 
 * Revision 6.12  2001/01/08  13:29:17  13:29:17  goetz (Andy Goetz)
 * added J.Quick's patch to support double arrays for resources
 * 
 * Revision 6.11  2001/01/08 11:46:14  goetz
 * added patch by B.Pedersen to support querying events
 *
 * Revision 6.10  2000/06/22 19:18:05  goetz
 * added support for D_USHORT_TYPE and D_ULONG_TYPE
 *
 * Revision 6.9  1999/07/08 15:44:27  goetz
 * added J.Quick's patch to fix reconnection bug on Linux
 *
 * Revision 6.8  1999/06/07 15:48:11  goetz
 * replace name with name_copy in db_dev_import()
 *
 * Revision 6.7  1999/02/22 17:17:20  taurel
 * Fix another bug in reconnection. This bug increases open f. for db_putresource and db_getresource
 *
 * Revision 6.6  99/02/04  12:51:19  12:51:19  taurel (E.Taurel)
 * Add a clnt_destroy in reconnect function to avoid mem. and open file leak
 * 
 * Revision 6.5  98/12/01  13:26:48  13:26:48  taurel (E.Taurel)
 * Added call to init resource cache
 * 
 * Revision 6.4  98/10/26  16:33:45  16:33:45  taurel (E.Taurel)
 * Fix a bug in the db_delreslist call (setacc_cli.c file)
 * 
 * Revision 6.3  98/10/12  16:10:33  16:10:33  taurel (E.Taurel)
 * Added a new call db_delreslist. Reconnection in its own file. Fix miscellaneous small bugs
 * 
 * Revision 6.2  98/09/01  16:21:21  16:21:21  taurel (E.Taurel)
 * Adapted to any number of nethost
 * 
 * Revision 6.1  98/08/21  08:51:56  08:51:56  taurel (E.Taurel)
 * Fix a little bug in tools_cli.c file.
 * 
 * Revision 6.0  98/08/14  08:55:00  08:55:00  taurel (E.Taurel)
 * Added many calls to server in order to have all utilities server oriented
 * 
 * Revision 5.15  97/12/01  15:35:38  15:35:38  klotz (W.D. Klotz)
 * WIN_NT_95_released_NOV_97
 * 
 * Revision 5.10  97/08/07  10:04:36  10:04:36  goetz (Andy Goetz)
 * ported to VxWorks
 * 
 * Revision 5.9  97/01/07  15:36:46  15:36:46  goetz (Andy Goetz)
 * Ported to Linux (2.0.9)
 * 
 * Revision 5.8  1996/11/26 10:12:54  taurel
 * Fix a bug in the arg. checking in the db_getresource function.
 *
 * Revision 5.7  96/11/22  17:42:00  17:42:00  taurel (E.Taurel)
 * Adapted to new release of setup_config
 * 
 * Revision 5.6  96/11/21  14:59:05  14:59:05  taurel (E.Taurel)
 * Fix_bug_in_db_reconnection_and_in_multi_nethost_implementatio
 * 
 * Revision 5.5  96/11/21  13:11:40  13:11:40  taurel (E.Taurel)
 * Fix bug in db reconnection and in the multi nethost implementation
 * of db_getresource
 * 
 * Revision 5.4  96/11/04  13:51:18  13:51:18  goetz (Andy Goetz)
 * added
 * 
 * Revision 5.3  96/10/21  15:53:39  15:53:39  taurel (E.Taurel)
 * Checked in after port to Windows NT
 * 
 * Revision 5.2  96/09/17  17:25:41  17:25:41  klotz (W.D. Klotz)
 * WD Klotz: checked NT build
 * 
 * Revision 5.1  96/06/06  08:49:09  08:49:09  taurel (E.Taurel)
 * Clarify ifdef definition for the PC port.
 * 
 * Revision 5.0  96/06/05  10:51:27  10:51:27  taurel (E.Taurel)
 * I forgot to specify release number during the prvious check-in !
 * Initial revision
 * 
 *-*******************************************************************/

#define PORTMAP

#include <macros.h>
#include <db_setup.h>
#include <db_xdr.h>

#if defined(_NT)
#include <API.h>
#include <ApiP.h>
#include <DevErrors.h>
#include <rpc.h>

#else
#include <API.h>
#include <private/ApiP.h>
#include <DevErrors.h>

#ifdef _OSK
#include <inet/socket.h>
#include <inet/netdb.h>
#include <strings.h>
#else
#include <string.h>
#include <sys/socket.h>
#ifndef vxworks
#include <netdb.h>
#else
#include <hostLib.h>
#include <taskLib.h>
#endif
#include <unistd.h>
#endif /* _OSK */
#endif	/* _NT */

#ifndef OSK
#include <stdlib.h>
#endif

#include <math.h>

#ifdef __STDCPP__
#include <vector>
#include <string>
#endif

#ifdef ALONE
CLIENT *cl;
int first = 0;
#else
extern dbserver_info db_info;
extern configuration_flags config_flags;
extern msgserver_info msg_info;
#endif /* ALONE */

#define SIZE_A	20
#define SIZE_B	40
#define SIZE_C	80

int test_star PT_((char *filter));

/* Static and Global variables */

int func_ptr = 0;
devexp_res *tab_clstu;
static struct timeval timeout_resource={15,0};

static int first_devexp = 0;
static int first_tcp_call = 0;
static struct sockaddr_in serv_adr;
#ifndef vxworks
static struct hostent *ht;
#else
static int host_addr;
#endif


/*
 * global variable defined in gen_api.c which keeps track of
 * multiple nethosts
 */

extern nethost_info *multi_nethost;


/****************************************************************************
*                                                                           *
*		db_getresource function code                                *
*               --------------                                              *
*                                                                           *
*    Function rule : To retrieve a resource value. The resource value is    *
*                    stored as a atring in a database on a remote           *
*                    computer                                               *
*                                                                           *
*    Argins : - A pointer to a string which defines the device name         *
*             - A pointer to an array of db_resource structure defining the *
*               resource to be retrieved                                    *
*             - The number of resource to be retrieved                      *
*                                                                           *
*    Argout : - The error code if any                                       *
*                                                                           *
*    In case of trouble, the function returns -1 and set the err varaible   *
*    pointed to by "perr". Otherwise, the function returns 0                *
*                                                                           *
*****************************************************************************/

int _DLLFunc db_getresource(char *dev_name, Db_resource res, 
			    u_int res_num,long *perr)
{
	db_res *recev;
	arr1 send;
	int i,j,k,l,ctr;
	int tcp_used = 0;
	short tmp_short;
	char numb[SIZE_A];
	char *char_ptr;
	short *short_ptr;
	long *long_ptr;
	float *float_ptr;
	double *double_ptr;
	char **str_ptr;
	char *ptrc;
	char *ptra;
	u_int diff;
	register char *temp,*tmp;
	CLIENT *tcp_cl;
	int tcp_so;
	long error;
	long i_nethost;
	char nethost[40];
long try_reconnect = False;
#ifndef _OSK
	struct timeval tout;
#endif
#ifdef ALONE
	char *serv_name = ALONE_SERVER_HOST;
#endif /* ALONE */

/* Try to verify the function parameters (non NULL pointer and two \
   characters in device name) */

	if (config_flags.no_database)
	{
		*perr = DbErr_NoDatabase;
		return(DS_NOTOK);
	}

	if (dev_name == NULL || res == NULL || res_num == 0)
	{
		*perr = DbErr_BadParameters;
		return(-1);
	}

	for (i=0;i<(int)res_num;i++)
	{
		if (res[i].resource_name == NULL || res[i].resource_adr == NULL)
		{
			*perr = DbErr_BadParameters;
			return(-1);
		}
	}

/* Check if device name follows naming conventions. If the nethost is specified,
   checks syntax. If it is not specified, only count the / number */

	if (dev_name[0] == '/')
	{
		l = 0;
		NB_CHAR(l,dev_name,'/');
		if (l != 5)
		{
			*perr = DbErr_BadParameters;
			return(-1);
		}
		else
		{
			if (dev_name[1] != '/')
			{
				*perr = DbErr_BadParameters;
				return(-1);
			}
		}
	}
	else
	{
		l = 0;
		NB_CHAR(l,dev_name,'/');
		if (l != 2)
		{
			*perr = DbErr_BadParameters;
			return(-1);
		}
	}


#ifdef ALONE
/* Create RPC connection if it's the first call */

	if (!first)
	{
		cl = clnt_create(serv_name,DB_SETUPPROG,DB_VERS_3,"udp");
		if (cl == NULL)
		{
			*perr = DbErr_CannotCreateClientHandle;
			return(-1);
		}
		clnt_control(cl,CLSET_TIMEOUT,(char *)&timeout_resource);
		clnt_control(cl,CLSET_RETRY_TIMEOUT,(char *)&timeout_resource);
		first++;
	}
#else

/*
 * find out which nethost has been requested for this device
 */
	if ((i_nethost = get_i_nethost_by_device_name(dev_name,perr)) < 0)
	{

/* The nethost is not imported, extract nethost name and import it */

		strcpy(nethost,dev_name + 2);
		for (i = 0;i < (int)strlen(nethost);i++)
		{
			if (nethost[i] == '/')
			{
				nethost[i] = 0;
				break;
			}
		}

/* The specified nethost is not in the list of imorted nethosts, therefore 
   call setup_config_multi() to add it */

		if (setup_config_multi(nethost,perr) != DS_OK)
			return(DS_NOTOK);

/* Find where the nethost is in the multi-nethost array */

		i_nethost = get_i_nethost_by_name(nethost,perr);
	}

/* If the RPC connection to the database server is not built, build one.
   The "config_flags" variable is defined as global by the device server
   API library. If the db_import failed, clear the configuration flag
   in order to recall the manager for database server RPC parameter at the
   next db_import (for reconnection) */

	if (i_nethost == 0)
	{
		if (config_flags.database_server != True)
		{
			if (db_import(&error))
			{
				config_flags.configuration = False;
				*perr = DbErr_CannotCreateClientHandle;
				return(-1);
			}
		}
	}
	else
	{
		if (multi_nethost[i_nethost].config_flags.database_server != True)
		{
			if (db_import_multi(multi_nethost[i_nethost].nethost,&error))
			{
				multi_nethost[i_nethost].config_flags.configuration = False;
				*perr = DbErr_CannotCreateClientHandle;
				return(-1);
			}
		}
	}
	dev_name = extract_device_name(dev_name,perr);

#endif /* ALONE */

/* Allocate memory for the array of pointeur to char */

	if((send.arr1_val = (nam *)calloc(res_num,sizeof(nam))) == NULL)
	{
		*perr = DbErr_ClientMemoryAllocation;
		return(-1);
	}

/* Build the full resource name (in lowercase letters) and initialize the array
  of pointer to resource name */

	k = strlen(dev_name);
	for (i=0;i<(int)res_num;i++)
	{
		l = strlen(res[i].resource_name);
		if ((send.arr1_val[i] = (nam)malloc(k + l + 2)) == NULL)
		{
			*perr = DbErr_ClientMemoryAllocation;
			for (j=0;j<i;j++)
				free(send.arr1_val[j]);
			free(send.arr1_val);
			return(-1);
		}

		strcpy(send.arr1_val[i],dev_name);
		send.arr1_val[i][k] = '/';
		send.arr1_val[i][k + 1] = '\0';
		strcat(send.arr1_val[i],res[i].resource_name);

		l = strlen(send.arr1_val[i]);
		for (j=0;j<l;j++)
			send.arr1_val[i][j] = tolower(send.arr1_val[i][j]);
	}

/* Initialize the structure sended to server */

	send.arr1_len = res_num;

/* Call server */

#ifdef ALONE
	recev = db_getres_1(&send,cl,&error);
#else
	if (i_nethost == 0)
		recev = db_getres_1(&send,db_info.conf->clnt,&error);
	else
		recev = db_getres_1(&send,multi_nethost[i_nethost].db_info->clnt,&error);
#endif /* ALONE */

/* Any problem with server ? */

	if(recev == NULL)
	{
		if (error == DevErr_RPCTimedOut || error == DbErr_RPCreception)
		{
#ifdef ALONE
			to_reconnection((void *)&send,(void **)&recev,&cl,(int)DB_GETRES,0,DB_UDP,&error);
#else
			if (i_nethost == 0)
			{
				to_reconnection((void *)&send,(void **)&recev,
				   		 &db_info.conf->clnt,
						 (int)DB_GETRES,i_nethost,
				   		 DB_UDP,&error);
			}
			else
			{
				to_reconnection((void *)&send,(void **)&recev,
			 	       &multi_nethost[i_nethost].db_info->clnt,
				       (int)DB_GETRES,i_nethost,DB_UDP,&error);
			}
#endif /* ALONE */
		}
		if (error != 0)
		{
			for (j=0;j<(int)res_num;j++)
				free(send.arr1_val[j]);
			free(send.arr1_val);
			*perr = error;
			return(-1);
		}
	}

/* Any problems during database access ? */

	if(recev->db_err != 0)
	{
		if (recev->db_err == DbErr_DatabaseNotConnected)
		{

/* If the server is not connected to the database (because a database update
   is just going on), sleep a while (20 mS) and redo the call */

			for (i = 0;i < RETRY;i++)
			{

#ifdef _OSK
				tsleep(SLEEP_TIME);
#else
				tout.tv_sec = 0;
				tout.tv_usec = 20000;
				select(0,0,0,0,&tout);
#endif /* _OSK */
#ifdef ALONE
				recev = db_getres_1(&send,cl,&error);
#else
				if (i_nethost == 0)
				{
					recev = db_getres_1(&send,db_info.conf->clnt,&error);
				}
				else
				{
					recev = db_getres_1(&send,
					  multi_nethost[i_nethost].db_info->clnt,
					  &error);
				}
#endif /* ALONE */
				if(recev == NULL)
				{
					for (j=0;j<(int)res_num;j++)
						free(send.arr1_val[j]);
					free(send.arr1_val);
					*perr = error;
					return(-1);
				}
				if (recev->db_err == 0 || recev->db_err != DbErr_DatabaseNotConnected)
					break;
			}
		}
		if (recev->db_err != DbErr_TooManyInfoForUDP)
		{
			for (j=0;j<(int)res_num;j++)
				free(send.arr1_val[j]);
			free(send.arr1_val);
			*perr = recev->db_err;
			return(-1);
		}

/* If the server answers that there is too many info to send for the UDP
   protocol, create a TCP connection to the server and redo the call.
   To be able to correctly close the TCP connection, we must know the 
   socket number to close (the RPC function does not do this). So, instead
   of the clnt_create function, we used the clnttcp_create function. */

		else
		{

			if (!first_tcp_call)
			{
#ifdef ALONE
				ht = gethostbyname(serv_name);
#else
				if (i_nethost == 0)
				{
#ifndef vxworks
					ht = gethostbyname(db_info.conf->server_host);
#else /* !vxworks */
					host_addr = hostGetByName(db_info.conf->server_host);
#endif /* !vxworks */
				}
				else
				{
#ifndef vxworks
					ht = gethostbyname(multi_nethost[i_nethost].db_info->server_host);
#else /* !vxworks */
					host_addr = hostGetByName(multi_nethost[i_nethost].db_info->server_host);
#endif /* !vxworks */
				}
#endif /* ALONE */
#ifndef vxworks
				if (ht  == NULL)
#else  /* !vxworks */
				if (host_addr == 0)
#endif /* !vxworks */
				{
					for (j=0;j<(int)res_num;j++)
						free(send.arr1_val[j]);
					free(send.arr1_val);
					*perr = DbErr_CannotCreateClientHandle;
					return(-1);
				}

				serv_adr.sin_family = AF_INET;
#ifndef vxworks
				memcpy((void *)(&serv_adr.sin_addr),ht->h_addr,(size_t)ht->h_length);
#else  /* !vxworks */
				memcpy((void *)(&serv_adr.sin_addr),(char*)&host_addr, 4
);
#endif /* !vxworks */
				first_tcp_call = 1;
			}

			serv_adr.sin_port = 0;
			tcp_so = RPC_ANYSOCK;
#ifdef ALONE
			tcp_cl = clnttcp_create(&serv_adr,DB_SETUPPROG,
						DB_VERS_3, &tcp_so,0,0);
#else
			if (i_nethost == 0)
			{
				tcp_cl = clnttcp_create(&serv_adr,
					        db_info.conf->prog_number,
					        DB_VERS_3,&tcp_so,0,0);
			}
			else
			{
				tcp_cl = clnttcp_create(&serv_adr,
					        multi_nethost[i_nethost].db_info->prog_number,
					        DB_VERS_3,&tcp_so,0,0);
			}
#endif /* ALONE */
			if (tcp_cl == NULL)
			{
				for (j=0;j<(int)res_num;j++)
					free(send.arr1_val[j]);
				free(send.arr1_val);
				*perr = DbErr_CannotCreateClientHandle;
				return(-1);
			}

			tcp_used = 1;
			recev = db_getres_1(&send,tcp_cl,&error);

/* Any problem with server ? */

			if(recev == NULL)
			{
#ifndef _NT
				close(tcp_so);
#else
				closesocket(tcp_so);
#endif
				clnt_destroy(tcp_cl);
				for (j=0;j<(int)res_num;j++)
					free(send.arr1_val[j]);
				free(send.arr1_val);
				*perr = error;
				return(-1);
			}

			if (recev->db_err == DbErr_DatabaseNotConnected)
			{

/* If the server is not connected to the database (because a database update
   is just going on), sleep a while (20 mS) and redo the call */

				for (i = 0;i < RETRY;i++)
				{

#ifdef _OSK
					tsleep(SLEEP_TIME);
#else
					tout.tv_sec = 0;
					tout.tv_usec = 20000;
					select(0,0,0,0,&tout);
#endif /* _OSK */
					recev = db_getres_1(&send,tcp_cl,&error);
					if(recev == NULL)
					{
#ifndef _NT
						close(tcp_so);
#else
						closesocket(tcp_so);
#endif
						clnt_destroy(tcp_cl);
						for (j=0;j<(int)res_num;j++)
							free(send.arr1_val[j]);
						free(send.arr1_val);
						*perr = error;
						return(-1);
					}
					if (recev->db_err == 0 || recev->db_err != DbErr_DatabaseNotConnected)
						break;
				}

/* Any problems during database access ? */

				if(recev->db_err != 0)
				{
#ifndef _NT
					close(tcp_so);
#else
					closesocket(tcp_so);
#endif
					clnt_destroy(tcp_cl);
					for (j=0;j<(int)res_num;j++)
						free(send.arr1_val[j]);
					free(send.arr1_val);
					*perr = recev->db_err;
					return(-1);
				}

			}
		}
	}

/* Return memory */

	for (j=0;j<(int)res_num;j++)
		free(send.arr1_val[j]);
	free(send.arr1_val);

/* Resources type conversion */

	for (i=0;i<(int)res_num;i++) 
	{
		ptrc = recev->res_val.arr1_val[i];
		if (strcmp(ptrc,"N_DEF") == 0)
		{
			continue;
		}
		switch(res[i].resource_type)
		{

		case D_SHORT_TYPE :
			if (ptrc[0] == '0' && ptrc[1] == 'x')
			{
				if (sscanf(&(ptrc[2]),"%hx",(short *)res[i].resource_adr) == -1)
				{
					*perr = DbErr_BadResourceType;
					return(-1);
				}
			}
			else
			{
				*(short *)res[i].resource_adr = (short)atoi(ptrc);
			}
			break;

		case D_USHORT_TYPE :
			if (ptrc[0] == '0' && ptrc[1] == 'x')
			{
				if (sscanf(&(ptrc[2]),"%hx",(short *)res[i].resource_adr) == -1)
				{
					*perr = DbErr_BadResourceType;
					return(-1);
				}
			}
			else
			{
				*(unsigned short *)res[i].resource_adr = (unsigned short)atoi(ptrc);
			}
			break;

		case D_LONG_TYPE :
			if (ptrc[0] == '0' && ptrc[1] == 'x')
			{
				if (sscanf(&(ptrc[2]),"%x",(long *)res[i].resource_adr) == -1)
				{
					*perr = DbErr_BadResourceType;
					return(-1);
				}
			}
			else
			{
				*(long *)res[i].resource_adr = atol(ptrc);
			}
			break;

		case D_ULONG_TYPE :
			if (ptrc[0] == '0' && ptrc[1] == 'x')
			{
				if (sscanf(&(ptrc[2]),"%x",(long *)res[i].resource_adr) == -1)
				{
					*perr = DbErr_BadResourceType;
					return(-1);
				}
			}
			else
			{
				*(unsigned long *)res[i].resource_adr = atol(ptrc);
			}
			break;

		case D_DOUBLE_TYPE :
			*(double *)res[i].resource_adr = atof(ptrc);
			break;

		case D_FLOAT_TYPE :
			*(float *)res[i].resource_adr = (float)atof(ptrc);
			break;

		case D_STRING_TYPE :
			if((ptra = (char *)malloc(strlen(ptrc) + 1)) == NULL)
			{
				*perr = DbErr_ClientMemoryAllocation;
				return(-1);
			}

			strcpy(ptra,ptrc);
			*(char **)res[i].resource_adr = ptra;
			break;

		case D_BOOLEAN_TYPE :
			l = strlen(ptrc);
			for (j=0;j<l;j++)
				ptrc[j] = tolower(ptrc[j]);

			if (!strcmp("off",ptrc) || !strcmp("false",ptrc) || !strcmp("0",ptrc))
				*(char *)res[i].resource_adr = FALSE;

			else if (!strcmp("on",ptrc) || !strcmp("true",ptrc) || !strcmp("1",ptrc))
				*(char *)res[i].resource_adr = TRUE;

			else
			{
				*perr = DbErr_BooleanResource;
				return(-1);
			}
			break;

		case D_VAR_CHARARR :

/* If the array has only one element, treat it has a single resource */

			if (ptrc[0] != INIT_ARRAY)
			{
#ifndef OSK
				if ((char_ptr = (char *)malloc((size_t)sizeof(char))) == NULL)
				{
#else
					if ((char_ptr = (char *)malloc(sizeof(char))) == NULL)
					{
#endif /* OSK */
						*perr = DbErr_ClientMemoryAllocation;
						return(-1);
					}

					if (ptrc[0] == '0' && ptrc[1] == 'x')
					{
						if (sscanf(&(ptrc[2]),"%hx",&tmp_short) == -1)
						{
							*perr = DbErr_BadResourceType;
							return(-1);
						}
						*char_ptr = (char)tmp_short;
					}
					else
					{
						*char_ptr = (char)atoi(ptrc);
					}

					((DevVarCharArray *)res[i].resource_adr)->sequence = char_ptr;
					((DevVarCharArray *)res[i].resource_adr)->length = 1;
				}

				else
				{

/* Retrieve the array element number */

#ifndef OSK
					tmp = (char *)strchr(ptrc,SEP_ELT);
#else
					tmp = index(ptrc,SEP_ELT);
#endif /* OSK */
					diff = (u_int)(tmp++ - ptrc) - 1;
					strncpy(numb,&ptrc[1],diff);
					numb[diff] = 0;
					ctr = (u_int)atoi(numb) - 1;

#ifndef OSK
					if ((char_ptr = (char *)calloc((size_t)(ctr + 1),(size_t)sizeof(char))) == NULL)
					{
#else
					if ((char_ptr = (char *)calloc((ctr + 1),sizeof(char))) == NULL)
					{
#endif /* OSK */
						*perr = DbErr_ClientMemoryAllocation;
						return(-1);
					}

/* Convert each array element */

					for (l=0;l<ctr;l++)
					{
#ifndef OSK
						temp = (char *)strchr(tmp,SEP_ELT);
#else
						temp = index(tmp,SEP_ELT);
#endif /* OSK */
						diff = (u_int)(temp++ - tmp);
						strncpy(numb,tmp,diff);
						numb[diff] = 0;
						if (numb[0] == '0' && numb[1] == 'x')
						{
							if (sscanf(&(numb[2]),"%hx",&tmp_short) == -1)
							{
								*perr = DbErr_BadResourceType;
								return(-1);
							}
							char_ptr[l] = (char)tmp_short;
						}
						else
							char_ptr[l] = (char)atoi(numb);
						tmp = temp;
					}
					if (tmp[0] == '0' && tmp[1] == 'x')
					{
						if (sscanf(&(tmp[2]),"%hx",&tmp_short) == -1)
						{
							*perr = DbErr_BadResourceType;
							return(-1);
						}
						char_ptr[l] = (char)tmp_short;
					}
					else 
						char_ptr[l] = (char)atoi(tmp);

					((DevVarCharArray *)res[i].resource_adr)->sequence = char_ptr;
					((DevVarCharArray *)res[i].resource_adr)->length = ctr + 1;
				}
			break;

			case D_VAR_SHORTARR :

/* If the array has only one element, treat it as a single resource */

				if (ptrc[0] != INIT_ARRAY) {
#ifndef OSK
				if ((short_ptr = (short *)malloc((size_t)sizeof(short))) == NULL) {
#else
				if ((short_ptr = (short *)malloc(sizeof(short))) == NULL) {
#endif /* OSK */
					*perr = DbErr_ClientMemoryAllocation;
					return(-1);
									}

				if (ptrc[0] == '0' && ptrc[1] == 'x') {
					if (sscanf(&(ptrc[2]),"%hx",short_ptr) == -1) {
						*perr = DbErr_BadResourceType;
						return(-1);
							  }
									}
				else {
					*short_ptr = (short)atoi(ptrc);
					}

				((DevVarShortArray *)res[i].resource_adr)->sequence = short_ptr;
				((DevVarShortArray *)res[i].resource_adr)->length = 1;
							}

				else {

/* Retrieve the array element number */

#ifndef OSK
				tmp = (char *)strchr(ptrc,SEP_ELT);
#else
				tmp = index(ptrc,SEP_ELT);
#endif /* OSK */
				diff = (u_int)(tmp++ - ptrc) - 1;
				strncpy(numb,&ptrc[1],diff);
				numb[diff] = 0;
				ctr = (u_int)atoi(numb) - 1;

#ifndef OSK
				if ((short_ptr = (short *)calloc((size_t)(ctr + 1),(size_t)sizeof(short))) == NULL) {
#else
				if ((short_ptr = (short *)calloc((ctr + 1),sizeof(short))) == NULL) {
#endif /* OSK */
					*perr = DbErr_ClientMemoryAllocation;
					return(-1);
									}

/* Convert each array element */

				for (l=0;l<ctr;l++) {
#ifndef OSK
					temp = (char *)strchr(tmp,SEP_ELT);
#else
					temp = index(tmp,SEP_ELT);
#endif /* OSK */
					diff = (u_int)(temp++ - tmp);
					strncpy(numb,tmp,diff);
					numb[diff] = 0;
					if (numb[0] == '0' && numb[1] == 'x') {
						if (sscanf(&(numb[2]),"%hx",&(short_ptr[l])) == -1) {
							*perr = DbErr_BadResourceType;
							return(-1);
						  }
								    }
					else
						short_ptr[l] = (short)atoi(numb);
					tmp = temp;
							}
				if (tmp[0] == '0' && tmp[1] == 'x') {
					if (sscanf(&(tmp[2]),"%hx",&(short_ptr[l])) == -1) {
						*perr = DbErr_BadResourceType;
						return(-1);
							  }
						}
				else 
					short_ptr[l] = (short)atoi(tmp);

				((DevVarShortArray *)res[i].resource_adr)->sequence = short_ptr;
				((DevVarShortArray *)res[i].resource_adr)->length = ctr + 1;
				}
				break;

			case D_VAR_LONGARR :

/* If the array has only one element, treat it as a single resource */

				if (ptrc[0] != INIT_ARRAY) {
#ifndef OSK
				if ((long_ptr = (long *)malloc((size_t)sizeof(long))) == NULL) {
#else
				if ((long_ptr = (long *)malloc(sizeof(long))) == NULL) {
#endif /* OSK */
					*perr = DbErr_ClientMemoryAllocation;
					return(-1);
									}

				if (ptrc[0] == '0' && ptrc[1] == 'x') {
					if (sscanf(&(ptrc[2]),"%x",long_ptr) == -1) {
					*perr = DbErr_BadResourceType;
					return(-1);
						  }
								}
			    	else {
					*long_ptr = atol(ptrc);
					}

				((DevVarLongArray *)res[i].resource_adr)->sequence = long_ptr;
				((DevVarLongArray *)res[i].resource_adr)->length = 1;
							}

				else {

/* Retrieve the array element number */

#ifndef OSK
				tmp = (char *)strchr(ptrc,SEP_ELT);
#else
				tmp = index(ptrc,SEP_ELT);
#endif /* OSK */
				diff = (u_int)(tmp++ - ptrc) - 1;
				strncpy(numb,&ptrc[1],diff);
				numb[diff] = 0;
				ctr = (u_int)atoi(numb) - 1;

#ifndef OSK
				if ((long_ptr = (long *)calloc((size_t)(ctr + 1),(size_t)sizeof(long))) == NULL) {
#else
				if ((long_ptr = (long *)calloc((ctr + 1),sizeof(long))) == NULL) {
#endif /* OSK */
					*perr = DbErr_ClientMemoryAllocation;
					return(-1);
									}

/* Convert each array element */

				for (l=0;l<ctr;l++) {
#ifndef OSK
					temp = (char *)strchr(tmp,SEP_ELT);
#else
					temp = index(tmp,SEP_ELT);
#endif /* OSK */
					diff = (u_int)(temp++ - tmp);
					strncpy(numb,tmp,diff);
					numb[diff] = 0;
					if (numb[0] == '0' && numb[1] == 'x') {
						if (sscanf(&(numb[2]),"%lx",&(long_ptr[l])) == -1) {
						*perr = DbErr_BadResourceType;
						return(-1);
							  }
							}
					else
						long_ptr[l] = atol(numb);
					tmp = temp;
							}
				if (tmp[0] == '0' && tmp[1] == 'x') {
					if (sscanf(&(tmp[2]),"%lx",&(long_ptr[l])) == -1) {
						*perr = DbErr_BadResourceType;
						return(-1);
							  }
						}
				else 
					long_ptr[l] = atol(tmp);

				((DevVarLongArray *)res[i].resource_adr)->sequence = long_ptr;
				((DevVarLongArray *)res[i].resource_adr)->length = ctr + 1;
					}
				break;

			case D_VAR_DOUBLEARR :

/* If the array has only one element, treat it as a single resource */

				if (ptrc[0] != INIT_ARRAY) {
#ifndef OSK
				if ((double_ptr = (double *)malloc((size_t)sizeof(double))) == NULL) {
#else
				if ((double_ptr = (double *)malloc(sizeof(double))) == NULL) {
#endif /* OSK */
					*perr = DbErr_ClientMemoryAllocation;
					return(-1);
									}

				*double_ptr = atof(ptrc);

				((DevVarDoubleArray *)res[i].resource_adr)->sequence = double_ptr;
				((DevVarDoubleArray *)res[i].resource_adr)->length = 1;
							}

				else {

/* Retrieve the array element number */

#ifndef OSK
				tmp = (char *)strchr(ptrc,SEP_ELT);
#else
				tmp = index(ptrc,SEP_ELT);
#endif /* OSK */
				diff = (u_int)(tmp++ - ptrc) - 1;
				strncpy(numb,&ptrc[1],diff);
				numb[diff] = 0;
				ctr = (u_int)atoi(numb) - 1;

#ifndef OSK
				if ((double_ptr = (double *)calloc((size_t)(ctr + 1),(size_t)sizeof(double))) == NULL) {
#else
				if ((double_ptr = (double *)calloc((ctr + 1),sizeof(double))) == NULL) {
#endif /* OSK */
					*perr = DbErr_ClientMemoryAllocation;
					return(-1);
									}

/* Convert each array element */

				for (l=0;l<ctr;l++) {
#ifndef OSK
					temp = (char *)strchr(tmp,SEP_ELT);
#else
					temp = index(tmp,SEP_ELT);
#endif /* OSK */
					diff = (u_int)(temp++ - tmp);
					strncpy(numb,tmp,diff);
					numb[diff] = 0;
					double_ptr[l] = atof(numb);
					tmp = temp;
							}
				double_ptr[l] = atof(tmp);

				((DevVarDoubleArray *)res[i].resource_adr)->sequence = double_ptr;
				((DevVarDoubleArray *)res[i].resource_adr)->length = ctr + 1;
					}
				break;

			case D_VAR_FLOATARR :

/* If the array has only one element, treat it as a single resource */

				if (ptrc[0] != INIT_ARRAY) {
#ifndef OSK
				if ((float_ptr = (float *)malloc((size_t)sizeof(float))) == NULL) {
#else
				if ((float_ptr = (float *)malloc(sizeof(float))) == NULL) {
#endif /* OSK */
					*perr = DbErr_ClientMemoryAllocation;
					return(-1);
									}

				*float_ptr = (float)atof(ptrc);

				((DevVarFloatArray *)res[i].resource_adr)->sequence = float_ptr;
				((DevVarFloatArray *)res[i].resource_adr)->length = 1;
							}

				else {

/* Retrieve the array element number */

#ifndef OSK
				tmp = (char *)strchr(ptrc,SEP_ELT);
#else
				tmp = index(ptrc,SEP_ELT);
#endif /* OSK */
				diff = (u_int)(tmp++ - ptrc) - 1;
				strncpy(numb,&ptrc[1],diff);
				numb[diff] = 0;
				ctr = (u_int)atoi(numb) - 1;

#ifndef OSK
				if ((float_ptr = (float *)calloc((size_t)(ctr + 1),(size_t)sizeof(float))) == NULL) {
#else
				if ((float_ptr = (float *)calloc((ctr + 1),sizeof(float))) == NULL) {
#endif /* OSK */
					*perr = DbErr_ClientMemoryAllocation;
					return(-1);
									}

/* Convert each array element */

				for (l=0;l<ctr;l++) {
#ifndef OSK
					temp = (char *)strchr(tmp,SEP_ELT);
#else
					temp = index(tmp,SEP_ELT);
#endif /* OSK */
					diff = (u_int)(temp++ - tmp);
					strncpy(numb,tmp,diff);
					numb[diff] = 0;
					float_ptr[l] = (float)atof(numb);
					tmp = temp;
							}
				float_ptr[l] = (float)atof(tmp);

				((DevVarFloatArray *)res[i].resource_adr)->sequence = float_ptr;
				((DevVarFloatArray *)res[i].resource_adr)->length = ctr + 1;
					}
				break;

			case D_VAR_STRINGARR :
				if (ptrc[0] != INIT_ARRAY) {
#ifndef OSK
				if ((str_ptr = (char **)malloc((size_t)sizeof(char *))) == NULL) {
#else
				if ((str_ptr = (char **)malloc(sizeof(char *))) == NULL) {
#endif /* OSK */
					*perr = DbErr_ClientMemoryAllocation;
					return(-1);
									}

				if((str_ptr[0] = (char *)malloc(strlen(ptrc) + 1)) == NULL)  {
					*perr = DbErr_ClientMemoryAllocation;
					return(-1);
					}

				strcpy(str_ptr[0],ptrc);

				((DevVarStringArray *)res[i].resource_adr)->sequence = str_ptr;
				((DevVarStringArray *)res[i].resource_adr)->length = 1;
							}

				else {

/* Retrieve the array element number */

#ifndef OSK
				tmp = (char *)strchr(ptrc,SEP_ELT);
#else
				tmp = index(ptrc,SEP_ELT);
#endif /* OSK */
				diff = (u_int)(tmp++ - ptrc) - 1;
				strncpy(numb,&ptrc[1],diff);
				numb[diff] = 0;
				ctr = (u_int)atoi(numb) - 1;

/* Allocate memory for the array of pointer to strings */

#ifndef OSK
				if ((str_ptr = (char **)calloc((size_t)(ctr + 1),(size_t)sizeof(char *))) == NULL) {
#else
				if ((str_ptr = (char **)calloc((ctr + 1),sizeof(char *))) == NULL) {
#endif /* OSK */
					*perr = DbErr_ClientMemoryAllocation;
					return(-1);
									}

/* Convert each array element */

				for (l=0;l<ctr;l++) {
#ifndef OSK
					temp = (char *)strchr(tmp,SEP_ELT);
#else
					temp = index(tmp,SEP_ELT);
#endif /* OSK */
					diff = (u_int)(temp++ - tmp);
					if ((str_ptr[l] = (char *)malloc(diff + 1)) == NULL) {
						for(k=0;k<l;k++)
							free(str_ptr[k]);
						free(str_ptr);
						*perr = DbErr_ClientMemoryAllocation;
						return(-1);
								}
					strncpy(str_ptr[l],tmp,diff);
					str_ptr[l][diff] = 0;
					tmp = temp;
							}
				if ((str_ptr[l] = (char *)malloc(strlen(tmp) + 1)) == NULL) {
					for(k=0;k<l;k++)
						free(str_ptr[k]);
					free(str_ptr);
					*perr = DbErr_ClientMemoryAllocation;
					return(-1);
									}
				strcpy(str_ptr[l],tmp);

				((DevVarStringArray *)res[i].resource_adr)->sequence = str_ptr;
				((DevVarStringArray *)res[i].resource_adr)->length = ctr + 1;
					}
				break;
					}
				}

/* Return memory allocated by XDR routines. If the TCP connection has been
   used, close the associated socket and destroy the RPC connection. */

	if (tcp_used == 1)
	{
		if (!clnt_freeres(tcp_cl,(xdrproc_t)xdr_db_res,(char *)recev))
		{
			*perr = DbErr_MemoryFree;
			return(-1);
		}
#ifndef _NT
		close(tcp_so);
#else
		closesocket(tcp_so);
#endif
		clnt_destroy(tcp_cl);
	}
	else
	{
#ifdef ALONE
		if (!clnt_freeres(cl,xdr_db_res,(char *)recev)) 
		{
			*perr = DbErr_MemoryFree;
			return(-1);
		}
#else
		if (i_nethost == 0)
		{
			if (!clnt_freeres(db_info.conf->clnt,(xdrproc_t)xdr_db_res,(char *)recev)) 
			{
				*perr = DbErr_MemoryFree;
				return(-1);
			}
		}
		else
		{
			if (!clnt_freeres(multi_nethost[i_nethost].db_info->clnt,(xdrproc_t)xdr_db_res,(char *)recev)) 
			{
				*perr = DbErr_MemoryFree;
				return(-1);
			}
		}
#endif /* ALONE */
	}

/* No error */

	*perr = 0;
	return(0);

}
 


/****************************************************************************
*                                                                           *
*		db_putresource function code                                *
*               --------------                                              *
*                                                                           *
*    Function rule : To update or insert a resource value. The resource     *
*                    value is stored as a string in a database on a remote  *
*                    computer                                               *
*                                                                           *
*    Argins : - A pointer to a string which defines the device name         *
*             - A pointer to an array of db_resource structure defining the *
*               resources to be updated or inserted                         *
*             - The number of resource to be retrieved                      *
*                                                                           *
*    Argout : - The error code if any                                       *
*                                                                           *
*    In case of trouble, the function returns -1 and set the err variable   *
*    pointed to by "perr". Otherwise, the function returns 0                *
*                                                                           *
*****************************************************************************/

int _DLLFunc db_putresource(char *dev_name, Db_resource res, 
			    u_int res_num,long *perr)

{
	int i,j,k,k1,l;
	int k2 = 0;
	tab_putres send;
	char tmp_rname[SIZE_C];
	char d_name[SIZE_B];
	register char *temp;
	u_int diff;
	int big_res;
	putres *tmp;
	char *tmp_arr;
	DevVarCharArray *tmp_char;
	DevVarStringArray *tmp_string;
	DevVarShortArray *tmp_short;
	DevVarLongArray *tmp_long;
	DevVarFloatArray *tmp_float;
	DevVarDoubleArray *tmp_double;
	u_int len = 0;
	int *recev;
	int big_packet = 0;
	CLIENT *tcp_cl;
	int tcp_so;
	long error;
	long i_nethost = 0;
#ifndef _OSK
	struct timeval tout;
#endif /* _OSK */
#ifdef ALONE
	char *serv_name = ALONE_SERVER_HOST;
#endif /* ALONE */

/* Verify function parameters (non NULL pointers and two \ characters in 
   device name). */

        if (config_flags.no_database)
        {
                *perr = DbErr_NoDatabase;
                return(DS_NOTOK);
        } 

	if (dev_name == NULL || res == NULL || res_num == 0)
	{
		*perr = DbErr_BadParameters;
		return(-1);
	}

	l = 0;
	NB_CHAR(l,dev_name,'/');
	if (l != 2)
	{
		*perr = DbErr_BadParameters;
		return(-1);
	}

	for (i=0;i<(int)res_num;i++)
	{
		if (res[i].resource_adr == NULL || res[i].resource_name == NULL)
		{
			*perr = DbErr_BadParameters;
			return(-1);
		}
		if (res[i].resource_type == D_VAR_CHARARR && 
 		    ((DevVarCharArray *)(res[i].resource_adr))->length == 0)
		{
			*perr = DbErr_BadParameters;
			return(-1);
		}
		else if (res[i].resource_type == D_VAR_SHORTARR &&
			((DevVarShortArray *)(res[i].resource_adr))->length == 0)
		{
			*perr = DbErr_BadParameters;
			return(-1);
		}
		else if (res[i].resource_type == D_VAR_LONGARR &&
			((DevVarLongArray *)(res[i].resource_adr))->length == 0)
		{
			*perr = DbErr_BadParameters;
			return(-1);
		}
		else if (res[i].resource_type == D_VAR_DOUBLEARR &&
			((DevVarDoubleArray *)(res[i].resource_adr))->length == 0)
		{
			*perr = DbErr_BadParameters;
			return(-1);
		}
		else if (res[i].resource_type == D_VAR_FLOATARR &&
			((DevVarFloatArray *)(res[i].resource_adr))->length == 0)
		{
			*perr = DbErr_BadParameters;
			return(-1);
		}
		else if (res[i].resource_type == D_VAR_STRINGARR &&
			((DevVarStringArray *)(res[i].resource_adr))->length == 0)
		{
			*perr = DbErr_BadParameters;
			return(-1);
		}
	}

/* If the users try to update resource of the "sec" domain, refuse to do
   the work */

#ifdef OSK
	tmp_arr = index(dev_name,'/');
#else
	tmp_arr = (char *)strchr(dev_name,'/');
#endif /* OSK */
	diff = (u_int)(tmp_arr - dev_name);
	strncpy(tmp_rname,dev_name,diff);
	tmp_rname[diff] = 0;

	for (i = 0;i < (int)diff;i++)
		tmp_rname[i] = tolower(tmp_rname[i]);
	if (strcmp(tmp_rname,"sec") == 0)
	{
		*perr = DbErr_DomainDefinition;
		return(-1);
	}

#ifdef ALONE
/* Create RPC connection if it is the first call */

	if (!first)
	{
		cl = clnt_create(serv_name,DB_SETUPPROG,DB_VERS_3,"udp");
		if (cl == NULL)
		{
			clnt_pcreateerror("why : ");
			*perr = DbErr_CannotCreateClientHandle;
			return(-1);
		}
		clnt_control(cl,CLSET_TIMEOUT,(char *)&timeout);
		clnt_control(cl,CLSET_RETRY_TIMEOUT,(char *)&retry_timeout);
		first++;
	}
#else
/* If the RPC connection to the database server is not built, build one.
   The "config_flags" variable is defined as global by the device server
   API library */

	if (config_flags.database_server != True)
	{
		if (db_import(&error))
		{
			config_flags.configuration = False;
			*perr = DbErr_CannotCreateClientHandle;
			return(-1);
		}
	}
#endif /* ALONE */

/* Allocate memory for the array putres structure */

#ifndef OSK
	if ((send.tab_putres_val = (putres *)calloc((size_t)res_num,(size_t)sizeof(putres))) == NULL)
	{
#else
	if ((send.tab_putres_val = (putres *)calloc(res_num,sizeof(putres))) == NULL)
	{
#endif /* OSK */
		*perr = DbErr_ClientMemoryAllocation;
		return(-1);
	}

	k1 = strlen(dev_name);
	for (i = 0;i < (int)res_num;i++)
	{

/* Build and allocate memory for the full resource name.
   Change the resource name to lowercase letters. */

		tmp = &send.tab_putres_val[i];
		l = strlen(res[i].resource_name);
		if ((tmp->res_name = (char *)malloc(k1 + l + 2)) == NULL)
		{
			*perr = DbErr_ClientMemoryAllocation;
			for (j=0;j<i;j++)
			{
				free(send.tab_putres_val[j].res_name);
				free(send.tab_putres_val[j].res_val);
			}
			free(send.tab_putres_val);
			return(-1);
		}

		strcpy(tmp->res_name,dev_name);
		tmp->res_name[k1] = '/';
		tmp->res_name[k1 + 1] = 0;
		strcat(tmp->res_name,res[i].resource_name);

		l = strlen(tmp->res_name);
		for (j=0;j<l;j++)
			tmp->res_name[j] = tolower(tmp->res_name[j]);

/* Build a string with the resource value */

		switch(res[i].resource_type)
		{
		case D_SHORT_TYPE :

/* Allocate memory for the string */

			if ((tmp->res_val = (char *)malloc(10)) == NULL)
			{
				*perr = DbErr_ClientMemoryAllocation;
				for (j=0;j<i;j++)
				{
					free(send.tab_putres_val[j].res_name);
					free(send.tab_putres_val[j].res_val);
				}
				free(tmp->res_name);
				free(send.tab_putres_val);
				return(-1);
			}

/* Convert resource value to string */

			sprintf(tmp->res_val,"%hd",*(short *)res[i].resource_adr);
			break;

		case D_USHORT_TYPE :

/* Allocate memory for the string */

			if ((tmp->res_val = (char *)malloc(10)) == NULL)
			{
				*perr = DbErr_ClientMemoryAllocation;
				for (j=0;j<i;j++)
				{
					free(send.tab_putres_val[j].res_name);
					free(send.tab_putres_val[j].res_val);
				}
				free(tmp->res_name);
				free(send.tab_putres_val);
				return(-1);
			}

/* Convert resource value to string */

			sprintf(tmp->res_val,"%hu",*(unsigned short *)res[i].resource_adr);
			break;

		case D_LONG_TYPE :

/* Allocate memory for the string */

			if ((tmp->res_val = (char *)malloc(16)) == NULL)
			{
				*perr = DbErr_ClientMemoryAllocation;
				for (j=0;j<i;j++)
				{
					free(send.tab_putres_val[j].res_name);
					free(send.tab_putres_val[j].res_val);
				}
				free(tmp->res_name);
				free(send.tab_putres_val);
				return(-1);
			}

/* Convert resource value to string */

			sprintf(tmp->res_val,"%ld",*(long *)res[i].resource_adr);
			break;

		case D_ULONG_TYPE :

/* Allocate memory for the string */

			if ((tmp->res_val = (char *)malloc(16)) == NULL)
			{
				*perr = DbErr_ClientMemoryAllocation;
				for (j=0;j<i;j++)
				{
					free(send.tab_putres_val[j].res_name);
					free(send.tab_putres_val[j].res_val);
				}
				free(tmp->res_name);
				free(send.tab_putres_val);
				return(-1);
			}

/* Convert resource value to string */

			sprintf(tmp->res_val,"%ul",*(unsigned long *)res[i].resource_adr);
			break;

		case D_FLOAT_TYPE :

/* Allocate memory for the string */

			if ((tmp->res_val = (char *)malloc(SIZE_A)) == NULL)
			{
				*perr = DbErr_ClientMemoryAllocation;
				for (j=0;j<i;j++)
				{
					free(send.tab_putres_val[j].res_name);
					free(send.tab_putres_val[j].res_val);
				}
				free(tmp->res_name);
				free(send.tab_putres_val);
				return(-1);
			}

/* Convert resource value to string */

			sprintf(tmp->res_val,"%.8e",*(float *)res[i].resource_adr);
			break;

		case D_DOUBLE_TYPE :

/* Allocate memory for the string */

			if ((tmp->res_val = (char *)malloc(SIZE_A)) == NULL)
			{
				*perr = DbErr_ClientMemoryAllocation;
				for (j=0;j<i;j++)
				{
					free(send.tab_putres_val[j].res_name);
					free(send.tab_putres_val[j].res_val);
				}
				free(tmp->res_name);
				free(send.tab_putres_val);
				return(-1);
			}

/* Convert resource value to string */

			sprintf(tmp->res_val,"%.8e",*(double *)res[i].resource_adr);
			break;

		case D_STRING_TYPE :

/* Verify that the string is not too long */

			l = strlen(*(char **)res[i].resource_adr);
			if (l > MAX_RES)
			{
				*perr = DbErr_StringTooLong;
				for (j=0;j<i;j++)
				{
					free(send.tab_putres_val[j].res_name);
					free(send.tab_putres_val[j].res_val);
				}
				free(tmp->res_name);
				free(send.tab_putres_val);
				return(-1);
			}
	
/* Allocate memory for the string */

			if ((tmp->res_val = (char *)malloc(l + 1)) == NULL)
			{
				*perr = DbErr_ClientMemoryAllocation;
				for (j=0;j<i;j++)
				{
					free(send.tab_putres_val[j].res_name);
					free(send.tab_putres_val[j].res_val);
				}
				free(tmp->res_name);
				free(send.tab_putres_val);
				return(-1);
			}

/* Copy the string */

			strcpy(tmp->res_val,*(char **)res[i].resource_adr);
			break;

		case D_BOOLEAN_TYPE :

/* Allocate memory for the string "Off" */

			if ((tmp->res_val = (char *)malloc(4)) == NULL)
			{
				*perr = DbErr_ClientMemoryAllocation;
				for (j=0;j<i;j++)
				{
					free(send.tab_putres_val[j].res_name);
					free(send.tab_putres_val[j].res_val);
				}
				free(tmp->res_name);
				free(send.tab_putres_val);
				return(-1);
			}

/* Convert the boolean value to string */

			if (*(char *)res[i].resource_adr == TRUE)
				strcpy(tmp->res_val,"On");
			else
				strcpy(tmp->res_val,"Off");

			break;

		case D_VAR_CHARARR :

		tmp_char = (DevVarCharArray *)res[i].resource_adr;

/* Allocate memory for the temporary string */

		if (k2 == 0) {
		if ((tmp_arr = (char *)malloc(SIZE)) == NULL) {
			*perr = DbErr_ClientMemoryAllocation;
			for (j=0;j<i;j++) {
				free(send.tab_putres_val[j].res_name);
				free(send.tab_putres_val[j].res_val);
					}
			free(tmp->res_name);
			free(send.tab_putres_val);
			return(-1);
								}
		tmp_arr[0] = 0;
		k2 = 1;
				}   


/* Build the temporary string and realloc memory for the temporary string if it 
   is needed. */

		for (j=0;j<(int)tmp_char->length;j++) {
			k = strlen(tmp_arr);
			tmp_arr[k++] = SEP_ELT;
			sprintf(&tmp_arr[k],"%d",tmp_char->sequence[j]);

			if (k > ((k2 * SIZE) - LIM)) {
				if ((tmp_arr = (char *)realloc((void *)tmp_arr,(k2 + 1) * SIZE)) == NULL) {
					*perr = DbErr_ClientMemoryAllocation;
					for (j=0;j<i;j++) {
						free(send.tab_putres_val[j].res_name);
						free(send.tab_putres_val[j].res_val);
							}
					free(tmp->res_name);
					free(send.tab_putres_val);
					free(tmp_arr);
					return(-1);
									}
				k2++;
						}
						}

/* Allocate memory for the full string (header and array elements) */

		if ((tmp->res_val = (char *)malloc(strlen(tmp_arr) + 10)) == NULL) {
			*perr = DbErr_ClientMemoryAllocation;
			for (j=0;j<i;j++) {
				free(send.tab_putres_val[j].res_name);
				free(send.tab_putres_val[j].res_val);
					}
			free(tmp->res_name);
			free(send.tab_putres_val);
			free(tmp_arr);
			return(-1);
							}

/* Copy the temporary string */

		tmp->res_val[0] = INIT_ARRAY;
		sprintf(&tmp->res_val[1],"%d",tmp_char->length);
		strcat(tmp->res_val,tmp_arr);

/* Clear the temporary buffer */

		tmp_arr[0] = 0;
		break;

			case D_VAR_SHORTARR :

		tmp_short = (DevVarShortArray *)res[i].resource_adr;

/* Allocate memory for the temporary string */

		if (k2 == 0) {
		if ((tmp_arr = (char *)malloc(SIZE)) == NULL) {
			*perr = DbErr_ClientMemoryAllocation;
			for (j=0;j<i;j++) {
				free(send.tab_putres_val[j].res_name);
				free(send.tab_putres_val[j].res_val);
					}
			free(tmp->res_name);
			free(send.tab_putres_val);
			return(-1);
								}
		tmp_arr[0] = 0;
		k2 = 1;
				}   

/* Build the temporary string and realloc memory for the temporary string if it
   is needed. */

		for (j=0;j<(int)tmp_short->length;j++) {
			k = strlen(tmp_arr);
			tmp_arr[k++] = SEP_ELT;
			sprintf(&tmp_arr[k],"%d",tmp_short->sequence[j]);

			if (k > ((k2 * SIZE) - LIM)) {
				if ((tmp_arr = (char *)realloc((void *)tmp_arr,(k2 + 1) * SIZE)) == NULL) {
					*perr = DbErr_ClientMemoryAllocation;
					for (j=0;j<i;j++) {
						free(send.tab_putres_val[j].res_name);
						free(send.tab_putres_val[j].res_val);
							}
					free(tmp->res_name);
					free(send.tab_putres_val);
					free(tmp_arr);
					return(-1);
									}
				k2++;
						}
						}

/* Allocate memory for the full string (header and array) */

		if ((tmp->res_val = (char *)malloc(strlen(tmp_arr) + 10)) == NULL) {
			*perr = DbErr_ClientMemoryAllocation;
			for (j=0;j<i;j++) {
				free(send.tab_putres_val[j].res_name);
				free(send.tab_putres_val[j].res_val);
					}
			free(tmp->res_name);
			free(send.tab_putres_val);
			free(tmp_arr);
			return(-1);
							}

/* Copy the temporary string */

		tmp->res_val[0] = INIT_ARRAY;
		sprintf(&tmp->res_val[1],"%d",tmp_short->length);
		strcat(tmp->res_val,tmp_arr);

/* Clear the temporary buffer */

		tmp_arr[0] = 0;
		break;

			case D_VAR_LONGARR :

		tmp_long = (DevVarLongArray *)res[i].resource_adr;

/* Allocate memory for the temporary string */

		if (k2 == 0) {
		if ((tmp_arr = (char *)malloc(SIZE)) == NULL) {
			*perr = DbErr_ClientMemoryAllocation;
			for (j=0;j<i;j++) {
				free(send.tab_putres_val[j].res_name);
				free(send.tab_putres_val[j].res_val);
					}
			free(tmp->res_name);
			free(send.tab_putres_val);
			return(-1);
								}
		tmp_arr[0] = 0;
		k2 = 1;
				}   

/* Build the temporary string and realloc memory for the temporary string if it
   is needed. */

		for (j=0;j<(int)tmp_long->length;j++) {
			k = strlen(tmp_arr);
			tmp_arr[k++] = SEP_ELT;
			sprintf(&tmp_arr[k],"%d",tmp_long->sequence[j]);

			if (k > ((k2 * SIZE) - LIM)) {
				if ((tmp_arr = (char *)realloc((void *)tmp_arr,(k2 + 1) * SIZE)) == NULL) {
					*perr = DbErr_ClientMemoryAllocation;
					for (j=0;j<i;j++) {
						free(send.tab_putres_val[j].res_name);
						free(send.tab_putres_val[j].res_val);
							}
					free(tmp->res_name);
					free(send.tab_putres_val);
					free(tmp_arr);
					return(-1);
									}
				k2++;
						}
						}

/* Allocate memory for the full string (header and array) */

		if ((tmp->res_val = (char *)malloc(strlen(tmp_arr) + 10)) == NULL) {
			*perr = DbErr_ClientMemoryAllocation;
			for (j=0;j<i;j++) {
				free(send.tab_putres_val[j].res_name);
				free(send.tab_putres_val[j].res_val);
					}
			free(tmp->res_name);
			free(send.tab_putres_val);
			free(tmp_arr);
			return(-1);
							}

/* Copy the temporary string */

		tmp->res_val[0] = INIT_ARRAY;
		sprintf(&tmp->res_val[1],"%d",tmp_long->length);
		strcat(tmp->res_val,tmp_arr);

/* Clear the temporary buffer */

		tmp_arr[0] = 0;
		break;

			case D_VAR_FLOATARR :

		tmp_float = (DevVarFloatArray *)res[i].resource_adr;

/* Allocate memory for the temporary string */

		if (k2 == 0) {
		if ((tmp_arr = (char *)malloc(SIZE)) == NULL) {
			*perr = DbErr_ClientMemoryAllocation;
			for (j=0;j<i;j++) {
				free(send.tab_putres_val[j].res_name);
				free(send.tab_putres_val[j].res_val);
					}
			free(tmp->res_name);
			free(send.tab_putres_val);
			return(-1);
								}
		tmp_arr[0] = 0;
		k2 = 1;
				}   

/* Build a string with only the array elements */

		for (j=0;j<(int)tmp_float->length;j++) {
			k = strlen(tmp_arr);
			tmp_arr[k++] = SEP_ELT;
			sprintf(&tmp_arr[k],"%.8e",tmp_float->sequence[j]);

			if (k > ((k2 * SIZE) - LIM)) {
				if ((tmp_arr = (char *)realloc((void *)tmp_arr,(k2 + 1) * SIZE)) == NULL) {
					*perr = DbErr_ClientMemoryAllocation;
					for (j=0;j<i;j++) {
						free(send.tab_putres_val[j].res_name);
						free(send.tab_putres_val[j].res_val);
							}
					free(tmp->res_name);
					free(send.tab_putres_val);
					free(tmp_arr);
					return(-1);
									}
				k2++;
						}
						}

/* Allocate memory for the full string (header and array) */

		if ((tmp->res_val = (char *)malloc(strlen(tmp_arr) + 10)) == NULL) {
			*perr = DbErr_ClientMemoryAllocation;
			for (j=0;j<i;j++) {
				free(send.tab_putres_val[j].res_name);
				free(send.tab_putres_val[j].res_val);
					}
			free(tmp->res_name);
			free(send.tab_putres_val);
			free(tmp_arr);
			return(-1);
							}

/* Copy the temporary string */

		tmp->res_val[0] = INIT_ARRAY;
		sprintf(&tmp->res_val[1],"%d",tmp_float->length);
		strcat(tmp->res_val,tmp_arr);

/* Clear the temporary buffer */

		tmp_arr[0] = 0;
		break;

			case D_VAR_DOUBLEARR :

		tmp_double = (DevVarDoubleArray *)res[i].resource_adr;

/* Allocate memory for the temporary string */

		if (k2 == 0) {
		if ((tmp_arr = (char *)malloc(SIZE)) == NULL) {
			*perr = DbErr_ClientMemoryAllocation;
			for (j=0;j<i;j++) {
				free(send.tab_putres_val[j].res_name);
				free(send.tab_putres_val[j].res_val);
					}
			free(tmp->res_name);
			free(send.tab_putres_val);
			return(-1);
								}
		tmp_arr[0] = 0;
		k2 = 1;
				}   

/* Build a string with only the array elements */

		for (j=0;j<(int)tmp_double->length;j++) {
			k = strlen(tmp_arr);
			tmp_arr[k++] = SEP_ELT;
			sprintf(&tmp_arr[k],"%.8e",tmp_double->sequence[j]);

			if (k > ((k2 * SIZE) - LIM)) {
				if ((tmp_arr = (char *)realloc((void *)tmp_arr,(k2 + 1) * SIZE)) == NULL) {
					*perr = DbErr_ClientMemoryAllocation;
					for (j=0;j<i;j++) {
						free(send.tab_putres_val[j].res_name);
						free(send.tab_putres_val[j].res_val);
							}
					free(tmp->res_name);
					free(send.tab_putres_val);
					free(tmp_arr);
					return(-1);
									}
				k2++;
						}
						}

/* Allocate memory for the full string (header and array) */

		if ((tmp->res_val = (char *)malloc(strlen(tmp_arr) + 10)) == NULL) {
			*perr = DbErr_ClientMemoryAllocation;
			for (j=0;j<i;j++) {
				free(send.tab_putres_val[j].res_name);
				free(send.tab_putres_val[j].res_val);
					}
			free(tmp->res_name);
			free(send.tab_putres_val);
			free(tmp_arr);
			return(-1);
							}

/* Copy the temporary string */

		tmp->res_val[0] = INIT_ARRAY;
		sprintf(&tmp->res_val[1],"%d",tmp_double->length);
		strcat(tmp->res_val,tmp_arr);

/* Clear the temporary buffer */

		tmp_arr[0] = 0;
		break;

		case D_VAR_STRINGARR :

			tmp_string = (DevVarStringArray *)res[i].resource_adr;

/* Allocate memory for the temporary string */

			if (k2 == 0)
			{
				if ((tmp_arr = (char *)malloc(SIZE)) == NULL)
				{
					*perr = DbErr_ClientMemoryAllocation;
					for (j=0;j<i;j++)
					{
						free(send.tab_putres_val[j].res_name);
						free(send.tab_putres_val[j].res_val);
					}
					free(tmp->res_name);
					free(send.tab_putres_val);
					return(-1);
				}
				tmp_arr[0] = 0;
				k2 = 1;
			}   

/* Build a string with only the array elements */

			for (j=0;j<(int)tmp_string->length;j++)
			{
				if (strlen(tmp_string->sequence[j]) > (size_t)MAX_RES)
				{
					*perr = DbErr_StringTooLong;
					for (j=0;j<i;j++)
					{
						free(send.tab_putres_val[j].res_name);
						free(send.tab_putres_val[j].res_val);
					}
					free(tmp->res_name);
					free(send.tab_putres_val);
					free(tmp_arr);
					return(-1);
				}

				k = strlen(tmp_arr);
				tmp_arr[k++] = SEP_ELT;
				tmp_arr[k] = 0;
				strcat(tmp_arr,tmp_string->sequence[j]);

				if (k > ((k2 * SIZE) - LIM))
				{
					if ((tmp_arr = (char *)realloc((void *)tmp_arr,(k2 + 1) * SIZE)) == NULL)
					{
						*perr = DbErr_ClientMemoryAllocation;
						for (j=0;j<i;j++)
						{
							free(send.tab_putres_val[j].res_name);
							free(send.tab_putres_val[j].res_val);
						}
						free(tmp->res_name);
						free(send.tab_putres_val);
						free(tmp_arr);
						return(-1);
					}
					k2++;
				}
			}

/* Allocate memory for the full string (header and array) */

			if ((tmp->res_val = (char *)malloc(strlen(tmp_arr) + 10)) == NULL)
			{
				*perr = DbErr_ClientMemoryAllocation;
				for (j=0;j<i;j++)
				{
					free(send.tab_putres_val[j].res_name);
					free(send.tab_putres_val[j].res_val);
				}
				free(tmp->res_name);
				free(send.tab_putres_val);
				free(tmp_arr);
				return(-1);
			}

/* Copy the temporary string */

			tmp->res_val[0] = INIT_ARRAY;
			sprintf(&tmp->res_val[1],"%d",tmp_string->length);
			strcat(tmp->res_val,tmp_arr);

/* Clear the temporary buffer */

			tmp_arr[0] = 0;
			break;
		}

/* Compute an estimation of the network packet size. If it exceeds 8K, set a 
   flag. */

		if ((len = strlen(send.tab_putres_val[i].res_val) + strlen(send.tab_putres_val[i].res_name) + len) > SIZE)
		{
			big_packet = 1;
		}
	}

/* Initialize the structure sended to server */

	send.tab_putres_len = res_num;

/* If it is necessary, create a TCP connection to be able to send more than
   8K of data. */

	if (big_packet == 1)
	{

/* To be able to correctly close the TCP connection, we must know the 
   socket number to close it (the RPC function does not do this). So, instead
   of the clnt_create function, we used the clnttcp_create function. */

		if (!first_tcp_call)
		{
#ifdef ALONE
			if ((ht = gethostbyname(serv_name)) == NULL)
			{
#else
#ifndef vxworks
				if ((ht = gethostbyname(db_info.conf->server_host)) == NULL)
				{
#else  /* !vxworks */
				if ((host_addr = hostGetByName(db_info.conf->server_host)) == 0)
				{
#endif /* !vxworks */
#endif /* ALONE */
					*perr = DbErr_CannotCreateClientHandle;
					for (j = 0;j < (int)res_num;j++)
					{
						free(send.tab_putres_val[j].res_name);
						free(send.tab_putres_val[j].res_val);
					}
					free(send.tab_putres_val);
					free(tmp_arr);
					return(-1);
				}

				serv_adr.sin_family = AF_INET;
#ifndef vxworks
				memcpy((void *)(&serv_adr.sin_addr),ht->h_addr,(size_t)ht->h_length);
#else  /* !vxworks */
				memcpy((void *)(&serv_adr.sin_addr),(char*)&host_addr,4);
#endif /* !vxworks */
				first_tcp_call = 1;
			}

			serv_adr.sin_port = 0;
			tcp_so = RPC_ANYSOCK;
#ifdef ALONE
			tcp_cl = clnttcp_create(&serv_adr,DB_SETUPPROG,
					DB_VERS_3, &tcp_so,0,0);
#else
			tcp_cl = clnttcp_create(&serv_adr,
				        db_info.conf->prog_number,
				        DB_VERS_3,&tcp_so,0,0);
#endif /* ALONE */
			if (tcp_cl == NULL)
			{
				*perr = DbErr_CannotCreateClientHandle;
				for (j = 0;j < (int)res_num;j++)
				{
					free(send.tab_putres_val[j].res_name);
					free(send.tab_putres_val[j].res_val);
				}
				free(send.tab_putres_val);
				free(tmp_arr);
				return(-1);
			}
		}

/* Call server */

#ifdef ALONE
	if (big_packet == 1)
		recev = db_putres_1(&send,tcp_cl,&error);
	else
		recev = db_putres_1(&send,cl,&error);
#else
	if (big_packet == 1)
		recev = db_putres_1(&send,tcp_cl,&error);
	else
		recev = db_putres_1(&send,db_info.conf->clnt,&error);
#endif /* ALONE */

/* If the server is not connected to the database (because a database update
   is just going on), sleep a while (20 mS) and redo the call */

	if(recev != NULL) {
	if (*recev == DbErr_DatabaseNotConnected) {
		for (i = 0;i < RETRY;i++) {

#ifdef _OSK
			tsleep(SLEEP_TIME);
#else
			tout.tv_sec = 0;
			tout.tv_usec = 20000;
			select(0,0,0,0,&tout);
#endif /* _OSK */
#ifdef ALONE
			if (big_packet == 1)
				recev = db_putres_1(&send,tcp_cl,&error);
			else
				recev = db_putres_1(&send,cl,&error);
#else
			if (big_packet == 1)
				recev = db_putres_1(&send,tcp_cl,&error);
			else
				recev = db_putres_1(&send,db_info.conf->clnt,&error);
#endif /* ALONE */
			if(recev == NULL)
				break;
			if ((*recev == 0) || (*recev != DbErr_DatabaseNotConnected))
				break;
						}
							}
			}

/* Any problem with server ?. If yes, and if it is a time-out, try to
   reconnect. Don't forget to free memory. */

	if (recev == NULL) {
		if (error == DevErr_RPCTimedOut || error == DbErr_RPCreception)
		{
#ifdef ALONE
			to_reconnection((void *)&send,(void **)&recev,&cl,(int)DB_PUTRES,i_nethost,DB_UDP,&error);
#else
			to_reconnection((void *)&send,(void **)&recev,
					&db_info.conf->clnt,(int)DB_PUTRES,
					i_nethost,DB_UDP,&error);
#endif /* ALONE */
		}

		if (error != 0) {
			for (j = 0;j < (int)res_num;j++) {
				free(send.tab_putres_val[j].res_name);
				free(send.tab_putres_val[j].res_val);
						}
			free(send.tab_putres_val);
			if (k2 != 0)
				free(tmp_arr);
			if (big_packet == 1) {
#ifndef _NT
				close(tcp_so);
#else
				closesocket(tcp_so);
#endif
				clnt_destroy(tcp_cl);
						}
			*perr = error;
			return(-1);
				}
			}

/* Return memory */

	for (j = 0;j < (int)res_num;j++) {
		free(send.tab_putres_val[j].res_name);
		free(send.tab_putres_val[j].res_val);
				}
	free(send.tab_putres_val);
	if (k2 != 0)
		free(tmp_arr);

/* Any problem during database access ? */

	if (*recev != 0) {
		if (big_packet == 1) {
#ifndef _NT
			close(tcp_so);
#else
			closesocket(tcp_so);
#endif
			clnt_destroy(tcp_cl);
					}
		*perr = *recev;
		return(-1);
			}

/* If the TCP connection was necessary, close it and destroy the associated
   socket */

	if (big_packet == 1)
	{
#ifndef _NT
		close(tcp_so);
#else
		closesocket(tcp_so);
#endif
		clnt_destroy(tcp_cl);
	}

/* Leave function */

	return(0);

}



/****************************************************************************
*                                                                           *
*		db_delresource function code                                *
*               --------------                                              *
*                                                                           *
*    Function rule : To delete resources. The resource value is    	    *
*                    stored as a atring in a database on a remote           *
*                    computer                                               *
*                                                                           *
*    Argins : - A pointer to a string which defines the device name         *
*             - A pointer to an array of string defining the 		    *
*               resource to be deleted                                      *
*             - The number of resource to be deleted                        *
*                                                                           *
*    Argout : - The error code if any                                       *
*                                                                           *
*    In case of trouble, the function returns -1 and set the err variable   *
*    pointed to by "perr". Otherwise, the function returns 0                *
*                                                                           *
*****************************************************************************/

int _DLLFunc db_delresource(char *dev_name,char **res_name,u_int res_num,long *perr)
{
	int i,j,k,l;
	arr1 send;
	long error;
	int *recev;
	char t_name[SIZE_B];
	register char *tmp;
	u_int diff;
	long i_nethost = 0;
#ifndef _OSK
	struct timeval tout;
#endif
#ifdef ALONE
	char *serv_name = ALONE_SERVER_HOST;
#endif /* ALONE */

        if (config_flags.no_database)
        {
                *perr = DbErr_NoDatabase;
                return(DS_NOTOK);
        } 

/* Try to verify the function parameters (non NULL pointer and two \
   characters in device name) */

	if (dev_name == NULL || res_name == NULL || res_num == 0)
	{
		*perr = DbErr_BadParameters;
		return(-1);
	}

	l=0;
	NB_CHAR(l,dev_name,'/');
	if (l != 2)
	{
		*perr = DbErr_BadParameters;
		return(-1);
	}

	for (i=0;i<(int)res_num;i++)
	{
		if (res_name[i] == NULL)
		{
			*perr = DbErr_BadParameters;
			return(-1);
		}
	}

#ifdef ALONE
/* Create RPC connection if it's the first call */

	if (!first)
	{
		cl = clnt_create(serv_name,DB_SETUPPROG,DB_VERS_3,"udp");
		if (cl == NULL)
		{
			*perr = DbErr_CannotCreateClientHandle;
			return(-1);
		}
		clnt_control(cl,CLSET_TIMEOUT,(char *)&timeout);
		clnt_control(cl,CLSET_RETRY_TIMEOUT,(char *)&retry_timeout);
		first++;
	}
#endif /* ALONE */

/* Allocate memory for the array of pointeur to char */

	if((send.arr1_val = (nam *)calloc(res_num,sizeof(nam))) == NULL)
	{
		*perr = DbErr_ClientMemoryAllocation;
		return(-1);
	}

/* Build the full resource name (in lowercase letters) and initialize the array
  of pointer to resource name */

	k = strlen(dev_name);
	for (i=0;i<(int)res_num;i++)
	{
		l = strlen(res_name[i]);
		if ((send.arr1_val[i] = (char *)malloc(k + l + 2)) == NULL)
		{
			*perr = DbErr_ClientMemoryAllocation;
			for (j=0;j<i;j++)
				free(send.arr1_val[j]);
			free(send.arr1_val);
			return(-1);
		}

		strcpy(send.arr1_val[i],dev_name);
		send.arr1_val[i][k] = '/';
		send.arr1_val[i][k + 1] = '\0';
		strcat(send.arr1_val[i],res_name[i]);

		l = strlen(send.arr1_val[i]);
		for (j=0;j<l;j++)
			send.arr1_val[i][j] = tolower(send.arr1_val[i][j]);
	}

/* If the device domain name is "sec", refuse to do the work */

	t_name[0] = 0;
#ifdef OSK
	tmp = index(send.arr1_val[0],'/');
#else
	tmp = (char *)strchr(send.arr1_val[0],'/');
#endif /* OSK */
	diff = (u_int)(tmp - send.arr1_val[0]);
	strncpy(t_name,send.arr1_val[0],diff);
	t_name[diff] = 0;
	if (strcmp(t_name,"sec") == 0)
	{
		for (j = 0;j < (int)res_num;j++)
			free(send.arr1_val[j]);
		free(send.arr1_val);
		*perr = DbErr_DomainDefinition;
		return(-1);
	}
		

/* Initialize the structure sended to server */

	send.arr1_len = res_num;

/* Call server */

#ifdef ALONE
	recev = db_delres_1(&send,cl,&error);
#else
	recev = db_delres_1(&send,db_info.conf->clnt,&error);
#endif /* ALONE */


/* Any problems during database access ? */

	if (recev != NULL)
	{
		if (*recev == DbErr_DatabaseNotConnected)
		{

/* If the server is not connected to the database (because a database update
   is just going on), sleep a while (20 mS) and redo the call */

			for (i = 0;i < RETRY;i++)
			{

#ifdef _OSK
				tsleep(SLEEP_TIME);
#else
				tout.tv_sec = 0;
				tout.tv_usec = 20000;
				select(0,0,0,0,&tout);
#endif /* _OSK */
#ifdef ALONE
				recev = db_delres_1(&send,cl,&error);
#else
				recev = db_delres_1(&send,db_info.conf->clnt,&error);
#endif /* ALONE */
				if(recev == NULL)
					break;
				if ((*recev == 0) || (*recev != DbErr_DatabaseNotConnected))
						break;
			}

		}
	}

/* Any problem with server ? If yes and if it is a time-out, try to reconnect
   to a new server. Don't forget to free memory */

	else
	{
		if (error == DevErr_RPCTimedOut || error == DbErr_RPCreception)
		{
#ifdef ALONE
			to_reconnection((void *)&send,(void **)&recev,&cl,(int)DB_DELRES,i_nethost,DB_UDP,&error);
#else
			to_reconnection((void *)&send,(void **)&recev,
				     &db_info.conf->clnt,(int)DB_DELRES,
				     i_nethost,DB_UDP,&error);
#endif /* ALONE */
		}
		if (error != 0)
		{
			for (j = 0;j < (int)res_num;j++)
				free(send.arr1_val[j]);
			free(send.arr1_val);
			*perr = error;
			return(-1);
		}
	}

/* Return memory */

	for (j = 0;j < (int)res_num;j++)
		free(send.arr1_val[j]);
	free(send.arr1_val);

/* Any problem with database access ? */

	if (*recev != 0)
	{
		*perr = *recev;
		return(-1);
	}

/* No error */

	*perr = 0;
	return(0);

}



/****************************************************************************
*                                                                           *
*		db_delreslist function code                                 *
*               -------------                                               *
*                                                                           *
*    Function rule : To delete resources. The resource value is    	    *
*                    stored as a atring in a database on a remote           *
*                    computer                                               *
*                                                                           *
*    Argins : - A pointer to an array of string defining the 		    *
*               resource to be deleted                                      *
*             - The number of resource to be deleted                        *
*                                                                           *
*    Argout : - The error code if any                                       *
*                                                                           *
*    It is not the same call than the previous one because the resource name*
*    are given here with the following syntax :				    *
*		domain/family/member/r_name				    *
*									    *
*    In case of trouble, the function returns -1 and set the err variable   *
*    pointed to by "perr". Otherwise, the function returns 0                *
*                                                                           *
*****************************************************************************/

long _DLLFunc db_delreslist(char **res_list, long res_num,long *perr)
{
	int i,j,k,l;
	arr1 send;
	long error;
	int *recev;
	long i_nethost = 0;
#ifndef _OSK
	struct timeval tout;
#endif
#ifdef ALONE
	char *serv_name = ALONE_SERVER_HOST;
#endif /* ALONE */

        if (config_flags.no_database)
        {
                *perr = DbErr_NoDatabase;
                return(DS_NOTOK);
        } 

/* Try to verify the function parameters (non NULL pointer and two \
   characters in device name) */

	if ((res_list == NULL) || (res_num == 0))
	{
		*perr = DbErr_BadParameters;
		return(-1);
	}

	for (i = 0;i < (int)res_num;i++)
	{
		l = 0;
		NB_CHAR(l,res_list[i],'/');
		if (l != 3)
		{
			*perr = DbErr_BadParameters;
			return(-1);
		}
	}

#ifdef ALONE
/* Create RPC connection if it's the first call */

	if (!first)
	{
		cl = clnt_create(serv_name,DB_SETUPPROG,DB_VERS_3,"udp");
		if (cl == NULL)
		{
			*perr = DbErr_CannotCreateClientHandle;
			return(-1);
		}
		clnt_control(cl,CLSET_TIMEOUT,(char *)&timeout);
		clnt_control(cl,CLSET_RETRY_TIMEOUT,(char *)&retry_timeout);
		first++;
	}
#endif /* ALONE */

/* Allocate memory for the array of pointeur to char */

	if((send.arr1_val = (nam *)calloc(res_num,sizeof(nam))) == NULL)
	{
		*perr = DbErr_ClientMemoryAllocation;
		return(-1);
	}

/* Copy resource name (in lowercase letters) and initialize the array
  of pointer to resource name */

	for (i = 0;i< (int) res_num;i++)
	{
		k = strlen(res_list[i]);
		if ((send.arr1_val[i] = (char *)malloc(k + 1)) == NULL)
		{
			*perr = DbErr_ClientMemoryAllocation;
			for (j = 0;j < i;j++)
				free(send.arr1_val[j]);
			free(send.arr1_val);
			return(-1);
		}

		strcpy(send.arr1_val[i],res_list[i]);

		for (j = 0;j < k;j++)
			send.arr1_val[i][j] = tolower(send.arr1_val[i][j]);
	}

/* Initialize the structure sended to server */

	send.arr1_len = res_num;

/* Call server */

#ifdef ALONE
	recev = db_delres_1(&send,cl,&error);
#else
	recev = db_delres_1(&send,db_info.conf->clnt,&error);
#endif /* ALONE */


/* Any problems during database access ? */

	if (recev != NULL)
	{
		if (*recev == DbErr_DatabaseNotConnected)
		{

/* If the server is not connected to the database (because a database update
   is just going on), sleep a while (20 mS) and redo the call */

			for (i = 0;i < RETRY;i++)
			{

#ifdef _OSK
				tsleep(SLEEP_TIME);
#else
				tout.tv_sec = 0;
				tout.tv_usec = 20000;
				select(0,0,0,0,&tout);
#endif /* _OSK */
#ifdef ALONE
				recev = db_delres_1(&send,cl,&error);
#else
				recev = db_delres_1(&send,db_info.conf->clnt,&error);
#endif /* ALONE */
				if(recev == NULL)
					break;
				if ((*recev == 0) || (*recev != DbErr_DatabaseNotConnected))
						break;
			}

		}
	}

/* Any problem with server ? If yes and if it is a time-out, try to reconnect
   to a new server. Don't forget to free memory */

	else
	{
		if (error == DevErr_RPCTimedOut || error == DbErr_RPCreception)
		{
#ifdef ALONE
			to_reconnection((void *)&send,(void **)&recev,&cl,(int)DB_DELRES,i_nethost,DB_UDP,&error);
#else
			to_reconnection((void *)&send,(void **)&recev,
				     &db_info.conf->clnt,(int)DB_DELRES,
				     i_nethost,DB_UDP,&error);
#endif /* ALONE */
		}
		if (error != 0)
		{
			for (j = 0;j < (int)res_num;j++)
				free(send.arr1_val[j]);
			free(send.arr1_val);
			*perr = error;
			return(-1);
		}
	}

/* Return memory */

	for (j = 0;j < (int)res_num;j++)
		free(send.arr1_val[j]);
	free(send.arr1_val);

/* Any problem with database access ? */

	if (*recev != 0)
	{
		*perr = *recev;
		return(-1);
	}

/* No error */

	*perr = 0;
	return(0);

}



/****************************************************************************
*                                                                           *
*		db_getdevlist function code                                 *
*               -------------                                               *
*                                                                           *
*    Function rule : To retrieve the deices names of the devices driven by  *
*                    a device server. These informations can be found in a  *
*                    database in a remote computer                          *
*                                                                           *
*    Argins : - The name of the device server                               *
*             - The address of the pointer to the string's array            *
*                                                                           *
*    Argout : - The number of deices for this device server                 *
*             - The error code in case of problems                          *
*                                                                           *
*    In case of trouble, the function returns -1 and set the err varaible   *
*    pointed to by "perr". Otherwise, the function returns 0                *
*                                                                           *
*****************************************************************************/


int _DLLFunc db_getdevlist(char *name,char ***tab, u_int *num_dev,long *perr)
{
	char *name1;
	db_res *recev;
	int i,j,l,k;
	long error;
	long i_nethost = 0;
#ifndef _OSK
	struct timeval tout;
#endif /* _OSK */
#ifdef ALONE
	char *serv_name = ALONE_SERVER_HOST;
#endif /* ALONE */

/*
 * if this is a device server without database then simply return
 * the list of devices passed on the command line
 */
 	if (config_flags.no_database == True)
	{
		*num_dev = config_flags.device_no;
		*tab = (char **)config_flags.device_list;
		return(DS_OK);
	}

/* Try to verify the function parameters (non NULL pointers and one
   \ character in device server name) */

	if (name == NULL || tab == NULL)
	{
		*perr = DbErr_BadParameters;
		return(-1);
	}
	k = 0;
	NB_CHAR(k,name,'/');
	if (k != 1)
	{
		*perr = DbErr_BadParameters;
		return(-1);
	}

#ifdef ALONE
/* Create RPC connection if it's the first call */

	if (!first)
	{
		cl = clnt_create(serv_name,DB_SETUPPROG,DB_VERS_3,"udp");
		if (cl == NULL)
		{
			*perr = DbErr_CannotCreateClientHandle;
			return(-1);
		}
		clnt_control(cl,CLSET_TIMEOUT,(char *)&timeout);
		clnt_control(cl,CLSET_RETRY_TIMEOUT,(char *)&retry_timeout);
		first++;
	}
#endif /* ALONE */

/* Make a copy of the device server name and all  the string's character 
   in lowercase */

	k = strlen(name);
	if ((name1 = (char *)malloc(k + 1)) == NULL)
	{
		*perr = DbErr_ClientMemoryAllocation;
		return(-1);
	}
	strcpy(name1,name);
	for(i=0;i<k;i++)
		name1[i] = tolower(name1[i]);	

/* Call server */

#ifdef ALONE
	recev = db_getdev_1(&name1,cl,&error);
#else
	recev = db_getdev_1(&name1,db_info.conf->clnt,&error);	
#endif /* ALONE */
	

/* Any problem with server ? If yes and if it is a time-out, try to reconnect
   to a new database server. */

	if(recev == NULL)
	{
		if (error == DevErr_RPCTimedOut || error == DbErr_RPCreception)
		{
#ifdef ALONE
			to_reconnection((void *)&name1,(void **)&recev,&cl,(int)DB_GETDEV,i_nethost,DB_UDP,&error);
#else
			to_reconnection((void *)&name1,(void **)&recev,
				     &db_info.conf->clnt,(int)DB_GETDEV,
				     i_nethost,DB_UDP,&error);
#endif /* ALONE */
		}
		if (error != 0)
		{
			free(name1);
			*perr = error;
			return(-1);
		}
	}

/* If the server is not connected to the database (because a database update
   is just going on), sleep a while (20 mS) and redo the call */

	if (recev->db_err == DbErr_DatabaseNotConnected)
	{
		for (i = 0;i < RETRY;i++)
		{

#ifdef _OSK
			tsleep(SLEEP_TIME);
#else
			tout.tv_sec = 0;
			tout.tv_usec = 20000;
			select(0,0,0,0,&tout);
#endif /* _OSK */
#ifdef ALONE
			recev = db_getdev_1(&name1,cl,&error);
#else
			recev = db_getdev_1(&name1,db_info.conf->clnt,&error);
#endif /* ALONE */
			if(recev == NULL)
			{
				free(name1);
				*perr = error;
				return(-1);
			}
			if (recev->db_err == 0 || recev->db_err != DbErr_DatabaseNotConnected)
				break;
		}
	}

/* Return memory */

	free(name1);

/* Any problems during database access ? */

	if(recev->db_err != 0)
	{
		*perr = recev->db_err;
		return(-1);
	}

/* Allocate memory to copy device name. I know that it i smore time consuming 
   than directly give the meory allocated by XDR to caller but how the caller
   will correctly free memory allocated by XDR */
   
   	if ((*tab = (char **)calloc(recev->res_val.arr1_len,sizeof(char *))) == NULL)
	{
		*perr = DbErr_ClientMemoryAllocation;
		return(-1);
	}
	for (i = 0;i < recev->res_val.arr1_len;i++)
	{
		l = strlen(recev->res_val.arr1_val[i]);
		if (((*tab)[i] = (char *)malloc(l + 1)) == NULL)
		{
			for (j = 0;j < i;j++)
				free((*tab)[j]);
			free(*tab);
			*perr = DbErr_ClientMemoryAllocation;
			return(-1);
		}
		strcpy((*tab)[i],recev->res_val.arr1_val[i]);
	}
	
/* Initialize devices name number */

	*num_dev = recev->res_val.arr1_len;

/* Free memory allocated by XDR */

#ifdef ALONE
	clnt_freeres(cl,(xdrproc_t)xdr_db_res,(char *)recev);
#else
	clnt_freeres(db_info.conf->clnt,(xdrproc_t)xdr_db_res,(char *)recev);
#endif /* ALONE */
	
/* No error */

	*perr = 0;
	return(0);

}



/****************************************************************************
*                                                                           *
*		db_dev_export function code                                 *
*               -------------                                               *
*                                                                           *
*    Function rule : To export a device. This means that after this function*
*                    has been executed by a device server,                  *
*                    a client is able to ask for host name,  		    *
*                    program number and version number of the device server *
*                    in charge of a device.These three informations are     *
*                    stored in a database                                   *
*		     This function is now supported in version 1,2 and 3    *
*		     The version 2 also send the process ID to the database *
*		     server						    *
*		     The version 3 also send the device server process name *
*		     to the database. This is useful for multi-classes      *
*		     device server.					    *
*                                                                           *
*    Argins : - A pointer to an array of db_devinf structures defining the  *
*               devices to be exported                                      *
*             - The number of resource to be exported                       *
*                                                                           *
*    Argout : - The error code if any                                       *
*                                                                           *
*    In case of trouble, the function returns -1 and set the err variable   *
*    pointed to by "perr". Otherwise, the function returns 0                *
*                                                                           *
*****************************************************************************/


int _DLLFunc db_dev_export(Db_devinf devexp, u_int dev_num,long *perr)
{
	int i,j,k,l;
	tab_dbdev_3 send3;
	tab_dbdev_2 send2;
	int *pdb_err;
	register db_devinfo_3 *devexp3;
	register db_devinfo_2 *devexp2;
	long error;
	int pid;
	long vers;
	long i_nethost = 0;
#ifndef _OSK
	struct timeval tout;
#endif /* _OSK */
#ifdef ALONE
	char *serv_name = ALONE_SERVER_HOST;
#endif /* ALONE */

#ifndef ALONE
	vers = db_info.conf->vers_number;
#else
	vers = DB_VERS_3;
#endif 

        if (config_flags.no_database)
        {
                *perr = DbErr_NoDatabase;
                return(DS_NOTOK);
        } 

/* Try to verify the functions parameters (Non NULL pointer and two
   \ character in the device name) */

	if (devexp == NULL || dev_num == 0)
	{
		*perr = DbErr_BadParameters;
		return(-1);
	}

	for (i=0;i<(int)dev_num;i++)
	{
		if (vers == DB_VERS_2)
		{
			if ((devexp[i].host_name == NULL) || 
		    	    (devexp[i].device_name == NULL) || 
		            (devexp[i].device_type == NULL) || 
		            (devexp[i].device_class == NULL))
			{
				*perr = DbErr_BadParameters;
				return(-1);
			}
		}
		else
		{
			if ((devexp[i].host_name == NULL) || 
		    	    (devexp[i].device_name == NULL) || 
		            (devexp[i].device_type == NULL) || 
		            (devexp[i].device_class == NULL) ||
		            (devexp[i].proc_name == NULL))
			{
				*perr = DbErr_BadParameters;
				return(-1);
			}
		}
		l = 0;
		NB_CHAR(l,devexp[i].device_name,'/');
		if (l != 2)
		{
			*perr = DbErr_BadParameters;
			return(-1);
		}
	}

#ifdef ALONE
/* Create RPC connection if it's the first call */

	if (!first)
	{
		cl = clnt_create(serv_name,DB_SETUPPROG,DB_VERS_3,"udp");
		if (cl == NULL)
		{
			*perr = DbErr_CannotCreateClientHandle;
			return(-1);
		}
		clnt_control(cl,CLSET_TIMEOUT,(char *)&timeout);
		clnt_control(cl,CLSET_RETRY_TIMEOUT,(char *)&retry_timeout);
		first++;
	}
#endif /* ALONE */

/* Allocate memory to copy the db_devimp structures array */

	if (vers == DB_VERS_2)
	{
		if ((devexp2 = (db_devinfo_2 *)calloc(dev_num,sizeof(db_devinfo_2))) == NULL)
		{
			*perr = DbErr_ClientMemoryAllocation;
			return(-1);
		}
	}
	else
	{
		if ((devexp3 = (db_devinfo_3 *)calloc(dev_num,sizeof(db_devinfo_3))) == NULL)
		{
			*perr = DbErr_ClientMemoryAllocation;
			return(-1);
		}
	}

/* Host name and device name in lowercase letters. To do that, we are obliged
   to make a copy of host_name and device_name to be abble to change them
   (ssm in OS-9 system). Copy also the device type and device class strings. */

	if (vers == DB_VERS_2)
	{
		for (i=0;i<(int)dev_num;i++)
		{
			k = strlen(devexp[i].host_name);
			if ((devexp2[i].host_name = (char *)malloc(k + 1)) == NULL)
			{
				*perr = DbErr_ClientMemoryAllocation;
				for (l=0;l<i;l++)
				{
					free(devexp2[i].host_name);
					free(devexp2[i].dev_name);
					free(devexp2[i].dev_type);
					free(devexp2[i].dev_class);
				}
				free(devexp2);
				return(-1);
			}
			strcpy(devexp2[i].host_name,devexp[i].host_name);
			for (j=0;j<k;j++) 
				devexp2[i].host_name[j] = tolower(devexp2[i].host_name[j]);

			k = strlen(devexp[i].device_name);
			if ((devexp2[i].dev_name = (char *)malloc(k + 1)) == NULL)
			{
				*perr = DbErr_ClientMemoryAllocation;
				for (l=0;l<i;l++)
				{
					free(devexp2[i].host_name);
					free(devexp2[i].dev_name);
					free(devexp2[i].dev_type);
					free(devexp2[i].dev_class);
				}
				free(devexp2[i].host_name);
				free(devexp2);
				return(-1);
			}
			strcpy(devexp2[i].dev_name,devexp[i].device_name);
			for (j=0;j<k;j++)
				devexp2[i].dev_name[j] = tolower(devexp2[i].dev_name[j]);

			k = strlen(devexp[i].device_type);
			if ((devexp2[i].dev_type = (char *)malloc(k + 1)) == NULL)
			{
				*perr = DbErr_ClientMemoryAllocation;
				for (l=0;l<i;l++)
				{
					free(devexp2[i].host_name);
					free(devexp2[i].dev_name);
					free(devexp2[i].dev_type);
					free(devexp2[i].dev_class);
				}
				free(devexp2[i].host_name);
				free(devexp2[i].dev_name);
				free(devexp2);
				return(-1);
			}
			strcpy(devexp2[i].dev_type,devexp[i].device_type);

			k = strlen(devexp[i].device_class);
			if ((devexp2[i].dev_class = (char *)malloc(k + 1)) == NULL)
			{
				*perr = DbErr_ClientMemoryAllocation;
				for (l=0;l<i;l++)
				{
					free(devexp2[i].host_name);
					free(devexp2[i].dev_name);
					free(devexp2[i].dev_type);
					free(devexp2[i].dev_class);
				}
				free(devexp2[i].host_name);
				free(devexp2[i].dev_name);
				free(devexp2[i].dev_type);
				free(devexp2);
				return(-1);
			}
			strcpy(devexp2[i].dev_class,devexp[i].device_class);

			devexp2[i].p_num = devexp[i].pn;
			devexp2[i].v_num = devexp[i].vn;

/* Get process ID (specific for version 2) */

			if (i == 0)
#if defined(_NT)
				pid = _getpid();
#else
#if !defined (vxworks)
				pid = getpid();
#else  /* !vxworks */
				pid = taskIdSelf();
#endif /* !vxworks */
#endif
			devexp2[i].pid = pid;
		}
	}
	else
	{
		for (i=0;i<(int)dev_num;i++)
		{
			k = strlen(devexp[i].host_name);
			if ((devexp3[i].host_name = (char *)malloc(k + 1)) == NULL)
			{
				*perr = DbErr_ClientMemoryAllocation;
				for (l=0;l<i;l++)
				{
					free(devexp3[i].host_name);
					free(devexp3[i].dev_name);
					free(devexp3[i].dev_type);
					free(devexp3[i].dev_class);
					free(devexp3[i].proc_name);
				}
				free(devexp3);
				return(-1);
			}
			strcpy(devexp3[i].host_name,devexp[i].host_name);
			for (j=0;j<k;j++) 
				devexp3[i].host_name[j] = tolower(devexp3[i].host_name[j]);

			k = strlen(devexp[i].device_name);
			if ((devexp3[i].dev_name = (char *)malloc(k + 1)) == NULL)
			{
				*perr = DbErr_ClientMemoryAllocation;
				for (l=0;l<i;l++)
				{
					free(devexp3[i].host_name);
					free(devexp3[i].dev_name);
					free(devexp3[i].dev_type);
					free(devexp3[i].dev_class);
					free(devexp3[i].proc_name);
				}
				free(devexp3[i].host_name);
				free(devexp3);
				return(-1);
			}
			strcpy(devexp3[i].dev_name,devexp[i].device_name);
			for (j=0;j<k;j++)
				devexp3[i].dev_name[j] = tolower(devexp3[i].dev_name[j]);

			k = strlen(devexp[i].device_type);
			if ((devexp3[i].dev_type = (char *)malloc(k + 1)) == NULL)
			{
				*perr = DbErr_ClientMemoryAllocation;
				for (l=0;l<i;l++)
				{
					free(devexp3[i].host_name);
					free(devexp3[i].dev_name);
					free(devexp3[i].dev_type);
					free(devexp3[i].dev_class);
					free(devexp3[i].proc_name);
				}
				free(devexp3[i].host_name);
				free(devexp3[i].dev_name);
				free(devexp3);
				return(-1);
			}
			strcpy(devexp3[i].dev_type,devexp[i].device_type);

			k = strlen(devexp[i].device_class);
			if ((devexp3[i].dev_class = (char *)malloc(k + 1)) == NULL)
			{
				*perr = DbErr_ClientMemoryAllocation;
				for (l=0;l<i;l++)
				{
					free(devexp3[i].host_name);
					free(devexp3[i].dev_name);
					free(devexp3[i].dev_type);
					free(devexp3[i].dev_class);
					free(devexp3[i].proc_name);
				}
				free(devexp3[i].host_name);
				free(devexp3[i].dev_name);
				free(devexp3[i].dev_type);
				free(devexp3);
				return(-1);
			}
			strcpy(devexp3[i].dev_class,devexp[i].device_class);

			devexp3[i].p_num = devexp[i].pn;
			devexp3[i].v_num = devexp[i].vn;

/* Get process ID (specific for version 2) */

			if (i == 0)
#if defined(_NT)
				pid = _getpid();
#else  /* _NT */
#if !defined (vxworks)
				pid = getpid();
#else  /* !vxworks */
				pid = taskIdSelf();
#endif /* !vxworks */
#endif /* _NT */
			devexp3[i].pid = pid;

/* Copy process name (specific for version 3) */

			k = strlen(devexp[i].proc_name);
			if ((devexp3[i].proc_name = (char *)malloc(k + 1)) == NULL)
			{
				*perr = DbErr_ClientMemoryAllocation;
				for (l=0;l<i;l++)
				{
					free(devexp3[i].host_name);
					free(devexp3[i].dev_name);
					free(devexp3[i].dev_type);
					free(devexp3[i].dev_class);
					free(devexp3[i].proc_name);
				}
				free(devexp3[i].host_name);
				free(devexp3[i].dev_name);
				free(devexp3[i].dev_type);
				free(devexp3[i].dev_class);
				free(devexp3);
				return(-1);
			}
			strcpy(devexp3[i].proc_name,devexp[i].proc_name);
			for (j=0;j<k;j++) 
				devexp3[i].proc_name[j] = tolower(devexp3[i].proc_name[j]);
		}

	}

/* Initialize the structure sended to the server */

	if (vers == DB_VERS_2)
	{
		send2.tab_dbdev_len = dev_num;
		send2.tab_dbdev_val = devexp2;
	}
	else
	{
		send3.tab_dbdev_len = dev_num;
		send3.tab_dbdev_val = devexp3;
	}

/* Call server */

#ifdef ALONE
	pdb_err = db_devexp_3(&send3,cl,&error);
#else
	if (vers == DB_VERS_2)
		pdb_err = db_devexp_2(&send2,db_info.conf->clnt,&error);
	else
		pdb_err = db_devexp_3(&send3,db_info.conf->clnt,&error);
#endif /* ALONE */

/* If the server is not connected to the database (because a database update
   is just going on), sleep a while (20 mS) and redo the call */

	if (pdb_err != NULL)
	{
		if (*pdb_err == DbErr_DatabaseNotConnected)
		{
			for (i = 0;i < RETRY;i++)
			{

#ifdef _OSK
				tsleep(SLEEP_TIME);
#else
				tout.tv_sec = 0;
				tout.tv_usec = 20000;
				select(0,0,0,0,&tout);
#endif /* _OSK */
#ifdef ALONE
				pdb_err = db_devexp_3(&send3,cl,&error);
#else
				if (vers == DB_VERS_2)
					pdb_err = db_devexp_2(&send2,db_info.conf->clnt,&error);
				else
					pdb_err = db_devexp_3(&send3,db_info.conf->clnt,&error);
#endif /* ALONE */
				if(pdb_err == NULL)
					break;
				if ((*pdb_err == 0) || (*pdb_err != DbErr_DatabaseNotConnected))
					break;
			}
		}
	}

/* Any problem with server ? If yes and if it is a time-out, try to reconnect
   to a new database server. Don't forget to free memory in case of error. */

	else
	{
		if (error == DevErr_RPCTimedOut || error == DbErr_RPCreception)
		{
#ifdef ALONE
			to_reconnection((void *)&send3,(void **)&pdb_err,&cl,(int)DB_DEVEXP_3,i_nethost,DB_UDP,&error);
#else
			if (vers == DB_VERS_2)
				to_reconnection((void *)&send2,
						(void **)&pdb_err,
					  	&db_info.conf->clnt,
						(int)DB_DEVEXP_2,
						i_nethost,DB_UDP,&error);
			else
				to_reconnection((void *)&send3,
						(void **)&pdb_err,
					  	&db_info.conf->clnt,
						(int)DB_DEVEXP_3,
						i_nethost,DB_UDP,&error);
#endif /* ALONE */
		}
		if (error != 0)
		{
			if (vers == DB_VERS_2)
			{
				for (l=0;l<(int)dev_num;l++)
				{
					free(devexp2[l].host_name);
					free(devexp2[l].dev_name);
					free(devexp2[l].dev_type);
					free(devexp2[l].dev_class);
				}
				free(devexp2);
			}
			else
			{
				for (l=0;l<(int)dev_num;l++)
				{
					free(devexp3[l].host_name);
					free(devexp3[l].dev_name);
					free(devexp3[l].dev_type);
					free(devexp3[l].dev_class);
					free(devexp3[l].proc_name);
				}
				free(devexp3);
			}
			*perr = error;
			return(-1);
		}
	}

/* Return memory */

	if (vers == DB_VERS_2)
	{
		for (l=0;l<(int)dev_num;l++)
		{
			free(devexp2[l].host_name);
			free(devexp2[l].dev_name);
			free(devexp2[l].dev_type);
			free(devexp2[l].dev_class);
		}
		free(devexp2);
	}
	else
	{
		for (l=0;l<(int)dev_num;l++)
		{
			free(devexp3[l].host_name);
			free(devexp3[l].dev_name);
			free(devexp3[l].dev_type);
			free(devexp3[l].dev_class);
			free(devexp3[l].proc_name);
		}
		free(devexp3);
	}

/* Any trouble during database access ? */

	if (*pdb_err != 0)
	{
		*perr = *pdb_err;
		return(-1);
	}

/* No error */

	*perr = 0;
	return(0);

}
 


/****************************************************************************
*                                                                           *
*		db_dev_import function code                                 *
*               -------------                                               *
*                                                                           *
*    Function rule : To import a device. This means to ask for the host name*
*                    the program number and the version number of the device*
*                    server which drives a device.                          *
*                                                                           *
*    Argins : - The address of an array of pointers to strings. Each string *
*               contains the name of a device to be imported.               *
*             - The number of devices to be imported                        *
*                                                                           *
*    Argout : - The adress of an array of db_devinf_imp structures. Each    *
*               structure defines a device                                  *
*             - The error code in case of problems                          *
*                                                                           *
*    In case of trouble, the function returns -1 and set the err variable   *
*    pointed to by "perr". Otherwise, the function returns 0                *
*                                                                           *
*****************************************************************************/


int _DLLFunc db_dev_import(char **name,Db_devinf_imp *tab, u_int num_dev,long *perr)
{
	int i,j,k,l;
	arr1 send;
	register Db_devinf_imp tmp_ptr;
	db_devinfo *tmp_ptr1;
	db_resimp *recev;
	long error;
	long i_nethost;
	char **name_copy;
#ifndef _OSK
	struct timeval tout;
#endif /* _OSK */
#ifdef ALONE
	char *serv_name = ALONE_SERVER_HOST;
#endif /* ALONE */

        if (config_flags.no_database)
        {
                *perr = DbErr_NoDatabase;
                return(DS_NOTOK);
        } 

/* Try to verify the function parameters (non NULL pointer and two
   \ character in the device name to be imported) */

	if (name == NULL || tab == NULL || num_dev == 0) 
	{
		*perr = DbErr_BadParameters;
		return(-1);
	}

/*
 * find out which nethost has been requested for the first device
 * It is not possible to db_import several devices from different
 * nethosts in the same call. The nethost chosen is the nethost associated
 * with the first device in the device name array
 */
	if ((i_nethost = get_i_nethost_by_device_name(name[0],perr)) < 0)
		return(DS_NOTOK);

	name_copy = (char**)malloc(sizeof(char*)*num_dev);

	for (i=0;i<(int)num_dev;i++) 
	{
/*
 * if nethost is specified in the device name "remove" it
 *
 *
 * BUG - this code removes the nethost and overwrites the device name 
 *       thereby losing the nethost information for good. after this 
 *	 everything can go wrong from segmentation violation
 *	 to reimport not working to who knows what ... !
 *
 *
 *		name[i] = extract_device_name(name[i],perr);
 *
 * BUG FIX - make copy of device name for local use
 *
 * ag + wdk (7jul99)
 */
		name_copy[i] = extract_device_name(name[i],perr);

		l = 0;
		NB_CHAR(l,name_copy[i],'/');
		if (l != 2) 
		{
			*perr = DbErr_BadParameters;
			return(-1);
		}
	}

#ifdef ALONE
/* Create RPC connection if it's the first call */

	if (!first) 
	{
		cl = clnt_create(serv_name,DB_SETUPPROG,DB_VERS_3,"udp");
		if (cl == NULL) 
		{
			*perr = DbErr_CannotCreateClientHandle;
			return(-1);
		}
		clnt_control(cl,CLSET_TIMEOUT,(char *)&timeout);
		clnt_control(cl,CLSET_RETRY_TIMEOUT,(char *)&retry_timeout);
		first++;
	}
#endif /* ALONE */

/* Allocate memory to build the array of pointers to strings and all device
   names in lowercase letters */

	if ((send.arr1_val = (nam *)calloc(num_dev,sizeof(nam))) == NULL) 
	{
		*perr = DbErr_ClientMemoryAllocation;
		return(-1);
	}
	for (k=0;k<(int)num_dev;k++) 
	{
		l = strlen(name_copy[k]);
		if ((send.arr1_val[k] = (char *)malloc(l + 1)) == NULL) 
		{
			*perr = DbErr_ClientMemoryAllocation;
			for(i=0;i<k;i++)
				free(send.arr1_val[i]);
			free(send.arr1_val);
			free(name_copy);
			return(-1);
		}
		strcpy(send.arr1_val[k],name_copy[k]);
		for(j=0;j<l;j++)
			send.arr1_val[k][j] = tolower(send.arr1_val[k][j]);
	}

/* Allocate memory for the array of structures sent back to the client */

	if ((*tab = (Db_devinf_imp)calloc(num_dev,sizeof(db_devinf_imp))) == NULL)
	{
		for (i=0;i<(int)num_dev;i++)
			free(send.arr1_val[i]);
		free(send.arr1_val);
		free(name_copy);
		*perr = DbErr_ClientMemoryAllocation;
		return(-1);
	}

/* Structure initialization (structure sended to server) */

	send.arr1_len = num_dev;

/* Call server */

#ifdef ALONE
	recev = db_devimp_1(&send,cl,&error);
#else
	if (i_nethost == 0)
	{
		recev = db_devimp_1(&send,db_info.conf->clnt,&error);
	}
	else
	{
		recev = db_devimp_1(&send,
		   multi_nethost[i_nethost].db_info->clnt,&error);
	}
#endif /* ALONE */

/* If the server is not connected to the database (because a database update
   is just going on), sleep a while (20 mS) and redo the call */

	if (recev != NULL)
	{
		if (recev->db_imperr == DbErr_DatabaseNotConnected)
		{
			for (i = 0;i < RETRY;i++)
			{

#ifdef _OSK
				tsleep(SLEEP_TIME);
#else
				tout.tv_sec = 0;
				tout.tv_usec = 20000;
				select(0,0,0,0,&tout);
#endif /* _OSK */
#ifdef ALONE
				recev = db_devimp_1(&send,cl,&error);
#else
				if (i_nethost == 0)
				{
					recev = db_devimp_1(&send,db_info.conf->clnt,&error);
				}
				else
				{
					recev = db_devimp_1(&send,multi_nethost[i_nethost].db_info->clnt,
				  			    &error);
				}
#endif /* ALONE */
				if(recev == NULL)
					break;
				if ((recev->db_imperr == 0) || (recev->db_imperr != DbErr_DatabaseNotConnected))
					break;
			}
		}
	}

/* Any problem with server ? If yes, don't forget to free memory */

	else
	{
		if (error == DevErr_RPCTimedOut || error == DbErr_RPCreception)
		{
#ifdef ALONE
			to_reconnection((void *)&send,(void **)&recev,&cl,(int)DB_DEVIMP,0,DB_UDP,&error);
#else
			if (i_nethost == 0)
			{
				to_reconnection((void *)&send,(void **)&recev,
					&db_info.conf->clnt,(int)DB_DEVIMP,
					i_nethost,DB_UDP,&error);
			}
			else
			{
				to_reconnection((void *)&send,(void **)&recev,
					&multi_nethost[i_nethost].db_info->clnt,
				        (int)DB_DEVIMP,i_nethost,DB_UDP,&error);
			}
#endif /* ALONE */
		}
		if (error != 0)
		{
			*perr = error;
			free(*tab);
			*tab = NULL;
			for (i=0;i<(int)num_dev;i++)
				free(send.arr1_val[i]);
			free(send.arr1_val);
			free(name_copy);
			return(-1);
		}
	}

/* Return memory */

	for (i=0;i<(int)num_dev;i++)
		free(send.arr1_val[i]);
	free(send.arr1_val);
	free(name_copy);

/* Any problem with database access ? */	

	if (recev->db_imperr != 0)
	{
		*perr = recev->db_imperr;
		free(*tab);
		*tab = NULL;
		return(-1);
	}

/* No error,so copy the result into the caller structures */

	for (i=0;i<(int)num_dev;i++)
	{
		tmp_ptr = &((*tab)[i]);	
		tmp_ptr1 = &(recev->imp_dev.tab_dbdev_val[i]);
		strcpy(tmp_ptr->device_name,tmp_ptr1->dev_name);
		strcpy(tmp_ptr->host_name,tmp_ptr1->host_name);
		strcpy(tmp_ptr->device_type,tmp_ptr1->dev_type);
		strcpy(tmp_ptr->device_class,tmp_ptr1->dev_class);
		tmp_ptr->pn = tmp_ptr1->p_num;
		tmp_ptr->vn = tmp_ptr1->v_num;
	}
		
/* Free the memory allocated by XDR */

#ifdef ALONE
	clnt_freeres(cl,xdr_db_resimp,(char *)recev);
#else
	if (i_nethost == 0)
	{
		clnt_freeres(db_info.conf->clnt,(xdrproc_t)xdr_db_resimp,(char *)recev);
	}
	else
	{
		clnt_freeres(multi_nethost[i_nethost].db_info->clnt,
		             (xdrproc_t)xdr_db_resimp,(char *)recev);
	}
#endif /* ALONE */

/* Leave function */

	*perr = 0;
	return(0);

}



/****************************************************************************
*                                                                           *
*		db_svc_unreg function code                                  *
*               ------------                                                *
*                                                                           *
*    Function rule : To unregister devices from database (to deinitialize   *
*                    the host name, program number and version number for   *
*                    all the devices driven by a device server)             *
*                                                                           *
*    Argins : - A pointer to a string which contains the device server      *
*               network name.                                               *
*                                                                           *
*    Argout : - The error caode in case of trouble                          *
*                                                                           *
*    In case of trouble, the function returns -1 and set the err variable   *
*    pointed to by "perr". Otherwise, the function returns 0                *
*                                                                           *
*****************************************************************************/

int _DLLFunc db_svc_unreg(char *ds_netnam,long *perr)
{
	int i,j,k;
	int *pdb_err;
	char *ds_netnam1;
	long error;
	long i_nethost = 0;
#ifndef _OSK
	struct timeval tout;
#endif /* _OSK */
#ifdef ALONE
	char *serv_name = ALONE_SERVER_HOST;
#endif /* ALONE */

        if (config_flags.no_database)
        {
                *perr = DbErr_NoDatabase;
                return(DS_NOTOK);
        } 

/* Try to verify the function parameters  (non NULL pointer and one
   \ character in device server name) */

	if (ds_netnam == NULL)
	{
		*perr = DbErr_BadParameters;
		return(-1);
	}
	j = 0;
	NB_CHAR(j,ds_netnam,'/');
	if (j != 1)
	{
		*perr = DbErr_BadParameters;
		return(-1);
	}

# ifdef ALONE
/* Create RPC connection if it's the first call */

	if (!first)
	{
		cl = clnt_create(serv_name,DB_SETUPPROG,DB_VERS_3,"udp");
		if (cl == NULL)
		{
			*perr = DbErr_CannotCreateClientHandle;
			return(-1);
		}
		clnt_control(cl,CLSET_TIMEOUT,(char *)&timeout);
		clnt_control(cl,CLSET_RETRY_TIMEOUT,(char *)&retry_timeout);
		first++;
	}
#endif /* ALONE */

/* Make a copy of device server network name and Device server network name 
   in lowercase letters */

	k = strlen(ds_netnam);
	if ((ds_netnam1 = (char *)malloc(k + 1)) == NULL)
	{
		*perr = DbErr_ClientMemoryAllocation;
		return(-1);
	}
	strcpy(ds_netnam1,ds_netnam);
	for (j=0;j<k;j++)
		ds_netnam1[j] = tolower(ds_netnam1[j]);

/* Call server */

#ifdef ALONE
	pdb_err = db_svcunr_1(&ds_netnam1,cl,&error);
#else
	pdb_err = db_svcunr_1(&ds_netnam1,db_info.conf->clnt,&error);
#endif /* ALONE */

/* If the server is not connected to the database (because a database update
   is just going on), sleep a while (20 mS) and redo the call */

	if (pdb_err != NULL)
	{
		if (*pdb_err == DbErr_DatabaseNotConnected)
		{
			for (i = 0;i < RETRY;i++)
			{

#ifdef _OSK
				tsleep(SLEEP_TIME);
#else
				tout.tv_sec = 0;
				tout.tv_usec = 20000;
				select(0,0,0,0,&tout);
#endif /* _OSK */
#ifdef ALONE
				pdb_err = db_svcunr_1(&ds_netnam1,cl,&error);
#else
				pdb_err = db_svcunr_1(&ds_netnam1,db_info.conf->clnt,&error);
#endif /* ALONE */
				if(pdb_err == NULL)
					break;
				if ((*pdb_err == 0) || (*pdb_err != DbErr_DatabaseNotConnected))
					break;
			}
		}
	}

/* Any problem with server ? If yes and if it a time-out, try to reconnect to
   a new database server. Don't fotget to free memory in case of error. */

	else
	{
		if (error == DevErr_RPCTimedOut || error == DbErr_RPCreception)
		{
#ifdef ALONE
			to_reconnection((void *)&ds_netnam1,(void **)&pdb_err,&cl,(int)DB_SVCUNR,i_nethost,DB_UDP,&error);
#else
			to_reconnection((void *)&ds_netnam1,(void **)&pdb_err,
				     &db_info.conf->clnt,(int)DB_SVCUNR,
				     i_nethost,DB_UDP,&error);
#endif /* ALONE */
		}
		if (error != 0)
		{
			*perr = error;
			return(-1);
		}
	}	

/* Return memory */

	free(ds_netnam1);

/* Any problem during database access ? */

	if (*pdb_err != 0)
	{
		*perr = *pdb_err;
		return(-1);
	}

/* No error */

	*perr = 0;
	return(0);

}



/****************************************************************************
*                                                                           *
*		db_svc_check function code                                  *
*               ------------                                                *
*                                                                           *
*    Function rule : To send back to the user the program numberand the     *
*                    version number of a device server (to allow him to     *
*                    test if the device server has not been killed by an    *
*                    OS-9 kill)                                             *
*                                                                           *
*    Argins : - A pointer to a string which contains the device server      *
*               network name.                                               *
*                                                                           *
*    Argout : - The program number                                          *
*             - The version number                                          *
*             - The host_name                                               *
*             - The error code in case of trouble                           *
*                                                                           *
*    In case of trouble, the function returns -1 and set the err variable   *
*    pointed to by "perr". Otherwise, the function returns 0                *
*                                                                           *
*****************************************************************************/

int _DLLFunc db_svc_check(char *ds_netname,char **pho_name, u_int *pp_num, u_int *pv_num,long *perr)
{
	int i,j,k;
	svc_inf *back;
	char *ds_netname1;
	long error;
	long i_nethost = 0;
#ifndef OSK
	struct timeval tout;
#endif /* OSK */
#ifdef ALONE
	char *serv_name = ALONE_SERVER_HOST;
#endif /* ALONE */

        if (config_flags.no_database)
        {
                *perr = DbErr_NoDatabase;
                return(DS_NOTOK);
        } 

/* Try to verify the function parameters (non NULL pointers and one
   / character in device server name) */

	if (ds_netname == NULL || pho_name == NULL || pp_num == NULL || pv_num == NULL)
	{
		*perr = DbErr_BadParameters;
		return(-1);
	}
	k = 0;
	NB_CHAR(k,ds_netname,'/');
	if (k != 1)
	{
		*perr = DbErr_BadParameters;
		return(-1);
	}

#ifdef ALONE
/* Create RPC connection if it's the first call */

	if (!first)
	{
		cl = clnt_create(serv_name,DB_SETUPPROG,DB_VERS_3,"udp");
		if (cl == NULL)
		{
			*perr = DbErr_CannotCreateClientHandle;
			return(-1);
		}
		clnt_control(cl,CLSET_TIMEOUT,(char *)&timeout);
		clnt_control(cl,CLSET_RETRY_TIMEOUT,(char *)&retry_timeout);
		first++;
	}
#endif /* ALONE */

/* Allocate memory for a copy of the device server network name and device 
   server network name in lowercase letters */

	k = strlen(ds_netname);
	if ((ds_netname1 = (char *)malloc(k + 1)) == NULL)
	{
		*perr = DbErr_ClientMemoryAllocation;
		return(-1);
	}
	strcpy(ds_netname1,ds_netname);
	for (j=0;j<k;j++) 
		ds_netname1[j] = tolower(ds_netname1[j]);

/* Call server */

#ifdef ALONE
	back = db_svcchk_1(&ds_netname1,cl,&error);
#else
	back = db_svcchk_1(&ds_netname1,db_info.conf->clnt,&error);
#endif /* ALONE */

/* If the server is not connected to the database (because a database update
   is just going on), sleep a while (20 mS) and redo the call */

	if (back != NULL)
	{
		if (back->db_err == DbErr_DatabaseNotConnected)
		{
			for (i = 0;i < RETRY;i++)
			{

#ifdef _OSK
				tsleep(SLEEP_TIME);
#else
				tout.tv_sec = 0;
				tout.tv_usec = 20000;
				select(0,0,0,0,&tout);
#endif /* _OSK */
#ifdef ALONE
				back = db_svcchk_1(&ds_netname1,cl,&error);
#else
				back = db_svcchk_1(&ds_netname1,db_info.conf->clnt,&error);
#endif /* ALONE */
				if(back == NULL)
					break;
				if ((back->db_err == 0) || (back->db_err != DbErr_DatabaseNotConnected))
					break;
			}
		}
	}

/* Any problem with server ? If yes and if it is a time-out, try to reconnect
   to a new database server. Don't forget to free memory in case of error */

	else
	{
		if (error == DevErr_RPCTimedOut || error == DbErr_RPCreception)
		{
#ifdef ALONE
			to_reconnection((void *)&ds_netname1,(void **)&back,&cl,(int)DB_SVCCHK,i_nethost,DB_UDP,&error);
#else
			to_reconnection((void *)&ds_netname1,(void **)&back,
				     &db_info.conf->clnt,(int)DB_SVCCHK,
				     i_nethost,DB_UDP,&error);
#endif /* ALONE */
		}
		if (error != 0)
		{
			free(ds_netname1);
			*perr = error;
			return(-1);
		}
	}

/* Return memory */

	free(ds_netname1);

/* Any problem during database access ? */

	if (back->db_err != 0)
	{
#ifdef ALONE
		clnt_freeres(cl,(xdrproc_t)xdr_svc_inf,(char *)back);
#else	
		clnt_freeres(db_info.conf->clnt,(xdrproc_t)xdr_svc_inf,(char *)back);
#endif
		*perr = back->db_err;
		return(-1);
	}

/* Allocate memory to store host name and copy it */

	if ((*pho_name = (char *)malloc(strlen(back->ho_name) + 1)) == NULL)
	{
		*perr = DbErr_ClientMemoryAllocation;
		return(-1);
	}
	strcpy(*pho_name,back->ho_name);
	
/* No error */

	*pp_num = back->p_num;
	*pv_num = back->v_num;
#ifdef ALONE
	clnt_freeres(cl,(xdrproc_t)xdr_svc_inf,(char *)back);
#else	
	clnt_freeres(db_info.conf->clnt,(xdrproc_t)xdr_svc_inf,(char *)back);
#endif
	*perr = 0;
	return(0);

}
 


#ifndef _OSK
/****************************************************************************
*                                                                           *
*		db_getdevexp function code                                  *
*               ------------                                                *
*                                                                           *
*    Function rule : To retrieve the exported device names. These           * 
*		     information can be found in a databse on a remote      *
*		     computer						    *
*                                                                           *
*    Argins : - A filter to select the exported device names.		    *
*             - The address of the pointer to the string's array            *
*                                                                           *
*    Argout : - The number of exported devices                              *
*             - The error code in case of problems                          *
*                                                                           *
*    In case of trouble, the function returns -1 and set the err varaible   *
*    pointed to by "perr". Otherwise, the function returns 0                *
*                                                                           *
*****************************************************************************/

int _DLLFunc db_getdevexp(char *filter,char ***tab, u_int *num_dev,long *perr)
{
	char *filter1;
	register db_res *recev;
	int i,j,k,tp;
	CLIENT *tcp_cl;
	int tcp_so;
	int tcp_used = 0;
	long error;
	struct timeval tout;
#ifdef ALONE
	char *serv_name = ALONE_SERVER_HOST;
#endif /* ALONE */

        if (config_flags.no_database)
        {
                *perr = DbErr_NoDatabase;
                return(DS_NOTOK);
        } 

/* Try to verify the function parameters (non NULL pointers) and no more 
   than 2 / characters in filter name */

	if (num_dev == NULL || tab == NULL)
	{
		*perr = DbErr_BadParameters;
		return(-1);
	}
	
/* If the filter string is NULL, replace it with * chracters */

	if (filter == NULL)
		filter = (char *)"*/*/*";

	i = 0;
	NB_CHAR(i,filter,'/');
	if (i > 2)
	{
		*perr = DbErr_BadParameters;
		return(-1);
	}


/* Verify that only one wild-card is used for every filter fields */

	if (test_star(filter))
	{
		*perr = DbErr_BadParameters;
		return(-1);
	}

/* Verify that the first and the last characters are not /. */

	k = strlen(filter);
	if (filter[0] == '/' || filter[k - 1] == '/')
	{
		*perr = DbErr_BadParameters;
		return(-1);
	}

/* Allocate memory for the db_res structures array if it's the first call
   to this function */

	if (!first_devexp)
	{
		if ((tab_clstu = (devexp_res *)calloc(ST_ALLOC,sizeof(devexp_res))) == NULL)
		{
			*perr = DbErr_ClientMemoryAllocation;
			return(-1);
		}
		first_devexp++;
	}

#ifdef ALONE
/* Create RPC connection if it's the first call */

	if (!first)
	{
		cl = clnt_create(serv_name,DB_SETUPPROG,DB_VERS_3,"udp");
		if (cl == NULL)
		{
			*perr = DbErr_CannotCreateClientHandle;
			return(-1);
		}
		clnt_control(cl,CLSET_TIMEOUT,(char *)&timeout);
		clnt_control(cl,CLSET_RETRY_TIMEOUT,(char *)&retry_timeout);
		first++;
	}
#endif /* ALONE */


/* Make a copy of the filter name and all  the string's character 
   in lowercase */

	if ((filter1 = (char *)malloc(k + 1)) == NULL)
	{
		*perr = DbErr_ClientMemoryAllocation;
		return(-1);
	}
	strcpy(filter1,filter);
	for(i=0;i<k;i++)
		filter1[i] = tolower(filter1[i]);	

/* Realloc memory if the array tab_clstu is full */

	if (func_ptr != 0 && (func_ptr & 0x7) == 0)
	{
		tp = ((func_ptr >> 3) + 1) << 3;
		if ((tab_clstu = (devexp_res *)realloc(tab_clstu,sizeof(devexp_res) * tp)) == NULL)
		{
			*perr = DbErr_ClientMemoryAllocation;
			return(-1);
		}
		memset((void *)(&tab_clstu[func_ptr]),0,sizeof(devexp_res) << 3);
	}

/* Call server */

#ifdef ALONE
	recev = db_getdevexp_1(&filter1,cl,&error);
#else
	recev = db_getdevexp_1(&filter1,db_info.conf->clnt,&error);	
#endif /* ALONE */
	
/* If the server is not connected to the database (because a database update
   is just going on), sleep a while (20 mS) and redo the call */

	if (recev != NULL)
	{
		if (recev->db_err == DbErr_DatabaseNotConnected)
		{
			for (i = 0;i < RETRY;i++)
			{
				tout.tv_sec = 0;
				tout.tv_usec = 20000;
				select(0,0,0,0,&tout);
#ifdef ALONE
				recev = db_getdevexp_1(&filter1,cl,&error);
#else
				recev = db_getdevexp_1(&filter1,db_info.conf->clnt,&error);
#endif /* ALONE */
				if(recev == NULL)
					break;
				if ((recev->db_err == 0) || (recev->db_err != DbErr_DatabaseNotConnected))
					break;
			}
		}
	}

/* Any problem with server ? */

	if(recev == NULL)
	{
		*perr = error;
		return(-1);
	}

/* Any problems during database access ? */

	if(recev->db_err != 0)
	{
		if (recev->db_err != DbErr_MaxDeviceForUDP)
		{
			*perr = recev->db_err;
			return(-1);
		}

/* If the server answers that there is too many info to send for the UDP
   protocol, create a TCP connection to the server and redo the call.
   To be able to correctly close the TCP connection, we must know the 
   socket number to close it (the RPC function does not do this). So, instead
   of the clnt_create function, we used the clnttcp_create function. */

		else
		{

			if (!first_tcp_call)
			{
#ifdef ALONE
				if ((ht = gethostbyname(serv_name)) == NULL)
				{
#else
#ifndef vxworks
				if ((ht = gethostbyname(db_info.conf->server_host)) == NULL)
				{
#else  /* !vxworks */
				if ((host_addr = hostGetByName(db_info.conf->server_host)) == 0) {
#endif /* !vxworks */
#endif /* ALONE */
					*perr = DbErr_CannotCreateClientHandle;
					return(-1);
				}

				serv_adr.sin_family = AF_INET;
#ifndef vxworks
				memcpy((void *)(&serv_adr.sin_addr),ht->h_addr,(size_t)ht->h_length);
#else  /* !vxworks */
				memcpy((void *)(&serv_adr.sin_addr),(char*)&host_addr,4);
#endif /* !vxworks */
				first_tcp_call = 1;
			}

			serv_adr.sin_port = 0;
			tcp_so = RPC_ANYSOCK;
#ifdef ALONE
			tcp_cl = clnttcp_create(&serv_adr,DB_SETUPPROG,
						DB_VERS_3, &tcp_so,0,0);
#else
			tcp_cl = clnttcp_create(&serv_adr,
					        db_info.conf->prog_number,
					        DB_VERS_3,&tcp_so,0,0);
#endif /* ALONE */
			if (tcp_cl == NULL)
			{
				*perr = DbErr_CannotCreateClientHandle;
				return(-1);
			}

/* Redo the call */

			recev = db_getdevexp_1(&filter1,tcp_cl,&error);

/* If the server is not connected to the database (because a database update
   is just going on), sleep a while (20 mS) and redo the call */

			if (recev != NULL)
			{
				if (recev->db_err == DbErr_DatabaseNotConnected)
				{
					for (i = 0;i < RETRY;i++)
					{
						tout.tv_sec = 0;
						tout.tv_usec = 20000;
						select(0,0,0,0,&tout);

						recev = db_getdevexp_1(&filter1,tcp_cl,&error);

						if(recev == NULL)
							break;
						if ((recev->db_err == 0) || (recev->db_err != DbErr_DatabaseNotConnected))
							break;
					}
				}
			}

/* Any problem with server ? */

			if(recev == NULL)
			{
				*perr = error;
#ifndef _NT
				close(tcp_so);
#else
				closesocket(tcp_so);
#endif
				clnt_destroy(tcp_cl);
				return(-1);
			}

/* Any problems during database access ? */

			if(recev->db_err != 0)
			{
				*perr = recev->db_err;
#ifndef _NT
				close(tcp_so);
#else
				closesocket(tcp_so);
#endif
				clnt_destroy(tcp_cl);
				return(-1);
			}

			tcp_used = 1;

		}
	}
	
/* Try to get TANGO exported device(s) list */

#ifdef __STDCPP__
	long ret_val;
	vector<string> tg_dev_name;
	long full_dev_nb;
	 
	ret_val = get_tango_exp_devices(filter1,tg_dev_name,perr);

/* Copy device name in classical C char arrays */
		
	switch (ret_val)
	{
	case 1 :
		full_dev_nb = recev->res_val.arr1_len; 
		break;
		
	case 0 :
		full_dev_nb = tg_dev_name.size() + recev->res_val.arr1_len;
		break;
	}
	
/* Merge the two arrays (taco devices and tango devices) */
	
	if ((*tab = new char *[full_dev_nb]) == NULL)
	{
		*perr = DbErr_ClientMemoryAllocation;
		return -1;
	}
	
	for (i = 0;i < full_dev_nb;i++)
	{
		if (i < recev->res_val.arr1_len)
		{
			if (((*tab)[i] = new char[strlen(recev->res_val.arr1_val[i]) + 1]) == NULL)
			{
				for (j = 0;j < i;j++)
					delete (*tab)[j];
				delete *tab;
				*perr = DbErr_ClientMemoryAllocation;
				return -1;
			}
			strcpy((*tab)[i],recev->res_val.arr1_val[i]);
		}
		else
		{
			j = i - recev->res_val.arr1_len;
			if (((*tab)[i] = new char[tg_dev_name[j].size() + 1]) == NULL)
			{
				for (k = 0;k < i;k++)
					delete (*tab)[k];
				delete *tab;
				*perr = DbErr_ClientMemoryAllocation;
				return -1;
			}
			strcpy((*tab)[i],tg_dev_name[j].c_str());
		}
	}

/* Return memory */

	free(filter1);
	if (tcp_used == 1)
		clnt_freeres(tcp_cl,(xdrproc_t)xdr_db_res,(char *)&(recev->res_val));
	else
		clnt_freeres(db_info.conf->clnt,(xdrproc_t)xdr_db_res,(char *)&(recev->res_val));
	
				
/* Sort the returned string array */

	kern_sort(*tab,full_dev_nb);

/* Initialize devices name number */

	*num_dev = full_dev_nb;
	
/* Copy the information needed to free memory in the db_freedevexp function
   in the tab_clstu array */

	if (tcp_used == 1)
	{
		tab_clstu[func_ptr].tcp = 1;
		tab_clstu[func_ptr].tcp_so = tcp_so;
		tab_clstu[func_ptr].cl = tcp_cl;
		tab_clstu[func_ptr].res.res_val.arr1_len = full_dev_nb;
		tab_clstu[func_ptr].res.res_val.arr1_val = *tab;
	}
	else
	{
#ifdef ALONE
		tab_clstu[func_ptr].cl = cl;
#else
		tab_clstu[func_ptr].cl = db_info.conf->clnt;
#endif /* ALONE */
		tab_clstu[func_ptr].tcp = 0;
		tab_clstu[func_ptr].res.res_val.arr1_len = full_dev_nb;
		tab_clstu[func_ptr].res.res_val.arr1_val = *tab;
	}
	func_ptr++;

/* No error */

	*perr = 0;
	return(0);
	
#else /* __STDCPP__ */

/* Return memory */

	free(filter1);
	
/* Sort the returned string array */

	kern_sort(recev->res_val.arr1_val,recev->res_val.arr1_len);

/* Initialize devices name number */

	*num_dev = recev->res_val.arr1_len;

/* Initialize the pointer to the array of string (memory alloc. by XDR) */

	*tab = recev->res_val.arr1_val;
	
/* Copy the information needed to free memory in the db_freedevexp function
   in the tab_clstu array */

	if (tcp_used == 1)
	{
		tab_clstu[func_ptr].tcp = 1;
		tab_clstu[func_ptr].tcp_so = tcp_so;
		tab_clstu[func_ptr].cl = tcp_cl;
		tab_clstu[func_ptr].res.res_val.arr1_len = recev->res_val.arr1_len;
		tab_clstu[func_ptr].res.res_val.arr1_val = *tab;	
	}
	else
	{
#ifdef ALONE
		tab_clstu[func_ptr].cl = cl;
#else
		tab_clstu[func_ptr].cl = db_info.conf->clnt;
#endif /* ALONE */
		tab_clstu[func_ptr].tcp = 0;
		tab_clstu[func_ptr].res.res_val.arr1_len = recev->res_val.arr1_len;
		tab_clstu[func_ptr].res.res_val.arr1_val = *tab;
	}
	func_ptr++;

/* No error */

	*perr = 0;
	return(0);
	
#endif /* __STDCPP__ */

}




/****************************************************************************
*                                                                           *
*		Code for kern_sort function                                 *
*                        ---------                                          *
*                                                                           *
*    Function rule : To sort an array of strings. The sort is done with the *
*		     strcmp function. The algorithm come from the famous    *
*	 	     Kernighan and Ritchie book (chapter 5)		    *
*                                                                           *
*    Argin : - The address of the array of strings pointers		    *
*	     - The number of elements in this array			    *
*                                                                           *
*    Argout : No argout                                                     *
*                                                                           *
****************************************************************************/
void kern_sort(char **tab,int n)
{
	int gap,i,j;
	char *temp;

	for (gap = n/2;gap > 0;gap /= 2)
	{
		for (i = gap;i < n;i++)
		{
			for (j = i - gap;j >=0; j -= gap)
			{
				if (strcmp(tab[j],tab[j + gap]) <= 0) 
					break;
				else
				{
					temp = tab[j];
					tab[j] = tab[j + gap];
					tab[j + gap] = temp;
				}
			}
		}
	}
}


			
/****************************************************************************
*                                                                           *
*		Code for test_star function                                 *
*                        ---------                                          *
*                                                                           *
*    Function rule : To test the number of wild card ('*') in every filter  *
*		     fields. The maximun number of '*' for each field is 1  *
*                                                                           *
*    Argin : - A pointer to the filter string				    *
*                                                                           *
*    Argout : No argout                                                     *
*                                                                           *
*    This function returns 0 if the * is correctly used. Otherwise, the     *
*    function returns -1						    *
*                                                                           *
****************************************************************************/
int test_star(char *filter)
{
	int i,j;
	char *tmp,*temp;
	u_int diff;
	char filter_domain[SIZE_A];
	char filter_family[SIZE_A];
	char filter_member[SIZE_A];

/* Extract from filter string each part of the filter (domain, family and 
   member). If two / characters can be retrieved in the filter string, this
   means that the domain, family and member part of the filter are initialized.
   If only one / can be retrieved, only the domain and family part are
   initialized and if there is no / in the filter string, just the domain
   is initialized. */

	i = 0;
	tmp = filter;
	NB_CHAR(i,tmp,'/');

	switch(i)
	{
	case 2 : 
		tmp = strchr(filter,'/');
		diff = (u_int)(tmp++ - filter);
		strncpy(filter_domain,filter,diff);
		filter_domain[diff] = 0;

		temp = strchr(tmp,'/');
		diff = (u_int)(temp++ - tmp);
		strncpy(filter_family,tmp,diff);
		filter_family[diff] = 0;

		strcpy(filter_member,temp);

/* For each fields, count the number of wild card used */

		j = 0;
		NB_CHAR(j,filter_domain,'*');
		if (j > 1)
			return(-1);

		j = 0;
		NB_CHAR(j,filter_family,'*');
		if (j > 1)
			return(-1);

		j = 0;
		 NB_CHAR(j,filter_member,'*');
		if (j > 1)
			return(-1);

		break;

	case 1 : 
		tmp = strchr(filter,'/');
		diff = (u_int)(tmp++ - filter);
		strncpy(filter_domain,filter,diff);
		filter_domain[diff] = 0;

		strcpy(filter_family,tmp);

/* For each fields, count the number of wild card used */

		j = 0;
		NB_CHAR(j,filter_domain,'*')
		if (j > 1)
			return(-1);

		j = 0;
		NB_CHAR(j,filter_family,'*');
		if (j > 1)
			return(-1);

		break;

	case 0 : 
		strcpy(filter_domain,filter);

/* For each fields, count the number of wild card used */

		j = 0;
		NB_CHAR(j,filter_domain,'*')
		if (j > 1)
			return(-1);

		break;
	}

	return(0);

}



/****************************************************************************
*                                                                           *
*		Code for db_freedevexp function                             *
*                        -------------                                      *
*                                                                           *
*    Function rule : To free all the memory needed by the db_getdevexp      *
*                    function (essentially allocated by XDR routines)       *
*                                                                           *
*    Argin : - The pointer to the array of exported device name strings.    *
*	       This pointer must have been initialized by a db_getdevexp    *
*	       function.						    *
*                                                                           *
*    Argout : No argout                                                     *
*                                                                           *
*    This function returns 0 if no errors occurs or -1 if a problem occurs  *
*                                                                           *
****************************************************************************/

int _DLLFunc db_freedevexp(char **ptr)
{
	register int i;
	int l;

        if (config_flags.no_database)
        {
                return(DS_NOTOK);
        } 

/* If the buffer's pointer is null (may be no device names have been returned
   by the db_getdevexp function), leave the function. */

	if (ptr == NULL)
		return(0);

/* At least one call to db_dataget function before using db_free ? */

	if (first_devexp == 0) 
		return(-1);

/* Does this pointer exist in the tab_clstu array ? */

	for (i = 0;i < func_ptr;i++)
	{
		if (tab_clstu[i].res.res_val.arr1_val == ptr)
			break;
	}

	if (i == func_ptr)
		return(-1);

/* TCP was used for this call ? */

	if (tab_clstu[i].tcp == 1)
	{

/* Free the memory, close the socket and destroy the RPC connection */

#ifdef __STDCPP__
		for (l = 0;l < tab_clstu[i].res.res_val.arr1_len;l++)
			delete [] ptr[l];
		delete [] ptr;
#else
		if (!clnt_freeres(tab_clstu[i].cl,(xdrproc_t)xdr_db_res,(char *)&(tab_clstu[i].res)))
			return(-1);
#endif /* __STDCPP__ */

#ifndef _NT
		close(tab_clstu[i].tcp_so);
#else
		closesocket(tab_clstu[i].tcp_so);
#endif
		clnt_destroy(tab_clstu[i].cl);
	}

	else
	{

/* Free the memory */

#ifdef __STDCPP__
		for (l = 0;l < tab_clstu[i].res.res_val.arr1_len;l++)
			delete ptr[l];
		delete ptr;
#else
		if (!clnt_freeres(tab_clstu[i].cl,(xdrproc_t)xdr_db_res,(char *)&(tab_clstu[i].res)))
			return(-1);
#endif
	}

	return(0);
	
}



/****************************************************************************
*                                                                           *
*		db_cmd_query function code                                  *
*               ------------                                                *
*                                                                           *
*    Function rule : To retrieve, from the database, the code associated to *
*		     a coomand string					    *
*                                                                           *
*    Argins : - The command name					    *
*                                                                           *
*    Argout : - The command code					    *
* 	      - The error caode in case of trouble                          *
*                                                                           *
*    In case of trouble, the function returns -1 and set the err variable   *
*    pointed to by "perr". Otherwise, the function returns 0                *
*                                                                           *
*****************************************************************************/

int _DLLFunc db_cmd_query(char *cmd_name, u_int *cmd_code,long *perr)
{
	int i;
	cmd_que *serv_ans;
	long error;
	long i_nethost = 0;
#ifndef _OSK
	struct timeval tout;
#endif /* _OSK */
#ifdef ALONE
	char *serv_name = ALONE_SERVER_HOST;
#endif /* ALONE */

        if (config_flags.no_database)
        {
                *perr = DbErr_NoDatabase;
                return(DS_NOTOK);
        } 

/* Try to verify the function parameters  (non NULL pointer and one
   \ character in device server name) */

	if ((cmd_name == NULL) || (cmd_code == NULL))
	{
		*cmd_code = 0;
		*perr = DbErr_BadParameters;
		return(-1);
	}

# ifdef ALONE
/* Create RPC connection if it's the first call */

	if (!first)
	{
		cl = clnt_create(serv_name,DB_SETUPPROG,DB_VERS_3,"udp");
		if (cl == NULL)
		{
			*cmd_code = 0;
			*perr = DbErr_CannotCreateClientHandle;
			return(-1);
		}
		clnt_control(cl,CLSET_TIMEOUT,(char *)&timeout);
		clnt_control(cl,CLSET_RETRY_TIMEOUT,(char *)&retry_timeout);
		first++;
	}
#endif /* ALONE */

/* Call server */

#ifdef ALONE
	serv_ans = db_cmd_query_1(&cmd_name,cl,&error);
#else
	serv_ans = db_cmd_query_1(&cmd_name,db_info.conf->clnt,&error);
#endif /* ALONE */

/* If the server is not connected to the database (because a database update
   is just going on), sleep a while (20 mS) and redo the call */

	if (serv_ans != NULL)
	{
		if (serv_ans->db_err == DbErr_DatabaseNotConnected)
		{
			for (i = 0;i < RETRY;i++)
			{

#ifdef _OSK
				tsleep(SLEEP_TIME);
#else
				tout.tv_sec = 0;
				tout.tv_usec = 20000;
				select(0,0,0,0,&tout);
#endif /* _OSK */
#ifdef ALONE
				serv_ans = db_cmd_query_1(&cmd_name,cl,&error);
#else
				serv_ans = db_cmd_query_1(&cmd_name,db_info.conf->clnt,&error);
#endif /* ALONE */
				if(serv_ans == NULL)
					break;
				if ((serv_ans->db_err == 0) || (serv_ans->db_err != DbErr_DatabaseNotConnected))
					break;
			}
		}
	}

/* Any problem with server ? If yes and if it a time-out, try to reconnect to
   a new database server. Don't forget to free memory in case of error. */

	else
	{
		if (error == DevErr_RPCTimedOut || error == DbErr_RPCreception)
		{
#ifdef ALONE
			to_reconnection((void *)&cmd_name,(void **)&serv_ans,&cl,(int)DB_CMDQUERY,i_nethost,DB_UDP,&error);
#else
			to_reconnection((void *)&cmd_name,(void **)&serv_ans,
				     &db_info.conf->clnt,(int)DB_CMDQUERY,
				     i_nethost,DB_UDP,&error);
#endif /* ALONE */
		}
		if (error != 0)
		{
			*cmd_code = 0;
			*perr = error;
			return(-1);
		}
	}	

/* Any problem during database access ? */

	if (serv_ans->db_err != 0)
	{
		*cmd_code = 0;
		*perr = serv_ans->db_err;
		return(-1);
	}

/* No error */

	*cmd_code = serv_ans->xcmd_code;
	*perr = 0;
	return(0);

}


/****************************************************************************
*                                                                           *
*		db_event_query function code                                *
*               ------------                                                *
*                                                                           *
*    Function rule : To retrieve, from the database, the code associated to *
*		     a coomand string					    *
*                                                                           *
*    Argins : - The command name					    *
*                                                                           *
*    Argout : - The command code					    *
* 	      - The error caode in case of trouble                          *
*                                                                           *
*    In case of trouble, the function returns -1 and set the err variable   *
*    pointed to by "perr". Otherwise, the function returns 0                *
*                                                                           *
*****************************************************************************/

int _DLLFunc db_event_query(char *event_name, u_int *event_code,long *perr)
{
	int i;
	event_que *serv_ans;
	long error;
	long i_nethost = 0;
#ifndef _OSK
	struct timeval tout;
#endif /* _OSK */
#ifdef ALONE
	char *serv_name = ALONE_SERVER_HOST;
#endif /* ALONE */

        if (config_flags.no_database)
        {
                *perr = DbErr_NoDatabase;
                return(DS_NOTOK);
        } 

/* Try to verify the function parameters  (non NULL pointer and one
   \ character in device server name) */

	if ((event_name == NULL) || (event_code == NULL))
	{
		*event_code = 0;
		*perr = DbErr_BadParameters;
		return(-1);
	}

# ifdef ALONE
/* Create RPC connection if it's the first call */

	if (!first)
	{
		cl = clnt_create(serv_name,DB_SETUPPROG,DB_VERS_3,"udp");
		if (cl == NULL)
		{
			*event_code = 0;
			*perr = DbErr_CannotCreateClientHandle;
			return(-1);
		}
		clnt_control(cl,CLSET_TIMEOUT,(char *)&timeout);
		clnt_control(cl,CLSET_RETRY_TIMEOUT,(char *)&retry_timeout);
		first++;
	}
#endif /* ALONE */

/* Call server */

#ifdef ALONE
	serv_ans = db_event_query_1(&event_name,cl,&error);
#else
	serv_ans = db_event_query_1(&event_name,db_info.conf->clnt,&error);
#endif /* ALONE */

/* If the server is not connected to the database (because a database update
   is just going on), sleep a while (20 mS) and redo the call */

	if (serv_ans != NULL)
	{
		if (serv_ans->db_err == DbErr_DatabaseNotConnected)
		{
			for (i = 0;i < RETRY;i++)
			{

#ifdef _OSK
				tsleep(SLEEP_TIME);
#else
				tout.tv_sec = 0;
				tout.tv_usec = 20000;
				select(0,0,0,0,&tout);
#endif /* _OSK */
#ifdef ALONE
				serv_ans = db_event_query_1(&event_name,cl,&error);
#else
				serv_ans = db_event_query_1(&event_name,db_info.conf->clnt,&error);
#endif /* ALONE */
				if(serv_ans == NULL)
					break;
				if ((serv_ans->db_err == 0) || (serv_ans->db_err != DbErr_DatabaseNotConnected))
					break;
			}
		}
	}

/* Any problem with server ? If yes and if it a time-out, try to reconnect to
   a new database server. Don't forget to free memory in case of error. */

	else
	{
		if (error == DevErr_RPCTimedOut || error == DbErr_RPCreception)
		{
#ifdef ALONE
			to_reconnection((void *)&event_name,(void **)&serv_ans,&cl,(int)DB_EVENTQUERY,i_nethost,DB_UDP,&error);
#else
			to_reconnection((void *)&event_name,(void **)&serv_ans,
				     &db_info.conf->clnt,(int)DB_EVENTQUERY,
				     i_nethost,DB_UDP,&error);
#endif /* ALONE */
		}
		if (error != 0)
		{
			*event_code = 0;
			*perr = error;
			return(-1);
		}
	}	

/* Any problem during database access ? */

	if (serv_ans->db_err != 0)
	{
		*event_code = 0;
		*perr = serv_ans->db_err;
		return(-1);
	}

/* No error */

	*event_code = serv_ans->xevent_code;
	*perr = 0;
	return(0);

}
#endif /* _OSK */



/****************************************************************************
*                                                                           *
*		db_psdev_register function code                             *
*               -----------------                                           *
*                                                                           *
*    Function rule : To register pseudo devices in the static database      *
*                                                                           *
*    Argins : - The array of pseudo devices information structures          *
*               In each structure, teh caller initialize the pseudo device  *
*		name and the update period in the dc			    *
*	      - The pseudo devices number				    *
*                                                                           *
*    Argout : No argout							    *
*                                                                           *
*    In case of major trouble, the function returns -1 and set the          *
*    error_code  variable of the error structure. In case of error for a    *
*    pseudo device in the list, the function returns 1.			    *
*    Otherwise, the function returns 0                			    *
*                                                                           *
*****************************************************************************/

int _DLLFunc db_psdev_register(db_psdev_info *psdev,long num_psdev,db_error *p_err)
{
	register long i;
	int l;
	psdev_reg_x *tmp_x;
	psdev_elt *tmp_x_low;
	long error;
	db_psdev_error *serv_ans;
	static char hostna[32];
	long i_nethost = 0;
#ifndef _OSK
	struct timeval tout;
#endif /* _OSK */
#ifdef ALONE
	char *serv_name = ALONE_SERVER_HOST;
#endif /* ALONE */

        if (config_flags.no_database)
        {
                p_err->error_code = DbErr_NoDatabase;
		p_err->psdev_err = 0;
                return(DS_NOTOK);
        } 

/* Try to verify the function parameters  (non NULL pointer) */

	if ((psdev == NULL) || (num_psdev == 0))
	{
		p_err->error_code = DbErr_BadParameters;
		p_err->psdev_err = 0;
		return(-1);
	}

	for (i = 0;i < num_psdev;i++)
	{
		l = 0;
		NB_CHAR(l,psdev[i].psdev_name,'/');
		if (l != 2)
		{
			p_err->error_code = DbErr_BadParameters;
			p_err->psdev_err = 0;
			return(-1);
		}
	}

# ifdef ALONE
/* Create RPC connection if it's the first call */

	if (!first)
	{
		cl = clnt_create(serv_name,DB_SETUPPROG,DB_VERS_3,"udp");
		if (cl == NULL)
		{
			p_err->error_code = DbErr_CannotCreateClientHandle;
			p_err->psdev_err = 0;
			return(-1);
		}
		clnt_control(cl,CLSET_TIMEOUT,(char *)&timeout);
		clnt_control(cl,CLSET_RETRY_TIMEOUT,(char *)&retry_timeout);
		first++;
	}
#endif /* ALONE */

/* Allocate memory for XDR transfer */

	if ((tmp_x = (psdev_reg_x *)malloc(sizeof(psdev_reg_x))) == NULL)
	{
		p_err->error_code = DbErr_ClientMemoryAllocation;
		p_err->psdev_err = 0;
		return(-1);
	}
	if ((tmp_x_low = (psdev_elt *)calloc(num_psdev,sizeof(psdev_elt))) == NULL)
	{
		free(tmp_x);
		p_err->error_code = DbErr_ClientMemoryAllocation;
		p_err->psdev_err = 0;
		return(-1);
	}

/* Init. the previously allocated structures */

#if defined(_NT)
	tmp_x->pid = _getpid();
#else  /* _NT */
#if !defined (vxworks)
	tmp_x->pid = getpid();
#else  /* !vxworks */
	tmp_x->pid = taskIdSelf();
#endif /* !vxworks */
#endif /* _NT */
	gethostname(hostna,sizeof(hostna));
	tmp_x->h_name = hostna;

	tmp_x->psdev_arr.psdev_arr_len = num_psdev;
	tmp_x->psdev_arr.psdev_arr_val = tmp_x_low;

	for (i = 0;i < num_psdev;i++)
	{
		tmp_x_low[i].poll = psdev[i].poll_interval;
		tmp_x_low[i].psdev_name = psdev[i].psdev_name;
	}

/* Call server */

#ifdef ALONE
	serv_ans = db_psdev_reg_1(tmp_x,cl,&error);
#else
	serv_ans = db_psdev_reg_1(tmp_x,db_info.conf->clnt,&error);
#endif /* ALONE */

/* If the server is not connected to the database (because a database update
   is just going on), sleep a while (20 mS) and redo the call */

	if (serv_ans != NULL)
	{
		if (serv_ans->error_code == DbErr_DatabaseNotConnected)
		{
			for (i = 0;i < RETRY;i++)
			{

#ifdef _OSK
				tsleep(SLEEP_TIME);
#else
				tout.tv_sec = 0;
				tout.tv_usec = 20000;
				select(0,0,0,0,&tout);
#endif /* _OSK */
#ifdef ALONE
				serv_ans = db_psdev_reg_1(tmp_x,cl,&error);
#else
				serv_ans = db_psdev_reg_1(tmp_x,db_info.conf->clnt,&error);
#endif /* ALONE */
				if(serv_ans == NULL)
					break;
				if ((serv_ans->error_code == 0) || (serv_ans->error_code != DbErr_DatabaseNotConnected))
					break;
			}
		}
	}

/* Any problem with server ? If yes and if it a time-out, try to reconnect to
   a new database server. Don't forget to free memory in case of error. */

	else
	{
		if (error == DevErr_RPCTimedOut || error == DbErr_RPCreception)
		{
#ifdef ALONE
			to_reconnection((void *)tmp_x,(void **)&serv_ans,&cl,(int)DB_PSDEV_REG,i_nethost,DB_UDP,&error);
#else
			to_reconnection((void *)tmp_x,(void **)&serv_ans,
				     &db_info.conf->clnt,(int)DB_PSDEV_REG,
				     i_nethost,DB_UDP,&error);
#endif /* ALONE */
		}
		if (error != 0)
		{
			free(tmp_x);
			free(tmp_x_low);
			p_err->error_code = error;
			p_err->psdev_err = 0;
			return(-1);
		}
	}	

/* Free memory */

	free(tmp_x);
	free(tmp_x_low);

/* Any problem during database access ? */

	if (serv_ans->error_code != 0)
	{
		p_err->error_code = serv_ans->error_code;
		p_err->psdev_err = serv_ans->psdev_err;
		return(1);
	}

/* No error */

	p_err->error_code = 0;
	p_err->psdev_err = 0;
	return(0);

}



/****************************************************************************
*                                                                           *
*		db_psdev_unregister function code                           *
*               -------------------                                         *
*                                                                           *
*    Function rule : To unregister pseudo devices from the static database  *
*                                                                           *
*    Argins : - The pseudo devices name list				    *
*	      - The pseudo devices number				    *
*                                                                           *
*    Argout : No argout							    *
*                                                                           *
*    In case of major trouble, the function returns -1 and set the          *
*    error_code  variable of the error structure. In case of error for a    *
*    pseudo device in the list, the function returns 1.			    *
*    Otherwise, the function returns 0                			    *
*                                                                           *
*****************************************************************************/

int _DLLFunc db_psdev_unregister(char *psdev_list[],long num_psdev,db_error *p_err)
{
	register long i,j,l;
	arr1 send;
	long error;
	db_psdev_error *serv_ans;
	long i_nethost = 0;
#ifndef _OSK
	struct timeval tout;
#endif /* _OSK */
#ifdef ALONE
	char *serv_name = ALONE_SERVER_HOST;
#endif /* ALONE */

        if (config_flags.no_database)
        {
                p_err->error_code = DbErr_NoDatabase;
		p_err->psdev_err = 0;
                return(DS_NOTOK);
        } 
/* Try to verify the function parameters  (non NULL pointer) */

	if ((psdev_list == NULL) || (num_psdev == 0))
	{
		p_err->error_code = DbErr_BadParameters;
		p_err->psdev_err = 0;
		return(-1);
	}

	for (i = 0;i < num_psdev;i++)
	{
		l = 0;
		NB_CHAR(l,psdev_list[i],'/');
		if (l != 2)
		{
			p_err->error_code = DbErr_BadParameters;
			p_err->psdev_err = 0;
			return(-1);
		}
	}

# ifdef ALONE
/* Create RPC connection if it's the first call */

	if (!first)
	{
		cl = clnt_create(serv_name,DB_SETUPPROG,DB_VERS_3,"udp");
		if (cl == NULL)
		{
			p_err->error_code = DbErr_CannotCreateClientHandle;
			p_err->psdev_err = 0;
			return(-1);
		}
		clnt_control(cl,CLSET_TIMEOUT,(char *)&timeout);
		clnt_control(cl,CLSET_RETRY_TIMEOUT,(char *)&retry_timeout);
		first++;
	}
#endif /* ALONE */

/* Allocate memory for the array of pointeur to char */

	if((send.arr1_val = (nam *)calloc(num_psdev,sizeof(nam))) == NULL)
	{
		p_err->error_code = DbErr_ClientMemoryAllocation;
		p_err->psdev_err = 0;
		return(-1);
	}

/* Initialize the array of pointer to pseudo device name */

	for (i = 0;i < num_psdev;i++)
	{
		l = strlen(psdev_list[i]);
		if ((send.arr1_val[i] = (char *)malloc(l + 2)) == NULL)
		{
			p_err->error_code = DbErr_ClientMemoryAllocation;
			p_err->psdev_err = 0;
			for (j = 0;j < i;j++)
				free(send.arr1_val[j]);
			free(send.arr1_val);
			return(-1);
		}

		strcpy(send.arr1_val[i],psdev_list[i]);
		for (j = 0;j < l;j++)
			send.arr1_val[i][j] = tolower(send.arr1_val[i][j]);
	}
	send.arr1_len = num_psdev;

/* Call server */

#ifdef ALONE
	serv_ans = db_psdev_unreg_1(&send,cl,&error);
#else
	serv_ans = db_psdev_unreg_1(&send,db_info.conf->clnt,&error);
#endif /* ALONE */

/* If the server is not connected to the database (because a database update
   is just going on), sleep a while (20 mS) and redo the call */

	if (serv_ans != NULL)
	{
		if (serv_ans->error_code == DbErr_DatabaseNotConnected)
		{
			for (i = 0;i < RETRY;i++)
			{

#ifdef _OSK
				tsleep(SLEEP_TIME);
#else
				tout.tv_sec = 0;
				tout.tv_usec = 20000;
				select(0,0,0,0,&tout);
#endif /* _OSK */
#ifdef ALONE
				serv_ans = db_psdev_unreg_1(&send,cl,&error);
#else
				serv_ans = db_psdev_unreg_1(&send,db_info.conf->clnt,&error);
#endif /* ALONE */
				if(serv_ans == NULL)
					break;
				if ((serv_ans->error_code == 0) || (serv_ans->error_code != DbErr_DatabaseNotConnected))
					break;
			}
		}
	}

/* Any problem with server ? If yes and if it a time-out, try to reconnect to
   a new database server. Don't forget to free memory in case of error. */

	else
	{
		if (error == DevErr_RPCTimedOut || error == DbErr_RPCreception)
		{
#ifdef ALONE
			to_reconnection((void *)&send,(void **)&serv_ans,&cl,(int)DB_PSDEV_UNREG,i_nethost,DB_UDP,&error);
#else
			to_reconnection((void *)&send,(void **)&serv_ans,
				     &db_info.conf->clnt,(int)DB_PSDEV_UNREG,
				     i_nethost,DB_UDP,&error);
#endif /* ALONE */
		}
		if (error != 0)
		{
			for (i = 0;i < num_psdev;i++)
				free(send.arr1_val[i]);
			free(send.arr1_val);
			p_err->error_code = error;
			p_err->psdev_err = 0;
			return(-1);
		}
	}	

/* Free memory */

	for (i = 0;i < num_psdev;i++)
		free(send.arr1_val[i]);
	free(send.arr1_val);

/* Any problem during database access ? */

	if (serv_ans->error_code != 0)
	{
		p_err->error_code = serv_ans->error_code;
		p_err->psdev_err = serv_ans->psdev_err;
		return(1);
	}

/* No error */

	p_err->error_code = 0;
	p_err->psdev_err = 0;
	return(0);

}



/****************************************************************************
*                                                                           *
*		Code for db_svc_close function                              *
*                        ------------                                       *
*                                                                           *
*    Function rule : To close the open connection of the database server    *
*		     to the database					    *
*                                                                           *
*    Argin : No argin							    *
*                                                                           *
*    Argout : The error code						    *
*                                                                           *
*    This function returns 0 if no errors occurs or -1 if a problem occurs  *
*                                                                           *
****************************************************************************/
int _DLLFunc db_svc_close(long *perr)
{
	int *pdb_err;
	long error;
	int padd;
	long i_nethost = 0;
#ifdef ALONE
	char *serv_name = ALONE_SERVER_HOST;
#endif /* ALONE */

#ifdef ALONE

        if (config_flags.no_database)
        {
                *perr = DbErr_NoDatabase;
                return(DS_NOTOK);
        } 
/* Create RPC connection if it's the first call */

	if (!first)
	{
		cl = clnt_create(serv_name,DB_SETUPPROG,DB_VERS_3,"udp");
		if (cl == NULL)
		{
			*perr = DbErr_CannotCreateClientHandle;
			return(-1);
		}
		clnt_control(cl,CLSET_TIMEOUT,(char *)&timeout);
		clnt_control(cl,CLSET_RETRY_TIMEOUT,(char *)&retry_timeout);
		first++;
	}
#endif /* ALONE */

/* Call server */

#ifdef ALONE
	pdb_err = db_clodb_1(cl,&error);
#else
	pdb_err = db_clodb_1(db_info.conf->clnt,&error);
#endif

/* Any problem with server ? */

	if (pdb_err == NULL)
	{
		if (error == DevErr_RPCTimedOut || error == DbErr_RPCreception)
		{
#ifdef ALONE
			to_reconnection((void *)&padd,(void **)&pdb_err,&cl,(int)DB_CLODB,i_nethost,DB_UDP,&error);
#else
			to_reconnection((void *)&padd,(void **)&pdb_err,
				     &db_info.conf->clnt,(int)DB_CLODB,
				     i_nethost,DB_UDP,&error);
#endif /* ALONE */
		}
		if (error != 0)
		{
			*perr = error;
			return(-1);
		}
	}

/* Any trouble during database access ? */

	if (*pdb_err != 0)
	{
		*perr = *pdb_err;
		return(-1);
	}

/* No error */

	*perr = 0;
	return(0);

}



/****************************************************************************
*                                                                           *
*		Code for db_svc_reopen function                             *
*                        -------------                                      *
*                                                                           *
*    Function rule : To reopen the database and the database tables in the  *
*		     database server.					    *
*                                                                           *
*    Argin : No argin							    *
*                                                                           *
*    Argout : The error code						    *
*                                                                           *
*    This function returns 0 if no errors occurs or -1 if a problem occurs  *
*                                                                           *
****************************************************************************/
int _DLLFunc db_svc_reopen(long *perr)
{
	int *pdb_err;
	long error;
	int padd;
	long i_nethost = 0;
#ifdef ALONE
	char *serv_name = ALONE_SERVER_HOST;
#endif /* ALONE */

        if (config_flags.no_database)
        {
                *perr = DbErr_NoDatabase;
                return(DS_NOTOK);
        } 

#ifdef ALONE
/* Create RPC connection if it's the first call */

	if (!first)
	{
		cl = clnt_create(serv_name,DB_SETUPPROG,DB_VERS_3,"udp");
		if (cl == NULL)
		{
			*perr = DbErr_CannotCreateClientHandle;
			return(-1);
		}
		clnt_control(cl,CLSET_TIMEOUT,(char *)&timeout);
		clnt_control(cl,CLSET_RETRY_TIMEOUT,(char *)&retry_timeout);
		first++;
	}
#endif /* ALONE */

/* Call server */

#ifdef ALONE
	pdb_err = db_reopendb_1(cl,&error);
#else
	pdb_err = db_reopendb_1(db_info.conf->clnt,&error);
#endif

/* Any problem with server ? */

	if (pdb_err == NULL)
	{
		if (error == DevErr_RPCTimedOut || error == DbErr_RPCreception)
		{
#ifdef ALONE
			to_reconnection((void *)&padd,(void **)&pdb_err,&cl,(int)DB_REOPENDB,i_nethost,DB_UDP,&error);
#else
			to_reconnection((void *)&padd,(void **)&pdb_err,
				     &db_info.conf->clnt,(int)DB_REOPENDB,
				     i_nethost,DB_UDP,&error);
#endif /* ALONE */
		}
		if (error != 0)
		{
			*perr = error;
			return(-1);
		}
	}

/* Any trouble during database access ? */

	if (*pdb_err != 0)
	{
		*perr = *pdb_err;
		return(-1);
	}

/* No error */

	*perr = 0;
	return(0);

}
