static char RcsId[] = "$Header: dbm_miscbro.cpp,v 6.10 2001/01/08 11:45:53 goetz Rel $";

/* $Log:	dbm_miscbro.cpp,v $
Revision 6.10  2001/01/08  11:45:53  11:45:53  goetz (Andy Goetz)
added patch by B.Pedersen to support querying events

 * Revision 6.9  2000/03/15 17:07:49  taurel
 * Change compilation variable from -solaris to sun
 *
Revision 6.8  2000/02/15  12:40:23  12:40:23  taurel (E.Taurel)
Fix bug in update of arrays in the updres_1_svc function (file dbm_update.cpp). Change the value of the array flag when calling the upd_res function.

Revision 6.7  99/11/21  21:47:59  21:47:59  goetz (Andy Goetz)
register version 1 of database service

 * Revision 6.6  1999/11/21 14:41:02  goetz
 * included M.Diehl's patches for dbm_getdev.cpp, dbm_serv.cpp and main_svc.cpp
 *
 * Revision 6.5  1999/08/20 17:21:26  taurel
 * Added a static before RcsId in dbm_impexp.cpp file in irder to make gcc quiet
 *
Revision 6.4  99/08/19  16:45:31  16:45:31  taurel (E.Taurel)
Remove the last two pagf in main_svc and dbm_clo_op files.

Revision 6.3  99/08/04  15:42:32  15:42:32  goetz (Andy Goetz)
version 1 of rpc service not registered anymore

 * Revision 6.2  1998/12/01 15:27:55  taurel
 * Just add new function in the xdr file
 *
Revision 6.1  98/10/27  08:43:26  08:43:26  taurel (E.Taurel)
Fix bug for GRETA appli

Revision 6.0  98/08/14  09:20:19  09:20:19  taurel (E.Taurel)
Added
 */

#include <API.h>
#include <DevErrors.h>
#include <db_xdr.h>

#include <string.h>
#include <ndbm.h>

// C++ include

#include <new>
#include <iostream.h>
#include <NdbmClass.h>
#include <string>

/* Some local functions declaration */


/* Some global variables */


/* Variables defined in elsewhere */

extern NdbmInfo dbgen;
extern db_res browse_back;


extern int errno;




/****************************************************************************
*                                                                           *
*	Server code for the devserverlist_1_svc function       	   	    *
*                           -------------------                       	    *
*                                                                           *
*    Method rule : To retrieve device server list for all the devices       *
*		   defined in the NAMES table			  	    *
*                                                                           *
*    Argin : No argin							    *
*                                                                           *
*    Argout : domain_list : The domain name list 			    *
*                                                                           *
*                                                                           *
****************************************************************************/


db_res *devserverlist_1_svc()
{
	datum key;
	string server;

	NdbmNameList serv_list;
	
#ifdef DEBUG
	cout << "In devserverlist_1_svc function" << endl;
#endif

//
// Initialize structure sent back to client
//

	browse_back.db_err = 0;
	browse_back.res_val.arr1_len = 0;
	browse_back.res_val.arr1_val = NULL;
	
//
// If the server is not connected to the database, return error
//

	if (dbgen.connected == False)
	{
		browse_back.db_err = DbErr_DatabaseNotConnected;
		return(&browse_back);
	}

//
// Get the server name list from the NAMES table
//

	try 
	{
		for (key = dbm_firstkey(dbgen.tid[0]);key.dptr != NULL;key = dbm_nextkey(dbgen.tid[0]))
		{
			long ind;
			NdbmNamesKey nameskey(key);

			nameskey.get_dev_indi(ind);
			if (ind != 1)
				continue;
						
			nameskey.get_ds_name(server);

			serv_list.add_if_new(server);		
		}
		if (dbm_error(dbgen.tid[0]) != 0)
		{			
			dbm_clearerr(dbgen.tid[0]);
			browse_back.db_err = DbErr_DatabaseAccess;
			return(&browse_back);			
		}
	}
	catch (NdbmError &err)
	{		
		cerr << err.get_err_message() << endl;	
		browse_back.db_err = err.get_err_code();
		return(&browse_back);
	}
	catch (bad_alloc)
	{		
		cerr << "Memory allocation error in devserverlist" << endl;
		browse_back.db_err = DbErr_ServerMemoryAllocation;
		return(&browse_back);
	}
	
//
// Sort device server name list
//
	
	serv_list.sort_name();

//
// Build the structure returned to caller
//
	
	browse_back.res_val.arr1_len = serv_list.length();
	if (serv_list.copy_to_C(browse_back.res_val.arr1_val) != 0)
	{
		cerr << "Memory allocation error in devserverlist" << endl;
		browse_back.db_err = DbErr_ServerMemoryAllocation;
		return(&browse_back);
	}
	
//
// Return data
//

	return(&browse_back);
}



/****************************************************************************
*                                                                           *
*	Server code for the devpersnamelist_1_svc function    	    	    *
*                           ---------------------                    	    *
*                                                                           *
*    Method rule : To device family list for all the device defined in the  *
*		   NAMES and PS_NAMES tables for a given domain		    *
*                                                                           *
*    Argin : - domain : The domain name					    *
*                                                                           *
*    Argout : - family_list : The family name list 			    *
*                                                                           * 
*                                                                           *
****************************************************************************/

db_res *devpersnamelist_1_svc(nam *server)
{
	datum key;
	string serv;
	string pers;
	NdbmNameList pers_list;
	
#ifdef DEBUG
	cout << "In devpersnamelist_1_svc function for server " << *server << endl;
#endif

	string user_server(*server);
	
//
// Initialize structure sent back to client
//

	browse_back.db_err = 0;
	browse_back.res_val.arr1_len = 0;
	browse_back.res_val.arr1_val = NULL;
		
//
// If the server is not connected to the database, return error
//

	if (dbgen.connected == False)
	{
		browse_back.db_err = DbErr_DatabaseNotConnected;
		return(&browse_back);
	}

//
// Get the family name list for the wanted domain in the NAMES table
//

	try
	{
		for (key = dbm_firstkey(dbgen.tid[0]);key.dptr != NULL;key = dbm_nextkey(dbgen.tid[0]))
		{
			long ind;
			NdbmNamesKey nameskey(key);

			nameskey.get_dev_indi(ind);
			if (ind != 1)
				continue;
						
			nameskey.get_ds_name(serv);
			if (serv != user_server)
				continue;
			
			nameskey.get_ds_pers_name(pers);
		
			pers_list.add_if_new(pers);
		}
		if (dbm_error(dbgen.tid[0]) != 0)
		{
			dbm_clearerr(dbgen.tid[0]);
			browse_back.db_err = DbErr_DatabaseAccess;
			return(&browse_back);
		}
	}
	catch (NdbmError &err)
	{
		cerr << err.get_err_message() << endl;		
		browse_back.db_err = err.get_err_code();
		return(&browse_back);
	}
	catch (bad_alloc)
	{		
		cerr << "Memory allocation error in devpersnamelist" << endl;
		browse_back.db_err = DbErr_ServerMemoryAllocation;
		return(&browse_back);		
	}
	
//
// Sort device server personal name list
//
	
	pers_list.sort_name();
	
//
// Build the sequence returned to caller
//
	
	browse_back.res_val.arr1_len = pers_list.length();
	if (pers_list.copy_to_C(browse_back.res_val.arr1_val) != 0)
	{
		cerr << "Memory allocation error in devpersnamelist" << endl;
		browse_back.db_err = DbErr_ServerMemoryAllocation;
		return(&browse_back);
	}
		
//
// Return data
//

	return(&browse_back);	
}




/****************************************************************************
*                                                                           *
*	Server code for the hostlist_1_svc function       	   	    *
*                           --------------                       	    *
*                                                                           *
*    Method rule : To device host list where device server should run       *		   in the NAMES table			  		    *
*                                                                           *
*    Argin : No argin							    *
*                                                                           *
*    Argout : domain_list : The domain name list 			    *
*                                                                           *
*                                                                           *
****************************************************************************/


db_res *hostlist_1_svc()
{
	datum key;
	string host;

	NdbmNameList host_list;
	
#ifdef DEBUG
	cout << "In hostlist_1_svc function" << endl;
#endif

//
// Initialize structure sent back to client
//

	browse_back.db_err = 0;
	browse_back.res_val.arr1_len = 0;
	browse_back.res_val.arr1_val = NULL;
	
//
// If the server is not connected to the database, return error
//

	if (dbgen.connected == False)
	{
		browse_back.db_err = DbErr_DatabaseNotConnected;
		return(&browse_back);
	}

//
// Get the server name list from the NAMES table
//

	try 
	{
		for (key = dbm_firstkey(dbgen.tid[0]);key.dptr != NULL;key = dbm_nextkey(dbgen.tid[0]))
		{

//
// Skip record if the device indice is different than 1
//
			NdbmNamesKey nameskey(key);
			long ind;
			
			nameskey.get_dev_indi(ind);
			if (ind != 1)
				continue;
				
			NdbmNamesCont cont(dbgen.tid[0],key);

			cont.get_host_name(host);

//
// Skip record if the device is not exported (for DS with DB library release 4)
//

			if (host == "not_exp")
				continue;
				
			host_list.add_if_new(host);		
		}
		if (dbm_error(dbgen.tid[0]) != 0)
		{			
			dbm_clearerr(dbgen.tid[0]);
			browse_back.db_err = DbErr_DatabaseAccess;
			return(&browse_back);			
		}
	}
	catch (NdbmError &err)
	{		
		cerr << err.get_err_message() << endl;	
		browse_back.db_err = err.get_err_code();
		return(&browse_back);
	}
	catch (bad_alloc)
	{		
		cerr << "Memory allocation error in devserverlist" << endl;
		browse_back.db_err = DbErr_ServerMemoryAllocation;
		return(&browse_back);
	}
	
//
// Sort device server host list
//
	
	host_list.sort_name();

//
// Build the structure returned to caller
//
	
	browse_back.res_val.arr1_len = host_list.length();
	if (host_list.copy_to_C(browse_back.res_val.arr1_val) != 0)
	{
		cerr << "Memory allocation error in hostlist" << endl;
		browse_back.db_err = DbErr_ServerMemoryAllocation;
		return(&browse_back);
	}
	
//
// Return data
//

	return(&browse_back);
}
