
/*+*******************************************************************

 File:          DevServerXdr.h

 Project:       Device Servers with sun-rpc

 Description:   Public include file for all applications
		using device server types.

 Author(s):  	Jens Meyer

 Original:	January 1991


 $Revision: 5.15 $
 $Date: 1997/12/01 15:22:12 $

 $Author: klotz $

 $Log: DevServerXdr.h,v $
 Revision 5.15  1997/12/01 15:22:12  klotz
 WIN_NT_95_released_NOV_97

 * Revision 3.24  93/10/29  17:03:54  17:03:54  meyer (J.Meyer)
 * Added length calculation for Rad. Monitor types
 * 
 * Revision 3.23  93/10/13  12:58:21  12:58:21  meyer (Jens Meyer)
 * Changed structures in pin_xdr.*
 * 
 * Revision 3.22  93/08/25  09:40:19  09:40:19  meyer (Jens Meyer)
 * Length calculation of D_VAR_MSTATARR was deleted in revision 3.14
 * 
 * Revision 3.21  93/06/25  11:16:29  11:16:29  meyer (Jens Meyer)
 * Corrected bug in BPM length calculation
 * 
 * Revision 3.20  93/06/24  18:10:39  18:10:39  meyer (Jens Meyer)
 * BPM XDR-length calculation
 * 
 * Revision 3.17  93/06/24  18:08:38  18:08:38  meyer (Jens Meyer)
 * New Pinhole XDR Types.
 * 
 * Revision 3.16  93/06/07  09:05:10  09:05:10  meyer (Jens Meyer)
 * Added GRP xdr types.
 * 
 * Revision 3.15  93/06/04  14:12:38  14:12:38  domingue ( Marie-Christine Dominguez)
 * Changed m4_xdr types.
 * 
 * Revision 3.14  93/05/27  12:59:16  12:59:16  meyer (Jens Meyer)
 * Added m4_xdr types and corrected icv101_xdr.
 * 
 * Revision 3.13  93/05/13  11:14:15  11:14:15  taurel (Emmanuel TAUREL)
 * Fix bug in daemon_data xdr function
 * 
 * Revision 3.12  93/04/28  08:28:45  08:28:45  meyer (Jens Meyer)
 * Added length calculation for BPSS structures
 * 
 * Revision 3.11  93/03/11  16:53:33  16:53:33  meyer (Jens Meyer)
 * Corrected length calculation for D_VAR_MSTATARR
 * 
 * Revision 3.10  93/03/10  08:45:06  08:45:06  meyer (Jens Meyer)
 * Added new type D_VAR_MSTATARR.
 * 
 * Revision 3.9  93/03/04  15:57:47  15:57:47  meyer (Jens Meyer)
 * Added the new xdr types D_VAR_PATTERNARR and D_ICV_MODE
 * 
 * Revision 3.8  93/01/21  13:51:57  13:51:57  meyer (Jens Meyer)
 * Added length calculation for PSS types.
 * 
 * Revision 3.7  92/12/21  08:38:53  08:38:53  meyer (Jens Meyer)
 * Added D_MOTOR_LONG and D_MOTOR_FLOAT types.
 * 
 * Revision 3.6  92/12/07  11:06:49  11:06:49  meyer (Jens Meyer)
 * Added types: D_BLADE_STATE, D_PSLIT_STATE, D_ATTE_TYPE
 * 
 * Revision 3.5  92/10/23  14:55:19  14:55:19  meyer (Jens Meyer)
 * Added XDR length calculation for current transformer type
 * 
 * Revision 3.4  92/10/05  10:21:30  10:21:30  meyer ()
 * Added field to current transformer structure
 * 
 * Revision 3.3  92/08/28  08:32:42  08:32:42  meyer ()
 * XDR length calculation for THC and VGC types
 * 
 * Revision 3.2  92/08/13  16:45:30  16:45:30  meyer ()
 * Splitted include and C files
 * 
 * Revision 3.1.1.2  92/08/11  16:13:53  16:13:53  meyer ()
 * added seism_xdr.h
 * 
 * Revision 3.1.1.1  92/08/05  13:37:29  13:37:29  meyer ()
 * XDR length + file splits
 * 
 * Revision 3.1  92/07/22  10:49:36  10:49:36  meyer ()
 * New types for RF, CT and update deamon.
 * 
 * Revision 3.0.1.4  92/07/22  10:31:03  10:31:03  meyer ()
 * added the new types D_DAEMON_STATUS, D_DAEMON_DATA, D_VAR_LRPARR 
 * and D_MULMOVE_TYPE.
 * 
 * Revision 3.0.1.3  92/06/18  17:49:32  17:49:32  meyer ()
 * added new data type for current transformer D_CT_LIFETIME.
 * 
 * Revision 3.0.1.2  92/06/17  18:08:26  18:08:26  chaize (Jean Michel Chaize)
 * modify Bpss structures 
 * 
 * Revision 3.0.1.1  92/04/07  17:49:48  17:49:48  meyer (Jens Meyer)
 * added D_RF_SIGCONFIG type for the radio frequency system.
 * 
 * Revision 3.0  92/04/03  09:08:14  09:08:14  meyer ()
 * New major library release (3.x)
 * 
 * Revision 2.10  92/02/05  17:01:59  17:01:59  dserver ()
 * released version with new bpm data types.
 * 
 * Revision 2.9.1.2  92/01/29  14:24:57  14:24:57  meyer ()
 * new BPM data transfer structures for SR BPM`s.
 * 
 * Revision 2.9.1.1  92/01/24  11:48:19  11:48:19  meyer ()
 * compatible version counting with release 2.9
 * 
 * Revision 2.9  92/01/24  11:41:56  11:41:56  meyer ()
 * corrected D_PSS_STATUS structure.
 * 
 * Revision 2.8  92/01/17  09:50:44  09:50:44  meyer ()
 * added D_GPIB_RES, D_GPIB_LOC and D_PSS_STATUS.
 * 
 * Revision 2.7  91/12/18  18:54:54  18:54:54  meyer ()
 * added definitions for D_GPIB_MUL_WRITE data type.
 * 
 * Revision 2.6  91/12/17  13:52:02  13:52:02  chaize (Jean Michel Chaize)
 * correct bugs on v2.5
 * 
 * Revision 2.5  91/12/16  15:59:54  15:59:54  chaize (Jean Michel Chaize)
 * add definition for D_STATE_INDIC, D_BPSS_STATE, D_BPSS_READPOINT
 * 
 * Revision 2.4  91/12/13  15:19:53  15:19:53  meyer ()
 * added definitions for D_GPIB_WRITE data type.
 * 
 * Revision 2.3  91/11/25  14:40:15  14:40:15  meyer ()
 * added definitions for D_INT_FLOAT_TYPE, D_HAZ_STATUS, D_VRIF_WDOG,
 * D_VRIF_STATUS, D_VRIF_POWERSTATUS.
 * 
 * Revision 2.2  91/10/14  14:05:58  14:05:58  meyer ()
 * corrected identification header.
 * 
 * Revision 2.1  91/10/02  16:12:38  16:12:38  meyer ()
 * complet update to revision 2.1 with full ANSI prototyping.
 * 
 * Revision 2.0  91/10/01  11:26:47  11:26:47  meyer ()
 * release 2.0 with NFS/RPC 1.1
 * 

 Copyright (c) 1990 by European Synchrotron Radiation Facility,
		       Grenoble, France

*******************************************************************-*/

#ifndef _DevServerXdr_h
#define _DevServerXdr_h

/*
 *  standart header string to use the "what" or "ident".
 */
#ifdef _IDENT
static char DevServerXdrh[] =
"@(#)$Header: /segfs/dserver/dev/system/xdr/include/RCS/DevServerXdr.h,v 5.15 1997/12/01 15:22:12 klotz Exp $";
#endif /* _IDENT */

#include <dev_xdr.h>
#include <bpm_xdr.h>
#include <bpss_xdr.h>
#include <ct_xdr.h>
#include <daemon_xdr.h>
#include <gpib_xdr.h>
#include <haz_xdr.h>
#include <maxe_xdr.h>
#include <pss_xdr.h>
#include <ram_xdr.h>
#include <rf_xdr.h>
#include <thc_xdr.h>
#include <union_xdr.h>
#include <vgc_xdr.h>
#include <vrif_xdr.h>
#include <ws_xdr.h>
#include <seism_xdr.h>
#include <atte_xdr.h>
#include <slit_xdr.h>
#include <icv101_xdr.h>
#include <mstat_xdr.h>
#include <m4_xdr.h>
#include <grp_xdr.h>
#include <pin_xdr.h>

#include <xdr_typelist.h>

#endif /* _DevServerXdr_h */

