static char RcsId[] = "@(#)$Header: /segfs/dserver/system/dc/svc/RCS/dcrd_svc.c,v 3.24 2002/03/12 11:26:55 goetz Rel $";

/* $Log: dcrd_svc.c,v $
 * Revision 3.24  2002/03/12 11:26:55  goetz
 * solaris now uses sigset() and not sigvec anymore
 *
 * Revision 3.23  1901/02/20 17:47:21  taurel
 * Add some test on the ptr retrieved from shared memory for the read server (dc_read.c file)
 *
 * Revision 3.22  2001/02/19 12:50:14  goetz
 * checkin for taurel
 *
 * Revision 3.21  2000/12/03 07:19:13  goetz
 * ported to Linux
 *
 * Revision 3.20  2000/03/13 15:28:33  taurel
 * Adapted to the new release of gettranscient (DSAIPI release 7.8 and above)
 *
 * Revision 3.19  99/07/05  14:24:25  14:24:25  taurel (E.Taurel)
 * Porte dto new release of gettranscienr_ut. I don't understand how it worked
 * before !!
 * 
 * Revision 3.18  99/06/02  16:06:26  16:06:26  taurel (E.Taurel)
 * Fix bug when transferring time for dc_devget_history
 * 
 * Revision 3.17  99/02/08  15:23:43  15:23:43  taurel (E.Taurel)
 * No change done
 * 
 * Revision 3.16  96/12/06  11:30:14  11:30:14  taurel (E.Taurel)
 * Adapted to new directory structure and incl. files
 * 
 * Revision 3.15  96/11/04  16:50:05  16:50:05  taurel (E.Taurel)
 * Change in the db_register function to fulfill
 * db software release 5 (process name).
 * 
 * Revision 3.14  96/06/14  11:25:43  11:25:43  taurel (E.Taurel)
 * In the still updated test, now manage the case where the update
 * period is 0. This means that no tests are needed.
 * 
 * Revision 3.13  96/02/28  09:13:11  09:13:11  taurel (Emmanuel TAUREL)
 * Ported to Solaris.
 * 
 * Revision 3.12  96/01/05  16:07:05  16:07:05  taurel (Emmanuel TAUREL)
 * Checked out for the two XDR files which have been
 * modified for the library port to Solaris (compatibility mode only).
 * 
 * Revision 3.11  95/12/15  17:26:31  17:26:31  taurel (Emmanuel TAUREL)
 * Check out for debug purpose. No change.
 * 
 * Revision 3.10  95/10/10  14:08:16  14:08:16  taurel (Emmanuel TAUREL)
 * Return date in the dc_devget_history function even if the command failed.
 * 
 * Revision 3.6  94/05/30  16:22:00  16:22:00  taurel (Emmanuel TAUREL)
 * Change the max number of open files.
 * 
 * Revision 3.5  94/01/25  13:25:21  13:25:21  taurel (Emmanuel TAUREL)
 * Check in. I don't remenbe why this file has been checked out!
 * 
 * Revision 3.4  93/11/30  10:42:52  10:42:52  taurel (Emmanuel Taurel)
 * Add signal handler for some UNIX signals with default action which is 
 * to kill the process without generating a core file.
 * 
 * Revision 3.3  93/08/27  09:30:18  09:30:18  taurel (Emmanuel Taurel)
 * Don't use signal and sigset in the same process !!!!
 * 
 * Revision 3.2  93/08/13  08:44:34  08:44:34  taurel (Emmanuel Taurel)
 * This file has been check out just for test purpose. Nothing has been changed.
 * 
 * Revision 3.1  93/06/15  08:12:19  08:12:19  taurel (Emmanuel Taurel)
 * Add new code for the dc_devget_history function call and the
 * RPC_CHECK call for device server system (same program number).
 * 
 * Revision 3.0  93/05/18  15:58:33  15:58:33  taurel (Emmanuel TAUREL)
 * Adapted for SUN release of the dc system (without RTDB).
 * 
 * Revision 3.0  93/05/17  17:44:37  17:44:37  taurel (Emmanuel Taurel)
 * Modified to port the dc system to SUN (without RTDB).
 * 
 * Revision 1.2  93/02/04  10:33:23  10:33:23  taurel (Emmanuel Taurel)
 * Major change to cope with the distributed release of the data collector
 * system.
 * 
 * Revision 1.1  92/10/29  14:00:52  14:00:52  taurel (Emmanuel Taurel)
 * Initial revision
 *  */

#ifdef _solaris
#define PORTMAP
#endif 

#include <API.h>
#include <DevErrors.h>
#include <private/ApiP.h>
#include <DevServer.h>

#include <signal.h>
#include <errno.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <netdb.h>
#include <sys/types.h>
#include <sys/ipc.h>
#include <sys/shm.h>
#include <string.h>
#include <sys/stat.h>
#include <sys/resource.h>

#include <dc_xdr.h>
#include <dcP.h>

extern int errno;

/* Function definition */

static void dc_prog_1();
void leave();
void register_dc();

/* Some global variables */

u_long pgnum;
char d_name[40];
char ds_name[40];
char psd_name[40];
int ctr;
int req_call;
int shift_dt;
upd_reqnb req;
hash_info mem;
int time_out = False;
char sig_devname[40];

int shmid_alloc,shmid_ptr,shmid_data;
char *addr_alloc,*addr_ptr,*addr_data;
int semid1;

db_resource res_serv_put;
db_resource res_serv_get[] = {
	{"start_req",D_LONG_TYPE},
	{"start_nb",D_LONG_TYPE},
	{"update",D_LONG_TYPE},
	{"shift_dt",D_LONG_TYPE},
		};
int res_serv_get_size = sizeof(res_serv_get)/sizeof(db_resource);

db_resource res1[] = {
	{"dev_number",D_LONG_TYPE},
	{"cellar_number",D_LONG_TYPE},
	{"data_size",D_LONG_TYPE},
		     };
int res1_size = sizeof(res1) / sizeof(db_resource);
int ptr_size,dat_size,alloc_size;

/* Some static variables */

static SVCXPRT *transp_sta;
static struct svc_req *rqstp_sta;

/* Some extern variables */

extern xdc *ptr_xdc;
extern xres *ptr_xres;
extern xresv backv;

extern mpar_back backm;
extern xdc *m_ptr_xdc;
extern xres *m_ptr_xres;
extern mxres *ptr_mxres;

extern outpar back_def;

extern xresh_mast backh;
extern xresh *ptr_xresh;

/* Signal handler for all the signals which kill the process */

void un_register_prog(signo)
int signo;
{
	long error;

	pmap_unset(pgnum, DC_VERS);

/* Added code to unregister the server from static db */

	db_svc_unreg(ds_name,&error);

	exit(1);
}

/* Signal handler for the alarm signal (time-out on asemaphore) */

void time_out_prog(signo)
int signo;
{
	time_out = True;
}


/* Default signal handler for signals which UNIX default action is to kill the
   process without generating a core file */

void default_sig(signo)
int signo;
{
	time_t tps;
	char *tps_str;
	struct tm *time_tm;

	tps = time((time_t *)0);
	time_tm = localtime(&tps);
	tps_str = asctime(time_tm);
	tps_str[24] = 0;
	fprintf(stderr,"%s : signal %d received !!!\n",tps_str,signo);
#ifndef _solaris
	fprintf(stderr,"Server requested from %x\n",transp_sta->xp_raddr.sin_addr.s_addr);
#endif
	
	if (rqstp_sta->rq_proc == DC_DEVGET)
		fprintf(stderr,"Dc_devget request with first device %s\n",sig_devname);
	else if (rqstp_sta->rq_proc == DC_DEVGETV)
		fprintf(stderr,"Dc_devgetv request with first device %s\n",sig_devname);
	else if (rqstp_sta->rq_proc == DC_DEVGETM)
		fprintf(stderr,"Dc_devgetm request with first device %s\n",sig_devname);
	else if (rqstp_sta->rq_proc == DC_DEVDEF)
		fprintf(stderr,"Dc_devdef request with first device %s\n",sig_devname);
	else if (rqstp_sta->rq_proc == DC_DEVGET_H)
		fprintf(stderr,"Dc_devget_history request with device %s\n",sig_devname);
	else
		fprintf(stderr,"utilities call\n");

	fflush(stderr);
}



/*****************************************************************************
*									     *
*		DATA COLLECTOR READ SERVER MAIN FUNCTION		     *
*									     *
******************************************************************************/

main(argc,argv)
int argc;
char *argv[];
{
	SVCXPRT *transp_tcp;
	SVCXPRT *transp_udp;
	struct sockaddr_in so;
	char hostna[32];
	char full_name[80];
#ifdef OBSOLETE_SUN
	int sig_mask;
	struct sigvec sighand;
#endif
#ifdef linux
	struct sigaction sigact;
#endif /* linux */

/* Added variables to manage transient program number */

	int sock_tcp;
	int sock_udp;
	char *netmanhost;
	struct rlimit lim;

/* Test argument number */

#ifndef ALONE
	if (argc != 3)
	{
		fprintf(stderr,"%s usage: %s <network manager host name> <server number>\n",argv[0],argv[0]);
		exit(1);
	}
	netmanhost = argv[1];
#else
	if (argc != 2)
	{
		fprintf(stderr,"%s usage: %s <server number>\n",argv[0],argv[0]);
		exit(1);
	}
#endif /* ALONE */

/* Install signal handler */

#ifdef OBSOLETE_SUN
	sig_mask = sigmask(SIGHUP);
	sigsetmask(sig_mask);

	sighand.sv_handler = un_register_prog;
	sighand.sv_mask = 0;
	sighand.sv_flags = 0;

	sigvec(SIGINT,&sighand,NULL);
	sigvec(SIGQUIT,&sighand,NULL);
	sigvec(SIGTERM,&sighand,NULL);

	sighand.sv_handler = time_out_prog;
	sigvec(SIGALRM,&sighand,NULL);

	sighand.sv_handler = default_sig;
	sigvec(SIGPIPE,&sighand,NULL);
	sigvec(SIGVTALRM,&sighand,NULL);
	sigvec(SIGPROF,&sighand,NULL);
#ifndef _solaris
	sigvec(SIGLOST,&sighand,NULL);
#endif
	sigvec(SIGUSR1,&sighand,NULL);
	sigvec(SIGUSR2,&sighand,NULL);
	sigvec(SIGXCPU,&sighand,NULL);
	sigvec(SIGXFSZ,&sighand,NULL);
#else
#ifndef linux
	(void) sigignore(SIGHUP);
	(void) sigset(SIGINT, un_register_prog);
	(void) sigset(SIGQUIT, un_register_prog);
	(void) sigset(SIGTERM, un_register_prog);
	(void) sigset(SIGALRM, time_out_prog);
	(void) sigset(SIGPIPE, default_sig);
	(void) sigset(SIGUSR1, default_sig);
	(void) sigset(SIGUSR2, default_sig);
	(void) sigset(SIGVTALRM, default_sig);
	(void) sigset(SIGPROF, default_sig);
#ifndef _solaris
	(void) sigset(SIGLOST, default_sig);
#endif /* _solaris */
#else
	sigact.sa_handler = SIG_IGN;
	sigaction(SIGHUP, &sigact, NULL);
	sigact.sa_handler = un_register_prog;
	sigaction(SIGINT, &sigact, NULL);
	sigact.sa_handler = un_register_prog;
	sigaction(SIGQUIT, &sigact, NULL);
	sigact.sa_handler = un_register_prog;
	sigaction(SIGTERM, &sigact, NULL);
	sigact.sa_handler = time_out_prog;
	sigaction(SIGALRM, &sigact, NULL);
	sigact.sa_handler = default_sig;
	sigaction(SIGPIPE, &sigact, NULL);
	sigact.sa_handler = default_sig;
	sigaction(SIGUSR1, &sigact, NULL);
	sigact.sa_handler = default_sig;
	sigaction(SIGUSR2, &sigact, NULL);
	sigact.sa_handler = default_sig;
	sigaction(SIGVTALRM, &sigact, NULL);
	sigact.sa_handler = default_sig;
	sigaction(SIGPROF, &sigact, NULL);
#endif /* !linux */
#endif /* OBSOLETE_SUN */

/* Change max number of open files to 120 */

	if (getrlimit(RLIMIT_NOFILE,&lim) == -1)
	{
		fprintf(stderr,"dc_server_rd : Can't get max number of files\n");
		exit(-1);
	}
	lim.rlim_cur = DC_MAX_FILES;
	if (setrlimit(RLIMIT_NOFILE,&lim) == -1)
	{
		fprintf(stderr,"dc_server_rd : Can't change max number of files\n");
		exit(-1);
	}

	gethostname(hostna,sizeof(hostna));

/* Added code to manage transient program number and to get host name*/

	sock_udp = sock_tcp = RPC_ANYSOCK;
	strcpy(full_name,argv[0]);
	strcat(full_name,"/");
	strcat(full_name,argv[1]);
	
	pgnum = gettransient(full_name);

	if (pgnum == 0)
	{
		fprintf(stderr,"dc_server_rd : Can't get transcient program number\n");
		leave(NO_UNREG);
	}

#ifdef DEBUG
	printf("Server host name : %s\n",hostna);
	printf("Program number : %x in hexa or %d in decimal\n",pgnum,pgnum);
#endif /* DEBUG */


	transp_tcp = svctcp_create(sock_tcp,0,0);

	if (transp_tcp == NULL)
	{
		fprintf(stderr, "cannot create tcp service.\n");
		leave(NO_UNREG);
	}

/* Register the server with the TCP protocol */

	if (!svc_register(transp_tcp,pgnum,DC_VERS,dc_prog_1,IPPROTO_TCP))
	{
		fprintf(stderr,"unable to register (pgnum,DC_VERS,tcp). \n");
		leave(NO_UNREG);
	}

	transp_udp = svcudp_create(sock_udp);
	if (transp_udp == NULL)
	{
		fprintf(stderr,"Cannot create UDP service\n");
		leave(NO_UNREG);
	}

/* Register the server with the UDP protocol */

	if (!svc_register(transp_udp,pgnum,DC_VERS,dc_prog_1,IPPROTO_UDP))
	{
		fprintf(stderr,"unable to register (pgnum,DC_VERS,udp)\n");
		leave(NO_UNREG);
 	}

/* Register myself in the static database */

#ifdef ALONE
	if (db_register(argv[1],pgnum,DC_VERS,hostna,argv[0]))
#else
	if (db_register(argv[2],pgnum,DC_VERS,hostna,argv[0]))
#endif /* ALONE */
		leave(NO_UNREG);

/* Retrieve shared memory segments size */

	if (shm_size(hostna))
		leave(UNREG);

/* Attach the alloc area (it's a shared memory segment) to this process
   data area */

	if ((shmid_alloc = shmget((key_t)KEY_ALLOC,(size_t)alloc_size,0666)) == -1)
	{
		fprintf(stderr,"dc_server_rd : Can't get the allocation table\n");
		fprintf(stderr,"dc_server_rd : Error code : %d\n",errno);
		leave(UNREG);
	}

	if ((addr_alloc = (char *)shmat(shmid_alloc,(char *)0,0)) == (char *)-1)
	{
		fprintf(stderr,"dc_server_rd : Can't attach to the allocation area shred memory segment\n");
		fprintf(stderr,"dc_server_rd : Error code : %d\n",errno);
		leave(UNREG);
	}

/* Attach the data buffer (it's a shared memory segment) to this process
   data area */

	if ((shmid_data = shmget((key_t)KEY_DATBUF,(size_t)dat_size,0666)) == -1)
	{
		fprintf(stderr,"dc_server_rd : Can't get the data buffer\n");
		fprintf(stderr,"dc_server_rd : Error code : %d\n",errno);
		leave(UNREG);
	}

	if ((addr_data = (char *)shmat(shmid_data,(char *)0,0)) == (char *)-1)
	{
		fprintf(stderr,"dc_server_rd : Can't attach to the data buffer shred memory segment\n");
		fprintf(stderr,"dc_server_rd : Error code : %d\n",errno);
		leave(UNREG);
	}

/* Attach the pointers buffer (it's a shared memory segment) to this process
   data area */

	if ((shmid_ptr = shmget((key_t)KEY_PTR,(size_t)ptr_size,0666)) == -1)
	{
		fprintf(stderr,"dc_server_rd : Can't get the pointers buffer\n");
		fprintf(stderr,"dc_server_rd : Error code : %d\n",errno);
		leave(UNREG);
	}

	if ((addr_ptr = (char *)shmat(shmid_ptr,(char *)0,0)) == (char *)-1)
	{
		fprintf(stderr,"dc_server_rd : Can't attach to the pointers buffer shred memory segment\n");
		fprintf(stderr,"dc_server_rd : Error code : %d\n",errno);
		leave(UNREG);
	}

/* Get the semaphore set id used to protect the pointers area */

	if ((semid1 = semget(SEMPTR_KEY,2,0666)) == -1)
	{
		fprintf(stderr,"dc_server_rd : Can't get the pointers sem.\n");
		perror("dc_server_rd ");
		leave(UNREG);
	}

/* End of hash_info structure initalisation */

	mem.sem_id = semid1;
	mem.parray = (dc_dev_param *)addr_ptr;

#ifndef ALONE
/* Send program number,host name and server version to network manager */
	
 	register_dc(netmanhost,hostna,pgnum,DC_VERS);

#endif /* ALONE */

	svc_run();
	fprintf(stderr, "svc_run returned\n");
	exit(1);
}

static void
dc_prog_1(rqstp, transp)
	struct svc_req *rqstp;
	SVCXPRT *transp;
{
	union {
		xdevget dc_devget_1_arg;
		xdevgetv dc_devgetv_1_arg;
		mpar dc_devgetm_1_arg;
		imppar dc_devdef_1_arg;
		xdevgeth dc_devgeth_1_arg;
	} argument;
	char *result;
	bool_t (*xdr_argument)(), (*xdr_result)();
	char *(*local)();
/* Added variables */
	int pid;
	static char *tmp_ch;

	transp_sta = transp;
	rqstp_sta = rqstp;

	switch (rqstp->rq_proc)
	{
	case NULLPROC:
		svc_sendreply(transp, (const xdrproc_t)xdr_void, NULL);
		return;

	case DC_DEVGET:
		xdr_argument = xdr_xdevget;
		xdr_result = xdr_xres;
		local = (char *(*)()) dc_devget_1;
		break;

	case DC_DEVGETV:
		xdr_argument = xdr_xdevgetv;
		xdr_result = xdr_xresv;
		local = (char *(*)()) dc_devgetv_1;
		break;

	case DC_DEVGETM:
		xdr_argument = xdr_mpar;
		xdr_result = xdr_mpar_back;
		local = (char *(*)()) dc_devgetm_1;
		break;

	case DC_DEVDEF:
		xdr_argument = xdr_imppar;
		xdr_result = xdr_outpar;
		local = (char *(*)()) dc_devdef_1;
		break;

	case DC_DEVGET_H:
		xdr_argument = xdr_xdevgeth;
		xdr_result = xdr_xresh_mast;
		local = (char *(*)()) dc_devgeth_1;
		break;

	case RPC_CHECK:
		tmp_ch = ds_name;
		svc_sendreply(transp,(const xdrproc_t)xdr_wrapstring,(caddr_t)&tmp_ch);
		return;
		
	case RPC_QUIT_SERVER:
		svc_sendreply(transp,(const xdrproc_t)xdr_void,NULL);
		pid = getpid();
		kill(pid,SIGQUIT);
		return;
		
	default:
		svcerr_noproc(transp);
		return;
	}

	memset(&argument, 0, sizeof(argument));

	if (!svc_getargs(transp, (const xdrproc_t)xdr_argument, (caddr_t)&argument))
	{
		svcerr_decode(transp);
		return;
	}
	result = (*local)(&argument, rqstp);
	if (result != NULL && !svc_sendreply(transp, (const xdrproc_t)xdr_result, result))
	{
		svcerr_systemerr(transp);
	}
	if (!svc_freeargs(transp, (const xdrproc_t)xdr_argument, (caddr_t)&argument))
	{
		fprintf(stderr, "unable to free arguments\n");
		exit(1);
	}
	one_more_request();

/* Added code to free memory allocated in the server functions */

	switch(rqstp->rq_proc)
	{
	case DC_DEVGETV :
		if (backv.xgen_err == 0)
		{
			free(ptr_xdc);
			free(ptr_xres);
		}
		break;

	case DC_DEVGETM :
		if (backm.xgen_err == 0)
		{
			free(m_ptr_xdc);
			free(m_ptr_xres);
			free(ptr_mxres);
		}
		break;

	case DC_DEVGET_H :
		if (backh.xgen_err == 0)
		{
			free(ptr_xdc);
			free(ptr_xresh);
		}
		break;

	case DC_DEVDEF :
		if (back_def.xgen_err != DcErr_ServerMemoryAllocation) 
			free(back_def.taberr.taberr_val);
		break;
	}
			
}



/****************************************************************************
*                                                                           *
*		Code for register_dc function                               *
*                        -----------                                        *
*                                                                           *
*    Function rule : To send server information (host_name,program number   *
*                    and version number) to the network manager             *
*                                                                           *
*    Argin : - The system host_name where the network manager is running    *
*            - The system host_name where the server is running             *
*            - The server program number                                    *
*            - The server version number                                    *
*                                                                           *
*    Argout : No argout                                                     *
*                                                                           *
*    This function is used only when the database is a part of the device   *
*    server system                                                          *
*                                                                           *
****************************************************************************/

#ifndef ALONE
void register_dc(netman_host,host,prog,vers)
char *netman_host;
char *host;
u_long prog;
u_long vers;
{
	_register_data register_data;
	CLIENT *netman_clnt;
	enum clnt_stat clnt_stat;
	static int res;

/* Create an RPC connection to network manager */

	netman_clnt = clnt_create(netman_host,NMSERVER_PROG,NMSERVER_VERS,"udp");
	if (netman_clnt == NULL)
	{
		fprintf(stderr,"Unable to create connection to network manager\n");
		exit(1);
	}

	clnt_control(netman_clnt,CLSET_TIMEOUT,&retry_timeout);
	clnt_control(netman_clnt,CLSET_TIMEOUT,&timeout);

/* Send informations to network manager */

	register_data.host_name = host;
	register_data.prog_number = prog;
	register_data.vers_number = vers;

	clnt_stat = clnt_call(netman_clnt,RPC_DB_REGISTER,xdr__register_data,
			&register_data,xdr_int,&res,timeout);

	if (clnt_stat != RPC_SUCCESS)
	{
		clnt_perror(netman_clnt,"register_db");
		exit(1);
	}
		
/* Exit function */

	clnt_destroy(netman_clnt);

}
#endif /* ALONE */



/****************************************************************************
*                                                                           *
*		Code for db_register function                               *
*                        -----------                                        *
*                                                                           *
*    Function rule : To export the pseudo device associated with this       *
*		     server, to request for server resources and to set the *
*		     resource "request number" to 0			    *
*                                                                           *
*    Argin : - The server number					    *
*            - The server program number                                    *
*            - The server version number                                    *
*	     - The server host name					    *
*	     - The full process name (argv[0])				    *
*                                                                           *
*    Argout : No argout                                                     *
*                                                                           *
*    This function returns -1 if one error occurs. Otherwise, it returns 0  *
*									    *
****************************************************************************/
int db_register(serv_num,pn_serv,vn_serv,host_name,c_proc_name)
char *serv_num;
unsigned int pn_serv;
unsigned int vn_serv;
char *host_name;
char *c_proc_name;
{
	struct hostent *host;
	long error;
	db_devinf devinfo;
	unsigned char tmp = 0;
	unsigned int diff;
	char *tmp1;
	char dev_type[40];
	char dev_class[40];
	char h_name[40];
	char proc_name[40];
	char *ptr;

/* Get host information */

	if ((host = gethostbyname(host_name)) == NULL)
	{
		fprintf(stderr,"dc_server_rd : Can't get host info, exiting...\n");
		return(-1);
	}
	tmp = (unsigned char)host->h_addr[3];

/* Build the pseudo device server name */

	strcpy(ds_name,"dc_server_rd/");
	strcpy(h_name,host->h_name);
	if ((tmp1 = strchr(h_name,'.')) != NULL)
	{
		diff = (u_int)(tmp1 - h_name);
		h_name[diff] = 0;
	}
	strcat(ds_name,h_name);
	strcat(ds_name,"_");
	strcat(ds_name,serv_num);

	h_name[0] = 0;

/* Build the pseudo device name */

	strcpy(d_name,"sys/dc_rd_");
	sprintf(&(d_name[strlen(d_name)]),"%u",tmp);
	strcat(d_name,"/");
	strcat(d_name,serv_num);

#ifdef DEBUG
	printf("Pseudo device server name : %s\n",ds_name);
	printf("Pseudo device name : %s\n",d_name);
#endif /* DEBUG */

/* Before I call the db_import, save the host name. This is necessary because
   the db_import call the clnt_create function wich call the gethostbyname
   and the structure sent back by this function is static.
   It is written in the UNIX documentation !! */

	strcpy(h_name,host->h_name);

/* Import the static database server */

	if (db_import(&error) == -1)
	{
		fprintf(stderr,"dc_server_rd : Can't import the static database server, exiting...\n");
		fprintf(stderr,"dc_server_rd : Error code : %d\n",error);
		return(-1);
	}

/* Build real process name */

	ptr = strrchr(c_proc_name,'/');
	if (ptr != NULL)
	{
		ptr++;
		strcpy(proc_name,ptr);
	}
	else
		strcpy(proc_name,c_proc_name);

/* Export me to the outside world */

	strcpy(dev_type,"DevType_Default");
	strcpy(dev_class,"DcReadServerClass");
	devinfo.device_type = dev_type;
	devinfo.device_class = dev_class;
	devinfo.device_name = d_name;
	devinfo.host_name = h_name;
	devinfo.pn = pn_serv;
	devinfo.vn = vn_serv;
	devinfo.proc_name = proc_name;

	if (db_dev_export(&devinfo,1,&error))
	{
		fprintf(stderr,"dc_server_rd : Can't export me to outside world, exiting...\n");
		fprintf(stderr,"dc_server_rd : Error code : %d\n",error);
		return(-1);
	}

/* Retrieve server resources */

	res_serv_get[0].resource_adr = &req.start_req;
	res_serv_get[1].resource_adr = &req.start_nb;
	res_serv_get[2].resource_adr = &req.update;
	res_serv_get[3].resource_adr = &shift_dt;

	if (db_getresource("CLASS/DC_RD/1",res_serv_get,res_serv_get_size,&error))
	{
		fprintf(stderr,"dc_server_rd : Can't retrieve my resources, exiting...\n");
		fprintf(stderr,"dc_server_rd : Error code : %d\n",error);
		return(-1);
	}

/* Init. request mask according to resources */

	if (req.start_req < 2 || req.start_req > 128)
	{
		fprintf(stderr,"dc_server_rd : start_req resource out of bound, exiting...\n");
		return(-1);
	}
	if (req.update < 2 || req.update > 1024)
	{
		fprintf(stderr,"dc_server_rd : update resource out of bound, exiting...\n");
		return(-1);
	}

	req.start = 0;
	switch(req.start_req)
	{
		case 2 : req.start_shift = 1;
			 break;

		case 4 : req.start_shift = 2;
			 break;

		case 8 : req.start_shift = 3;
			 break;

		case 16 : req.start_shift = 4;
			 break;

		case 32 : req.start_shift = 5;
			 break;

		case 64 : req.start_shift = 6;
			 break;

		case 128 : req.start_shift = 7;
			 break;
	}

	switch(req.update)
	{
		case 2 : req.shift = 1;
			 break;

		case 4 : req.shift = 2;
			 break;

		case 8 : req.shift = 3;
			 break;

		case 16 : req.shift = 4;
			 break;

		case 32 : req.shift = 5;
			 break;

		case 64 : req.shift = 6;
			 break;

		case 128 : req.shift = 7;
			 break;

		case 256 : req.shift = 8;
			   break;

		case 512 : req.shift = 9;
			   break;

		case 1024 : req.shift = 10;
			    break;
	}

/* Update the "server request" resource to 0 */

	strcpy(psd_name,"sys/dc_rd_");
	sprintf(&(psd_name[strlen(psd_name)]),"%u",tmp);
	strcat(psd_name,"/request");

#ifdef DEBUG
	printf("\nUpdate resource device name : %s\n",psd_name);
#endif /* DEBUG */

	ctr = 0;
	res_serv_put.resource_name = serv_num;
	res_serv_put.resource_type = D_LONG_TYPE;
	res_serv_put.resource_adr = &ctr;

	if (db_putresource(psd_name,&res_serv_put,1,&error))
	{
		fprintf(stderr,"dc_server_rd : Can't update the request resource, exiting\n");
		fprintf(stderr,"dc_server_rd : Error code : %d\n",error);
		return(-1);
	}

/* Leave function */

	return(0);

}



/****************************************************************************
*                                                                           *
*		Code for shm_size function                                  *
*                        --------                                           *
*                                                                           *
*    Function rule : To retrieve from the static database the shared memory *
*		     segment size.				     	    *
*                                                                           *
*    Argin : - The host name						    *
*                                                                           *
*    Argout : No argout                                                     *
*                                                                           *
*    This function returns -1 if one error occurs. Otherwise, it returns 0  *
*									    *
****************************************************************************/
int shm_size(host_name)
char *host_name;
{
	static long dev_num;
	static long cell_num;
	static long dat_size1;
	unsigned int diff;
	char dev_name[40];
	char hostna[32];
	char *tmp;
	long error;
	int nb_tot;

/* Build the device name which is a function of the host name */

	strcpy(hostna,host_name);
	if ((tmp = strchr(hostna,'.')) != NULL)
	{
		diff = (u_int)(tmp - hostna);
		hostna[diff] = 0;
	}
	strcpy(dev_name,"CLASS/DC/");
	strcat(dev_name,hostna);

/* Retrieve data collector memories size */

	dev_num = dat_size1 = 0;
	res1[0].resource_adr = &dev_num;
	res1[1].resource_adr = &cell_num;
	res1[2].resource_adr = &dat_size1;
	if (db_getresource(dev_name,res1,res1_size,&error))
	{
		fprintf(stderr,"dc_server_rd : Can't retrieve resources\n");
		fprintf(stderr,"dc_server_rd : Error code : %d\n",error);
		return(-1);
	}
	if (dev_num == 0 || dat_size1 == 0 || cell_num == 0)
	{
		fprintf(stderr,"dc_server_rd : Resources dev_number, cellar_number or data_size not defined\n");
		return(-1);
	}

/* Compute real memories size */

	nb_tot = cell_num + dev_num;
	ptr_size = (int)((nb_tot * sizeof(dc_dev_param)) + (nb_tot * sizeof(int_level)));
	dat_size = dat_size1;
	alloc_size = (int)(dat_size1 / 256);

/* Initialise the hahsing parameters in the mem structure */

	mem.hash_table_size = dev_num;
	mem.cellar_size = cell_num;

	return(0);

}



/****************************************************************************
*                                                                           *
*		Code for one_more_request function                          *
*                        ----------------                                   *
*                                                                           *
*    Function rule : To count the request which arrive to this server and,  *
*		     to update the request resources when it is needed.     *
*                                                                           *
*    Argin : No argin							    *
*                                                                           *
*    Argout : No argout                                                     *
*                                                                           *
****************************************************************************/
one_more_request()
{
	long error;
	int ctr1;
	int ctr_mul,ctr_mul_st,delta;
	time_t tps;
	char *tps_str;
	struct tm *time_tm;

/* If we are in the startup phase, update resource only "req.start_nb" time
   and every "req.start_mask" request */

	ctr1 = ctr + req_call;
	if (req.start < req.start_nb)
	{
		ctr_mul = (ctr >> req.start_shift);
		delta = ((ctr_mul + 1) << req.start_shift) - ctr;
		if (req_call >= delta)
		{
			ctr_mul_st = ctr1 >> req.start_shift;
			ctr = ctr_mul_st << req.start_shift;
#ifdef DEBUG
	printf("Update request resource. ctr = %d\n",ctr);
#endif /* DEBUG */
			if (db_putresource(psd_name,&res_serv_put,1,&error))
			{
				tps = time((time_t *)0);
				time_tm = localtime(&tps);
				tps_str = asctime(time_tm);
				tps_str[24] = 0;
				fprintf(stderr,"%s dc_server_rd : Can't update request resources\n",tps_str);
			}
			req.start = ctr_mul_st;
		}
	}

/* After the starting phase, update request resources every "req.update"
   request */

	else
	{
		ctr_mul = (ctr >> req.shift);
		delta = ((ctr_mul + 1) << req.shift) - ctr;
		if (req_call >= delta)
		{
			ctr = (ctr1 >> req.shift) << req.shift;
#ifdef DEBUG
	printf("Update request resource. ctr = %d\n",ctr);
#endif /* DEBUG */

			if (db_putresource(psd_name,&res_serv_put,1,&error))
			{
				tps = time((time_t *)0);
				time_tm = localtime(&tps);
				tps_str = asctime(time_tm);
				tps_str[24] = 0;
				fprintf(stderr,"%s dc_server_rd : Can't update request resources\n",tps_str);
			}
		}
	}
	ctr = ctr1;
}



/****************************************************************************
*                                                                           *
*		Code for leave function                                     *
*                        -----                                              *
*                                                                           *
*    Function rule : To terminate the server in a proper way.		    *
*                                                                           *
*    Argin : - A flag to unregister (or not to unregister) the server from  *
*	       the static database					    *
*                                                                           *
*    Argout : No argout                                                     *
*                                                                           *
****************************************************************************/
void leave(flag)
int flag;
{
	long error;

/* Unregister server from portmapper */

	pmap_unset(pgnum, DC_VERS);

/* Unregister server from database (if necessary) */

	if (flag == UNREG)
	{
		if (db_svc_unreg(ds_name,&error))
			fprintf(stderr,"dc_server_rd : Error during server unregister...\n");
	}
	
/* Exit server */

	exit(-1);
}
