static char RcsId[] = "@(#)$Header: /segfs/dserver/system/dc/svc/RCS/dc_inf.c,v 3.24 2002/03/12 11:26:55 goetz Rel $";

/* $Log: dc_inf.c,v $
 * Revision 3.24  2002/03/12 11:26:55  goetz
 * solaris now uses sigset() and not sigvec anymore
 *
 * Revision 3.23  1901/02/20 17:47:17  taurel
 * Add some test on the ptr retrieved from shared memory for the read server (dc_read.c file)
 *
 * Revision 3.22  2001/02/19 12:50:14  goetz
 * checkin for taurel
 *
 * Revision 3.21  2000/12/03 07:19:13  goetz
 * ported to Linux
 *
 * Revision 3.20  2000/03/13 15:28:28  taurel
 * Adapted to the new release of gettranscient (DSAIPI release 7.8 and above)
 *
 * Revision 3.19  99/07/05  14:24:18  14:24:18  taurel (E.Taurel)
 * Porte dto new release of gettranscienr_ut. I don't understand how it worked
 * before !!
 * 
 * Revision 3.18  99/06/02  16:06:23  16:06:23  taurel (E.Taurel)
 * Fix bug when transferring time for dc_devget_history
 * 
 * Revision 3.17  99/02/08  15:23:37  15:23:37  taurel (E.Taurel)
 * No change done
 * 
 * Revision 3.16  96/12/06  11:30:12  11:30:12  taurel (E.Taurel)
 * Adapted to new directory structure and incl. files
 * 
 * Revision 3.15  96/11/04  16:50:04  16:50:04  taurel (E.Taurel)
 * Change in the db_register function to fulfill
 * db software release 5 (process name).
 * 
 * Revision 3.14  96/06/14  11:25:41  11:25:41  taurel (E.Taurel)
 * In the still updated test, now manage the case where the update
 * period is 0. This means that no tests are needed.
 * 
 * Revision 3.13  96/02/28  09:13:10  09:13:10  taurel (Emmanuel TAUREL)
 * Ported to Solaris.
 * 
 * Revision 3.12  96/01/05  16:07:04  16:07:04  taurel (Emmanuel TAUREL)
 * Checked out for the two XDR files which have been
 * modified for the library port to Solaris (compatibility mode only).
 * 
 * Revision 3.11  95/12/15  17:26:30  17:26:30  taurel (Emmanuel TAUREL)
 * Check out for debug purpose. No change.
 * 
 * Revision 3.10  95/10/10  14:08:15  14:08:15  taurel (Emmanuel TAUREL)
 * Return date in the dc_devget_history function even if the command failed.
 * 
 * Revision 3.1  93/10/06  17:47:27  17:47:27  taurel (Emmanuel TAUREL)
 * Modified for the beam lines. In their control system, you can't predict
 * the device domain name.
 * 
 * Revision 3.0  93/05/17  17:43:10  17:43:10  taurel (Emmanuel Taurel)
 * Modified to port the dc system to SUN (without RTDB).
 * 
 * Revision 1.1  93/02/04  10:23:52  10:23:52  taurel (Emmanuel Taurel)
 * Initial revision
 *  */

#include <API.h>
#include <DevErrors.h>

#include <dc_xdr.h>
#include <dcP.h>

#include <stdlib.h>

/* Variables defined in dc_svc.c */

extern hash_info mem;

extern char *addr_ptr,*addr_alloc,*addr_data;
extern int dat_size,alloc_size,ptr_size;

extern int req_call;



/****************************************************************************
*                                                                           *
*		Server code for dc_info function                            *
*                               -------                                     *
*                                                                           *
*    Function rule : To return to the client a structure with :             *
*			- The amount of free memory in the data buffer      *
*			- The amount of devices defined in this dc          *
*			- The number of devices defined in each domain      *
*                                                                           *
*    Argin : No argin							    *
*                                                                           *
*    Argout : No argout                                                     *
*                                                                           *
****************************************************************************/

dc_infox_back *dc_info_1(fill)
int *fill;
{
	static dc_infox_back ret;
	static domain_info dom_array[MAX_DOM];
	static dom_x dom_x_array[MAX_DOM];
	long error;
	unsigned int free,lfree;
	int nb_area;
	int nb_tot,i,j;
	int resu,cptr;
	register dc_dev_param *array;
	char *temp;
	unsigned int diff;
	char domain[40];
	int nb_dom = 0;

/* Miscellaneous initialization */

	ret.err_code = 0;
	for (i = 0;i < MAX_DOM;i++) {
		dom_array[i].dom_name[0] = 0;
		dom_array[i].dom_nb_dev = 0;
				    }
	ret.back.dom_ax.dom_ax_val = dom_x_array;

#ifdef DEBUG
	printf("Executing dc_info request\n");
#endif /* DEBUG */

/* Init the number of request to 1 for this call */

	req_call  = 1;

/* Compute the amount of elemet in the hash table plus the cellar table */

	nb_tot = mem.hash_table_size + mem.cellar_size;
	array = mem.parray;

/* Ask for data buffer status */

	if (dcmem_info(addr_alloc,alloc_size,&lfree,&free,&nb_area,&error)) {
		ret.err_code = DcErr_DatabaseError;
		return(&ret);
									}
	ret.back.free_mem = free;
	ret.back.mem = dat_size;

/* Count all the register devices */

	cptr = 0;

	for (i = 0;i < nb_tot;i++) {
		if (array[i].device_name[0] == 0)
			continue;

		cptr++;

/* Get domain name from device name */

		temp = (char *)strchr(array[i].device_name,'/');
		diff = (u_int)(temp++ - array[i].device_name);
		strncpy(domain,array[i].device_name,diff);
		domain[diff] = 0;

/* Is it a known domain ? */

		for (j = 0;j < nb_dom;j++) {
			if (strcmp(dom_array[j].dom_name,domain) == NULL)
				break;
					   }

		if (j == nb_dom) {
			nb_dom++;
			strcpy(dom_array[j].dom_name,domain);
				}
		dom_array[j].dom_nb_dev++;
		
						}

/* Init. parameters sent back to caller */

	ret.back.dom_ax.dom_ax_len = nb_dom;
	for (i = 0;i < nb_dom;i++) {
		ret.back.dom_ax.dom_ax_val[i].dom_nb_dev = dom_array[i].dom_nb_dev;
		ret.back.dom_ax.dom_ax_val[i].dom_name = dom_array[i].dom_name;
				   }
	ret.back.nb_dev = cptr;

/* Leave server */

	return(&ret);

}
