
/*+*******************************************************************

 File:		DevStates.h

 Project:	Device Servers

 Description:	Public include device server state definitions

 Author(s):	Andy Goetz
		Jens Meyer

 Original:	March 1992


 $Revision: 4.30 $
 $Date: 98/12/22 10:18:10 $

 $Author: taurel $

 $Log:	DevStates.h,v $
 * Revision 4.30  98/12/22  10:18:10  10:18:10  taurel (E.Taurel)
 * Added a const keyword.
 * 
 * Revision 4.29  97/10/10  17:54:01  17:54:01  pons (Jean-Luc Pons)
 * *** empty log message ***
 * 
 * Revision 4.28  97/10/09  17:31:55  17:31:55  pons ()
 * Add DEVSTANDBY_NOT_REACHED and DEVON_NOT_REACHED..
 * 
 * Revision 4.27  96/11/07  15:54:02  15:54:02  meyer (J.Meyer)
 * Added DEVDISABLED.
 * 
 * Revision 4.26  96/09/17  17:08:51  17:08:51  klotz (W.D. Klotz)
 * WD Klotz: checked NT build
 * 
 * Revision 4.25  96/05/06  18:40:17  18:40:17  meyer (J.Meyer)
 * Fortran compatible include file.
 * 
 * Revision 4.24  95/02/15  18:58:01  18:58:01  dserver ()
 * checked windows version: compiles wthout errors.
 * 
 * Revision 4.7  94/07/20  17:08:21  17:08:21  meyer (Jens Meyer)
 * Version with MSDOS include files.
 * The same version number as API-lib.
 * 
 * Revision 3.28  94/07/20  16:54:33  16:54:33  meyer (Jens Meyer)
 * Changed include file names for MSDOS.
 * 
 * Revision 3.27  94/05/27  17:36:09  17:36:09  beteva ()
 * ended the comment at the end of DEVBAKEING
 * 
 * Revision 3.26  93/12/23  14:01:13  14:01:13  chaize
 * added DEVALARM.
 * 
 * Revision 3.25  93/09/24  17:25:15  17:25:15  meyer (Jens Meyer)
 * Release with error and command resources.
 * 
 * Revision 3.21  93/08/11  12:11:15  12:11:15  meyer (Jens Meyer)
 * Changed shift bits for Team Number and DS Identification.
 * 
 * Revision 3.20  93/08/05  18:36:36  18:36:36  meyer (Jens Meyer)
 * Database support for commands and errors.
 * 
 * Revision 3.4  93/02/19  18:06:30  18:06:30  epaud (Francis Epaud)
 * Add LECROY 1151 counter and CAEN V462 gate generator device servers
 * 
 * Revision 3.3  92/09/03  15:37:09  15:37:09  meyer
 * added new states for LINAC.
 * 
 * Revision 3.2  92/08/13  13:49:54  13:49:54  meyer ()
 * corrected spelling error.
 * 
 * Revision 3.1  92/06/17  16:38:18  16:38:18  meyer ()
 * added states for LINAC device.
 * 
 * Revision 3.0  92/03/31  09:48:00  09:48:00  meyer ()
 * New major library release (3.x)
 * 
 * Revision 2.2  92/03/30  16:59:24  16:59:24  meyer ()
 * corrected the external definition of DEVSTATES.
 * 
 * Revision 2.1  92/03/25  17:50:33  17:50:33  meyer ()
 * extracted the device state definitions from DevServer.h.
 * DevServer.h includes this file automatically.
 * 

 Copyright (c) 1990 by European Synchrotron Radiation Facility, 
                       Grenoble, France

********************************************************************-*/

#ifndef _DevStates_h
#define _DevStates_h


/*
 *  standart header string to use "what" or "ident".
 */
#ifdef _IDENT
static char DevStatesh[] =
"@(#)$Header: DevStates.h,v 4.30 98/12/22 10:18:10 taurel Exp $";
#endif /* _IDENT */


/*
 *  Device states   
 *
 *  Should be only defined in the general include file
 *  if they are used as return values to the client.
 */

#define DEVUNKNOWN	 0

#define DEVOFF		 1
#define DEVON		 2

#define DEVCLOSE	 3
#define DEVOPEN		 4

#define DEVLOW		 5
#define DEVHIGH		 6

#define DEVINSERTED	 7
#define DEVEXTRACTED	 8
#define DEVMOVING	 9

#define DEVWARMUP 	10
#define DEVINIT		11

#define DEVSTANDBY	12
#define DEVSERVICE	13
#define DEVRUN		14

#define DEVLOCAL	15
#define DEVREMOTE	16
#define DEVAUTOMATIC	17

#define DEVRAMP		18
#define DEVTRIPPED	19
#define DEVHV_ENABLE	20
#define DEVBEAM_ENABLE	21

#define DEVBLOCKED	22
#define DEVFAULT	23

#define DEVSTARTING		24	
#define DEVSTOPPING		25	
#define DEVSTARTREQUESTED	26  	/* startup sequence requested but
					   not initialised */
#define DEVSTOPREQUESTED	27	/* stop sequence requested but
					   not initialised */

#define DEVPOSITIVEENDSTOP	28
#define DEVNEGATIVEENDSTOP	29


#define DEVBAKEREQUESTED   	30   /* bake requested but not yet started */
#define DEVBAKEING         	31   /* channel is bakeing */
#define DEVSTOPBAKE        	32   /*	channel bake is stopping */

#define DEVFORCEDOPEN           33
#define DEVFORCEDCLOSE          34

#define DEVOFFUNAUTHORISED      35    /* off, restarting not authorised */
#define DEVONNOTREGULAR         36    /* on, temp not regulated  */
#define DEVRESETTING          	37    /* resetting */
#define DEVFORBIDDEN          	38
#define DEVOPENING          	39
#define DEVCLOSING          	40
#define DEVUNDEFINED          	41

#define DEVCOUNTING             42      /* Device counting */
#define STOPPED                 43      /* Device stopped  */
#define RUNNING                 44      /* Device running */
#define DEVALARM                45      /* Powersupply in alarm */
#define DEVDISABLED		46

#define DEVSTANDBY_NOT_REACHED	47
#define DEVON_NOT_REACHED	48

#if !defined(FORTRAN)
extern _DLLFunc const char* DEVSTATES[];
#endif /* FORTRAN */

#endif /* _DevStates_h */
