/*+*******************************************************************

 File:          CntrlDsNumbers.h

 Project:       Device Servers with SUN-RPC

 Description:   Include file with the definitions for all 
		device server classes of the machine control 
		group.

 Author(s):     Jens Meyer

 Original:      July 1993


 $Revision: 4.56 $
 $Date: 2002/02/22 13:19:46 $

 $Author: meyer $

 $Log:	CntrlDsNumbers.h,v $
 * Revision 4.56  2002/02/22  13:19:46  13:19:46  meyer (J.Meyer)
 * Corrected base number.
 * 
 * Revision 4.55  2002/02/22  13:14:25  13:14:25  meyer (J.Meyer)
 * Added stetching cell class.
 * 
 * Revision 4.54  2002/01/16  17:41:18  17:41:18  pons ()
 * Add DevCAV78CoolBase class (CAV78 Coolling)
 * 
 * Revision 4.53  2001/05/29  13:06:03  13:06:03  chaize (Jm.Chaize)
 * *** empty log message ***
 * 
 * Revision 4.52  01/02/19  11:38:27  11:38:27  pons ()
 * Add Transversal feedback Class base
 * 
 * Revision 4.51  20/0./3.  7.:8.:5.  7.:8.:5.  pons ()
 * Add the DevIPTaxiBase.
 * 
 * Revision 4.50  2000/02/15  12:48:18  12:48:18  meyer (J.Meyer)
 * Added FrontEndLog Class base.
 * 
 * Revision 4.49  99/12/10  11:16:16  11:16:16  olivier (Olivier Martin)
 * Add AYCO Base
 * 
 * Revision 4.48  99/12/08  14:57:45  14:57:45  pons ()
 * Add FeVac Base
 * 
 * Revision 4.47  99/10/04  14:45:31  14:45:31  olivier (Olivier Martin)
 * Added IP Module ADA08 Base
 * 
 * Revision 4.46  99/05/05  17:52:16  17:52:16  goetz (Andy Goetz)
 * add base for ID Treff and Hfo (ci done by JMC under the name of Goetz).
 * 
 * Revision 4.45  99/01/07  09:41:56  09:41:56  pons ()
 * Add Cavity Coolling loop base
 * 
 * Revision 4.44  98/09/21  15:50:28  15:50:28  chaize (Jm.Chaize)
 * correct syntax error
 * 
 * Revision 4.43  98/09/21  15:47:02  15:47:02  chaize (Jm.Chaize)
 * add Global Feedback class
 * ,
 * 
 * Revision 4.42  98/08/14  18:45:21  18:45:21  pons ()
 * Add ADC icv101 base.
 * 
 * Revision 4.41  98/07/31  17:55:22  17:55:22  pons ()
 * Add Mille Tour BPM high level class base
 * 
 * Revision 4.40  98/06/23  17:09:51  17:09:51  pons ()
 * Add MachStat base
 * 
 * Revision 4.39  98/06/23  17:11:21  17:11:21  meyer (J.Meyer)
 * Add Serial line protocol for dose meter
 * 
 * Revision 4.38  98/01/28  14:41:22  14:41:22  penel (C.Penel)
 * adding EmphuBase (Penel)
 * 
 * Revision 4.37  97/10/23  11:10:16  11:10:16  cardonne
 * Base for Varian ionpump
 * 
 * Revision 4.36  97/10/19  10:54:27  10:54:27  chaize (Jm.Chaize)
 * add NoBreak class for power management.
 * 
 * Revision 4.35  97/10/15  08:07:10  08:07:10  domingue (Mc.Dominguez)
 * add Cobula class
 * 
 * Revision 4.34  1997/10/10  17:56:44  pons
 * Add RF Phase regulation loop base
 *
 * Revision 4.33  97/09/24  14:23:36  14:23:36  bsa (B.Scaringella)
 * Added TSX17 interface between old PLC class and RFplc class
 * 
 * Revision 4.32  97/09/19  16:35:17  16:35:17  chaize (Jm.Chaize)
 * add GIP G64 Industry Pack carrier
 * 
 * Revision 4.31  97/09/04  17:30:58  17:30:58  pons ()
 * Add RF Driver regulation loop
 * 
 * Revision 4.30  97/08/11  12:00:13  12:00:13  domingue (Mc.Dominguez)
 * Gpsm definition (correct mistake)
 * 
 * Revision 4.29  1997/08/11  11:40:47  domingue
 * add Gpsm (fieldbus access)
 *
 * Revision 4.28  1997/08/10  17:45:26  meyer
 * Added the cavity Tuner class.
 *
 * Revision 4.27  97/08/08  11:39:37  11:39:37  pons ()
 * Add Arc detector class
 * 
 * Revision 4.26  97/07/10  13:38:19  13:38:19  pons ()
 * Add high level cavities base
 * 
 * Revision 4.25  97/07/06  11:52:13  11:52:13  chaize (Jm.Chaize)
 * Add base for bunch clock
 * 
 * Revision 4.24  97/06/30  09:52:55  09:52:55  pons ()
 * Add klystron tube base
 * 
 * Revision 4.23  97/04/14  16:36:58  16:36:58  pons ()
 * Add high-level klystron base
 * 
 * Revision 4.22  97/03/17  09:31:26  09:31:26  meyer (J.Meyer)
 * Added the RF HVPS device class.
 * 
 * Revision 4.21  97/03/03  14:53:06  14:53:06  chaize (Jm.Chaize)
 * added lLinac classe
 * 
 * Revision 4.20  97/01/30  13:59:59  13:59:59  fladmark (I.Fladmark)
 * Implemented number for Multi Signal Class.
 * 
 * Revision 4.19  97/01/30  13:52:05  13:52:05  pons ()
 * *** empty log message ***
 * 
 * Revision 4.18  96/12/09  16:05:46  16:05:46  pons ()
 * Add Sequencer class
 * 
 * Revision 4.17  96/11/26  11:27:05  11:27:05  meyer (J.Meyer)
 * Added DevIonPumpBase, DevFilamentBase and DevFocusBase.
 * 
 * Revision 4.16  96/10/09  15:14:06  15:14:06  fladmark (I.Fladmark)
 * Included Tuner Loop Class for SRRF3.
 * 
 * Revision 4.15  96/09/06  10:36:42  10:36:42  fladmark (I.Fladmark)
 * Included Driver RF.
 * 
 * Revision 4.14  96/09/03  18:59:02  18:59:02  meyer (J.Meyer)
 * Added DevInterlockBase.
 * 
 * Revision 4.13  96/08/30  09:13:50  09:13:50  meyer (J.Meyer)
 * Added DevSiemensBase and DevRfplcBase.
 * 
 * Revision 4.12  96/08/28  17:11:55  17:11:55  fladmark (I.Fladmark)
 * Updated with Nucletude serial line protocol class.
 * 
 * Revision 4.11  96/08/08  11:15:42  11:15:42  bsa (B.Scaringella)
 * added FrontEnd Class base
 * 
 * Revision 4.10  96/06/26  09:43:30  09:43:30  meyer (J.Meyer)
 * Added the Signal-, the Protocol- and the Anode class.
 * 
 * Revision 4.9  96/05/14  08:40:15  08:40:15  meyer (J.Meyer)
 * Added brackets around base definition.
 * 
 * Revision 4.8  96/05/07  09:21:06  09:21:06  chaize (Jm.Chaize)
 * *** empty log message ***
 * 
 * Revision 4.7  96/05/06  18:40:11  18:40:11  meyer (J.Meyer)
 * Fortran compatible include file.
 * 
 * Revision 4.6  96/05/06  12:54:23  12:54:23  chaize (Jm.Chaize)
 * Added base address for dsp classes
 * 
 * Revision 4.5  96/05/03  16:22:21  16:22:21  fladmark (I.Fladmark)
 * Added New Fluid device server
 * 
 * Revision 4.4  96/03/01  10:23:32  10:23:32  fladmark (I.Fladmark)
 * Added AirCondition class
 * 
 * Revision 4.3  96/02/12  15:09:59  15:09:59  meyer (Jens Meyer)
 * added definition for West PID controller device class.
 * 
 * Revision 4.2  96/02/07  14:53:53  14:53:53  fladmark ()
 * Included number for Alarms device server.
 * 
 * Revision 4.1  96/02/02  11:26:50  11:26:50  penel (Christophe Penel)
 * Add groups 19 to 28 for ID Servers
 * 
 * Revision 4.0  95/08/09  17:36:25  17:36:25  meyer (Jens Meyer)
 * Added class for VARIAN gauge controller.
 * 
 * Revision 3.40  95/07/24  14:22:42  14:22:42  fladmark ()
 * Added HpibSICL Class.
 * 
 * Revision 3.39  95/07/23  08:40:25  08:40:25  fladmark ()
 * Installed number for Cts Class.
 * 
 * Revision 3.38  95/03/13  11:30:38  11:30:38  chaize (Jean Michel Chaize)
 * add bpm class
 * 
 * Revision 3.37  94/10/06  10:27:44  10:27:44  fladmark (Ingrid Fladmark)
 * Added Number for Tagger Class.
 * 
 * Revision 3.36  94/07/06  13:23:58  13:23:58  meyer (Jens Meyer)
 * Added fluid class base number.
 * 
 * Revision 3.35  94/06/24  13:39:01  13:39:01  fladmark ()
 * Included Number for C5680 Streak Camera class.
 * 
 * Revision 3.34  94/06/08  13:17:38  13:17:38  chaize (Jean Michel Chaize)
 * Added VLM class base number
 * 
 * Revision 3.33  94/03/24  11:29:25  11:29:25  fladmark (Ingrid Fladmark)
 * Added number for CalcSignals device server.
 * 
 * Revision 3.32  94/03/10  16:08:56  16:08:56  verdier (Pascal Verdier)
 * Added DevVdsp71Base
 * 
 * Revision 3.31  94/02/25  10:37:11  10:37:11  fladmark ()
 * Added base address for Srct.
 * 
 * Revision 3.30  94/02/24  13:59:27  13:59:27  taurel (Emmanuel TAUREL)
 * Check in by E.T to stop the growing of differents release of this file.
 * 
 * Revision 3.29  94/01/17  10:37:37  10:37:37  goetz (Andy Goetz)
 * added XBPM class base number
 * 
 * Revision 3.28  93/12/23  13:49:09  13:49:09  chaize (Jean Michel CHAIZE)
 * added DevHazemeyerBase.
 * 
 * Revision 3.27  93/12/07  14:22:45  14:22:45  meyer (Jens Meyer)
 * Added DevIdBase.
 * 
 * Revision 3.26  93/11/08  10:31:31  10:31:31  meyer (Jens Meyer)
 * Added DevPowerMeterBase.
 * 
 * Revision 3.25  93/09/24  17:25:01  17:25:01  meyer (Jens Meyer)
 * Release with error and command resources.
 * 
 * Revision 3.22  93/08/19  18:54:04  18:54:04  meyer (Jens Meyer)
 * Added base address for AirCUnit class.
 * 
 * Revision 3.21  93/08/11  12:10:23  12:10:23  meyer (Jens Meyer)
 * Changed shift bits for Team Number and DS Identification.
 * 
 * Revision 3.20  93/08/10  12:59:12  12:59:12  meyer (Jens Meyer)
 * Database support for commands and errors.
 * 

 Copyright (c) 1990 by European Synchrotron Radiation Facility,
		       Grenoble, France

********************************************************************-*/

#ifndef _CntrlDsNumbers_h
#define _CntrlDsNumbers_h

#include <DserverTeams.h>

/* Test service */
#define DevTestBase     (CntrlTeamNumber + DS_LSHIFT(1, DS_IDENT_SHIFT)) 
/* Aircondition Units Server (J. Meyer)*/
#define DevAirCUnitBase (CntrlTeamNumber + DS_LSHIFT(2, DS_IDENT_SHIFT))
/* Power Meter Server (P. Verdier) */
#define DevPowerMeterBase (CntrlTeamNumber + DS_LSHIFT(3, DS_IDENT_SHIFT))
/* Insertion device classes (C. Penel) */
#define DevIdBase (CntrlTeamNumber + DS_LSHIFT(4, DS_IDENT_SHIFT)) 
/* hazemeyer classes (J.M. Chaize) */
#define DevHazemeyerBase (CntrlTeamNumber + DS_LSHIFT(5, DS_IDENT_SHIFT)) 
/* XBPM class (A.Gotz) */
#define DevXBPMBase (CntrlTeamNumber + DS_LSHIFT(6, DS_IDENT_SHIFT))
/* XFeedback class (A.Gotz) */
#define DevXFDBKBase (CntrlTeamNumber + DS_LSHIFT(7, DS_IDENT_SHIFT))
/* Srct class (I.Fladmark) */
#define DevSRCTBase (CntrlTeamNumber + DS_LSHIFT(8, DS_IDENT_SHIFT))
/* VDSP71 Board for Voltage Monitor Server (P. Verdier) */
#define DevVdsp71Base (CntrlTeamNumber + DS_LSHIFT(9, DS_IDENT_SHIFT))
/* CalcSignals class (I.Fladmark) */
#define DevCalcSignalsBase (CntrlTeamNumber + DS_LSHIFT(10, DS_IDENT_SHIFT))
/* VLM class (J.M. Chaize) */
#define DevVLMBase (CntrlTeamNumber + DS_LSHIFT(11, DS_IDENT_SHIFT))
/* C5680 Streak Camera class (I. Fladmark) */
#define DevC5680Base (CntrlTeamNumber + DS_LSHIFT(12, DS_IDENT_SHIFT))
/* Fluid Circuit class (J. Meyer) */
#define DevFluidBase (CntrlTeamNumber + DS_LSHIFT(13, DS_IDENT_SHIFT))
/* Tagger Class (I. Fladmark) */
#define DevTaggerBase (CntrlTeamNumber + DS_LSHIFT(14, DS_IDENT_SHIFT))
/* Bpm Class (JM. Chaize) */
#define DevBpmBase (CntrlTeamNumber + DS_LSHIFT(15, DS_IDENT_SHIFT))
/* Cts Class (I. Fladmark) */
#define DevCTSBase (CntrlTeamNumber + DS_LSHIFT(16, DS_IDENT_SHIFT))
/* HpibSICL Class (I. Fladmark) */
#define DevHPIBSICLBase (CntrlTeamNumber + DS_LSHIFT(17, DS_IDENT_SHIFT))
/* Pgvarian Class (J. Meyer) */
#define DevPgvarianBase (CntrlTeamNumber + DS_LSHIFT(18, DS_IDENT_SHIFT))
/* Elesta device classes (C. Penel) */
#define DevElestaBase (CntrlTeamNumber + DS_LSHIFT(19, DS_IDENT_SHIFT))
/* Berger device classes (C. Penel) */
#define DevBergerBase (CntrlTeamNumber + DS_LSHIFT(20, DS_IDENT_SHIFT))
/* Axe device classes (C. Penel) */
#define DevAxeBase (CntrlTeamNumber + DS_LSHIFT(21, DS_IDENT_SHIFT))
/* Taper device classes (C. Penel) */
#define DevTaperBase (CntrlTeamNumber + DS_LSHIFT(22, DS_IDENT_SHIFT))  
/* IdSlit device classes (C. Penel) */
#define DevIdSlitBase (CntrlTeamNumber + DS_LSHIFT(23, DS_IDENT_SHIFT)) 
/* Revolver device classes (C. Penel) */
#define DevRevolverBase (CntrlTeamNumber + DS_LSHIFT(24, DS_IDENT_SHIFT)) 
/* Meca device classes (C. Penel) */
#define DevMecaBase (CntrlTeamNumber + DS_LSHIFT(25, DS_IDENT_SHIFT))
/* Power device classes (C. Penel) */
#define DevPowerBase (CntrlTeamNumber + DS_LSHIFT(26, DS_IDENT_SHIFT))
/* Bulstra device classes (C. Penel) */
#define DevBulstraBase (CntrlTeamNumber + DS_LSHIFT(27, DS_IDENT_SHIFT)) 
/* Lien device classes (C. Penel) */
#define DevLienBase (CntrlTeamNumber + DS_LSHIFT(28, DS_IDENT_SHIFT))
/* Alarms device classes (I. Fladmark) */
#define DevAlarmBase (CntrlTeamNumber + DS_LSHIFT(29, DS_IDENT_SHIFT))
/* West PID controller device class (J. Meyer) */
#define DevPidBase (CntrlTeamNumber + DS_LSHIFT(30, DS_IDENT_SHIFT))
/* AirCondition device class (I. Fladmark) */
#define DevAirConditionBase (CntrlTeamNumber + DS_LSHIFT(31, DS_IDENT_SHIFT)) 
/* Fluid device class (I. Fladmark) */
#define DevFLUIDBase (CntrlTeamNumber + DS_LSHIFT(32, DS_IDENT_SHIFT))
/* Dsp device class (J.M. Chaize) */
#define DevDspBase (CntrlTeamNumber + DS_LSHIFT(33, DS_IDENT_SHIFT))
/* Signal treatment class (J. Meyer) */
#define DevSignalBase (CntrlTeamNumber + DS_LSHIFT(34, DS_IDENT_SHIFT))
/* ESRF serial line protocol class (J. Meyer) */
#define DevProtocolBase (CntrlTeamNumber + DS_LSHIFT(35, DS_IDENT_SHIFT))
/* Anode power supply device class (J. Meyer) */
#define DevAnodeBase (CntrlTeamNumber + DS_LSHIFT(36, DS_IDENT_SHIFT))
/* FrontEnd Class error base */
#define DevFrontEndBase (CntrlTeamNumber + DS_LSHIFT(37, DS_IDENT_SHIFT))
/* Nucletude serial line protocol class */
#define DevNucletudeBase (CntrlTeamNumber + DS_LSHIFT(38, DS_IDENT_SHIFT))
/* Siemens serial line protocol class (J. Meyer) */
#define DevSiemensBase (CntrlTeamNumber + DS_LSHIFT(39, DS_IDENT_SHIFT))
/* RF PLC device class (J. Meyer) */
#define DevRfplcBase (CntrlTeamNumber + DS_LSHIFT(40, DS_IDENT_SHIFT))
/* RF Interlock class (J. Meyer) */
#define DevInterlockBase (CntrlTeamNumber + DS_LSHIFT(41, DS_IDENT_SHIFT))
/* Driver RF class (I. Fladmark) */
#define DevDriverRFBase (CntrlTeamNumber + DS_LSHIFT(42, DS_IDENT_SHIFT))
/* Tuner Loop class (I. Fladmark) */
#define DevTunerLoopBase (CntrlTeamNumber + DS_LSHIFT(43, DS_IDENT_SHIFT))
/* RF ion pump power supply device class (JL. Pons) */
#define DevIonPumpBase (CntrlTeamNumber + DS_LSHIFT(44, DS_IDENT_SHIFT))
/* RF Filament power supply device class (JL. Pons) */
#define DevFilamentBase (CntrlTeamNumber + DS_LSHIFT(45, DS_IDENT_SHIFT))
/* RF Focus power supply device class (JL. Pons) */
#define DevFocusBase (CntrlTeamNumber + DS_LSHIFT(46, DS_IDENT_SHIFT))
/* Sequencer class (JL. Pons) */
#define DevSequencerBase (CntrlTeamNumber + DS_LSHIFT(47, DS_IDENT_SHIFT))
/* Multi Signal class (I. Fladmark) */
#define DevMSignalBase (CntrlTeamNumber + DS_LSHIFT(48, DS_IDENT_SHIFT))
/*  Linac class (JM Chaize) */
#define DevLinacBase (CntrlTeamNumber + DS_LSHIFT(49, DS_IDENT_SHIFT))
/* RF HVPS device class (J. Meyer) */
#define DevHvpsBase (CntrlTeamNumber + DS_LSHIFT(50, DS_IDENT_SHIFT))
/* RF Klystron high-level device class (JL PONS) */
#define DevKlystronBase (CntrlTeamNumber + DS_LSHIFT(51, DS_IDENT_SHIFT))
/* RF Klystron tube device class (JL PONS) */
#define DevKlystronTubeBase (CntrlTeamNumber + DS_LSHIFT(52, DS_IDENT_SHIFT))
/* BunchClock device class (JM Chaize) */
#define DevBCBase (CntrlTeamNumber + DS_LSHIFT(53, DS_IDENT_SHIFT))
/* high level cavities class (JL Pons) */
#define DevCavitiesBase (CntrlTeamNumber + DS_LSHIFT(54, DS_IDENT_SHIFT))
/* Arc detector class (JL Pons) */
#define DevArcBase (CntrlTeamNumber + DS_LSHIFT(55, DS_IDENT_SHIFT))
/* Tuner class (J. Meyer) */
#define DevTunerBase (CntrlTeamNumber + DS_LSHIFT(56, DS_IDENT_SHIFT))
/* Gpsm (Fieldbus access) class (for 1000 tours BPM) (MC Dominguez) */
#define DevGpsmBase (CntrlTeamNumber + DS_LSHIFT(57, DS_IDENT_SHIFT))
/* RF Driver regulation loop (JL PONS) */
#define DevDrivLoopBase (CntrlTeamNumber + DS_LSHIFT(58, DS_IDENT_SHIFT))
/* GIP Industry Pack G64 board (JM Chaize) */
#define DevGIPBase (CntrlTeamNumber + DS_LSHIFT(59, DS_IDENT_SHIFT))
/* TSX17 plc interface between Plc class and RFplc class (B. Scaringella) */
#define DevTsx17Base (CntrlTeamNumber + DS_LSHIFT(60, DS_IDENT_SHIFT))
/* RF Phase regulation loop (JL PONS) */
#define DevPhaseLoopBase (CntrlTeamNumber + DS_LSHIFT(61, DS_IDENT_SHIFT))
/* Cobula (for 1000 tours BPM) (MC Dominguez) */
#define DevCobulaBase (CntrlTeamNumber + DS_LSHIFT(62, DS_IDENT_SHIFT))
/* NoBreak base for HQPS power management (JM Chaize) */
#define DevNoBreakBase (CntrlTeamNumber + DS_LSHIFT(63, DS_IDENT_SHIFT))
/* VIPBase base for Varian ionpump (JM Chaize) */
#define DevVIPBase (CntrlTeamNumber + DS_LSHIFT(64, DS_IDENT_SHIFT))
/* EMPHU base for EMPHU SYSTEM (C PENEL) */
#define DevEmphuBase (CntrlTeamNumber + DS_LSHIFT(65, DS_IDENT_SHIFT))
/* Serial line protocol for dose meter define by JF.Bouteille (J Meyer) */
#define DevJFBProtocolBase (CntrlTeamNumber + DS_LSHIFT(66, DS_IDENT_SHIFT))
/* MachStat base (JL Pons) */
#define DevMachStatBase (CntrlTeamNumber + DS_LSHIFT(67, DS_IDENT_SHIFT))
/* Mille Tour BPM high level class base (JL Pons) */
#define DevMTourBase (CntrlTeamNumber + DS_LSHIFT(68, DS_IDENT_SHIFT))
/* ADC icv101 base (JL Pons) */
#define DevAdcicv101Base (CntrlTeamNumber + DS_LSHIFT(69, DS_IDENT_SHIFT))
/* Global feedback base (JM Chaize) */
#define DevGfeedbackBase (CntrlTeamNumber + DS_LSHIFT(70, DS_IDENT_SHIFT))
/* Cavity Coolling loop base (JL Pons) */
#define DevCoolloopBase (CntrlTeamNumber + DS_LSHIFT(71, DS_IDENT_SHIFT))
/* Insertion Device base (A Gotz) */
#define DevIDBase (CntrlTeamNumber + DS_LSHIFT(72, DS_IDENT_SHIFT))
/* Transfer Efficiency Base */
#define DevTreffBase (CntrlTeamNumber + DS_LSHIFT(73, DS_IDENT_SHIFT))
/*  Horizontal Focussing Base */
#define DevHfoBase (CntrlTeamNumber + DS_LSHIFT(74, DS_IDENT_SHIFT))
/*  IP Module ADA08 Base */
#define DevADA08Base (CntrlTeamNumber + DS_LSHIFT(75, DS_IDENT_SHIFT))
/*  FeVac Base (High level class for FE vacuum) */
#define DevFeVacBase (CntrlTeamNumber + DS_LSHIFT(76, DS_IDENT_SHIFT))
/*  SYCODS (Booster Power Supply correction) */
#define DevSYCOBase (CntrlTeamNumber + DS_LSHIFT(77, DS_IDENT_SHIFT))
/* FrontEndLog Class base */
#define DevFrontEndLogBase (CntrlTeamNumber + DS_LSHIFT(78, DS_IDENT_SHIFT))
/* IPTaxi Class base */
#define DevIPTaxiBase (CntrlTeamNumber + DS_LSHIFT(79, DS_IDENT_SHIFT))
/* Transversal feedback Class base */
#define DevFeedTransBase (CntrlTeamNumber + DS_LSHIFT(80, DS_IDENT_SHIFT))
#define DevHDBBase (CntrlTeamNumber + DS_LSHIFT(81, DS_IDENT_SHIFT))
/* Cav78 Coolling Class base */
#define DevCAV78CoolBase (CntrlTeamNumber + DS_LSHIFT(82, DS_IDENT_SHIFT))
/* Stretching cell Class base */
#define DevSCBase (CntrlTeamNumber + DS_LSHIFT(83, DS_IDENT_SHIFT))
#endif	/* _CntrlDsNumbers_h */
