static char RcsId[] =
"@(#)$Header: /segfs/dserver/system/xdr/src/RCS/ct_xdr.c,v 5.22 2002/03/11 12:35:57 goetz Rel $";

/*+*******************************************************************

 File:          rf_xdr.c

 Project:       Device Servers with sun-rpc

 Description:   xdr_routines for radio frequency types.

 Author(s):     Jens Meyer

 Original:      April 1992

$Revision: 5.22 $
$Date: 2002/03/11 12:35:57 $

$Author: goetz $

$Log: ct_xdr.c,v $
Revision 5.22  2002/03/11 12:35:57  goetz
added extern C prototype to VGC xdr routines for C++

Revision 5.21  2001/11/12 10:01:36  goetz
updated C port for Windows 95/98/NT using Visual C++ 6

Revision 5.20  2001/01/08 12:17:35  goetz
added patch by B.Pedersen to support querying events

Revision 5.19  2000/10/02 12:08:45  goetz
removed stderr from api_xdr.c

Revision 5.18  1999/07/08 14:10:46  goetz
changed _LPfd_set type for Linux in macros.h

Revision 5.17  1998/05/25 17:59:39  klotz
fixed C++ prototypes in api_xdr.h

Revision 5.16  1998/04/29 10:24:01  goetz
macros.h - added __STDCPP__ for HP C++ compiler (aCC)

 * Revision 5.15  97/12/01  15:16:07  15:16:07  klotz (W.D. Klotz)
 * WIN_NT_95_released_NOV_97
 * 
 * Revision 4.34  97/01/30  13:58:36  13:58:36  goetz (Andy Goetz)
 * removed dev_printdebug() from DevXdrKernel.h
 * 
 * Revision 4.33  97/01/09  10:08:41  10:08:41  goetz (Andy Goetz)
 * (xdrproc_t) castings added to maxe_xdr, ram_xdr, thc_xdr, seism_xdr
 * 
 * Revision 4.32  97/01/08  16:48:30  16:48:30  goetz (Andy Goetz)
 * Ported to Linux (2.0.9)
 * 
Revision 4.31  1996/11/18 17:28:47  goetz
Check

 * Revision 4.28  96/10/21  16:22:21  16:22:21  taurel (E.Taurel)
 * Check_in_after_port_to_OS9/ISP_2.1_and_OS9/RPC1.4
 * 
 * Revision 4.27  96/09/17  16:39:59  16:39:59  klotz (W.D. Klotz)
 * WD Klotz: tested NT build  
 * 
 * Revision 4.26  96/07/19  10:01:00  10:01:00  taurel (E.Taurel)
 * Some_change_in_macros.h_for_the_API_port_to_OS-9_Ultra_C++
 * 
 * Revision 4.25  96/06/07  16:23:04  16:23:04  meyer (J.Meyer)
 * Corrected_elif_to_else_in_macros.h
 * 
 * Revision 4.24  96/06/05  15:01:38  15:01:38  meyer (J.Meyer)
 * Corrected_macros.h
 * 
 * Revision 4.23  96/06/03  13:10:16  13:10:16  meyer (J.Meyer)
 * Cleaned-up_MSDOS_and_added_porting_options_for_Windows_NT.
 * 
 * Revision 4.22  96/05/23  11:07:25  11:07:25  taurel (E.Taurel)
 * Added_some_definitions_for_C++_in_API_xdr.h_file
 * 
 * Revision 4.21  96/05/06  18:37:36  18:37:36  meyer (J.Meyer)
 * Fortran_compatibility_for:_dev_xdr.h,macros.h,maxe_xdr.h
 * 
 * Revision 4.20  96/02/27  13:31:36  13:31:36  meyer (J.Meyer)
 * Deleted_Cross_References_To_DSAPI_Library
 * 
 * Revision 4.19  96/01/11  17:40:21  17:40:21  meyer (Jens Meyer)
 * Added_#define_PORTMAP_to_macros.h.
 * 
 * Revision 4.18  95/12/21  10:33:29  10:33:29  meyer (Jens Meyer)
 * Corrected length calculation for D_VAR_MSTATARR.
 * 
 * Revision 4.17  95/08/02  16:05:13  16:05:13  meyer (Jens Meyer)
 * Corrected DevXdrKernel.h after C++ implementation.
 * 
 * Revision 4.15  95/03/02  10:27:52  10:27:52  meyer (Jens Meyer)
 * Added D_VAR_SFRPARR type to the kernel.
 * 
 * Revision 4.14  95/02/20  09:56:40  09:56:40  meyer (Jens Meyer)
 * Passed the compilers for HPUX, SUNOS and UCC after the first windows check in.
 * 
 * Revision 4.13  95/02/10  17:18:57  17:18:57  meyer (Jens Meyer)
 * Deleted
 * 
 * Revision 4.12  95/02/01  14:26:47  14:26:47  klotz (W.D. Klotz)
 * WDK: first successfull compile of dbase, api, xdr on WIN16/3.1
 * 
 * Revision 4.11  95/01/03  13:19:19  13:19:19  meyer (Jens Meyer)
 * Repared bug in dev_cmd_query() for version 3!
 * 
 * Revision 4.10  94/12/08  15:24:50  15:24:50  meyer (Jens Meyer)
 * Changed _manager_data in API_xdr and added old version to API_xdr_vers3.
 * 
 * Revision 4.9  94/11/28  17:04:12  17:04:12  meyer (Jens Meyer)
 * Data types for compatibility with library version 3.x
 * 
 * Revision 4.8  94/08/16  16:59:28  16:59:28  meyer (Jens Meyer)
 * Corrected error in ws_xdr.h
 * 
 * Revision 4.7  94/08/16  16:34:24  16:34:24  meyer (Jens Meyer)
 * Added define for MAX_RESOURCE_FIELD_LENGTH to macros.h
 * 
 * Revision 4.6  94/08/12  15:07:38  15:07:38  meyer (Jens Meyer)
 * Added valriable arguments to all API RPC structures.
 * 
 * Revision 4.5  94/07/20  18:15:40  18:15:40  meyer (Jens Meyer)
 * Changed include files in macros.h!
 * 
 * Revision 4.4  94/07/20  08:55:39  08:55:39  meyer (Jens Meyer)
 * All XDR functions with prototypes!
 * 
 * Revision 4.3  94/07/18  18:50:49  18:50:49  meyer (Jens Meyer)
 * Had to change macros.h, because #define must be in the first column!
 * 
 * Revision 4.2  94/07/18  18:22:06  18:22:06  meyer (Jens Meyer)
 * First test with PC macros for the XDR kernel.
 * 
 * Revision 4.1  94/05/02  10:50:42  10:50:42  meyer (Jens Meyer)
 * For Security System without connection count.
 * 
 * Revision 4.0  94/03/14  18:17:28  18:17:28  meyer (Jens Meyer)
 * Library version with Security System.
 * 
 * Revision 3.50  94/03/12  14:36:21  14:36:21  meyer (Jens Meyer)
 * Changed API xdr structures for security.
 * 
 * Revision 3.35  94/03/03  10:52:04  10:52:04  taurel (Emmanuel TAUREL)
 * Added unsigned long array type in the XDRkernel
 * 
 * Revision 3.34  94/03/03  10:28:57  10:28:57  taurel (Emmanuel TAUREL)
 * Added the unsigned long array type in
 * XDR kernel (LC and ET).
 * 
 * Revision 3.33  94/01/12  16:34:20  16:34:20  meyer (Jens Meyer)
 * Global XDR type array for data collector access
 * 
 * Revision 3.31  93/12/02  09:38:53  09:38:53  meyer (Jens Meyer)
 * New release with small XDR data type kernel.
 * 
 * Revision 1.1  93/11/15  11:05:10  11:05:10  meyer (Jens Meyer)
 * Initial revision
 * 

Copyright (c) 1990 by European Synchrotron Radiation Facility,
		      Grenoble, France

*******************************************************************-*/

#include <dev_xdr.h>
#include <ct_xdr.h>


bool_t
xdr_DevCtIntLifeTime (xdrs, objp)
	XDR *xdrs;
	DevCtIntLifeTime *objp;
{
	if (!xdr_float(xdrs, &objp->DeltaIntensity)) {
		return (FALSE);
	}
	if (!xdr_float(xdrs, &objp->LifeTime)) {
		return (FALSE);
	}
	if (!xdr_long(xdrs, &objp->DateTicks)) {
		return (FALSE);
	}
	if (!xdr_long(xdrs, &objp->DeltaTused)) {
		return (FALSE);
	}
	return (TRUE);
}


long
xdr_length_DevCtIntLifeTime(objp)
	DevCtIntLifeTime *objp;
	{
	long  length = 0;

	length = length + xdr_length_DevFloat (&objp->DeltaIntensity);
	length = length + xdr_length_DevFloat (&objp->LifeTime);
	length = length + xdr_length_DevLong  (&objp->DateTicks);
	length = length + xdr_length_DevLong  (&objp->DeltaTused);

	return (length);
}




bool_t
xdr_DevVarCtIntLifeTimeArray(xdrs, objp)
	XDR *xdrs;
	DevVarCtIntLifeTimeArray *objp;
{
	if (!xdr_array(xdrs, (caddr_t *)&objp->sequence,
	    (u_int *)&objp->length, MAXU_INT, sizeof(DevCtIntLifeTime),
	    (xdrproc_t)xdr_DevCtIntLifeTime)) {
		return (FALSE);
	}
	return (TRUE);
}

long
xdr_length_DevVarCtIntLifeTimeArray (objp)
	DevVarCtIntLifeTimeArray *objp;
{
	long    length = 0;

	/*
	 *  four bytes for the number of array elements
  	 */

	length = length + xdr_length_DevLong ((long *)&objp->length);

	/*
	 *  now calculate the length of the array
	 */

	length = length + (objp->length *
	         xdr_length_DevCtIntLifeTime(&objp->sequence[0]) );

	return (length);
}


