/****************************************************************************

 File          :   tc_api.h

 Project       :   Type conversion library

 Description   :   The interface file (header file) for the library

 Author        :   Faranguiss Poncet

 Original      :   November 1996

 $Revision: 1.8 $                               $Author: poncet $
 $Date: 98/06/12 11:28:01 $                                     $State: Rel $

 $Log:	tc_api.h,v $
 * Revision 1.8  98/06/12  11:28:01  11:28:01  poncet (F.Poncet)
 * Added "DevMulMove" type for conversion to string (Maxe dev server).
 * 
 * Revision 1.7  98/06/10  17:41:09  17:41:09  poncet (F.Poncet)
 * Added the conversion function (one way only) for DevMotorLong and for
 * DevMotorFloat types.
 * 
 * Revision 1.6  97/04/10  10:07:32  10:07:32  poncet (F.Poncet)
 * Changed the precision for the conversion of the floats and doubles to
 * string. This precision was .21g before and now is .4g
 * 
 * Revision 1.5  97/03/21  14:02:47  14:02:47  poncet (F.Poncet)
 * Changed TC_HPUX_DEF_PATH  definition to "libtcapi.sl" (instead of
 * "/usr/local/lib/libtcapi.sl" previously in tc_api.h file.
 * Changed also TC_SOLARIS_DEF_PATH  definition to "libtcapi.so" (instead of
 * "/usr/local/lib/libtcapi.so" previously in tc_api.h file.
 * These changes result in the fact that at run time the library can be
 * installed anywhere but dynamic loader will find it if the corresponding
 * environment variable SHLIB_PATH (for HPUX) or LD_LIBRARY_PATH (for SOLARIS)
 * is correctly set.
 * If the library is installed in /usr/local/lib (as is the case at ESRF)
 * normally there is no need to set SHLIB_PATH or LD_LIBRARY_PATH to this
 * directory.
 * 
 * Revision 1.4  97/01/21  14:45:43  14:45:43  poncet (F.Poncet)
 * File unchanged. Archived for compatible revision numbers.
 * 
 * 
 * Revision 1.3  97/01/17  16:16:49  16:16:49  poncet (F.Poncet)
 * Changed minor details in the type outputs in tc_str.c.
 * 
 * Revision 1.2  97/01/10  11:30:38  11:30:38  poncet (F.Poncet)
 * File unchanged. Archived for compatible revision numbers.
 * 
 * Revision 1.1  96/11/25  18:25:07  18:25:07  poncet (F.Poncet)
 * Initial revision
 * 

 Copyright (c) 1996 by European Synchrotron Radiation Facility,
                       Grenoble, France

                       All Rights Reserved

****************************************************************************/


#ifndef _tcapi_h
#define _tcapi_h

#define TC_HPUX_DEF_PATH      "libtcapi.sl"
#define TC_SOLARIS_DEF_PATH   "libtcapi.so"

#include <tc_str.h>

#endif /* _tcapi_h */
