static char RcsId[] =
"@(#)$Header: Manager.c,v 4.12 20/0./3. 5.:7.:3. taurel Rel $ ";
/*********************************************************************

 File:          Manager.c

 Project:       Device Servers with sun-rpc

 Description:   Source code for implementing a Network Manager

 Author(s):     Jens Meyer

 Original:	January 1991


 $Revision: 4.12 $
 $Date: 20/0./3. 5.:7.:3. $

 $Author: taurel $

 $Log:	Manager.c,v $
 * Revision 4.12  20/0./3.  5.:7.:3.  5.:7.:3.  taurel (E.Taurel)
 * Remove the chmod for unix operating system
 * 
 * Revision 4.11  99/11/21  20:36:15  20:36:15  goetz (Andy Goetz)
 * calling svc_destroy() before execv() for database and message server (M.Diehl patch)
 * 
 Revision 4.10  1999/08/04 11:55:08  goetz
 fixed bug in initialisation of config_flags to initialise only 7 fields

 Revision 4.9  1999/07/11 10:19:35  goetz
 added support for Linux binaries

 Revision 4.8  1999/03/10 14:11:49  taurel
 Added new env. variables for ORACLE db

 * Revision 4.7  98/10/15  16:56:54  16:56:54  taurel (E.Taurel)
 * Some
 * 
 * Revision 4.6  98/10/15  16:53:07  16:53:07  taurel (Emmanuel Taurel)
 * Added a new -oracle option
 * 
 * Revision 4.4  96/01/16  11:00:00  11:00:00  meyer (J.Meyer)
 * Added environment variable DBHOME for RTDB startup.
 * 
 * Revision 4.3  96/01/11  10:17:49  10:17:49  taurel (Emmanuel TAUREL)
 * Change the dbase path in the include file.
 * 
 * Revision 4.2  95/01/04  16:28:28  16:28:28  meyer (Jens Meyer)
 * Version ported to solaris2.
 * 
 * Revision 4.1  94/12/19  17:01:39  17:01:39  meyer (Jens Meyer)
 * Tested for RTDB and DBM.
 * 
 * Revision 4.0  94/12/12  11:31:29  11:31:29  meyer (Jens Meyer)
 * Version with security tested for RTDB
 * 
 * Revision 3.3  92/11/16  19:19:07  19:19:07  meyer (Jens Meyer)
 * Corrected compile options for s700 version
 * 
 * Revision 3.2  92/11/10  11:27:27  11:27:27  meyer (Jens Meyer)
 * Corrected directory path to system/bin
 * 
 * Revision 3.1  92/11/10  11:14:24  11:14:24  meyer (Jens Meyer)
 * Corrected
 * 
 * Revision 3.0  92/11/10  10:57:44  10:57:44  meyer (Jens Meyer)
 * Unique
 * 


 Copyright (c) 1990 by  European Synchrotron Radiation Facility,
			Grenoble, France

			All Rights Reserved

**********************************************************************/


#include <API.h>
#include <ApiP.h>
#include <DevErrors.h>
#include <ManagerP.h>
#include <signal.h>

/********************************
 *           GLOBALS            *
 ********************************/

	void 		quit_server ();

	extern config_flags 	c_flags;
	extern char		*dshome;
	extern char		*display;
	extern char		nethost [32];
	extern char		logfile [256];

	server_conf		db_conf  = {NULL,0,0};
	server_conf		msg_conf = {NULL,0,0};

        dbserver_info   	db_info;



/***************************************
 *                                     *
 *  register message server to manager *
 *                                     *
 ***************************************/

_msg_manager_data *rpc_msg_register_1 (register_data)
	_register_data		*register_data;

{
	static _msg_manager_data	msg_manager_data;
	FILE   *system_log = NULL;
	char   *time_string;
	time_t   clock;

	/*
	 *  get message server info
	 */

	sprintf (msg_conf.host_name,"%s",register_data->host_name);
	msg_conf.prog_number = register_data->prog_number;
	msg_conf.vers_number = register_data->vers_number;

	/*
	 *  write information to System.log file
	 */

       	if ( (system_log = fopen (logfile, "a")) != NULL )
	   {
	   time (&clock);
	   time_string = ctime (&clock);
	   fprintf (system_log, 
		    "Message Server registered at : %s",time_string);
	   fprintf (system_log, 
		    "msg_host = %s  prog_nu = %d  vers_nu = %d\n\n",
					    msg_conf.host_name,
					    msg_conf.prog_number,
					    msg_conf.vers_number);
	   fclose (system_log);
	   }
   	else
           {
	   fprintf (stderr,"cannot open System.log file.\n");
	   }


	/*
	 *  set manager return values
	 */

	msg_manager_data.dshome  = dshome;
	msg_manager_data.display = display;


	/*
	 *  set configuration status
	 */

	c_flags.msg_server = True;

	return (&msg_manager_data);
}



/**********************************************
 *                                            *
 * register static database server to manager *
 *                                            *
 **********************************************/

int *rpc_db_register_1 (register_data)
	_register_data		*register_data;

{
	FILE   		*system_log = NULL;
	static int	status = 0;
	char   		*time_string;
	time_t 		clock;

	/*
	 *  get database server info
	 */

	sprintf (db_conf.host_name,"%s",register_data->host_name);
	db_conf.prog_number = register_data->prog_number;
	db_conf.vers_number = register_data->vers_number;

	/*
	 *  write information to System.log file
	 */

       	if ( (system_log = fopen (logfile, "a")) != NULL )
	   {
	   time (&clock);
	   time_string = ctime (&clock);
	   fprintf (system_log, 
		    "Database Server registered at : %s",time_string);
	   fprintf (system_log, 
		    "db_host = %s  prog_nu = %d  vers_nu = %d\n\n",
					    db_conf.host_name,
					    db_conf.prog_number,
					    db_conf.vers_number);
	   fclose (system_log);
	   }
   	else
           {
	   fprintf (stderr,"cannot open System.log file.\n");
	   }

	/*
	 *  set configuration status
	 */

	c_flags.db_server = True;

	return (&status);
}




/***************************************************
 *                                                 *
 *  send static database server and message server *
 *  configuration back to the requesting process.  *
 *                                                 *
 ***************************************************/

_manager_data *rpc_get_config_4 (register_data)
	_register_data	*register_data;

{
	static _manager_data	manager_data;
	FILE   			*system_log = NULL;
	char   			*time_string;
	time_t 			clock;

	manager_data.error  = 0;
	manager_data.status = 0;
	manager_data.var_argument.length   = 0;
	manager_data.var_argument.sequence = NULL;

	/*
	 *  write information about the reading process
	 *  (can be server or client) to the System.log file
	 */
	if ( c_flags.request_log == True )
	   {
       	   if ( (system_log = fopen (logfile, "a")) != NULL )
	      {
	      time (&clock);
	      time_string = ctime (&clock);
	      fprintf (system_log, "Configuration request at : %s",time_string);
	      fprintf (system_log,
		"Requesting process is running on %s with pid = %d\n",
		 register_data->host_name, register_data->prog_number);
	      fclose (system_log);
	      }
   	   else
              {
	      fprintf (stderr,"cannot open System.log file.\n");
	      }
	   }


	/*
	 *  set manager return values
	 */

	manager_data.msg_info.host_name   = msg_conf.host_name;
	manager_data.msg_info.prog_number = msg_conf.prog_number;
	manager_data.msg_info.vers_number = msg_conf.vers_number;

	manager_data.db_info.host_name   = db_conf.host_name;
	manager_data.db_info.prog_number = db_conf.prog_number ;
	manager_data.db_info.vers_number = db_conf.vers_number ;

	manager_data.security            = c_flags.security;

	return (&manager_data);
}



/****************************************************************
 *     Quit Network Manager and its related applications        *
 *     like Message Server and Database Server                  *
 ****************************************************************/

void unreg_server (signo)
	int 	signo;

{
	FILE    *system_log = NULL;
	char 	*time_string;
	time_t  clock;
	int	i;

#ifdef OSK
	if (signo != SIGQUIT && signo != SIGINT)
	   {
	   return;
	   }
#endif /* OSK */

	/*
	 *  write system shutdown message to System.log file
	 */

	if ( (system_log = fopen (logfile, "a")) != NULL )
	   {
	   time (&clock);
	   time_string = ctime (&clock);
	   fprintf (system_log, "\nSystem shutdown at : %s",time_string);
	   fclose (system_log);
	   }

	/*
	 *  quit database and message servers
	 */

	if (c_flags.db_server)
		quit_server ( db_conf.host_name,
			      db_conf.prog_number,
			      db_conf.vers_number );
#ifdef unix
	if (c_flags.msg_server)
		quit_server ( msg_conf.host_name,
			      msg_conf.prog_number,
			      msg_conf.vers_number );
#endif /* unix */


	/*
	 *  unregister manager from portmapper
	 */

	pmap_unset (NMSERVER_PROG, NMSERVER_VERS);
	pmap_unset (NMSERVER_PROG, NMSERVER_VERS_1);
	exit (-1);
}



/****************************************************************
 *     Quit remote server by RPC call                           *
 ****************************************************************/

void quit_server (host_name, prog_number, vers_number)
	char	*host_name;
	long	prog_number;
	long    vers_number;

{
	CLIENT		*clnt;

	
	clnt = clnt_create (host_name,
			    prog_number,
			    vers_number,
			    "udp");
	if (clnt != NULL)
	   {
	   clnt_control (clnt, CLSET_TIMEOUT, (char *) &timeout);
	   clnt_control (clnt, CLSET_RETRY_TIMEOUT, (char *) &retry_timeout);

	   clnt_call (clnt, RPC_QUIT_SERVER, xdr_void, NULL, 
		      xdr_void, NULL, timeout);

	   clnt_destroy (clnt);
	   }
}
	

