static char RcsId[] = "@(#)$Header: /segfs/dserver/system/dc/tools/RCS/dc_del.c,v 3.6 2002/01/31 10:20:55 goetz Exp $";
/*
 * $Log: dc_del.c,v $
 * Revision 3.6  2002/01/31 10:20:55  goetz
 * Linux port using "rsh"
 *
 * Revision 3.5  1996/02/27 16:51:30  taurel
 * Ported to Solaris.
 *
 * Revision 3.4  94/01/26  10:01:01  10:01:01  taurel (Emmanuel TAUREL)
 * A little bug for the sun release !
 * 
 * Revision 3.3  94/01/25  18:12:35  18:12:35  taurel (Emmanuel Taurel)
 * Modified for the experiment guys. They use tcsh or csh as login shell for
 * the dserver login so, force the remsh to be executed with a sh.
 * 
 * Revision 3.2  93/09/15  10:15:15  10:15:15  taurel (Emmanuel Taurel)
 * The login used in the remote shell is now a resource.
 * 
 * Revision 3.1  93/07/19  15:18:06  15:18:06  taurel (Emmanuel Taurel)
 * Now, the dc_dels command path is a resource.
 * 
 * Revision 3.0  93/05/17  17:31:17  17:31:17  taurel (Emmanuel Taurel)
 * Modified to port the dc system to SUN (without RTDB).
 * 
 * Revision 1.3  93/02/03  11:23:29  11:23:29  taurel (Emmanuel Taurel)
 * Strongly modified to be able to cope with the distributed dc.
 * 
 * Revision 1.2  92/09/30  16:47:59  16:47:59  taurel (Emmanuel Taurel)
 * Some minor changes due to first real tests.
 * 
 * Revision 1.1  92/08/26  16:01:14  16:01:14  taurel (Emmanuel Taurel)
 * Initial revision
 *  */

#include <API.h>
#include <stdio.h>
#include <string.h>
#include <errno.h>
#include <stdlib.h>
#include <unistd.h>
#include <sys/stat.h>

DevVarStringArray host_dc;
char *dc_path;
char *s_dc_path;
char *dc_login;

db_resource res1[] = {
	{"host",D_VAR_STRINGARR,&host_dc},
		     };

int res1_size = sizeof(res1) / sizeof(db_resource);

db_resource res2[] = {
	{"path",D_STRING_TYPE,&dc_path},
	{"s_path",D_STRING_TYPE,&s_dc_path},
     	{"login",D_STRING_TYPE,&dc_login},
		     };

int res2_size = sizeof(res2) / sizeof(db_resource);


/****************************************************************************
*                                                                           *
*		Code for dc_del command                                     *
*                        ------                                             *
*                                                                           *
*    Command rule : To remove the data collector system from memory  	    *
*		    The data collector system could be distributed on       *
*		    several hosts. This command will retrieve on which host *
*		    this system is running (with resources) and will run a  *
*		    local command (with remote shell) on ecah host          *
*                                                                           *
*    Synopsis : dc_del <password> 					    *
*                                                                           *
****************************************************************************/


main(argc,argv)
int argc;
char *argv[];
{
	long error;
	char *tmp,*net;
	unsigned int diff;
	char hostna[32];
	char dev_name[40];
	char psd_name[80];
	char cmd[160];
	int i;
	struct stat fista;

/* Argument test */

	if (argc != 2) {
		fprintf(stderr,"dc_del usage : dc_del <password>\n");
		exit(-1);
			}

/* Import static database */

	if (db_import(&error)) {
		fprintf(stderr,"dc_del : Can't import static database\n");
		fprintf(stderr,"dc_del : Check your NETHOST environment variable\n");
		exit(-1);
				}

/* Retrieve on which host the data collector is running */

	host_dc.length = 0;
	if (db_getresource("CLASS/DC/1",res1,res1_size,&error)) {
		fprintf(stderr,"dc_del : Can't retrieve resources\n");
		fprintf(stderr,"dc_del : Error code : %d\n",error);
		exit(-1);
								  }
	if (host_dc.length == 0) {
		fprintf(stderr,"dc_del : Resource host not defined\n");
		fprintf(stderr,"dc_del : Sorry, but I exit !\n");
		exit(-1);
				 }

/* Get the NETHOST environment variable (No need to test if NETHOST is
   defined because this has been done during the static database import
   stuff */

	net = getenv("NETHOST");

/* Call the dc_dels command on each dc host */

	for (i = 0;i < host_dc.length;i++) {

/* Retrieve from database the primary path for dc tools */

		psd_name[0] = 0;
		strcpy(psd_name,"class/dc/");
		strcat(psd_name,host_dc.sequence[i]);

		dc_path = NULL;
		s_dc_path = NULL;
		dc_login = NULL;

		if(db_getresource(psd_name,res2,res2_size,&error)) {
			fprintf(stderr,"dc_del : Can't retrieve primary dc tools path for %s\n",host_dc.sequence[i]);
			fprintf(stderr,"dc_del : Error code : %d\n",error);
			exit(-1);
								}

		if (dc_path == NULL || s_dc_path == NULL || dc_login == NULL) {
			fprintf(stderr,"dc_del : Path or login for dc_tools on %s not defined\n",host_dc.sequence[i]);
			fprintf(stderr,"dc_del : Sorry, but I exit\n");
			exit(-1);
				     }

/* Build the string which is the remsh command */

#if defined(sun) || defined(linux)
		strcpy(cmd,"rsh ");
#else
		strcpy(cmd,"remsh ");
#endif /* sun */
		strcat(cmd,host_dc.sequence[i]);
		strcat(cmd," -l ");
		strcat(cmd,dc_login);
		strcat(cmd," \"echo \\\"NETHOST=");
		strcat(cmd,net);
		strcat(cmd,";export NETHOST;");
		strcat(cmd,dc_path);
		strcat(cmd,"/");
		strcat(cmd,s_dc_path);
		strcat(cmd,"/dc_dels ");
		strcat(cmd,argv[1]);
		strcat(cmd,"\\\" | sh \" | tee /usr/tmp/dcdelsta");

#ifdef DEBUG
		printf("Command string : %s\n",cmd);
#endif /* DEBUG */

		printf("Executing dc_del on %s \n",host_dc.sequence[i]);
		system(cmd);

/* Any error during local dc_del init ? */

		stat("/usr/tmp/dcdelsta",&fista);
		if (fista.st_size != 0) {
			unlink("/usr/tmp/dcdelsta");
			break;
					}
		else
			unlink("/usr/tmp/dcdelsta");
		
					   }

}
