static char RcsId[] = "@(#)$Header: /segfs/dserver/system/dc/svc/RCS/dc_devall.c,v 3.24 2002/03/12 11:26:55 goetz Rel $";

/* $Log: dc_devall.c,v $
 * Revision 3.24  2002/03/12 11:26:55  goetz
 * solaris now uses sigset() and not sigvec anymore
 *
 * Revision 3.23  1901/02/20 17:47:15  taurel
 * Add some test on the ptr retrieved from shared memory for the read server (dc_read.c file)
 *
 * Revision 3.22  2001/02/19 12:50:14  goetz
 * checkin for taurel
 *
 * Revision 3.21  2000/12/03 07:19:13  goetz
 * ported to Linux
 *
 * Revision 3.20  2000/03/13 15:28:26  taurel
 * Adapted to the new release of gettranscient (DSAIPI release 7.8 and above)
 *
 * Revision 3.19  99/07/05  14:23:28  14:23:28  taurel (E.Taurel)
 * Porte dto new release of gettranscienr_ut. I don't understand how it worked
 * before !!
 * 
 * Revision 3.18  99/06/02  16:06:21  16:06:21  taurel (E.Taurel)
 * Fix bug when transferring time for dc_devget_history
 * 
 * Revision 3.17  99/02/08  15:23:34  15:23:34  taurel (E.Taurel)
 * No change done
 * 
 * Revision 3.16  96/12/06  11:30:11  11:30:11  taurel (E.Taurel)
 * Adapted to new directory structure and incl. files
 * 
 * Revision 3.15  96/11/04  16:50:03  16:50:03  taurel (E.Taurel)
 * Change in the db_register function to fulfill
 * db software release 5 (process name).
 * 
 * Revision 3.14  96/06/14  11:25:41  11:25:41  taurel (E.Taurel)
 * In the still updated test, now manage the case where the update
 * period is 0. This means that no tests are needed.
 * 
 * Revision 3.13  96/02/28  09:13:09  09:13:09  taurel (Emmanuel TAUREL)
 * Ported to Solaris.
 * 
 * Revision 3.12  96/01/05  16:07:03  16:07:03  taurel (Emmanuel TAUREL)
 * Checked out for the two XDR files which have been
 * modified for the library port to Solaris (compatibility mode only).
 * 
 * Revision 3.11  95/12/15  17:26:29  17:26:29  taurel (Emmanuel TAUREL)
 * Check out for debug purpose. No change.
 * 
 * Revision 3.10  95/10/10  14:08:14  14:08:14  taurel (Emmanuel TAUREL)
 * Return date in the dc_devget_history function even if the command failed.
 * 
 * Revision 3.0  93/05/17  17:42:28  17:42:28  taurel (Emmanuel TAUREL)
 * Modified to port the dc system to SUN (without RTDB).
 * 
 * Revision 1.1  93/02/04  10:23:04  10:23:04  taurel (Emmanuel Taurel)
 * Initial revision
 *  */

#include <API.h>
#include <DevErrors.h>

#include <dc_xdr.h>
#include <dcP.h>

#include <stdlib.h>

/* Some global variables */

dc_devallx_back ret_devall;

/* Variables defined in dc_svc.c */

extern hash_info mem;

extern int req_call;



/****************************************************************************
*                                                                           *
*		Server code for dc_devall function                          *
*                               ---------                                   *
*                                                                           *
*    Function rule : To return to the client a list with all the names of   *
*		     devices defined in the local dc 		            *
*                                                                           *
*    Argin : No argin							    *
*                                                                           *
*    Argout : No argout                                                     *
*                                                                           *
****************************************************************************/

dc_devallx_back *dc_devall_1(fill)
int *fill;
{
	char **str_ptr;
	int cptr,i,resu;
	int nb_16 = 1;
	int nb_tot;
	register dc_dev_param *array;

/* Miscellaneous initialization */

	ret_devall.err_code = 0;

#ifdef DEBUG
	printf("Executing dc_devall request\n");
#endif /* DEBUG */

/* Init the number of request to 1 for this call */

	req_call  = 1;

/* Compute the amount of element in the hash table plus the cellar table */

	nb_tot = mem.hash_table_size + mem.cellar_size;
	array = mem.parray;

/* Allocate an array for the first 16 string pointers */

	if ((str_ptr = (char **)calloc(16,sizeof(char *))) == NULL)  {
		ret_devall.err_code = DcErr_ServerMemoryAllocation;
		ret_devall.dev_name.name_arr_len = 0;
		return(&ret_devall);
								}

/* Retrieve in the deviec_info part of the pointers area, all the registered 
   devices */

	cptr = 0;

	for (i = 0;i < nb_tot;i++) {
		if (array[i].device_name[0] == 0)
			continue;

/* Allocate memory for the full device name and build it */

		if ((str_ptr[cptr] = (char *)malloc(60)) == NULL) {
			for (i = 0;i < cptr;i++)
				free(str_ptr[i]);
			free(str_ptr);
			ret_devall.err_code = DcErr_ServerMemoryAllocation;
			ret_devall.dev_name.name_arr_len = 0;
			return(&ret_devall);
								}

		strcpy(str_ptr[cptr],array[i].device_name);
		cptr++;

/* Reallocate memory for the array of pointers if it is full */

		if ((cptr & 0xF) == 0) {
			nb_16++;
			if ((str_ptr = (char **)realloc(str_ptr,(nb_16 << 4) * sizeof(char *))) == NULL) {
				for (i = 0;i < cptr;i++)
					free(str_ptr[i]);
				free(str_ptr);
				ret_devall.err_code = DcErr_ServerMemoryAllocation;
				ret_devall.dev_name.name_arr_len = 0;
				return(&ret_devall);
								}
				}
				}

/* Initialise sent back parameters */

	ret_devall.dev_name.name_arr_len = cptr;
	ret_devall.dev_name.name_arr_val = str_ptr;

/* Leave server */

	return(&ret_devall);

}
