/*+*******************************************************************

 File:          SysNumbers.h

 Project:       Device Servers with SUN-RPC

 Description:   Include file with the definitions for all 
		software of the system group 

 Author(s):     Emmanuel Taurel

 Original:      January 1994


 $Revision: 4.30 $
 $Date: 98/08/19 09:17:39 $

 $Author: taurel $

 $Log:	SysNumbers.h,v $
 * Revision 4.30  98/08/19  09:17:39  09:17:39  taurel (E.Taurel)
 * Added base number for starter device server.
 * 
 * Revision 4.29  96/12/05  16:50:50  16:50:50  goetz (Andy Goetz)
 * added DevBenchBase for the new Bench class being written by Steve Hunt
 * 
 * Revision 4.28  96/05/14  08:40:24  08:40:24  meyer (J.Meyer)
 * Added brackets around base definition.
 * 
 * Revision 4.27  96/05/13  13:23:23  13:23:23  meyer (J.Meyer)
 * Corrected LSHIFT to DS_LSHIFT.
 * 
 * Revision 4.26  96/05/06  18:40:21  18:40:21  meyer (J.Meyer)
 * Fortran compatible include file.
 * 
 * Revision 4.25  95/10/03  09:40:31  09:40:31  taurel (E.Taurel)
 * Added HDB filler and HDB library base numbers.
 * 
 * Revision 4.24  95/02/15  18:58:03  18:58:03  dserver (dserver)
 * checked windows version: compiles wthout errors.
 * 
 * Revision 4.7  94/07/20  17:08:23  17:08:23  meyer (Jens Meyer)
 * Version with MSDOS include files.
 * The same version number as API-lib.
 * 
 * Revision 1.5  94/04/20  16:21:50  16:21:50  servant (Florence Servant)
 * NewDevBase adding for new StructDaemon structure for daemon_xdr.h
 * 
 * Revision 1.3  94/02/24  14:21:27  14:21:27  taurel (Emmanuel TAUREL)
 * Fixed a bad spelling in the definition of the clock base.
 * 
 * Revision 1.2  94/02/24  13:35:40  13:35:40  taurel (Emmanuel TAUREL)
 * Added a base for the master clock device server.
 * 
 * Revision 1.1  94/01/31  11:40:29  11:40:29  taurel (Emmanuel TAUREL)
 * Initial revision
 * 

 Copyright (c) 1990 by European Synchrotron Radiation Facility,
		       Grenoble, France

********************************************************************-*/
#include <DserverTeams.h>

#ifndef _SysNumbers_h
#define _SysNumbers_h


/*------- Device server identification ---------*/

#define	DcBase		(SysTeamNumber + DS_LSHIFT(1, DS_IDENT_SHIFT))
#define DevMClockBase	(SysTeamNumber + DS_LSHIFT(2, DS_IDENT_SHIFT))

/*------- Daemon Device server (for new resources) -------*/

#define NewDevBase      (SysTeamNumber + DS_LSHIFT(3, DS_IDENT_SHIFT))

/*------- HDB Filler Device Server ----------------------*/

#define HdbFillerBase	(SysTeamNumber + DS_LSHIFT(4, DS_IDENT_SHIFT))

/*------- HDB Library base number ----------------------*/

#define HdbLibBase	(SysTeamNumber + DS_LSHIFT(5, DS_IDENT_SHIFT))

/*------- Bench base number ----------------------------*/

#define DevBenchBase	(SysTeamNumber + DS_LSHIFT(6, DS_IDENT_SHIFT))

/*------- Starter base number ----------------------------*/

#define DevStarterBase	(SysTeamNumber + DS_LSHIFT(7, DS_IDENT_SHIFT))

/*------- Data collector warning codes ---------*/

#define DcWarnBase      (DcBase + DS_LSHIFT(WarningError, DS_CAT_SHIFT))


/*------- Data collector error codes -----------*/
#define	DcErrorBase	(DcBase)


#endif	/* _SysDsNumbers_h */
