static char RcsId[]         = 
"@(#)$Header: ds_prog_vers3.c,v 8.40 2002/03/18 10:10:54 goetz Rel $";

/*+*******************************************************************

 File       :  	ds_prog_vers3.c

 Project    : 	Device Servers with sun-rpc

 Description:   RPC entry points for the RPC version 1
		which was used up to library version 3.

 Author(s)  :	Jens Meyer

 Original   :	November 1994


 $Revision: 8.40 $
 $Date: 2002/03/18 10:10:54 $
 $Author: goetz $

 $Log:	ds_prog_vers3.c,v $
 * Revision 8.40  2002/03/18  10:10:54  10:10:54  goetz (Andy Goetz)
 * removed ^M from files which were confusing Ultra C++ compiler
 * 
 * Revision 8.39  2002/03/18  05:48:51  05:48:51  goetz (Andy Goetz)
 * added tango_dev_free() and dev_error_clear(); error message in command_handler
 * 
 Revision 8.38  2002/03/13 07:29:25  goetz
 fixed bug initializing struct _devserver to zero; rpc_protocol=D_UDP

 Revision 8.37  2002/03/11 14:20:20  goetz
 initalise prog_number and config_flags to zero at startup

 Revision 8.36  2002/03/07 15:58:45  goetz
 fixed leak in extract_device_name

 Revision 8.35  2002/03/06 22:08:43  goetz
 made stateless import and reimport work for no database devices

 Revision 8.34  2002/03/06 21:00:08  goetz
 added -nodb option to device_server(); suppressed -m -s; improved dev_cmd_query

 Revision 8.33  2002/03/05 11:52:48  goetz
 added command name to C++ commands_list, asynchronous and events support -nodb

 Revision 8.32  2002/03/03 22:45:02  goetz
 added TACO-lite option i.e. no database

 Revision 8.31  2002/02/28 12:13:06  goetz
 setup_config() and setup_config_multi() now call rpc_nt_init() for Windows

 Revision 8.30  2001/11/12 09:59:59  goetz
 updated C port for Windows 95/98/NT using Visual C++ 6

 Revision 8.29  2001/07/26 05:05:09  goetz
 fixed error in CORBA::is_nil() test

 Revision 8.28  2001/07/25 13:13:15  goetz
 tango cmd_query in_name and out_name left NULL; desc replaces reason for errors

 Revision 8.27  2001/07/25 13:05:39  goetz
 added space to dev_error_str() string; test CORBA::is_nil() for tango database

 Revision 8.26  2001/04/10 14:24:34  goetz
 set timeout on tango devices to 3 seconds

 Revision 8.25  2001/03/20 11:56:39  goetz
 DevCmdNameList searched before database for commands in tango_api.cpp

 Revision 8.24  2001/03/10 16:38:20  goetz
 ported tango_api to TANGO 2

 Revision 8.23  2001/02/28 12:26:48  goetz
 converted TANGO states to TACO states

 Revision 8.22  2001/01/16 10:09:45  goetz
 applied J.Quick's patch for security; removed stderr from DevServerMain.c

 * Revision 8.21  2001/01/15  11:36:40  11:36:40  goetz (Andy Goetz)
 * added check for ds == NULL in all dev_ api routines; changed ds__signal prototype
 * 
 Revision 8.20  2001/01/08 13:14:50  goetz
 added patch by B.Pedersen to support querying events

 Revision 8.19  2000/12/11 12:06:44  goetz
 fixed bugs with TANGO interface returning unsigned values and states

 Revision 8.18  2000/11/12 13:24:03  goetz
 added dynamic error handling; improved TANGO error treatment

 Revision 8.17  1900/09/26 13:36:34  goetz
 tango_dev_putget() and tango_dev_putget_raw() implement immediate reconnection

 * Revision 8.16  2000/09/25  14:50:16  14:50:16  goetz (Andy Goetz)
 * tango_api implements TANGO_HOST, stateless import and reimport
 * 
 * Revision 8.15  20/0./7.  1.:6.:9.  1.:6.:9.  goetz (Andy Goetz)
 * changed from tango database to host mysql, added support for float and double arrays
 * 
 * Revision 8.14  20/0./6.  2.:4.:0.  2.:4.:0.  goetz (Andy Goetz)
 * fixed bug in dev_event_listen() which caused server to crash
 * 
 Revision 8.13  2000/06/02 21:56:49  goetz
 _DEVICE_H now _TANGO_DEVICE_H in Device.H; (char*)taco_tango

 Revision 8.12  2000/06/02 15:58:07  goetz
 dev_event_fire() now device specific; ported to SuSE V6.4

 Revision 8.11  2000/05/31 07:47:54  goetz
 tango_api has local copies of argc and argv, ported to HP-UX

 * Revision 8.10  2000/05/29  21:39:20  21:39:20  goetz (Andrew GOETZ)
 * fixed prototyping problems with C++ on HP-UX
 * 
 * Revision 8.9  2000/05/29  18:13:30  18:13:30  goetz (Andrew GOETZ)
 * fixed bug in dev_import_timeout() which prevented timeouts < 2s
 * 
 Revision 8.8  2000/05/02 15:32:14  goetz
 added prototype for tsleep() for OS9 C++

 * Revision 8.7  2000/05/02  14:19:36  14:19:36  goetz (Andy Goetz)
 * removed check for device server running on different host
 * 
 * Revision 8.6  2000/05/02  13:29:29  13:29:29  goetz (Andy Goetz)
 * added random sleep to gettransient + 3 retries
 * 
 Revision 8.5  2000/03/27 17:13:45  goetz
 declared pmap_getmaps() as external C function for OS9 C++

 Revision 8.4  2000/03/13 14:50:02  goetz
 import timeout now programmable using dev_import_timeout()

 Revision 8.3  2000/03/13 10:31:35  goetz
 added Jens' modifications to fix bug in local putget

 Revision 8.2  2000/03/10 17:01:23  goetz
 dev_synch() now excludes udp clients and new imports

 Revision 8.1  2000/01/18 16:48:48  goetz
 tango_dev_import() now only called in dev_import if -DTANGO

 Revision 8.0  1999/12/28 14:18:31  goetz
 added TANGO support for TACO dev_xxx() calls via -DTANGO for C++

 Revision 7.10  1999/11/25 08:27:13  goetz
 replaced fprintf(stderr) with printf; made startup() C++ compatible

 Revision 7.9  1999/11/22 20:18:59  goetz
 removed const from gettransient() prototype

 Revision 7.8  1999/11/21 20:45:37  goetz
 included all M.Diehl's patches (major changes to gettransient() + main())

 Revision 7.7  1999/11/18 22:29:00  goetz
 fixed event multi-client bug, free client handle after event_listen, timeout in dev_synch()

 Revision 7.6  1999/11/01 19:05:16  goetz
 make local copy of user name returned by getpwuid() in sec_api.c

 Revision 7.5  1999/08/06 17:44:12  goetz
 removed usage of varargs for g++ on solaris and hpux

 * Revision 7.4  99/07/09  05:15:27  05:15:27  goetz (Andy Goetz)
 * added M.Diehl's patch to DevServerSig.c to exit() after calling unregister_server()
 * 
 Revision 7.3  1999/06/07 15:27:00  goetz
 fixed bug with multi-nethost reimport, device name stored with nethost

 Revision 7.2  1999/05/12 15:22:01  goetz
 changed dev_event_fire() to void; fixed bug in dev_event_unlisten()

 * Revision 7.1  99/05/11  15:59:49  15:59:49  goetz (Andy Goetz)
 * replace static declaration of event_client[] array by malloc()
 * 
 Revision 7.0  1999/04/26 07:30:42  goetz
 implemented user events (added event_api.c)

 Revision 6.15  1999/03/27 09:00:20  goetz
 asynch_cleanup() only checks for asynch clients; C++ returns output arguments if DS_WARNING

 * Revision 6.14  99/02/27  15:21:20  15:21:20  goetz (Andy Goetz)
 * fixed reimport bug; disabled reimport for rpc version 1
 * 
 Revision 6.13  1999/02/05 00:50:27  goetz
 fixed reimport socket+memory leak; ported to aCC on HPUX; suppressed rpc errors

 * Revision 6.12  99/01/18  21:39:03  21:39:03  goetz (Andy Goetz)
 * suppressed test for RPC_TIMEDOUT in svc_check()
 * 
 * Revision 6.11  99/01/14  23:14:53  23:14:53  goetz (Andy Goetz)
 * dbase timeout = 4 s; unregister ver. 1; svc_check() handles RPC_TIMEDOUT
 * 
 * Revision 6.10  98/12/22  10:29:46  10:29:46  taurel (E.Taurel)
 * Added support for Solaris and HP C++ native compiler. Remove K_R C support
 * 
 * Revision 6.9  98/12/15  14:05:05  14:05:05  goetz (Andy Goetz)
 * unregister RPC; use pgm no. 1 as flag; dev_pending() checks timeout; extern C prototype
 * 
 * Revision 6.8  98/11/20  14:35:36  14:35:36  goetz (Andy Goetz)
 * unregister API_VERSION (4) correctly now + check return value of svc_register()
 * 
 * Revision 6.7  98/11/20  10:35:01  10:35:01  goetz (Andy Goetz)
 * improved gettrans_ut(); multi-config_flags=0; removde static client_data; fixed linux select() bug; only register pgm # 0,4,5; portmap address == 111
 * 
 * Revision 6.6  98/09/24  09:25:10  09:25:10  goetz (Andy Goetz)
 * fixed stupid type which reintroduced asynchronous memory leak
 * 
 * Revision 6.5  98/08/26  16:20:34  16:20:34  goetz (Andy Goetz)
 * added dynamic NETHOST allocation, fixed bug in db_setup_multi, ported to Irix 6.4
 * 
 * Revision 6.4  98/04/29  10:21:23  10:21:23  goetz (Andy Goetz)
 * asynchronous - memory leak fixed, OS9 bug fixed, stale handle cleanup, pending=300
 * 
 * Revision 6.3  97/12/10  15:28:34  15:28:34  meyer (J.Meyer)
 * Changed select() timeout in rpc_check_host() to 200ms
 * 
 * Revision 6.2  97/12/01  12:59:16  12:59:16  goetz (Andy Goetz)
 * intermediate checkin before opening 5.14.1 branch
 * 
 * Revision 6.1  97/11/20  21:49:25  21:49:25  goetz (Andy Goetz)
 * main() continue even if cannot register asynch rpc
 * 
 * Revision 6.0  97/11/03  17:22:27  17:22:27  goetz (Andy Goetz)
 * merged synchronous and asynchronous branches
 * 
 Revision 5.15  1997/10/24 15:27:02  klotz
 ported to Windows NT 4.0 + NMSDK 5.0 ; tested with TextTalkds ; new DevServerMain.c

 * Revision 5.14  97/09/25  17:36:41  17:36:41  goetz (Andy Goetz)
 * fixed
 * 
 Revision 5.13  1997/09/03 17:34:34  meyer
 Added casting for ucc++ in DevServerSig.c

 * Revision 5.12  97/09/03  15:54:10  15:54:10  meyer (J.Meyer)
 * Changed OS9 signal handling from intercept() to signal().
 * 
 * Revision 5.11  97/08/05  14:19:26  14:19:26  goetz (Andy Goetz)
 * ported to VxWork 5.2, pgm. no. based on CRC, -m suppressed, -ve errors bug fix
 * 
 * Revision 5.10  97/03/14  17:26:10  17:26:10  dserver ()
 * fixed bug with open file handles after free
 * 
 * Revision 5.8.1.4  97/03/14  17:24:48  17:24:48  goetz (Andy Goetz)
 * fixed bug with open file handles after free
 * 
 * Revision 5.9  97/03/13  11:17:13  11:17:13  klotz (W.D. Klotz)
 * first part of NT4.0 port
 * 
 * Revision 5.8  97/01/31  12:06:21  12:06:21  goetz (Andy Goetz)
 * dev_protocol(), Linux+security bug fixes, dev_import() ignores timeout on NULL procedure, svc_run for OS9
 * 
 * Revision 5.7  97/01/14  08:57:18  08:57:18  goetz (Andy Goetz)
 * added stateless to dev_free(),_raw(),_asyn(),_protocol(),_timeout()
 * 
 * Revision 5.6  97/01/12  18:33:38  18:33:38  goetz (Andy Goetz)
 * dev_import() now stateless i.e. import works even if server is not running
 * 
 * Revision 5.5  97/01/08  17:02:27  17:02:27  goetz (Andy Goetz)
 * Ported to Linux (2.0.9)
 * 
 * Revision 5.4  96/11/27  09:58:13  09:58:13  goetz (Andy Goetz)
 * removed rpc admin interface from DevServerMain.c; putenv() suppressed for _UCC
 * 
 * Revision 5.3  96/11/26  16:24:39  16:24:39  goetz (Andy Goetz)
 * fixed bug (i_nethost=0) in dev_import_local()
 * 
 * Revision 5.2  96/11/26  13:31:02  13:31:02  goetz (Andy Goetz)
 * OICDevice (C++ wrapper for OIC) added + fixed multi-nethost memory leaks
 * 
 * Revision 5.1  96/11/04  11:00:07  11:00:07  goetz (Andy Goetz)
 * added multi nethost support
 * 
 * Revision 4.39  96/10/21  16:15:08  16:15:08  taurel (E.Taurel)
 * Check in after port to MICROWARE ISP 2.1,
 * RPC 1.4
 * 
 * Revision 4.38  96/09/17  17:15:31  17:15:31  klotz (W.D. Klotz)
 * WD Klotz: checked NT build
 * 
 * Revision 4.37  96/07/08  16:21:58  16:21:58  taurel (E.Taurel)
 * Ported_to_OS-9_Ultra_C++
 * 
 * Revision 4.36  96/06/03  18:13:38  18:13:38  meyer (J.Meyer)
 * Changed_dev_export()_and_db_import()_for_database_version_3
 * 
 * Revision 4.35  96/06/03  13:09:26  13:09:26  meyer (J.Meyer)
 * Cleaned-up_MSDOS_and_added_porting_options_for_Windows_NT.
 * 
 * Revision 4.34  96/01/30  11:34:57  11:34:57  meyer (J.Meyer)
 * Corrected
 * 
 * Revision 4.33  96/01/11  15:54:38  15:54:38  meyer (Jens Meyer)
 * Ported
 * 
 * Revision 4.32  95/10/03  09:46:57  09:46:57  taurel (Emmanuel TAUREL)
 * Added include file for HDB library.
 * 
 * Revision 4.31  95/08/02  16:12:45  16:12:45  meyer (Jens Meyer)
 * Corrected casting in svc_api.c and double define of ds__destroy() in oic.c after C++ implementation.
 * 
 * Revision 4.30  95/08/01  15:45:37  15:45:37  meyer (Jens Meyer)
 * Bringing all files to the same verion number!
 * 
 * Revision 4.27  95/03/03  13:25:15  13:25:15  meyer (Jens Meyer)
 * Corrected warnings found by the PC compiler.
 * 
 * Revision 4.26  95/03/01  12:38:42  12:38:42  meyer (Jens Meyer)
 * Corrected creation of security key and cleand up function headers.
 * 
 * Revision 4.25  95/02/20  09:53:39  09:53:39  meyer (Jens Meyer)
 * Passed the compilers for HPUX, SUNOS and UCC after the first windows check in.
 * 
 * Revision 4.24  95/02/02  14:12:51  14:12:51  klotz (W.D. Klotz)
 * checked windows vversion: compiles wthout errors
 * 
 * Revision 4.23  95/02/02  13:43:38  13:43:38  klotz (W.D. Klotz)
 * Corrected check in of version 4.22.
 * 
 * Revision 4.22  95/02/01  15:41:03  15:41:03  klotz (W.D. Klotz)
 * test
 * 
 * Revision 4.21  95/01/16  15:33:31  15:33:31  goetz (Andy Goetz)
 * Added bug corrections from version 4.16 (4.16.1.x).
 * 
 * Revision 4.20  95/01/16  14:10:42  14:10:42  goetz (Andy Goetz)
 * first LynxOS release
 * 
 * Revision 4.16  94/12/17  07:58:03  07:58:03  meyer (Jens Meyer)
 * DevServerMain - get transient program number for version 1 !
 * 
 * Revision 4.15  94/12/08  15:31:35  15:31:35  meyer (Jens Meyer)
 * Modified setup_config() for new Manager version.
 * 
 * Revision 4.14  94/12/06  08:24:08  08:24:08  meyer (Jens Meyer)
 * OS9 version 3.0 port which passed all other compilers!
 * 
 * Revision 4.13  94/11/29  16:39:24  16:39:24  meyer (Jens Meyer)
 * Corrected bug in local dev_putget call.
 * 
 * Revision 4.12  94/11/28  19:23:52  19:23:52  meyer (Jens Meyer)
 * Compatibility with old version 3 libraries.
 * 
 * Revision 4.10  94/11/28  15:50:27  15:50:27  meyer (Jens Meyer)
 * Compatible with version 3 servers.
 * 

 Copyright (c) 1990 by  European Synchrotron Radiation Facility,
			Grenoble, France

*******************************************************************-*/

#include <API.h>
#include <ApiP.h>
#include <DevServer.h>
#include <DevServerP.h>
#include <API_xdr_vers3.h>

/****************************************
 *          Globals                     *
 ****************************************/

/*
 *  Types for global state flags for the current
 *  server or client status and for Database Server
 *  information are defined in API.h
 */

/*
 *  Configuration flags
 */

extern configuration_flags      config_flags;


/*
 * Minimal access for clients of version 3.
 * Defined in DevServerMain.c and initialised with the
 * minimal access right given in the security database.
 */

extern long minimal_access;

void _WINAPI devserver_prog_1	PT_( (struct svc_req *rqstp,SVCXPRT *transp) );

/*+**********************************************************************
 Function   :   static void devserver_prog_1()

 Description:   Entry point for received RPCs of version 1.
	    :   Switches to the wished remote procedure.

 Arg(s) In  :   struct svc_rep *rqstp - RPC request handle
	    :   SVCXPRT *transp       - Service transport handle

 Arg(s) Out :   none

 Return(s)  :   none
***********************************************************************-*/

void _WINAPI devserver_prog_1 (struct svc_req *rqstp, SVCXPRT *transp) 
{
	union {
		_dev_import_in	rpc_dev_import_4_arg;
		_dev_free_in 	rpc_dev_free_4_arg;
		_server_data 	rpc_dev_putget_4_arg;
                _dev_query_in   rpc_dev_query_cmd_4_arg;
	} argument;

	char	*help_ptr;
	char *result;
	xdrproc_t xdr_argument,xdr_result;
#ifdef  __cplusplus
	DevRpcLocalFunc local;
#else
	char *(*local)();
#endif

	/*
	 *  call the right server routine
	 */

	switch (rqstp->rq_proc) {
	case NULLPROC:
#ifdef _UCC
		svc_sendreply(transp, (xdrproc_t)xdr_void, (caddr_t)NULL);
#else
		svc_sendreply(transp, (xdrproc_t)xdr_void, NULL);
#endif /* _UCC */
		return;

	case RPC_CHECK:
		help_ptr = &(config_flags.server_name[0]);
		svc_sendreply (transp, (xdrproc_t)xdr_wrapstring, 
			       (caddr_t) &help_ptr);
		return;

	case RPC_DEV_IMPORT:
		xdr_argument = (xdrproc_t)xdr__dev_import_in_3;
		xdr_result = (xdrproc_t)xdr__dev_import_out_3;
#ifdef __cplusplus
		local = (DevRpcLocalFunc) rpc_dev_import_4;
#else
		local = (char *(*)()) rpc_dev_import_4;
#endif
		break;

	case RPC_DEV_FREE:
		xdr_argument = (xdrproc_t)xdr__dev_free_in_3;
		xdr_result = (xdrproc_t)xdr__dev_free_out_3;
#ifdef __cplusplus
		local = (DevRpcLocalFunc) rpc_dev_free_4;
#else
		local = (char *(*)()) rpc_dev_free_4;
#endif
		break;

	case RPC_DEV_PUTGET:
		xdr_argument = (xdrproc_t)xdr__server_data_3;
		xdr_result = (xdrproc_t)xdr__client_data_3;
#ifdef __cplusplus
		local = (DevRpcLocalFunc) rpc_dev_putget_4;
#else
		local = (char *(*)()) rpc_dev_putget_4;
#endif
		break;

	case RPC_DEV_PUT:
		xdr_argument = (xdrproc_t)xdr__server_data_3;
		xdr_result = (xdrproc_t)xdr__client_data_3;
#ifdef __cplusplus
		local = (DevRpcLocalFunc) rpc_dev_put_4;
#else
		local = (char *(*)()) rpc_dev_put_4;
#endif
		break;

        case RPC_DEV_CMD_QUERY:
		xdr_argument = (xdrproc_t)xdr__dev_query_in_3;
		xdr_result = (xdrproc_t)xdr__dev_query_out_3;
#ifdef __cplusplus
		local = (DevRpcLocalFunc) rpc_dev_cmd_query_4;
#else
		local = (char *(*)()) rpc_dev_cmd_query_4;
#endif
		break;

	case RPC_DEV_PUTGET_RAW:
		xdr_argument = (xdrproc_t)xdr__server_data_3;
		xdr_result = (xdrproc_t)xdr__client_raw_data_3;
#ifdef __cplusplus
		local = (DevRpcLocalFunc) rpc_dev_putget_raw_4;
#else
		local = (char *(*)()) rpc_dev_putget_raw_4;
#endif
		break;

	case RPC_DEV_PUT_ASYN:
		/*
		 * Read incoming arguments and send
                 * the reply immediately without waiting
		 * the execution of the function.
		 */
		xdr_argument = (xdrproc_t)xdr__server_data_3;
		xdr_result = (xdrproc_t)xdr__client_data_3;
	        /*
	         * Function only for the adminstration and security part
		 * of the asynchronous call.
		 */
#ifdef __cplusplus
		local = (DevRpcLocalFunc) rpc_dev_put_asyn_4;
#else
		local = (char *(*)()) rpc_dev_put_asyn_4;
#endif
	        break;

	default:
		svcerr_noproc(transp);
		return;
	}


	memset(&argument, 0, sizeof(argument));

	if (!svc_getargs(transp, xdr_argument, (caddr_t) &argument)) 
	{
		dev_printerror (SEND,"%s",
		"svcerr_decode : server couldn't decode incoming arguments");
		svcerr_decode(transp);
		return;
	}

	/*
	 * Now switch again on the requested procedure and
	 * set default values into the not initialised fields.
	 * Version 4 has some more fields initialised.
	 */

	switch (rqstp->rq_proc) 
	   {
	   case RPC_DEV_IMPORT:
	 	argument.rpc_dev_import_4_arg.access_right  = minimal_access;
	 	argument.rpc_dev_import_4_arg.client_id     = 0;
	 	argument.rpc_dev_import_4_arg.connection_id = 0;

	 	argument.rpc_dev_import_4_arg.var_argument.length   = 0;
	 	argument.rpc_dev_import_4_arg.var_argument.sequence = 0;
		break;

	   case RPC_DEV_FREE:
	 	argument.rpc_dev_free_4_arg.access_right = minimal_access;
	 	argument.rpc_dev_free_4_arg.client_id    = 0;

	 	argument.rpc_dev_free_4_arg.var_argument.length   = 0;
	 	argument.rpc_dev_free_4_arg.var_argument.sequence = 0;
		break;

	   case RPC_DEV_PUTGET:
	   case RPC_DEV_PUT:
	   case RPC_DEV_PUTGET_RAW:
	   case RPC_DEV_PUT_ASYN:
	 	argument.rpc_dev_putget_4_arg.access_right = minimal_access;
	 	argument.rpc_dev_putget_4_arg.client_id    = 0;

	 	argument.rpc_dev_putget_4_arg.var_argument.length   = 0;
	 	argument.rpc_dev_putget_4_arg.var_argument.sequence = 0;
		break;

           case RPC_DEV_CMD_QUERY:
	 	argument.rpc_dev_query_cmd_4_arg.var_argument.length   = 0;
	 	argument.rpc_dev_query_cmd_4_arg.var_argument.sequence = 0;
		break;
	   }


	result = (*local)(&argument, rqstp);
	if (result != NULL && !svc_sendreply(transp, (xdrproc_t)xdr_result, (caddr_t)result)) 
	{
		dev_printerror (SEND,"%s",
		"svcerr_systemerr : server couldn't send repply arguments");
		svcerr_systemerr(transp);
	}


	/*
	 * If an asynchronous call was requested, execute now the
	 * command. After the answer was already send back to 
	 * the client.
	 */

	if ( rqstp->rq_proc == RPC_DEV_PUT_ASYN )
	   {
	   rpc_dev_put_asyn_cmd ((_server_data *)&argument);
	   }


	if (!svc_freeargs(transp, xdr_argument, (caddr_t) &argument)) 
	{
		dev_printerror (SEND,"%s",
		"svc_freeargs : server couldn't free arguments !!");
		return;
	}
}
