static char RcsId[] = "$Header: db_devdel.cpp,v 6.0 98/08/14 10:58:27 taurel Rel $";

/* $Log:	db_devdel.cpp,v $
Revision 6.0  98/08/14  10:58:27  10:58:27  taurel (E.Taurel)
New utilities release which are server oriented
 */

/* TACO include file */

#include <API.h>

/* Include files */

#include <string.h>
#include <unistd.h>

#include <iostream.h>
#include <string>


/****************************************************************************
*                                                                           *
*		Code for db_devdel command                                  *
*                        ---------                                          *
*                                                                           *
*    Command rule : To delete a device and its resources from the database. *
*                   The -r option is used if the user does not want device  *
*		    resources to be also deleted			    *
*                                                                           *
*    Synopsis : db_devdel [-r] <device name>               		    *
*                                                                           *
****************************************************************************/


int main(int argc,char *argv[])
{
	long i;
	long error,res;
	db_error err;
	long del_res = True;
	long opt = False;
	long errflag = False;
	extern int optopt;
	int c;
	char *tmp;

//
// Argument test and device name structure
//

	if ((argc < 2) || (argc > 3))
	{
		cerr << "db_devdel usage : db_devdel [-r] <device name>" << endl;
		exit(-1);
	}

	while ((c = getopt(argc,argv,"r")) != -1)
	{
		switch (c)
		{
		case 'r':
			del_res = False;
			opt = True;
			break;
			
		case '?':
			errflag = True;
			break;
		}
	}
	if (errflag == True)
	{
		cerr << "db_devdel usage : db_devdel [-r] <device name>" << endl;
		exit(-1);
	}

	string dev_name;
	if (opt == True)			
		dev_name = argv[2];
	else
		dev_name = argv[1];

#ifdef DEBUG
	cout  << "Device name : " << dev_name << endl;
#endif /* DEBUG */

	i = 0;
	NB_CHAR(i,dev_name.c_str(),'/');
	if (i != 2)
	{
		cerr << "db_devres : Bad device name" << endl;
		exit(-1);
	}

//
// Connect to database server
//

	if (db_import(&error) == -1)
	{
		cerr << "db_devinfo : Impossible to connect to database server" << endl;
		exit(-1);
	}

//
// Ask database server to remove device
//

	res = db_devicedelete(dev_name.c_str(),&error);	

//
// Display error message if the call fails
//

	if (res == -1)
	{
		if (error == DbErr_DeviceNotDefined)
		{
			cerr << "Device " << dev_name << " is not defined in the database" << endl;
		}
		else
		{
			cerr << "The call to database server failed with error " << error << endl;
			cerr << "Error message : " << dev_error_str(error) << endl;
		}
		exit(-1);
	}

//
// Delete device resources if it is wanted
//

	if (del_res == True)
	{
		tmp = (char *)dev_name.c_str();
		res = db_devicedeleteres(1,&tmp,&err);
		
		if (res == -1)
		{
			cerr << "The call to database server to delete device resources failed with error " << err.error_code << endl;
			cerr << "Error message : " << dev_error_str(err.error_code) << endl;
		}
	}

}


