#include <greta.h>
#include <Xm/Text.h>


/****************************************************************************
*									    *
*		xsDeviceWindowCreateManaged :				    *
*		---------------------------				    *
*									    *
****************************************************************************/

void xsDeviceWindowCreate(Widget rootparent, Widget mainWindow, 
		          int index, char *dev_name)
{
/* the parent parameter of CreateMainWindow, called by the main module with the
value topLevelShell is used, don't know why, so just pass it */
/* the parent of the device window is in fact mainWindow, also passed */

    Arg      args[20];
    Cardinal ac=0;
    Boolean  argok=False;

    Widget   devDialogShell;
    Widget   devForm;
    Widget   devDeletePB;
    Widget   devUpdatePB;
    Widget   devCancelPB;
    Widget   devRestartPB;
    Widget   devPingPB;
    Widget   devMenuBar;
    Widget   fileCascadeButton1;
    Widget   filePulldownMenu1;
    Widget   devPrintPB;
    Widget   devDismissPB;
    Widget   devSavePB;
    Widget   devSaveAsPB;
    Widget   editCascadeButton1;
    Widget   editPulldownMenu1;
    Widget   devUndoPB;
    Widget   devCutPB;
    Widget   devCopyPB;
    Widget   devPastePB;
    Widget   devTextDeletePB;
    Widget   devChainResPB;
    Widget   separator;
    Widget   devicePanedWindow;
    Widget   devInfoForm;
    Widget   devInfoSW;
    Widget   devInfoText;
    Widget   devInfoLb;
    Widget   devResForm;
    Widget   devResSW;
    Widget   devResText;
    Widget   devResLb;
    
    char s[256]; /* to formate little strings */

/* Insertion of the code generated by BX in _creation.c
   in case of static windows, without callback attachments */
   
    ac = 0;
    XtSetArg(args[ac], XmNmwmFunctions, 33); ac++;
    XtSetArg(args[ac], XmNwidth, 605); ac++;
    XtSetArg(args[ac], XmNheight, 725); ac++;
    devDialogShell = XtCreatePopupShell("devDialogShell",
        xmDialogShellWidgetClass,
        mainWindow,
        args, 
        ac);
    
    ac = 0;
    XtSetArg(args[ac], XmNautoUnmanage, False); ac++;
    devForm = XmCreateForm(devDialogShell,
        "devForm",
        args, 
        ac);
    
    ac = 0;
    XtSetArg(args[ac], XmNsensitive, True); ac++;
    XtSetArg(args[ac], XmNx, 502); ac++;
    XtSetArg(args[ac], XmNy, 686); ac++;
    XtSetArg(args[ac], XmNwidth, 72); ac++;
    XtSetArg(args[ac], XmNheight, 36); ac++;
    devRestartPB = XmCreatePushButton(devForm,
        "devRestartPB",
        args, 
        ac);
    XtManageChild(devRestartPB);
    
    ac = 0;
    XtSetArg(args[ac], XmNx, 387); ac++;
    XtSetArg(args[ac], XmNy, 686); ac++;
    XtSetArg(args[ac], XmNwidth, 72); ac++;
    XtSetArg(args[ac], XmNheight, 36); ac++;
    devPingPB = XmCreatePushButton(devForm,
        "devPingPB",
        args, 
        ac);
    XtManageChild(devPingPB);
    
    ac = 0;
    XtSetArg(args[ac], XmNx, 266); ac++;
    XtSetArg(args[ac], XmNy, 686); ac++;
    XtSetArg(args[ac], XmNwidth, 72); ac++;
    XtSetArg(args[ac], XmNheight, 36); ac++;
    devDeletePB = XmCreatePushButton(devForm,
        "devDeletePB",
        args, 
        ac);
    XtManageChild(devDeletePB);
    
    ac = 0;
    XtSetArg(args[ac], XmNx, 30); ac++;
    XtSetArg(args[ac], XmNy, 686); ac++;
    XtSetArg(args[ac], XmNwidth, 72); ac++;
    XtSetArg(args[ac], XmNheight, 36); ac++;
    devUpdatePB = XmCreatePushButton(devForm,
        "devUpdatePB",
        args, 
        ac);
    XtManageChild(devUpdatePB);
    ccb_make_parent_def_button(devUpdatePB, (XtPointer)0, (XtPointer)0);
    
    ac = 0;
    XtSetArg(args[ac], XmNx, 151); ac++;
    XtSetArg(args[ac], XmNy, 686); ac++;
    XtSetArg(args[ac], XmNwidth, 72); ac++;
    XtSetArg(args[ac], XmNheight, 36); ac++;
    devCancelPB = XmCreatePushButton(devForm,
        "devCancelPB",
        args, 
        ac);
    XtManageChild(devCancelPB);
    
    ac = 0;
    XtSetArg(args[ac], XmNx, 0); ac++;
    XtSetArg(args[ac], XmNy, 0); ac++;
    XtSetArg(args[ac], XmNwidth, 605); ac++;
    XtSetArg(args[ac], XmNheight, 32); ac++;
    devMenuBar = XmCreateMenuBar(devForm,
        "devMenuBar",
        args, 
        ac);
    XtManageChild(devMenuBar);
    
    ac = 0;
    XtSetArg(args[ac], XmNx, 5); ac++;
    XtSetArg(args[ac], XmNy, 5); ac++;
    XtSetArg(args[ac], XmNwidth, 39); ac++;
    XtSetArg(args[ac], XmNheight, 22); ac++;
    fileCascadeButton1 = XmCreateCascadeButton(devMenuBar,
        "fileCascadeButton1",
        args, 
        ac);
    XtManageChild(fileCascadeButton1);
    file_button_cb(fileCascadeButton1, (XtPointer)0, (XtPointer)0);
    
    ac = 0;
    filePulldownMenu1 = XmCreatePulldownMenu(XtParent(fileCascadeButton1),
        "filePulldownMenu1",
        args, 
        ac);
    
    ac = 0;
    XtSetArg(args[ac], XmNrecomputeSize, False); ac++;
    devPrintPB = XmCreatePushButton(filePulldownMenu1,
        "devPrintPB",
        args, 
        ac);
    XtManageChild(devPrintPB);
    
    ac = 0;
    XtSetArg(args[ac], XmNsensitive, False); ac++;
    XtSetArg(args[ac], XmNrecomputeSize, False); ac++;
    devSavePB = XmCreatePushButton(filePulldownMenu1,
        "devSavePB",
        args, 
        ac);
    XtManageChild(devSavePB);
    
    ac = 0;
    XtSetArg(args[ac], XmNrecomputeSize, False); ac++;
    devSaveAsPB = XmCreatePushButton(filePulldownMenu1,
        "devSaveAsPB",
        args, 
        ac);
    XtManageChild(devSaveAsPB);
    
    ac = 0;
    XtSetArg(args[ac], XmNrecomputeSize, False); ac++;
    devDismissPB = XmCreatePushButton(filePulldownMenu1,
        "devDismissPB",
        args, 
        ac);
    XtManageChild(devDismissPB);
    
    ac = 0;
    XtSetArg(args[ac], XmNsubMenuId, filePulldownMenu1); ac++;
    XtSetValues(fileCascadeButton1, args, ac);
    
    ac = 0;
    XtSetArg(args[ac], XmNx, 44); ac++;
    XtSetArg(args[ac], XmNy, 5); ac++;
    XtSetArg(args[ac], XmNwidth, 41); ac++;
    XtSetArg(args[ac], XmNheight, 22); ac++;
    editCascadeButton1 = XmCreateCascadeButton(devMenuBar,
        "editCascadeButton1",
        args, 
        ac);
    XtManageChild(editCascadeButton1);
    
    ac = 0;
    editPulldownMenu1 = XmCreatePulldownMenu(XtParent(editCascadeButton1),
        "editPulldownMenu1",
        args, 
        ac);
    
    ac = 0;
    devUndoPB = XmCreatePushButton(editPulldownMenu1,
        "devUndoPB",
        args, 
        ac);
    XtManageChild(devUndoPB);
    
    ac = 0;
    XtSetArg(args[ac], XmNrecomputeSize, False); ac++;
    devCutPB = XmCreatePushButton(editPulldownMenu1,
        "devCutPB",
        args, 
        ac);
    XtManageChild(devCutPB);
    
    ac = 0;
    XtSetArg(args[ac], XmNrecomputeSize, False); ac++;
    devCopyPB = XmCreatePushButton(editPulldownMenu1,
        "devCopyPB",
        args, 
        ac);
    XtManageChild(devCopyPB);
    
    ac = 0;
    XtSetArg(args[ac], XmNrecomputeSize, False); ac++;
    devPastePB = XmCreatePushButton(editPulldownMenu1,
        "devPastePB",
        args, 
        ac);
    XtManageChild(devPastePB);
    
    ac = 0;
    XtSetArg(args[ac], XmNrecomputeSize, False); ac++;
    devTextDeletePB = XmCreatePushButton(editPulldownMenu1,
        "devTextDeletePB",
        args, 
        ac);
    XtManageChild(devTextDeletePB);
    
    ac = 0;
    XtSetArg(args[ac], XmNrecomputeSize, False); ac++;
    devChainResPB = XmCreatePushButton(editPulldownMenu1,
        "devChainResPB",
        args, 
        ac);
    XtManageChild(devChainResPB);
    
    ac = 0;
    XtSetArg(args[ac], XmNsubMenuId, editPulldownMenu1); ac++;
    XtSetValues(editCascadeButton1, args, ac);
    
    ac = 0;
    XtSetArg(args[ac], XmNx, 1); ac++;
    XtSetArg(args[ac], XmNy, 665); ac++;
    XtSetArg(args[ac], XmNwidth, 603); ac++;
    XtSetArg(args[ac], XmNheight, 20); ac++;
    separator = XmCreateSeparator(devForm,
        "separator",
        args, 
        ac);
    XtManageChild(separator);
    
    ac = 0;
    XtSetArg(args[ac], XmNx, 1); ac++;
    XtSetArg(args[ac], XmNy, 40); ac++;
    XtSetArg(args[ac], XmNwidth, 603); ac++;
    XtSetArg(args[ac], XmNheight, 629); ac++;
    devicePanedWindow = XmCreatePanedWindow(devForm,
        "devicePanedWindow",
        args, 
        ac);
    XtManageChild(devicePanedWindow);
    
    ac = 0;
    XtSetArg(args[ac], XmNwidth, 597); ac++;
    XtSetArg(args[ac], XmNheight, 185); ac++;
    devInfoForm = XmCreateForm(devicePanedWindow,
        "devInfoForm",
        args, 
        ac);
    XtManageChild(devInfoForm);
    
    ac = 0;
    XtSetArg(args[ac], XmNx, 5); ac++;
    XtSetArg(args[ac], XmNy, 30); ac++;
    XtSetArg(args[ac], XmNwidth, 587); ac++;
    XtSetArg(args[ac], XmNheight, 145); ac++;
    devInfoSW = XmCreateScrolledWindow(devInfoForm,
        "devInfoSW",
        args, 
        ac);
    XtManageChild(devInfoSW);
    
    ac = 0;
    XtSetArg(args[ac], XmNeditMode, XmMULTI_LINE_EDIT); ac++;
    XtSetArg(args[ac], XmNeditable, False); ac++;
    devInfoText = XmCreateText(devInfoSW,
        "devInfoText",
        args, 
        ac);
    XtManageChild(devInfoText);
    
    ac = 0;
    XtSetArg(args[ac], XmNalignment, XmALIGNMENT_BEGINNING); ac++;
    XtSetArg(args[ac], XmNx, 0); ac++;
    XtSetArg(args[ac], XmNy, 0); ac++;
    XtSetArg(args[ac], XmNwidth, 140); ac++;
    XtSetArg(args[ac], XmNheight, 40); ac++;
    devInfoLb = XmCreateLabel(devInfoForm,
        "devInfoLb",
        args, 
        ac);
    XtManageChild(devInfoLb);
    
    ac = 0;
    XtSetArg(args[ac], XmNwidth, 597); ac++;
    XtSetArg(args[ac], XmNheight, 430); ac++;
    devResForm = XmCreateForm(devicePanedWindow,
        "devResForm",
        args, 
        ac);
    XtManageChild(devResForm);
    
    ac = 0;
    XtSetArg(args[ac], XmNx, 5); ac++;
    XtSetArg(args[ac], XmNy, 30); ac++;
    XtSetArg(args[ac], XmNwidth, 587); ac++;
    XtSetArg(args[ac], XmNheight, 400); ac++;
    devResSW = XmCreateScrolledWindow(devResForm,
        "devResSW",
        args, 
        ac);
    XtManageChild(devResSW);
    
    ac = 0;
    XtSetArg(args[ac], XmNeditMode, XmMULTI_LINE_EDIT); ac++;
    devResText = XmCreateText(devResSW,
        "devResText",
        args, 
        ac);
    XtManageChild(devResText);
    
    ac = 0;
    XtSetArg(args[ac], XmNalignment, XmALIGNMENT_BEGINNING); ac++;
    XtSetArg(args[ac], XmNx, 0); ac++;
    XtSetArg(args[ac], XmNy, 0); ac++;
    XtSetArg(args[ac], XmNwidth, 120); ac++;
    XtSetArg(args[ac], XmNheight, 40); ac++;
    devResLb = XmCreateLabel(devResForm,
        "devResLb",
        args, 
        ac);
    XtManageChild(devResLb);
        
/* Position the default button */

    ac = 0;
    XtSetArg(args[ac], XmNdefaultButton, devUpdatePB); ac++;
    XtSetValues(devForm, args, ac);
    
/* Position the attachments */
    
    ac = 0;
    XtSetArg(args[ac], XmNtopAttachment, XmATTACH_NONE); ac++;
    XtSetArg(args[ac], XmNbottomAttachment, XmATTACH_FORM); ac++;
    XtSetArg(args[ac], XmNleftAttachment, XmATTACH_POSITION); ac++;
    XtSetArg(args[ac], XmNrightAttachment, XmATTACH_NONE); ac++;
    XtSetArg(args[ac], XmNleftPosition, 83); ac++;
    XtSetArg(args[ac], XmNbottomOffset, 3); ac++;
    XtSetArg(args[ac], XmNleftOffset, 0); ac++;
    XtSetValues(devRestartPB, args, ac);
    
    ac = 0;
    XtSetArg(args[ac], XmNtopAttachment, XmATTACH_NONE); ac++;
    XtSetArg(args[ac], XmNbottomAttachment, XmATTACH_FORM); ac++;
    XtSetArg(args[ac], XmNleftAttachment, XmATTACH_POSITION); ac++;
    XtSetArg(args[ac], XmNrightAttachment, XmATTACH_NONE); ac++;
    XtSetArg(args[ac], XmNleftPosition, 64); ac++;
    XtSetArg(args[ac], XmNbottomOffset, 3); ac++;
    XtSetArg(args[ac], XmNleftOffset, 0); ac++;
    XtSetValues(devPingPB, args, ac);
    
    ac = 0;
    XtSetArg(args[ac], XmNtopAttachment, XmATTACH_NONE); ac++;
    XtSetArg(args[ac], XmNbottomAttachment, XmATTACH_FORM); ac++;
    XtSetArg(args[ac], XmNleftAttachment, XmATTACH_POSITION); ac++;
    XtSetArg(args[ac], XmNrightAttachment, XmATTACH_NONE); ac++;
    XtSetArg(args[ac], XmNleftPosition, 44); ac++;
    XtSetArg(args[ac], XmNbottomOffset, 3); ac++;
    XtSetArg(args[ac], XmNrightOffset, 0); ac++;
    XtSetValues(devDeletePB, args, ac);
    
    ac = 0;
    XtSetArg(args[ac], XmNtopAttachment, XmATTACH_NONE); ac++;
    XtSetArg(args[ac], XmNbottomAttachment, XmATTACH_FORM); ac++;
    XtSetArg(args[ac], XmNleftAttachment, XmATTACH_POSITION); ac++;
    XtSetArg(args[ac], XmNrightAttachment, XmATTACH_NONE); ac++;
    XtSetArg(args[ac], XmNleftPosition, 5); ac++;
    XtSetArg(args[ac], XmNbottomOffset, 3); ac++;
    XtSetArg(args[ac], XmNrightOffset, 0); ac++;
    XtSetValues(devUpdatePB, args, ac);
    
    ac = 0;
    XtSetArg(args[ac], XmNtopAttachment, XmATTACH_NONE); ac++;
    XtSetArg(args[ac], XmNbottomAttachment, XmATTACH_FORM); ac++;
    XtSetArg(args[ac], XmNleftAttachment, XmATTACH_POSITION); ac++;
    XtSetArg(args[ac], XmNrightAttachment, XmATTACH_NONE); ac++;
    XtSetArg(args[ac], XmNleftPosition, 25); ac++;
    XtSetArg(args[ac], XmNbottomOffset, 3); ac++;
    XtSetArg(args[ac], XmNrightOffset, 0); ac++;
    XtSetValues(devCancelPB, args, ac);
    
    ac = 0;
    XtSetArg(args[ac], XmNleftAttachment, XmATTACH_FORM); ac++;
    XtSetArg(args[ac], XmNrightAttachment, XmATTACH_FORM); ac++;
    XtSetArg(args[ac], XmNtopOffset, 0); ac++;
    XtSetArg(args[ac], XmNleftOffset, 0); ac++;
    XtSetArg(args[ac], XmNrightOffset, 0); ac++;
    XtSetValues(devMenuBar, args, ac);
    
    ac = 0;
    XtSetArg(args[ac], XmNtopAttachment, XmATTACH_NONE); ac++;
    XtSetArg(args[ac], XmNbottomAttachment, XmATTACH_FORM); ac++;
    XtSetArg(args[ac], XmNleftAttachment, XmATTACH_FORM); ac++;
    XtSetArg(args[ac], XmNrightAttachment, XmATTACH_FORM); ac++;
    XtSetArg(args[ac], XmNbottomOffset, 40); ac++;
    XtSetArg(args[ac], XmNleftOffset, 1); ac++;
    XtSetArg(args[ac], XmNrightOffset, 1); ac++;
    XtSetValues(separator, args, ac);
    
    ac = 0;
    XtSetArg(args[ac], XmNtopAttachment, XmATTACH_FORM); ac++;
    XtSetArg(args[ac], XmNbottomAttachment, XmATTACH_FORM); ac++;
    XtSetArg(args[ac], XmNleftAttachment, XmATTACH_FORM); ac++;
    XtSetArg(args[ac], XmNrightAttachment, XmATTACH_FORM); ac++;
    XtSetArg(args[ac], XmNtopOffset, 40); ac++;
    XtSetArg(args[ac], XmNbottomOffset, 56); ac++;
    XtSetArg(args[ac], XmNleftOffset, 1); ac++;
    XtSetArg(args[ac], XmNrightOffset, 1); ac++;
    XtSetValues(devicePanedWindow, args, ac);
    
    ac = 0;
    XtSetArg(args[ac], XmNtopAttachment, XmATTACH_FORM); ac++;
    XtSetArg(args[ac], XmNbottomAttachment, XmATTACH_FORM); ac++;
    XtSetArg(args[ac], XmNleftAttachment, XmATTACH_FORM); ac++;
    XtSetArg(args[ac], XmNrightAttachment, XmATTACH_FORM); ac++;
    XtSetArg(args[ac], XmNtopOffset, 30); ac++;
    XtSetArg(args[ac], XmNbottomOffset, 10); ac++;
    XtSetArg(args[ac], XmNleftOffset, 5); ac++;
    XtSetArg(args[ac], XmNrightOffset, 5); ac++;
    XtSetValues(devInfoSW, args, ac);
    
    ac = 0;
    XtSetArg(args[ac], XmNtopOffset, 0); ac++;
    XtSetArg(args[ac], XmNleftOffset, 0); ac++;
    XtSetValues(devInfoLb, args, ac);
    
    ac = 0;
    XtSetArg(args[ac], XmNtopAttachment, XmATTACH_FORM); ac++;
    XtSetArg(args[ac], XmNbottomAttachment, XmATTACH_FORM); ac++;
    XtSetArg(args[ac], XmNleftAttachment, XmATTACH_FORM); ac++;
    XtSetArg(args[ac], XmNrightAttachment, XmATTACH_FORM); ac++;
    XtSetArg(args[ac], XmNtopOffset, 30); ac++;
    XtSetArg(args[ac], XmNbottomOffset, 0); ac++;
    XtSetArg(args[ac], XmNleftOffset, 5); ac++;
    XtSetArg(args[ac], XmNrightOffset, 5); ac++;
    XtSetValues(devResSW, args, ac);
    
    ac = 0;
    XtSetArg(args[ac], XmNtopOffset, 0); ac++;
    XtSetArg(args[ac], XmNleftOffset, 0); ac++;
    XtSetValues(devResLb, args, ac);

/**************************** CALLBACK ATTACHMENTS ****************************/
/* Callbacks attachment with index as client parameter */

    XtAddCallback(devDeletePB, XmNactivateCallback, PrepareDevDelCb,(XtPointer)index);
    XtAddCallback(devDeletePB, XmNactivateCallback, DialogCb, (XtPointer)DevDelOpFormID);
    XtAddCallback(devUpdatePB, XmNactivateCallback, DevPrepareUpdateCb,(XtPointer)index);
    XtAddCallback(devUpdatePB, XmNactivateCallback, DialogCb, (XtPointer)DevUpdateBoxID);
    XtAddCallback(devCancelPB, XmNactivateCallback, DevDismissCb, (XtPointer)index);
    XtAddCallback(devRestartPB, XmNactivateCallback, DevRestartCb, (XtPointer)index);
    XtAddCallback(devRestartPB, XmNactivateCallback, DialogCb, (XtPointer)ServRestartBoxID);
    XtAddCallback(devPingPB, XmNactivateCallback, DevPingCb,(XtPointer)index);
    XtAddCallback(devPrintPB, XmNactivateCallback, DevPreparePrintCb, (XtPointer)index);
    XtAddCallback(devPrintPB, XmNactivateCallback, DialogCb, (XtPointer)PrintFormID);
    XtAddCallback(devSavePB, XmNactivateCallback, DevSaveCb, (XtPointer)index);
    XtAddCallback(devSaveAsPB, XmNactivateCallback, DevSaveShowFileSelCb, (XtPointer)index);
    XtAddCallback(devDismissPB, XmNactivateCallback, DevDismissCb, (XtPointer)index);
    XtAddCallback(devUndoPB, XmNactivateCallback, DevUndoCb, (XtPointer)index);
    XtAddCallback(devCutPB, XmNactivateCallback, DevCutCb, (XtPointer)index);
    XtAddCallback(devCopyPB, XmNactivateCallback, DevCopyCb, (XtPointer)index);
    XtAddCallback(devPastePB, XmNactivateCallback, DevPasteCb, (XtPointer)index);
    XtAddCallback(devTextDeletePB, XmNactivateCallback, DevDeleteCb, (XtPointer)index);
    XtAddCallback(devChainResPB, XmNactivateCallback, DevChainResCb, (XtPointer)index);

    XtAddEventHandler(devResText, ButtonPressMask, True,
                                  dev_reso_text_event_hand, (XtPointer) index);
    

/**************************** END OF CREATION CODE ****************************/    

/* Set the Dialog title resource to the dev_name */

    sprintf(s,"Device %s",dev_name);
    xsSetTitle(devForm, s);
    							
/* Create the associated struct upkeeping info to manipulate the window */

	create_dev_struct(index, dev_name, devForm, 
					   devInfoText, devResText);
	
}

/************************************************************************
*									*
*				xsServerWindowCreate :			*
*				--------------------			*
*									*
*************************************************************************/

void xsServerWindowCreate(Widget rootparent, Widget mainWindow, 
			  int index, char *serv_name)
{
/* Variable declarations */

    Arg      args[20];
    Cardinal ac=0;
    Boolean  argok=False;

    Widget   servDialogShell;
    Widget   servForm;
    Widget   servUnregPB;
    Widget   servDeletePB;
    Widget   servUpdatePB;
    Widget   servCancelPB;
    Widget   servRestartPB;
    Widget   servMenuBar;
    Widget   fileCascadeButton2;
    Widget   filePulldownMenu2;
    Widget   servPrintPB;
    Widget   servDismissPB;
    Widget   servSavePB;
    Widget   servSaveAsPB;
    Widget   editCascadeButton2;
    Widget   editPulldownMenu2;
    Widget   servUndoPB;
    Widget   servCutPB;
    Widget   servCopyPB;
    Widget   servPastePB;
    Widget   servTextDeletePB;
    Widget   servChainResPB;
    Widget   servSep;
    Widget   serverPanedWindow;
    Widget   servInfoForm;
    Widget   servInfoSW;
    Widget   servInfoText;
    Widget   servInfoLb;
    Widget   servDevListForm;
    Widget   servDevListSW;
    Widget   servDevListText;
    Widget   servDevListLb;
    Widget   servResForm;
    Widget   servResSW;
    Widget   servResText;
    Widget   servResLb;
    
    char s[256]; /* to formate little strings */
    
/* Creation Code without callbacks attachments */
        
    ac = 0;
    XtSetArg(args[ac], XmNmwmFunctions, 33); ac++;
    XtSetArg(args[ac], XmNwidth, 616); ac++;
    XtSetArg(args[ac], XmNheight, 807); ac++;
    servDialogShell = XtCreatePopupShell("servDialogShell",
        xmDialogShellWidgetClass,
        mainWindow,
        args, 
        ac);
    
    ac = 0;
    XtSetArg(args[ac], XmNautoUnmanage, False); ac++;
    servForm = XmCreateForm(servDialogShell,
        "servForm",
        args, 
        ac);
    
    ac = 0;
    XtSetArg(args[ac], XmNsensitive, True); ac++;
    XtSetArg(args[ac], XmNx, 511); ac++;
    XtSetArg(args[ac], XmNy, 768); ac++;
    XtSetArg(args[ac], XmNwidth, 72); ac++;
    XtSetArg(args[ac], XmNheight, 36); ac++;
    servRestartPB = XmCreatePushButton(servForm,
        "servRestartPB",
        args, 
        ac);
    XtManageChild(servRestartPB);
    
    ac = 0;
    XtSetArg(args[ac], XmNx, 271); ac++;
    XtSetArg(args[ac], XmNy, 768); ac++;
    XtSetArg(args[ac], XmNwidth, 72); ac++;
    XtSetArg(args[ac], XmNheight, 36); ac++;
    servUnregPB = XmCreatePushButton(servForm,
        "servUnregPB",
        args, 
        ac);
    XtManageChild(servUnregPB);
    
    ac = 0;
    XtSetArg(args[ac], XmNx, 394); ac++;
    XtSetArg(args[ac], XmNy, 768); ac++;
    XtSetArg(args[ac], XmNwidth, 72); ac++;
    XtSetArg(args[ac], XmNheight, 36); ac++;
    servDeletePB = XmCreatePushButton(servForm,
        "servDeletePB",
        args, 
        ac);
    XtManageChild(servDeletePB);
    
    ac = 0;
    XtSetArg(args[ac], XmNx, 31); ac++;
    XtSetArg(args[ac], XmNy, 768); ac++;
    XtSetArg(args[ac], XmNwidth, 72); ac++;
    XtSetArg(args[ac], XmNheight, 36); ac++;
    servUpdatePB = XmCreatePushButton(servForm,
        "servUpdatePB",
        args, 
        ac);
    XtManageChild(servUpdatePB);
    ccb_make_parent_def_button(servUpdatePB, (XtPointer)0, (XtPointer)0);
    
    ac = 0;
    XtSetArg(args[ac], XmNx, 154); ac++;
    XtSetArg(args[ac], XmNy, 768); ac++;
    XtSetArg(args[ac], XmNwidth, 72); ac++;
    XtSetArg(args[ac], XmNheight, 36); ac++;
    servCancelPB = XmCreatePushButton(servForm,
        "servCancelPB",
        args, 
        ac);
    XtManageChild(servCancelPB);
    
    ac = 0;
    XtSetArg(args[ac], XmNx, 0); ac++;
    XtSetArg(args[ac], XmNy, 0); ac++;
    XtSetArg(args[ac], XmNwidth, 616); ac++;
    XtSetArg(args[ac], XmNheight, 32); ac++;
    servMenuBar = XmCreateMenuBar(servForm,
        "servMenuBar",
        args, 
        ac);
    XtManageChild(servMenuBar);
    
    ac = 0;
    XtSetArg(args[ac], XmNx, 5); ac++;
    XtSetArg(args[ac], XmNy, 5); ac++;
    XtSetArg(args[ac], XmNwidth, 39); ac++;
    XtSetArg(args[ac], XmNheight, 22); ac++;
    fileCascadeButton2 = XmCreateCascadeButton(servMenuBar,
        "fileCascadeButton2",
        args, 
        ac);
    XtManageChild(fileCascadeButton2);
    file_button_cb(fileCascadeButton2, (XtPointer)0, (XtPointer)0);
    
    ac = 0;
    filePulldownMenu2 = XmCreatePulldownMenu(XtParent(fileCascadeButton2),
        "filePulldownMenu2",
        args, 
        ac);
    
    ac = 0;
    XtSetArg(args[ac], XmNrecomputeSize, False); ac++;
    servPrintPB = XmCreatePushButton(filePulldownMenu2,
        "servPrintPB",
        args, 
        ac);
    XtManageChild(servPrintPB);
    
    ac = 0;
    XtSetArg(args[ac], XmNsensitive, False); ac++;
    XtSetArg(args[ac], XmNrecomputeSize, False); ac++;
    servSavePB = XmCreatePushButton(filePulldownMenu2,
        "servSavePB",
        args, 
        ac);
    XtManageChild(servSavePB);
    
    ac = 0;
    XtSetArg(args[ac], XmNrecomputeSize, False); ac++;
    servSaveAsPB = XmCreatePushButton(filePulldownMenu2,
        "servSaveAsPB",
        args, 
        ac);
    XtManageChild(servSaveAsPB);
    
    ac = 0;
    XtSetArg(args[ac], XmNrecomputeSize, False); ac++;
    servDismissPB = XmCreatePushButton(filePulldownMenu2,
        "servDismissPB",
        args, 
        ac);
    XtManageChild(servDismissPB);
    
    ac = 0;
    XtSetArg(args[ac], XmNsubMenuId, filePulldownMenu2); ac++;
    XtSetValues(fileCascadeButton2, args, ac);
    
    ac = 0;
    XtSetArg(args[ac], XmNx, 44); ac++;
    XtSetArg(args[ac], XmNy, 5); ac++;
    XtSetArg(args[ac], XmNwidth, 41); ac++;
    XtSetArg(args[ac], XmNheight, 22); ac++;
    editCascadeButton2 = XmCreateCascadeButton(servMenuBar,
        "editCascadeButton2",
        args, 
        ac);
    XtManageChild(editCascadeButton2);
    
    ac = 0;
    editPulldownMenu2 = XmCreatePulldownMenu(XtParent(editCascadeButton2),
        "editPulldownMenu2",
        args, 
        ac);
    
    ac = 0;
    servUndoPB = XmCreatePushButton(editPulldownMenu2,
        "servUndoPB",
        args, 
        ac);
    XtManageChild(servUndoPB);
    
    ac = 0;
    XtSetArg(args[ac], XmNrecomputeSize, False); ac++;
    servCutPB = XmCreatePushButton(editPulldownMenu2,
        "servCutPB",
        args, 
        ac);
    XtManageChild(servCutPB);
    
    ac = 0;
    XtSetArg(args[ac], XmNrecomputeSize, False); ac++;
    servCopyPB = XmCreatePushButton(editPulldownMenu2,
        "servCopyPB",
        args, 
        ac);
    XtManageChild(servCopyPB);
    
    ac = 0;
    XtSetArg(args[ac], XmNrecomputeSize, False); ac++;
    servPastePB = XmCreatePushButton(editPulldownMenu2,
        "servPastePB",
        args, 
        ac);
    XtManageChild(servPastePB);
    
    ac = 0;
    XtSetArg(args[ac], XmNrecomputeSize, False); ac++;
    servTextDeletePB = XmCreatePushButton(editPulldownMenu2,
        "servTextDeletePB",
        args, 
        ac);
    XtManageChild(servTextDeletePB);
    
    ac = 0;
    XtSetArg(args[ac], XmNrecomputeSize, False); ac++;
    servChainResPB = XmCreatePushButton(editPulldownMenu2,
        "servChainResPB",
        args, 
        ac);
    XtManageChild(servChainResPB);
    
    ac = 0;
    XtSetArg(args[ac], XmNsubMenuId, editPulldownMenu2); ac++;
    XtSetValues(editCascadeButton2, args, ac);
    
    ac = 0;
    XtSetArg(args[ac], XmNx, 1); ac++;
    XtSetArg(args[ac], XmNy, 747); ac++;
    XtSetArg(args[ac], XmNwidth, 614); ac++;
    XtSetArg(args[ac], XmNheight, 20); ac++;
    servSep = XmCreateSeparator(servForm,
        "servSep",
        args, 
        ac);
    XtManageChild(servSep);
    
    ac = 0;
    XtSetArg(args[ac], XmNx, 1); ac++;
    XtSetArg(args[ac], XmNy, 40); ac++;
    XtSetArg(args[ac], XmNwidth, 614); ac++;
    XtSetArg(args[ac], XmNheight, 711); ac++;
    serverPanedWindow = XmCreatePanedWindow(servForm,
        "serverPanedWindow",
        args, 
        ac);
    XtManageChild(serverPanedWindow);
    
    ac = 0;
    XtSetArg(args[ac], XmNwidth, 608); ac++;
    XtSetArg(args[ac], XmNheight, 172); ac++;
    servInfoForm = XmCreateForm(serverPanedWindow,
        "servInfoForm",
        args, 
        ac);
    XtManageChild(servInfoForm);
    
    ac = 0;
    XtSetArg(args[ac], XmNx, 5); ac++;
    XtSetArg(args[ac], XmNy, 30); ac++;
    XtSetArg(args[ac], XmNwidth, 598); ac++;
    XtSetArg(args[ac], XmNheight, 132); ac++;
    servInfoSW = XmCreateScrolledWindow(servInfoForm,
        "servInfoSW",
        args, 
        ac);
    XtManageChild(servInfoSW);
    
    ac = 0;
    XtSetArg(args[ac], XmNeditMode, XmMULTI_LINE_EDIT); ac++;
    XtSetArg(args[ac], XmNeditable, False); ac++;
    servInfoText = XmCreateText(servInfoSW,
        "servInfoText",
        args, 
        ac);
    XtManageChild(servInfoText);
    
    ac = 0;
    XtSetArg(args[ac], XmNalignment, XmALIGNMENT_BEGINNING); ac++;
    XtSetArg(args[ac], XmNx, 0); ac++;
    XtSetArg(args[ac], XmNy, 0); ac++;
    XtSetArg(args[ac], XmNwidth, 139); ac++;
    XtSetArg(args[ac], XmNheight, 40); ac++;
    servInfoLb = XmCreateLabel(servInfoForm,
        "servInfoLb",
        args, 
        ac);
    XtManageChild(servInfoLb);
    
    ac = 0;
    XtSetArg(args[ac], XmNwidth, 608); ac++;
    XtSetArg(args[ac], XmNheight, 167); ac++;
    servDevListForm = XmCreateForm(serverPanedWindow,
        "servDevListForm",
        args, 
        ac);
    XtManageChild(servDevListForm);
    
    ac = 0;
    XtSetArg(args[ac], XmNx, 5); ac++;
    XtSetArg(args[ac], XmNy, 30); ac++;
    XtSetArg(args[ac], XmNwidth, 598); ac++;
    XtSetArg(args[ac], XmNheight, 137); ac++;
    servDevListSW = XmCreateScrolledWindow(servDevListForm,
        "servDevListSW",
        args, 
        ac);
    XtManageChild(servDevListSW);
    
    ac = 0;
    XtSetArg(args[ac], XmNeditMode, XmMULTI_LINE_EDIT); ac++;
    servDevListText = XmCreateText(servDevListSW,
        "servDevListText",
        args, 
        ac);
    XtManageChild(servDevListText);
    
    ac = 0;
    XtSetArg(args[ac], XmNalignment, XmALIGNMENT_BEGINNING); ac++;
    XtSetArg(args[ac], XmNx, 0); ac++;
    XtSetArg(args[ac], XmNy, 0); ac++;
    XtSetArg(args[ac], XmNwidth, 207); ac++;
    XtSetArg(args[ac], XmNheight, 40); ac++;
    servDevListLb = XmCreateLabel(servDevListForm,
        "servDevListLb",
        args, 
        ac);
    XtManageChild(servDevListLb);
    
    ac = 0;
    XtSetArg(args[ac], XmNwidth, 608); ac++;
    XtSetArg(args[ac], XmNheight, 350); ac++;
    servResForm = XmCreateForm(serverPanedWindow,
        "servResForm",
        args, 
        ac);
    XtManageChild(servResForm);
    
    ac = 0;
    XtSetArg(args[ac], XmNx, 5); ac++;
    XtSetArg(args[ac], XmNy, 30); ac++;
    XtSetArg(args[ac], XmNwidth, 598); ac++;
    XtSetArg(args[ac], XmNheight, 320); ac++;
    servResSW = XmCreateScrolledWindow(servResForm,
        "servResSW",
        args, 
        ac);
    XtManageChild(servResSW);
    
    ac = 0;
    XtSetArg(args[ac], XmNeditMode, XmMULTI_LINE_EDIT); ac++;
    servResText = XmCreateText(servResSW,
        "servResText",
        args, 
        ac);
    XtManageChild(servResText);

    
    ac = 0;
    XtSetArg(args[ac], XmNalignment, XmALIGNMENT_BEGINNING); ac++;
    XtSetArg(args[ac], XmNx, 0); ac++;
    XtSetArg(args[ac], XmNy, 0); ac++;
    XtSetArg(args[ac], XmNwidth, 125); ac++;
    XtSetArg(args[ac], XmNheight, 40); ac++;
    servResLb = XmCreateLabel(servResForm,
        "servResLb",
        args, 
        ac);
    XtManageChild(servResLb);
    
/* Position XmNdefaultButton */

    ac = 0;
    XtSetArg(args[ac], XmNdefaultButton, servUpdatePB); ac++;
    XtSetValues(servForm, args, ac);

/* Position the attachments */

    ac = 0;
    XtSetArg(args[ac], XmNtopAttachment, XmATTACH_NONE); ac++;
    XtSetArg(args[ac], XmNbottomAttachment, XmATTACH_FORM); ac++;
    XtSetArg(args[ac], XmNleftAttachment, XmATTACH_POSITION); ac++;
    XtSetArg(args[ac], XmNrightAttachment, XmATTACH_NONE); ac++;
    XtSetArg(args[ac], XmNleftPosition, 83); ac++;
    XtSetArg(args[ac], XmNbottomOffset, 3); ac++;
    XtSetArg(args[ac], XmNrightOffset, 0); ac++;
    XtSetValues(servRestartPB, args, ac);
     
    ac = 0;
    XtSetArg(args[ac], XmNtopAttachment, XmATTACH_NONE); ac++;
    XtSetArg(args[ac], XmNbottomAttachment, XmATTACH_FORM); ac++;
    XtSetArg(args[ac], XmNleftAttachment, XmATTACH_POSITION); ac++;
    XtSetArg(args[ac], XmNrightAttachment, XmATTACH_NONE); ac++;
    XtSetArg(args[ac], XmNleftPosition, 44); ac++;
    XtSetArg(args[ac], XmNbottomOffset, 3); ac++;
    XtSetArg(args[ac], XmNrightOffset, 0); ac++;
    XtSetValues(servUnregPB, args, ac);
    
    ac = 0;
    XtSetArg(args[ac], XmNtopAttachment, XmATTACH_NONE); ac++;
    XtSetArg(args[ac], XmNbottomAttachment, XmATTACH_FORM); ac++;
    XtSetArg(args[ac], XmNleftAttachment, XmATTACH_POSITION); ac++;
    XtSetArg(args[ac], XmNrightAttachment, XmATTACH_NONE); ac++;
    XtSetArg(args[ac], XmNleftPosition, 64); ac++;
    XtSetArg(args[ac], XmNbottomOffset, 3); ac++;
    XtSetArg(args[ac], XmNrightOffset, 0); ac++;
    XtSetValues(servDeletePB, args, ac);
    
    ac = 0;
    XtSetArg(args[ac], XmNtopAttachment, XmATTACH_NONE); ac++;
    XtSetArg(args[ac], XmNbottomAttachment, XmATTACH_FORM); ac++;
    XtSetArg(args[ac], XmNleftAttachment, XmATTACH_POSITION); ac++;
    XtSetArg(args[ac], XmNrightAttachment, XmATTACH_NONE); ac++;
    XtSetArg(args[ac], XmNleftPosition, 5); ac++;
    XtSetArg(args[ac], XmNbottomOffset, 3); ac++;
    XtSetArg(args[ac], XmNrightOffset, 0); ac++;
    XtSetValues(servUpdatePB, args, ac);
    
    ac = 0;
    XtSetArg(args[ac], XmNtopAttachment, XmATTACH_NONE); ac++;
    XtSetArg(args[ac], XmNbottomAttachment, XmATTACH_FORM); ac++;
    XtSetArg(args[ac], XmNleftAttachment, XmATTACH_POSITION); ac++;
    XtSetArg(args[ac], XmNrightAttachment, XmATTACH_NONE); ac++;
    XtSetArg(args[ac], XmNleftPosition, 25); ac++;
    XtSetArg(args[ac], XmNbottomOffset, 3); ac++;
    XtSetArg(args[ac], XmNrightOffset, 0); ac++;
    XtSetValues(servCancelPB, args, ac);
    
    ac = 0;
    XtSetArg(args[ac], XmNleftAttachment, XmATTACH_FORM); ac++;
    XtSetArg(args[ac], XmNrightAttachment, XmATTACH_FORM); ac++;
    XtSetArg(args[ac], XmNtopOffset, 0); ac++;
    XtSetArg(args[ac], XmNleftOffset, 0); ac++;
    XtSetArg(args[ac], XmNrightOffset, 0); ac++;
    XtSetValues(servMenuBar, args, ac);
    
    ac = 0;
    XtSetArg(args[ac], XmNtopAttachment, XmATTACH_NONE); ac++;
    XtSetArg(args[ac], XmNbottomAttachment, XmATTACH_FORM); ac++;
    XtSetArg(args[ac], XmNleftAttachment, XmATTACH_FORM); ac++;
    XtSetArg(args[ac], XmNrightAttachment, XmATTACH_FORM); ac++;
    XtSetArg(args[ac], XmNbottomOffset, 40); ac++;
    XtSetArg(args[ac], XmNleftOffset, 1); ac++;
    XtSetArg(args[ac], XmNrightOffset, 1); ac++;
    XtSetValues(servSep, args, ac);
    
    ac = 0;
    XtSetArg(args[ac], XmNtopAttachment, XmATTACH_FORM); ac++;
    XtSetArg(args[ac], XmNbottomAttachment, XmATTACH_FORM); ac++;
    XtSetArg(args[ac], XmNleftAttachment, XmATTACH_FORM); ac++;
    XtSetArg(args[ac], XmNrightAttachment, XmATTACH_FORM); ac++;
    XtSetArg(args[ac], XmNtopOffset, 40); ac++;
    XtSetArg(args[ac], XmNbottomOffset, 56); ac++;
    XtSetArg(args[ac], XmNleftOffset, 1); ac++;
    XtSetArg(args[ac], XmNrightOffset, 1); ac++;
    XtSetValues(serverPanedWindow, args, ac);
    
    ac = 0;
    XtSetArg(args[ac], XmNtopAttachment, XmATTACH_FORM); ac++;
    XtSetArg(args[ac], XmNbottomAttachment, XmATTACH_FORM); ac++;
    XtSetArg(args[ac], XmNleftAttachment, XmATTACH_FORM); ac++;
    XtSetArg(args[ac], XmNrightAttachment, XmATTACH_FORM); ac++;
    XtSetArg(args[ac], XmNtopOffset, 30); ac++;
    XtSetArg(args[ac], XmNbottomOffset, 10); ac++;
    XtSetArg(args[ac], XmNleftOffset, 5); ac++;
    XtSetArg(args[ac], XmNrightOffset, 5); ac++;
    XtSetValues(servInfoSW, args, ac);
    
    ac = 0;
    XtSetArg(args[ac], XmNtopOffset, 0); ac++;
    XtSetArg(args[ac], XmNleftOffset, 0); ac++;
    XtSetValues(servInfoLb, args, ac);
    
    ac = 0;
    XtSetArg(args[ac], XmNtopAttachment, XmATTACH_FORM); ac++;
    XtSetArg(args[ac], XmNbottomAttachment, XmATTACH_FORM); ac++;
    XtSetArg(args[ac], XmNleftAttachment, XmATTACH_FORM); ac++;
    XtSetArg(args[ac], XmNrightAttachment, XmATTACH_FORM); ac++;
    XtSetArg(args[ac], XmNtopOffset, 30); ac++;
    XtSetArg(args[ac], XmNbottomOffset, 0); ac++;
    XtSetArg(args[ac], XmNleftOffset, 5); ac++;
    XtSetArg(args[ac], XmNrightOffset, 5); ac++;
    XtSetValues(servDevListSW, args, ac);
    
    ac = 0;
    XtSetArg(args[ac], XmNtopOffset, 0); ac++;
    XtSetArg(args[ac], XmNleftOffset, 0); ac++;
    XtSetValues(servDevListLb, args, ac);
    
    ac = 0;
    XtSetArg(args[ac], XmNtopAttachment, XmATTACH_FORM); ac++;
    XtSetArg(args[ac], XmNbottomAttachment, XmATTACH_FORM); ac++;
    XtSetArg(args[ac], XmNleftAttachment, XmATTACH_FORM); ac++;
    XtSetArg(args[ac], XmNrightAttachment, XmATTACH_FORM); ac++;
    XtSetArg(args[ac], XmNtopOffset, 30); ac++;
    XtSetArg(args[ac], XmNbottomOffset, 0); ac++;
    XtSetArg(args[ac], XmNleftOffset, 5); ac++;
    XtSetArg(args[ac], XmNrightOffset, 5); ac++;
    XtSetValues(servResSW, args, ac);
    
    ac = 0;
    XtSetArg(args[ac], XmNtopOffset, 0); ac++;
    XtSetArg(args[ac], XmNleftOffset, 0); ac++;
    XtSetValues(servResLb, args, ac);

/*************************** CALLBACK ATTACHMENTS ***************************/

    XtAddCallback(servUpdatePB, XmNactivateCallback, ServPrepareUpdateCb, (XtPointer)index);
    XtAddCallback(servUpdatePB, XmNactivateCallback, DialogCb, (XtPointer)ServUpdateBoxID);
    XtAddCallback(servCancelPB, XmNactivateCallback, ServDismissCb, (XtPointer)index);
    XtAddCallback(servDeletePB, XmNactivateCallback, PrepareServDelCb, (XtPointer)index);
    XtAddCallback(servDeletePB, XmNactivateCallback, DialogCb, (XtPointer)ServDelOpFormID);
    XtAddCallback(servUnregPB, XmNactivateCallback, ServUnregCb, (XtPointer)index);
    XtAddCallback(servRestartPB, XmNactivateCallback, ServRestartCb, (XtPointer)index);
    XtAddCallback(servRestartPB, XmNactivateCallback, DialogCb, (XtPointer)ServRestartBoxID);
    XtAddCallback(servPrintPB, XmNactivateCallback, ServPreparePrintCb, (XtPointer)index);
    XtAddCallback(servPrintPB, XmNactivateCallback, DialogCb, (XtPointer)PrintFormID);
    XtAddCallback(servDismissPB, XmNactivateCallback, ServDismissCb, (XtPointer)index);
    XtAddCallback(servSavePB, XmNactivateCallback, ServSaveCb, (XtPointer)index);
    XtAddCallback(servSaveAsPB, XmNactivateCallback, ServSaveShowFileSelCb, (XtPointer)index);
    XtAddCallback(servUndoPB, XmNactivateCallback, ServUndoCb, (XtPointer)index);
    XtAddCallback(servCutPB, XmNactivateCallback, ServCutCb, (XtPointer)index);
    XtAddCallback(servCopyPB, XmNactivateCallback, ServCopyCb, (XtPointer)index);
    XtAddCallback(servPastePB, XmNactivateCallback, ServPasteCb, (XtPointer)index);
    XtAddCallback(servTextDeletePB, XmNactivateCallback, ServDeleteCb, (XtPointer)index);
    XtAddCallback(servChainResPB, XmNactivateCallback, ServChainResCb, (XtPointer)index);
    XtAddEventHandler(servResText, ButtonPressMask, True,
                                 serv_reso_text_event_hand, (XtPointer) index);

/*************************** END OF CREATION CODE ***************************/    
    
/* Position the title following serv_name */

	sprintf(s, "Server %s", serv_name);
	xsSetTitle(servForm, s);
	
/* Create the associated struct upkeeping info to manipulate the window */

	create_serv_struct(index, serv_name, servForm, 
					   servInfoText, servDevListText, servResText);
}

/************************************************************************
*									*
*			xsResourcesWindowCreate :			*
*			-----------------------				*
*									*
*************************************************************************/

void xsResourcesWindowCreate(Widget rootparent, Widget mainWindow, 
			     int index, char *res_filter)
{
/* Variable declarations */

    char *s;
    Arg      args[20];
    Cardinal ac=0;
    Boolean  argok=False;

    Widget   resDialogShell;
    Widget   resForm;
    Widget   resTextForm;
    Widget   resSW;
    Widget   resText;
    Widget   resLb;
    Widget   resUpdatePB;
    Widget   resCancelPB;
    Widget   resMenuBar;
    Widget   fileCascadeButton3;
    Widget   filePulldownMenu3;
    Widget   resPrintPB;
    Widget   resDismissPB;
    Widget   resSavePB;
    Widget   resSaveAsPB;
    Widget   editCascadeButton3;
    Widget   editPulldownMenu3;
    Widget   resUndoPB;
    Widget   resCutPB;
    Widget   resCopyPB;
    Widget   resPastePB;
    Widget   resTextDeletePB;
    Widget   resSep;
    
/* Creation Code without callbacks attachments */

    ac = 0;
    XtSetArg(args[ac], XmNtitle, "resDialogShell"); ac++;
    XtSetArg(args[ac], XmNwidth, 612); ac++;
    XtSetArg(args[ac], XmNheight, 469); ac++;
    XtSetArg(args[ac], XmNmwmFunctions, MWM_FUNC_ALL|MWM_FUNC_CLOSE); ac++;
    resDialogShell = XtCreatePopupShell("resDialogShell",
        xmDialogShellWidgetClass,
        mainWindow,
        args, 
        ac);
        
    ac = 0;
    XtSetArg(args[ac], XmNautoUnmanage, False); ac++;
    XtSetArg(args[ac], XmNdialogStyle, XmDIALOG_MODELESS); ac++;
    XtSetArg(args[ac], XmNx, 1077); ac++;
    XtSetArg(args[ac], XmNy, 54); ac++;
    XtSetArg(args[ac], XmNwidth, 612); ac++;
    XtSetArg(args[ac], XmNheight, 469); ac++;
    resForm = XmCreateForm(resDialogShell,
        "resForm",
        args, 
        ac);
   
    ac = 0;
    XtSetArg(args[ac], XmNx, 1); ac++;
    XtSetArg(args[ac], XmNy, 40); ac++;
    XtSetArg(args[ac], XmNwidth, 610); ac++;
    XtSetArg(args[ac], XmNheight, 373); ac++;
    resTextForm = XmCreateForm(resForm,
        "resTextForm",
        args, 
        ac);
    XtManageChild(resTextForm);
    
    ac = 0;
    XtSetArg(args[ac], XmNx, 5); ac++;
    XtSetArg(args[ac], XmNy, 30); ac++;
    XtSetArg(args[ac], XmNwidth, 600); ac++;
    XtSetArg(args[ac], XmNheight, 343); ac++;
    resSW = XmCreateScrolledWindow(resTextForm,
        "resSW",
        args, 
        ac);
    XtManageChild(resSW);
    
    ac = 0;
    XtSetArg(args[ac], XmNeditMode, XmMULTI_LINE_EDIT); ac++;
    resText = XmCreateText(resSW,
        "resText",
        args, 
        ac);
    XtManageChild(resText);
    
    ac = 0;
    XtSetArg(args[ac], XmNalignment, XmALIGNMENT_BEGINNING); ac++;
    XtSetArg(args[ac], XmNx, 0); ac++;
    XtSetArg(args[ac], XmNy, 0); ac++;
    XtSetArg(args[ac], XmNwidth, 120); ac++;
    XtSetArg(args[ac], XmNheight, 40); ac++;
    resLb = XmCreateLabel(resTextForm,
        "resLb",
        args, 
        ac);
    XtManageChild(resLb);
    
    ac = 0;
    XtSetArg(args[ac], XmNx, 142); ac++;
    XtSetArg(args[ac], XmNy, 432); ac++;
    XtSetArg(args[ac], XmNwidth, 72); ac++;
    XtSetArg(args[ac], XmNheight, 36); ac++;
    resUpdatePB = XmCreatePushButton(resForm,
        "resUpdatePB",
        args, 
        ac);
    XtManageChild(resUpdatePB);
    
    ac = 0;
    XtSetArg(args[ac], XmNx, 398); ac++;
    XtSetArg(args[ac], XmNy, 432); ac++;
    XtSetArg(args[ac], XmNwidth, 72); ac++;
    XtSetArg(args[ac], XmNheight, 36); ac++;
    resCancelPB = XmCreatePushButton(resForm,
        "resCancelPB",
        args, 
        ac);
    XtManageChild(resCancelPB);
    
    ac = 0;
    XtSetArg(args[ac], XmNx, 0); ac++;
    XtSetArg(args[ac], XmNy, 0); ac++;
    XtSetArg(args[ac], XmNwidth, 612); ac++;
    XtSetArg(args[ac], XmNheight, 34); ac++;
    resMenuBar = XmCreateMenuBar(resForm,
        "resMenuBar",
        args, 
        ac);
    XtManageChild(resMenuBar);
    
    ac = 0;
    XtSetArg(args[ac], XmNx, 5); ac++;
    XtSetArg(args[ac], XmNy, 5); ac++;
    XtSetArg(args[ac], XmNwidth, 41); ac++;
    XtSetArg(args[ac], XmNheight, 24); ac++;
    fileCascadeButton3 = XmCreateCascadeButton(resMenuBar,
        "fileCascadeButton3",
        args, 
        ac);
    XtManageChild(fileCascadeButton3);
    file_button_cb(fileCascadeButton3, (XtPointer)0, (XtPointer)0);
    
    ac = 0;
    filePulldownMenu3 = XmCreatePulldownMenu(XtParent(fileCascadeButton3),
        "filePulldownMenu3",
        args, 
        ac);
    
    ac = 0;
    XtSetArg(args[ac], XmNrecomputeSize, False); ac++;
    resPrintPB = XmCreatePushButton(filePulldownMenu3,
        "resPrintPB",
        args, 
        ac);
    XtManageChild(resPrintPB);
    
    ac = 0;
    XtSetArg(args[ac], XmNrecomputeSize, False); ac++;
    XtSetArg(args[ac], XmNsensitive, False); ac++;
    resSavePB = XmCreatePushButton(filePulldownMenu3,
        "resSavePB",
        args, 
        ac);
    XtManageChild(resSavePB);
    
    ac = 0;
    XtSetArg(args[ac], XmNrecomputeSize, False); ac++;
    resSaveAsPB = XmCreatePushButton(filePulldownMenu3,
        "resSaveAsPB",
        args, 
        ac);
    XtManageChild(resSaveAsPB);
    
    ac = 0;
    XtSetArg(args[ac], XmNrecomputeSize, False); ac++;
    resDismissPB = XmCreatePushButton(filePulldownMenu3,
        "resDismissPB",
        args, 
        ac);
    XtManageChild(resDismissPB);

    ac = 0;
    XtSetArg(args[ac], XmNsubMenuId, filePulldownMenu3); ac++;
    XtSetValues(fileCascadeButton3, args, ac);
    
    ac = 0;
    XtSetArg(args[ac], XmNx, 46); ac++;
    XtSetArg(args[ac], XmNy, 5); ac++;
    XtSetArg(args[ac], XmNwidth, 43); ac++;
    XtSetArg(args[ac], XmNheight, 24); ac++;
    editCascadeButton3 = XmCreateCascadeButton(resMenuBar,
        "editCascadeButton3",
        args, 
        ac);
    XtManageChild(editCascadeButton3);
    
    ac = 0;
    editPulldownMenu3 = XmCreatePulldownMenu(XtParent(editCascadeButton3),
        "editPulldownMenu3",
        args, 
        ac);
    
    ac = 0;
    resUndoPB = XmCreatePushButton(editPulldownMenu3,
        "resUndoPB",
        args, 
        ac);
    XtManageChild(resUndoPB);
    
    ac = 0;
    XtSetArg(args[ac], XmNrecomputeSize, False); ac++;
    resCutPB = XmCreatePushButton(editPulldownMenu3,
        "resCutPB",
        args, 
        ac);
    XtManageChild(resCutPB);
    
    ac = 0;
    XtSetArg(args[ac], XmNrecomputeSize, False); ac++;
    resCopyPB = XmCreatePushButton(editPulldownMenu3,
        "resCopyPB",
        args, 
        ac);
    XtManageChild(resCopyPB);
    
    ac = 0;
    XtSetArg(args[ac], XmNrecomputeSize, False); ac++;
    resPastePB = XmCreatePushButton(editPulldownMenu3,
        "resPastePB",
        args, 
        ac);
    XtManageChild(resPastePB);
    
    ac = 0;
    XtSetArg(args[ac], XmNrecomputeSize, False); ac++;
    resTextDeletePB = XmCreatePushButton(editPulldownMenu3,
        "resTextDeletePB",
        args, 
        ac);
    XtManageChild(resTextDeletePB);
    
    ac = 0;
    XtSetArg(args[ac], XmNsubMenuId, editPulldownMenu3); ac++;
    XtSetValues(editCascadeButton3, args, ac);
    
    ac = 0;
    XtSetArg(args[ac], XmNx, 1); ac++;
    XtSetArg(args[ac], XmNy, 409); ac++;
    XtSetArg(args[ac], XmNwidth, 610); ac++;
    XtSetArg(args[ac], XmNheight, 20); ac++;
    resSep = XmCreateSeparator(resForm,
        "resSep",
        args, 
        ac);
    XtManageChild(resSep);
    
/* Position XmNdefaultButton */

    ac = 0;
    XtSetArg(args[ac], XmNdefaultButton, resUpdatePB); ac++;
    XtSetValues(resForm, args, ac);
    
/* Position the attachments */
    
    ac = 0;
    XtSetArg(args[ac], XmNtopAttachment, XmATTACH_FORM); ac++;
    XtSetArg(args[ac], XmNbottomAttachment, XmATTACH_FORM); ac++;
    XtSetArg(args[ac], XmNleftAttachment, XmATTACH_FORM); ac++;
    XtSetArg(args[ac], XmNrightAttachment, XmATTACH_FORM); ac++;
    XtSetArg(args[ac], XmNtopOffset, 40); ac++;
    XtSetArg(args[ac], XmNbottomOffset, 56); ac++;
    XtSetArg(args[ac], XmNleftOffset, 1); ac++;
    XtSetArg(args[ac], XmNrightOffset, 1); ac++;
    XtSetValues(resTextForm, args, ac);
    
    ac = 0;
    XtSetArg(args[ac], XmNtopAttachment, XmATTACH_FORM); ac++;
    XtSetArg(args[ac], XmNbottomAttachment, XmATTACH_FORM); ac++;
    XtSetArg(args[ac], XmNleftAttachment, XmATTACH_FORM); ac++;
    XtSetArg(args[ac], XmNrightAttachment, XmATTACH_FORM); ac++;
    XtSetArg(args[ac], XmNtopOffset, 30); ac++;
    XtSetArg(args[ac], XmNbottomOffset, 0); ac++;
    XtSetArg(args[ac], XmNleftOffset, 5); ac++;
    XtSetArg(args[ac], XmNrightOffset, 5); ac++;
    XtSetValues(resSW, args, ac);
    
    ac = 0;
    XtSetArg(args[ac], XmNleftAttachment, XmATTACH_FORM); ac++;
    XtSetArg(args[ac], XmNtopOffset, 0); ac++;
    XtSetArg(args[ac], XmNleftOffset, 0); ac++;
    XtSetValues(resLb, args, ac);
    
    ac = 0;
    XtSetArg(args[ac], XmNtopAttachment, XmATTACH_NONE); ac++;
    XtSetArg(args[ac], XmNbottomAttachment, XmATTACH_FORM); ac++;
    XtSetArg(args[ac], XmNleftAttachment, XmATTACH_NONE); ac++;
    XtSetArg(args[ac], XmNrightAttachment, XmATTACH_POSITION); ac++;
    XtSetArg(args[ac], XmNrightPosition, 35); ac++;
    XtSetArg(args[ac], XmNbottomOffset, 1); ac++;
    XtSetArg(args[ac], XmNrightOffset, 0); ac++;
    XtSetValues(resUpdatePB, args, ac);
    
    ac = 0;
    XtSetArg(args[ac], XmNtopAttachment, XmATTACH_NONE); ac++;
    XtSetArg(args[ac], XmNbottomAttachment, XmATTACH_FORM); ac++;
    XtSetArg(args[ac], XmNleftAttachment, XmATTACH_POSITION); ac++;
    XtSetArg(args[ac], XmNrightAttachment, XmATTACH_NONE); ac++;
    XtSetArg(args[ac], XmNleftPosition, 65); ac++;
    XtSetArg(args[ac], XmNbottomOffset, 1); ac++;
    XtSetArg(args[ac], XmNrightOffset, 0); ac++;
    XtSetValues(resCancelPB, args, ac);
    
    ac = 0;
    XtSetArg(args[ac], XmNleftAttachment, XmATTACH_FORM); ac++;
    XtSetArg(args[ac], XmNrightAttachment, XmATTACH_FORM); ac++;
    XtSetArg(args[ac], XmNtopOffset, 0); ac++;
    XtSetArg(args[ac], XmNleftOffset, 0); ac++;
    XtSetArg(args[ac], XmNrightOffset, 0); ac++;
    XtSetValues(resMenuBar, args, ac);
    
    ac = 0;
    XtSetArg(args[ac], XmNtopAttachment, XmATTACH_NONE); ac++;
    XtSetArg(args[ac], XmNbottomAttachment, XmATTACH_FORM); ac++;
    XtSetArg(args[ac], XmNleftAttachment, XmATTACH_FORM); ac++;
    XtSetArg(args[ac], XmNrightAttachment, XmATTACH_FORM); ac++;
    XtSetArg(args[ac], XmNbottomOffset, 40); ac++;
    XtSetArg(args[ac], XmNleftOffset, 1); ac++;
    XtSetArg(args[ac], XmNrightOffset, 1); ac++;
    XtSetValues(resSep, args, ac);
    
/*************************** CALLBACK ATTACHMENTS ***************************/

    XtAddCallback(resUpdatePB, XmNactivateCallback, ResPrepareUpdateCb, (XtPointer)index);
    XtAddCallback(resUpdatePB, XmNactivateCallback, DialogCb, (XtPointer)ResUpdateBoxID);
    XtAddCallback(resCancelPB, XmNactivateCallback, ResDismissCb,  (XtPointer)index);
    XtAddCallback(resPrintPB, XmNactivateCallback, ResPreparePrintCb, (XtPointer)index);
    XtAddCallback(resPrintPB, XmNactivateCallback, DialogCb, (XtPointer)PrintFormID);
    XtAddCallback(resDismissPB, XmNactivateCallback, ResDismissCb, (XtPointer)index);
    XtAddCallback(resSavePB, XmNactivateCallback, ResSaveCb, (XtPointer)index);
    XtAddCallback(resSaveAsPB, XmNactivateCallback, ResSaveShowFileSelCb, (XtPointer)index);
    XtAddCallback(resUndoPB, XmNactivateCallback, ResUndoCb, (XtPointer)index);
    XtAddCallback(resCutPB, XmNactivateCallback, ResCutCb, (XtPointer)index);
    XtAddCallback(resCopyPB, XmNactivateCallback, ResCopyCb, (XtPointer)index);
    XtAddCallback(resPastePB, XmNactivateCallback, ResPasteCb, (XtPointer)index);
    XtAddCallback(resTextDeletePB, XmNactivateCallback, ResDeleteCb, (XtPointer)index);

/*************************** END OF CREATION CODE ***************************/    
    
    
/* Position the title following res_filter */

	s=malloc((strlen(res_filter)+strlen("Resources matching ")+1)*sizeof(char));
	sprintf(s, "Resources matching %s", res_filter);
	xsSetTitle(resForm, s);
	free(s);
	
/* Create the associated struct upkeeping info to manipulate the window */

	create_res_struct(index, res_filter, resForm, resText);
}


/************************************************************************
*									*
*		xsDevDcHdbWindowCreate :				*
*		----------------------					*
*									*
*************************************************************************/

void xsDevDcHdbWindowCreate(Widget rootparent, Widget mainWindow, 
		            int index, char *dev_name)
{
/* Variable declarations */

    Arg      args[20];
    Cardinal ac=0;
    Boolean  argok=False;

    Widget   devDcDialogShell;
    Widget   devDcForm;
    Widget   devDcDeletePB;
    Widget   devDcUpdatePB;
    Widget   devDcCancelPB;
    Widget   devDcRestartPB;
    Widget   devDcPingPB;
    Widget   devDcMenuBar;
    Widget   devDcfileCascadeButton2;
    Widget   devDcfilePulldownMenu2;
    Widget   devDcPrintPB;
    Widget   devDcDismissPB;
    Widget   devDcSavePB;
    Widget   devDcSaveAsPB;
    Widget   devDceditCascadeButton2;
    Widget   devDceditPulldownMenu2;
    Widget   devDcUndoPB;
    Widget   devDcCutPB;
    Widget   devDcCopyPB;
    Widget   devDcPastePB;
    Widget   devDcTextDeletePB;
    Widget   devDcChainResPB;
    Widget   devDcSep;
    Widget   devDcPanedWindow;
    Widget   devDcDevInfoForm;
    Widget   devDcDevInfoSW;
    Widget   devDcDevInfoText;
    Widget   devDcDevInfoLb;
    Widget   devDcInfoForm;
    Widget   devDcInfoSW;
    Widget   devDcInfoText;
    Widget   devDcInfoLb;
    Widget   devDcResForm;
    Widget   devDcResSW;
    Widget   devDcResText;
    Widget   devDcResLb;
    
    char s[256]; /* to formate little strings */
    
/* Creation Code without callbacks attachments */

    ac = 0;
    XtSetArg(args[ac], XmNtitle, "devDcDialogShell"); ac++;
    XtSetArg(args[ac], XmNwidth, 616); ac++;
    XtSetArg(args[ac], XmNheight, 860); ac++;
    XtSetArg(args[ac], XmNmwmFunctions, MWM_FUNC_ALL|MWM_FUNC_CLOSE); ac++;
    devDcDialogShell = XtCreatePopupShell("devDcDialogShell",
        xmDialogShellWidgetClass,
        mainWindow,
        args, 
        ac);
    
    ac = 0;
    XtSetArg(args[ac], XmNautoUnmanage, False); ac++;
    XtSetArg(args[ac], XmNdialogStyle, XmDIALOG_MODELESS); ac++;
    XtSetArg(args[ac], XmNx, 653); ac++;
    XtSetArg(args[ac], XmNy, 33); ac++;
    XtSetArg(args[ac], XmNwidth, 616); ac++;
    XtSetArg(args[ac], XmNheight, 854); ac++;
    devDcForm = XmCreateForm(devDcDialogShell,
        "devDcForm",
        args, 
        ac);
	
    ac = 0;
    XtSetArg(args[ac], XmNsensitive, True); ac++;
    XtSetArg(args[ac], XmNx, 502); ac++;
    XtSetArg(args[ac], XmNy, 686); ac++;
    XtSetArg(args[ac], XmNwidth, 72); ac++;
    XtSetArg(args[ac], XmNheight, 36); ac++;
    devDcRestartPB = XmCreatePushButton(devDcForm,
        "devDcRestartPB",
        args, 
        ac);
    XtManageChild(devDcRestartPB);
    
    ac = 0;
    XtSetArg(args[ac], XmNx, 387); ac++;
    XtSetArg(args[ac], XmNy, 686); ac++;
    XtSetArg(args[ac], XmNwidth, 72); ac++;
    XtSetArg(args[ac], XmNheight, 36); ac++;
    devDcPingPB = XmCreatePushButton(devDcForm,
        "devDcPingPB",
        args, 
        ac);
    XtManageChild(devDcPingPB);
        
    ac = 0;
    XtSetArg(args[ac], XmNx, 436); ac++;
    XtSetArg(args[ac], XmNy, 811); ac++;
    XtSetArg(args[ac], XmNwidth, 72); ac++;
    XtSetArg(args[ac], XmNheight, 36); ac++;
    devDcDeletePB = XmCreatePushButton(devDcForm,
        "devDcDeletePB",
        args, 
        ac);
    XtManageChild(devDcDeletePB);
    
    ac = 0;
    XtSetArg(args[ac], XmNx, 92); ac++;
    XtSetArg(args[ac], XmNy, 811); ac++;
    XtSetArg(args[ac], XmNwidth, 72); ac++;
    XtSetArg(args[ac], XmNheight, 36); ac++;
    devDcUpdatePB = XmCreatePushButton(devDcForm,
        "devDcUpdatePB",
        args, 
        ac);
    XtManageChild(devDcUpdatePB);
    
    ac = 0;
    XtSetArg(args[ac], XmNx, 264); ac++;
    XtSetArg(args[ac], XmNy, 811); ac++;
    XtSetArg(args[ac], XmNwidth, 72); ac++;
    XtSetArg(args[ac], XmNheight, 36); ac++;
    devDcCancelPB = XmCreatePushButton(devDcForm,
        "devDcCancelPB",
        args, 
        ac);
    XtManageChild(devDcCancelPB);
    
    ac = 0;
    XtSetArg(args[ac], XmNx, 0); ac++;
    XtSetArg(args[ac], XmNy, 0); ac++;
    XtSetArg(args[ac], XmNwidth, 616); ac++;
    XtSetArg(args[ac], XmNheight, 34); ac++;
    devDcMenuBar = XmCreateMenuBar(devDcForm,
        "devDcMenuBar",
        args, 
        ac);
    XtManageChild(devDcMenuBar);
    
    ac = 0;
    XtSetArg(args[ac], XmNx, 5); ac++;
    XtSetArg(args[ac], XmNy, 5); ac++;
    XtSetArg(args[ac], XmNwidth, 41); ac++;
    XtSetArg(args[ac], XmNheight, 24); ac++;
    devDcfileCascadeButton2 = XmCreateCascadeButton(devDcMenuBar,
        "devDcfileCascadeButton2",
        args, 
        ac);
    XtManageChild(devDcfileCascadeButton2);
    file_button_cb(devDcfileCascadeButton2, (XtPointer)0, (XtPointer)0);
    
    ac = 0;
    devDcfilePulldownMenu2 = XmCreatePulldownMenu(XtParent(devDcfileCascadeButton2),
        "devDcfilePulldownMenu2",
        args, 
        ac);
    
    ac = 0;
    XtSetArg(args[ac], XmNrecomputeSize, False); ac++;
    devDcPrintPB = XmCreatePushButton(devDcfilePulldownMenu2,
        "devDcPrintPB",
        args, 
        ac);
    XtManageChild(devDcPrintPB);
    
    ac = 0;
    XtSetArg(args[ac], XmNrecomputeSize, False); ac++;
    XtSetArg(args[ac], XmNsensitive, False); ac++;
    devDcSavePB = XmCreatePushButton(devDcfilePulldownMenu2,
        "devDcSavePB",
        args, 
        ac);
    XtManageChild(devDcSavePB);
    
    ac = 0;
    XtSetArg(args[ac], XmNrecomputeSize, False); ac++;
    devDcSaveAsPB = XmCreatePushButton(devDcfilePulldownMenu2,
        "devDcSaveAsPB",
        args, 
        ac);
    XtManageChild(devDcSaveAsPB);
    
    ac = 0;
    XtSetArg(args[ac], XmNrecomputeSize, False); ac++;
    devDcDismissPB = XmCreatePushButton(devDcfilePulldownMenu2,
        "devDcDismissPB",
        args, 
        ac);
    XtManageChild(devDcDismissPB);

    ac = 0;
    XtSetArg(args[ac], XmNsubMenuId, devDcfilePulldownMenu2); ac++;
    XtSetValues(devDcfileCascadeButton2, args, ac);
    
    ac = 0;
    XtSetArg(args[ac], XmNx, 46); ac++;
    XtSetArg(args[ac], XmNy, 5); ac++;
    XtSetArg(args[ac], XmNwidth, 43); ac++;
    XtSetArg(args[ac], XmNheight, 24); ac++;
    devDceditCascadeButton2 = XmCreateCascadeButton(devDcMenuBar,
        "devDceditCascadeButton2",
        args, 
        ac);
    XtManageChild(devDceditCascadeButton2);
    
    ac = 0;
    devDceditPulldownMenu2 = XmCreatePulldownMenu(XtParent(devDceditCascadeButton2),
        "devDceditPulldownMenu2",
        args, 
        ac);
    
    ac = 0;
    devDcUndoPB = XmCreatePushButton(devDceditPulldownMenu2,
        "devDcUndoPB",
        args, 
        ac);
    XtManageChild(devDcUndoPB);
    
    ac = 0;
    XtSetArg(args[ac], XmNrecomputeSize, False); ac++;
    devDcCutPB = XmCreatePushButton(devDceditPulldownMenu2,
        "devDcCutPB",
        args, 
        ac);
    XtManageChild(devDcCutPB);
    
    ac = 0;
    XtSetArg(args[ac], XmNrecomputeSize, False); ac++;
    devDcCopyPB = XmCreatePushButton(devDceditPulldownMenu2,
        "devDcCopyPB",
        args, 
        ac);
    XtManageChild(devDcCopyPB);
    
    ac = 0;
    XtSetArg(args[ac], XmNrecomputeSize, False); ac++;
    devDcPastePB = XmCreatePushButton(devDceditPulldownMenu2,
        "devDcPastePB",
        args, 
        ac);
    XtManageChild(devDcPastePB);
    
    ac = 0;
    XtSetArg(args[ac], XmNrecomputeSize, False); ac++;
    devDcTextDeletePB = XmCreatePushButton(devDceditPulldownMenu2,
        "devDcTextDeletePB",
        args, 
        ac);
    XtManageChild(devDcTextDeletePB);
    
    ac = 0;
    XtSetArg(args[ac], XmNrecomputeSize, False); ac++;
    devDcChainResPB = XmCreatePushButton(devDceditPulldownMenu2,
        "devDcChainResPB",
        args, 
        ac);
    XtManageChild(devDcChainResPB);
    
    
    ac = 0;
    XtSetArg(args[ac], XmNsubMenuId, devDceditPulldownMenu2); ac++;
    XtSetValues(devDceditCascadeButton2, args, ac);
    
    ac = 0;
    XtSetArg(args[ac], XmNx, 1); ac++;
    XtSetArg(args[ac], XmNy, 800); ac++;
    XtSetArg(args[ac], XmNwidth, 614); ac++;
    XtSetArg(args[ac], XmNheight, 20); ac++;
    devDcSep = XmCreateSeparator(devDcForm,
        "devDcSep",
        args, 
        ac);
    XtManageChild(devDcSep);
    
    ac = 0;
    XtSetArg(args[ac], XmNx, 1); ac++;
    XtSetArg(args[ac], XmNy, 40); ac++;
    XtSetArg(args[ac], XmNwidth, 614); ac++;
    XtSetArg(args[ac], XmNheight, 758); ac++;
    devDcPanedWindow = XmCreatePanedWindow(devDcForm,
        "devDcPanedWindow",
        args, 
        ac);
    XtManageChild(devDcPanedWindow);
    
    ac = 0;
    XtSetArg(args[ac], XmNwidth, 608); ac++;
    XtSetArg(args[ac], XmNheight, 172); ac++;
    devDcDevInfoForm = XmCreateForm(devDcPanedWindow,
        "devDcDevInfoForm",
        args, 
        ac);
    XtManageChild(devDcDevInfoForm);
    
    ac = 0;
    XtSetArg(args[ac], XmNx, 5); ac++;
    XtSetArg(args[ac], XmNy, 30); ac++;
    XtSetArg(args[ac], XmNwidth, 598); ac++;
    XtSetArg(args[ac], XmNheight, 132); ac++;
    devDcDevInfoSW = XmCreateScrolledWindow(devDcDevInfoForm,
        "devDcDevInfoSW",
        args, 
        ac);
    XtManageChild(devDcDevInfoSW);
    
    ac = 0;
    XtSetArg(args[ac], XmNeditMode, XmMULTI_LINE_EDIT); ac++;
    XtSetArg(args[ac], XmNeditable, False); ac++;
    devDcDevInfoText = XmCreateText(devDcDevInfoSW,
        "devDcDevInfoText",
        args, 
        ac);
    XtManageChild(devDcDevInfoText);
    
    ac = 0;
    XtSetArg(args[ac], XmNalignment, XmALIGNMENT_BEGINNING); ac++;
    XtSetArg(args[ac], XmNx, 0); ac++;
    XtSetArg(args[ac], XmNy, 0); ac++;
    XtSetArg(args[ac], XmNwidth, 139); ac++;
    XtSetArg(args[ac], XmNheight, 40); ac++;
    devDcDevInfoLb = XmCreateLabel(devDcDevInfoForm,
        "devDcDevInfoLb",
        args, 
        ac);
    XtManageChild(devDcDevInfoLb);
    
    ac = 0;
    XtSetArg(args[ac], XmNwidth, 608); ac++;
    XtSetArg(args[ac], XmNheight, 167); ac++;
    devDcInfoForm = XmCreateForm(devDcPanedWindow,
        "devDcInfoForm",
        args, 
        ac);
    XtManageChild(devDcInfoForm);
    
    ac = 0;
    XtSetArg(args[ac], XmNx, 5); ac++;
    XtSetArg(args[ac], XmNy, 30); ac++;
    XtSetArg(args[ac], XmNwidth, 598); ac++;
    XtSetArg(args[ac], XmNheight, 137); ac++;
    devDcInfoSW = XmCreateScrolledWindow(devDcInfoForm,
        "devDcInfoSW",
        args, 
        ac);
    XtManageChild(devDcInfoSW);
    
    ac = 0;
    XtSetArg(args[ac], XmNeditMode, XmMULTI_LINE_EDIT); ac++;
    XtSetArg(args[ac], XmNeditable, False); ac++;
    devDcInfoText = XmCreateText(devDcInfoSW,
        "devDcInfoText",
        args, 
        ac);
    XtManageChild(devDcInfoText);
    
    ac = 0;
    XtSetArg(args[ac], XmNalignment, XmALIGNMENT_BEGINNING); ac++;
    XtSetArg(args[ac], XmNx, 0); ac++;
    XtSetArg(args[ac], XmNy, 0); ac++;
    XtSetArg(args[ac], XmNwidth, 207); ac++;
    XtSetArg(args[ac], XmNheight, 40); ac++;
    devDcInfoLb = XmCreateLabel(devDcInfoForm,
        "devDcInfoLb",
        args, 
        ac);
    XtManageChild(devDcInfoLb);
    
    ac = 0;
    XtSetArg(args[ac], XmNwidth, 608); ac++;
    XtSetArg(args[ac], XmNheight, 397); ac++;
    devDcResForm = XmCreateForm(devDcPanedWindow,
        "devDcResForm",
        args, 
        ac);
    XtManageChild(devDcResForm);
    
    ac = 0;
    XtSetArg(args[ac], XmNx, 5); ac++;
    XtSetArg(args[ac], XmNy, 30); ac++;
    XtSetArg(args[ac], XmNwidth, 598); ac++;
    XtSetArg(args[ac], XmNheight, 367); ac++;
    devDcResSW = XmCreateScrolledWindow(devDcResForm,
        "devDcResSW",
        args, 
        ac);
    XtManageChild(devDcResSW);
    
    ac = 0;
    XtSetArg(args[ac], XmNeditMode, XmMULTI_LINE_EDIT); ac++;
    devDcResText = XmCreateText(devDcResSW,
        "devDcResText",
        args, 
        ac);
    XtManageChild(devDcResText);
    
    ac = 0;
    XtSetArg(args[ac], XmNalignment, XmALIGNMENT_BEGINNING); ac++;
    XtSetArg(args[ac], XmNx, 0); ac++;
    XtSetArg(args[ac], XmNy, 0); ac++;
    XtSetArg(args[ac], XmNwidth, 120); ac++;
    XtSetArg(args[ac], XmNheight, 40); ac++;
    devDcResLb = XmCreateLabel(devDcResForm,
        "devDcResLb",
        args, 
        ac);
    XtManageChild(devDcResLb);

/* Position XmNdefaultButton */

    ac = 0;
    XtSetArg(args[ac], XmNdefaultButton, devDcUpdatePB); ac++;
    XtSetValues(devDcForm, args, ac);

/* Position the attachments */

    ac = 0;
    XtSetArg(args[ac], XmNtopAttachment, XmATTACH_NONE); ac++;
    XtSetArg(args[ac], XmNbottomAttachment, XmATTACH_FORM); ac++;
    XtSetArg(args[ac], XmNleftAttachment, XmATTACH_POSITION); ac++;
    XtSetArg(args[ac], XmNrightAttachment, XmATTACH_NONE); ac++;
    XtSetArg(args[ac], XmNleftPosition, 83); ac++;
    XtSetArg(args[ac], XmNbottomOffset, 3); ac++;
    XtSetArg(args[ac], XmNleftOffset, 0); ac++;
    XtSetValues(devDcRestartPB, args, ac);
    
    ac = 0;
    XtSetArg(args[ac], XmNtopAttachment, XmATTACH_NONE); ac++;
    XtSetArg(args[ac], XmNbottomAttachment, XmATTACH_FORM); ac++;
    XtSetArg(args[ac], XmNleftAttachment, XmATTACH_POSITION); ac++;
    XtSetArg(args[ac], XmNrightAttachment, XmATTACH_NONE); ac++;
    XtSetArg(args[ac], XmNleftPosition, 64); ac++;
    XtSetArg(args[ac], XmNbottomOffset, 3); ac++;
    XtSetArg(args[ac], XmNleftOffset, 0); ac++;
    XtSetValues(devDcPingPB, args, ac); 
       
    ac = 0;
    XtSetArg(args[ac], XmNtopAttachment, XmATTACH_NONE); ac++;
    XtSetArg(args[ac], XmNbottomAttachment, XmATTACH_FORM); ac++;
    XtSetArg(args[ac], XmNleftAttachment, XmATTACH_POSITION); ac++;
    XtSetArg(args[ac], XmNrightAttachment, XmATTACH_NONE); ac++;
    XtSetArg(args[ac], XmNleftPosition, 44); ac++;
    XtSetArg(args[ac], XmNbottomOffset, 3); ac++;
    XtSetArg(args[ac], XmNrightOffset, 0); ac++;
    XtSetValues(devDcDeletePB, args, ac);
    
    ac = 0;
    XtSetArg(args[ac], XmNtopAttachment, XmATTACH_NONE); ac++;
    XtSetArg(args[ac], XmNbottomAttachment, XmATTACH_FORM); ac++;
    XtSetArg(args[ac], XmNleftAttachment, XmATTACH_POSITION); ac++;
    XtSetArg(args[ac], XmNrightAttachment, XmATTACH_NONE); ac++;
    XtSetArg(args[ac], XmNleftPosition, 5); ac++;
    XtSetArg(args[ac], XmNbottomOffset, 3); ac++;
    XtSetArg(args[ac], XmNrightOffset, 0); ac++;
    XtSetValues(devDcUpdatePB, args, ac);
    
    ac = 0;
    XtSetArg(args[ac], XmNtopAttachment, XmATTACH_NONE); ac++;
    XtSetArg(args[ac], XmNbottomAttachment, XmATTACH_FORM); ac++;
    XtSetArg(args[ac], XmNleftAttachment, XmATTACH_POSITION); ac++;
    XtSetArg(args[ac], XmNrightAttachment, XmATTACH_NONE); ac++;
    XtSetArg(args[ac], XmNleftPosition, 25); ac++;
    XtSetArg(args[ac], XmNbottomOffset, 3); ac++;
    XtSetArg(args[ac], XmNrightOffset, 0); ac++;
    XtSetValues(devDcCancelPB, args, ac);
    
    ac = 0;
    XtSetArg(args[ac], XmNleftAttachment, XmATTACH_FORM); ac++;
    XtSetArg(args[ac], XmNrightAttachment, XmATTACH_FORM); ac++;
    XtSetArg(args[ac], XmNtopOffset, 0); ac++;
    XtSetArg(args[ac], XmNleftOffset, 0); ac++;
    XtSetArg(args[ac], XmNrightOffset, 0); ac++;
    XtSetValues(devDcMenuBar, args, ac);
    
    ac = 0;
    XtSetArg(args[ac], XmNtopAttachment, XmATTACH_NONE); ac++;
    XtSetArg(args[ac], XmNbottomAttachment, XmATTACH_FORM); ac++;
    XtSetArg(args[ac], XmNleftAttachment, XmATTACH_FORM); ac++;
    XtSetArg(args[ac], XmNrightAttachment, XmATTACH_FORM); ac++;
    XtSetArg(args[ac], XmNbottomOffset, 40); ac++;
    XtSetArg(args[ac], XmNleftOffset, 1); ac++;
    XtSetArg(args[ac], XmNrightOffset, 1); ac++;
    XtSetValues(devDcSep, args, ac);
    
    ac = 0;
    XtSetArg(args[ac], XmNtopAttachment, XmATTACH_FORM); ac++;
    XtSetArg(args[ac], XmNbottomAttachment, XmATTACH_FORM); ac++;
    XtSetArg(args[ac], XmNleftAttachment, XmATTACH_FORM); ac++;
    XtSetArg(args[ac], XmNrightAttachment, XmATTACH_FORM); ac++;
    XtSetArg(args[ac], XmNtopOffset, 40); ac++;
    XtSetArg(args[ac], XmNbottomOffset, 56); ac++;
    XtSetArg(args[ac], XmNleftOffset, 1); ac++;
    XtSetArg(args[ac], XmNrightOffset, 1); ac++;
    XtSetValues(devDcPanedWindow, args, ac);
    
    ac = 0;
    XtSetArg(args[ac], XmNtopAttachment, XmATTACH_FORM); ac++;
    XtSetArg(args[ac], XmNbottomAttachment, XmATTACH_FORM); ac++;
    XtSetArg(args[ac], XmNleftAttachment, XmATTACH_FORM); ac++;
    XtSetArg(args[ac], XmNrightAttachment, XmATTACH_FORM); ac++;
    XtSetArg(args[ac], XmNtopOffset, 30); ac++;
    XtSetArg(args[ac], XmNbottomOffset, 10); ac++;
    XtSetArg(args[ac], XmNleftOffset, 5); ac++;
    XtSetArg(args[ac], XmNrightOffset, 5); ac++;
    XtSetValues(devDcDevInfoSW, args, ac);
    
    ac = 0;
    XtSetArg(args[ac], XmNtopOffset, 0); ac++;
    XtSetArg(args[ac], XmNleftOffset, 0); ac++;
    XtSetValues(devDcDevInfoLb, args, ac);
    
    ac = 0;
    XtSetArg(args[ac], XmNtopAttachment, XmATTACH_FORM); ac++;
    XtSetArg(args[ac], XmNbottomAttachment, XmATTACH_FORM); ac++;
    XtSetArg(args[ac], XmNleftAttachment, XmATTACH_FORM); ac++;
    XtSetArg(args[ac], XmNrightAttachment, XmATTACH_FORM); ac++;
    XtSetArg(args[ac], XmNtopOffset, 30); ac++;
    XtSetArg(args[ac], XmNbottomOffset, 0); ac++;
    XtSetArg(args[ac], XmNleftOffset, 5); ac++;
    XtSetArg(args[ac], XmNrightOffset, 5); ac++;
    XtSetValues(devDcInfoSW, args, ac);
    
    ac = 0;
    XtSetArg(args[ac], XmNtopOffset, 0); ac++;
    XtSetArg(args[ac], XmNleftOffset, 0); ac++;
    XtSetValues(devDcInfoLb, args, ac);
    
    ac = 0;
    XtSetArg(args[ac], XmNtopAttachment, XmATTACH_FORM); ac++;
    XtSetArg(args[ac], XmNbottomAttachment, XmATTACH_FORM); ac++;
    XtSetArg(args[ac], XmNleftAttachment, XmATTACH_FORM); ac++;
    XtSetArg(args[ac], XmNrightAttachment, XmATTACH_FORM); ac++;
    XtSetArg(args[ac], XmNtopOffset, 30); ac++;
    XtSetArg(args[ac], XmNbottomOffset, 0); ac++;
    XtSetArg(args[ac], XmNleftOffset, 5); ac++;
    XtSetArg(args[ac], XmNrightOffset, 5); ac++;
    XtSetValues(devDcResSW, args, ac);
    
    ac = 0;
    XtSetArg(args[ac], XmNtopOffset, 0); ac++;
    XtSetArg(args[ac], XmNleftOffset, 0); ac++;
    XtSetValues(devDcResLb, args, ac);

/*************************** CALLBACK ATTACHMENTS ***************************/

    XtAddCallback(devDcUpdatePB, XmNactivateCallback, DevDcPrepareUpdateCb, (XtPointer)index);
    XtAddCallback(devDcUpdatePB, XmNactivateCallback, DialogCb, (XtPointer)DevUpdateBoxID);
    XtAddCallback(devDcCancelPB, XmNactivateCallback, DevDcDismissCb, (XtPointer)index);
    XtAddCallback(devDcDeletePB, XmNactivateCallback, PrepareDevDcDelCb, (XtPointer)index);
    XtAddCallback(devDcDeletePB, XmNactivateCallback, DialogCb, (XtPointer)DevDelOpFormID);
    XtAddCallback(devDcRestartPB, XmNactivateCallback, DevDcRestartCb, (XtPointer)index);
    XtAddCallback(devDcRestartPB, XmNactivateCallback, DialogCb, (XtPointer)ServRestartBoxID);
    XtAddCallback(devDcPingPB, XmNactivateCallback, DevDcPingCb, (XtPointer)index);
    XtAddCallback(devDcPrintPB, XmNactivateCallback, DevDcPreparePrintCb, (XtPointer)index);
    XtAddCallback(devDcPrintPB, XmNactivateCallback, DialogCb, (XtPointer)PrintFormID);
    XtAddCallback(devDcDismissPB, XmNactivateCallback, DevDcDismissCb, (XtPointer)index);
    XtAddCallback(devDcSavePB, XmNactivateCallback, DevDcSaveCb, (XtPointer)index);
    XtAddCallback(devDcSaveAsPB, XmNactivateCallback, DevDcSaveShowFileSelCb, (XtPointer)index);
    XtAddCallback(devDcUndoPB, XmNactivateCallback, DevDcUndoCb, (XtPointer)index);
    XtAddCallback(devDcCutPB, XmNactivateCallback, DevDcCutCb, (XtPointer)index);
    XtAddCallback(devDcCopyPB, XmNactivateCallback, DevDcCopyCb, (XtPointer)index);
    XtAddCallback(devDcPastePB, XmNactivateCallback, DevDcPasteCb, (XtPointer)index);
    XtAddCallback(devDcTextDeletePB, XmNactivateCallback, DevDcDeleteCb, (XtPointer)index);
    XtAddCallback(devDcChainResPB, XmNactivateCallback, DevDcChainResCb, (XtPointer)index);
    XtAddEventHandler(devDcResText, ButtonPressMask, True,
                                 devdc_reso_text_event_hand, (XtPointer) index);

/*************************** END OF CREATION CODE ***************************/    
    
/* Position the title following dev_name */

	sprintf(s, "Device %s", dev_name);
	xsSetTitle(devDcForm, s);
	
/* Create the associated struct upkeeping info to manipulate the window */

	create_dev_dc_struct(index, dev_name, devDcForm, devDcDevInfoText, 
			     devDcResText,devDcInfoText);
}

