static char RcsId[] =
"@(#)$Header: vgc_xdr.c,v 5.21 2001/11/12 10:01:36 goetz Rel $";

/*+*******************************************************************

 File:          vgc_xdr.c

 Project:       Device Servers with sun-rpc

 Description:   xdr_routines for vacuum gauge controller types.

 Author(s):     Jens Meyer

 Original:      January 1991

$Revision: 5.21 $
$Date: 2001/11/12 10:01:36 $

$Author: goetz $

$Log:	vgc_xdr.c,v $
 * Revision 5.21  2001/11/12  10:01:36  10:01:36  goetz (Andy Goetz)
 * updated C port for Windows 95/98/NT using Visual C++ 6
 * 
Revision 5.20  2001/01/08 12:17:35  goetz
added patch by B.Pedersen to support querying events

Revision 5.19  2000/10/02 12:08:45  goetz
removed stderr from api_xdr.c

Revision 5.18  1999/07/08 14:10:46  goetz
changed _LPfd_set type for Linux in macros.h

Revision 5.17  1998/05/25 17:59:36  klotz
fixed C++ prototypes in api_xdr.h

Revision 5.16  1998/04/29 10:23:58  goetz
macros.h - added __STDCPP__ for HP C++ compiler (aCC)

 * Revision 5.15  97/12/01  15:16:49  15:16:49  klotz (W.D. Klotz)
 * WIN_NT_95_released_NOV_97
 * 
 * Revision 4.34  97/01/30  13:58:34  13:58:34  goetz (Andy Goetz)
 * removed dev_printdebug() from DevXdrKernel.h
 * 
 * Revision 4.33  97/01/09  10:08:39  10:08:39  goetz (Andy Goetz)
 * (xdrproc_t) castings added to maxe_xdr, ram_xdr, thc_xdr, seism_xdr
 * 
 * Revision 4.32  97/01/08  16:48:28  16:48:28  goetz (Andy Goetz)
 * Ported to Linux (2.0.9)
 * 
Revision 4.31  1996/11/18 17:28:45  goetz
Check

 * Revision 4.28  96/10/21  16:22:17  16:22:17  taurel (E.Taurel)
 * Check_in_after_port_to_OS9/ISP_2.1_and_OS9/RPC1.4
 * 
 * Revision 4.27  96/09/17  16:40:25  16:40:25  klotz (W.D. Klotz)
 * WD Klotz: tested NT build  
 * 
 * Revision 4.26  96/07/19  10:00:59  10:00:59  taurel (E.Taurel)
 * Some_change_in_macros.h_for_the_API_port_to_OS-9_Ultra_C++
 * 
 * Revision 4.25  96/06/07  16:23:03  16:23:03  meyer (J.Meyer)
 * Corrected_elif_to_else_in_macros.h
 * 
 * Revision 4.24  96/06/05  15:01:36  15:01:36  meyer (J.Meyer)
 * Corrected_macros.h
 * 
 * Revision 4.23  96/06/03  13:10:15  13:10:15  meyer (J.Meyer)
 * Cleaned-up_MSDOS_and_added_porting_options_for_Windows_NT.
 * 
 * Revision 4.22  96/05/23  11:07:21  11:07:21  taurel (E.Taurel)
 * Added_some_definitions_for_C++_in_API_xdr.h_file
 * 
 * Revision 4.21  96/05/06  18:37:34  18:37:34  meyer (J.Meyer)
 * Fortran_compatibility_for:_dev_xdr.h,macros.h,maxe_xdr.h
 * 
 * Revision 4.20  96/02/27  13:31:35  13:31:35  meyer (J.Meyer)
 * Deleted_Cross_References_To_DSAPI_Library
 * 
 * Revision 4.19  96/01/11  17:40:20  17:40:20  meyer (Jens Meyer)
 * Added_#define_PORTMAP_to_macros.h.
 * 
 * Revision 4.18  95/12/21  10:33:25  10:33:25  meyer (Jens Meyer)
 * Corrected length calculation for D_VAR_MSTATARR.
 * 
 * Revision 4.17  95/08/02  16:05:11  16:05:11  meyer (Jens Meyer)
 * Corrected DevXdrKernel.h after C++ implementation.
 * 
 * Revision 4.15  95/03/02  10:27:48  10:27:48  meyer (Jens Meyer)
 * Added D_VAR_SFRPARR type to the kernel.
 * 
 * Revision 4.14  95/02/20  09:56:35  09:56:35  meyer (Jens Meyer)
 * Passed the compilers for HPUX, SUNOS and UCC after the first windows check in.
 * 
 * Revision 4.13  95/02/10  17:18:53  17:18:53  meyer (Jens Meyer)
 * Deleted
 * 
 * Revision 4.12  95/02/01  14:27:09  14:27:09  klotz (W.D. Klotz)
 * WDK: first successfull compile of dbase, api, xdr on WIN16/3.1
 * 
 * Revision 4.11  95/01/03  13:19:15  13:19:15  meyer (Jens Meyer)
 * Repared bug in dev_cmd_query() for version 3!
 * 
 * Revision 4.10  94/12/08  15:24:47  15:24:47  meyer (Jens Meyer)
 * Changed _manager_data in API_xdr and added old version to API_xdr_vers3.
 * 
 * Revision 4.9  94/11/28  17:04:08  17:04:08  meyer (Jens Meyer)
 * Data types for compatibility with library version 3.x
 * 
 * Revision 4.8  94/08/16  16:59:25  16:59:25  meyer (Jens Meyer)
 * Corrected error in ws_xdr.h
 * 
 * Revision 4.7  94/08/16  16:34:20  16:34:20  meyer (Jens Meyer)
 * Added define for MAX_RESOURCE_FIELD_LENGTH to macros.h
 * 
 * Revision 4.6  94/08/12  15:07:34  15:07:34  meyer (Jens Meyer)
 * Added valriable arguments to all API RPC structures.
 * 
 * Revision 4.5  94/07/20  18:15:37  18:15:37  meyer (Jens Meyer)
 * Changed include files in macros.h!
 * 
 * Revision 4.4  94/07/20  08:55:59  08:55:59  meyer (Jens Meyer)
 * All XDR functions with prototypes!
 * 
 * Revision 4.3  94/07/18  18:50:46  18:50:46  meyer (Jens Meyer)
 * Had to change macros.h, because #define must be in the first column!
 * 
 * Revision 4.2  94/07/18  18:22:27  18:22:27  meyer (Jens Meyer)
 * First test with PC macros for the XDR kernel.
 * 
 * Revision 4.1  94/05/02  10:50:39  10:50:39  meyer (Jens Meyer)
 * For Security System without connection count.
 * 
 * Revision 4.0  94/03/14  18:17:23  18:17:23  meyer (Jens Meyer)
 * Library version with Security System.
 * 
 * Revision 3.50  94/03/12  14:36:17  14:36:17  meyer (Jens Meyer)
 * Changed API xdr structures for security.
 * 
 * Revision 3.35  94/03/03  10:52:01  10:52:01  taurel (Emmanuel TAUREL)
 * Added unsigned long array type in the XDRkernel
 * 
 * Revision 3.34  94/03/03  10:28:54  10:28:54  taurel (Emmanuel TAUREL)
 * Added the unsigned long array type in
 * XDR kernel (LC and ET).
 * 
 * Revision 3.33  94/01/12  16:34:17  16:34:17  meyer (Jens Meyer)
 * Global XDR type array for data collector access
 * 
 * Revision 3.31  93/12/02  09:38:50  09:38:50  meyer (Jens Meyer)
 * New release with small XDR data type kernel.
 * 
 * Revision 1.1  93/12/01  15:29:35  15:29:35  meyer (Jens Meyer)
 * Initial revision
 * 

Copyright (c) 1990 by European Synchrotron Radiation Facility,
		      Grenoble, France

*******************************************************************-*/

#include <dev_xdr.h>
#include <vgc_xdr.h>


bool_t
xdr_DevVgcStat(xdrs, objp)
	XDR *xdrs;
	DevVgcStat *objp;
{
	if (!xdr_opaque(xdrs, (caddr_t)objp->status, 8)) {
		return (FALSE);
	}
	if (!xdr_opaque(xdrs, (caddr_t)objp->error, 8)) {
		return (FALSE);
	}
	return (TRUE);
}

long
xdr_length_DevVgcStat(objp)
	DevVgcStat *objp;
{
	long	length = 0;

	length = length + 8;
	length = length + 8;

	return (length);
}



bool_t
xdr_DevVgcGauge(xdrs, objp)
	XDR *xdrs;
	DevVgcGauge *objp;
{
	if (!xdr_opaque(xdrs, (caddr_t)objp->status, 8)) {
		return (FALSE);
	}
	if (!xdr_opaque(xdrs, (caddr_t)objp->error, 8)) {
		return (FALSE);
	}
	if (!xdr_opaque(xdrs, (caddr_t)objp->relay_status, 16)) {
		return (FALSE);
	}
	if (!xdr_char(xdrs, &objp->type)) {
		return (FALSE);
	}
	if (!xdr_char(xdrs, &objp->number)) {
		return (FALSE);
	}
	if (!xdr_opaque(xdrs, (caddr_t)objp->gauge_status, 8)) {
		return (FALSE);
	}
	if (!xdr_opaque(xdrs, (caddr_t)objp->gauge_error, 8)) {
		return (FALSE);
	}
	if (!xdr_double(xdrs, &objp->pressure)) {
		return (FALSE);
	}
	return (TRUE);
}

long
xdr_length_DevVgcGauge (objp)
	DevVgcGauge *objp;
{
	long	length = 0;

	length = length + 8;
	length = length + 8;
	length = length + 16;
        length = length + xdr_length_DevChar (&objp->type);
        length = length + xdr_length_DevChar (&objp->number);
	length = length + 8;
	length = length + 8;
        length = length + xdr_length_DevDouble (&objp->pressure);

	return (length);
}





bool_t
xdr_DevVgcPiraniGauge(xdrs, objp)
	XDR *xdrs;
	DevVgcPiraniGauge *objp;
{
	if (!xdr_char(xdrs, &objp->type)) {
		return (FALSE);
	}
	if (!xdr_char(xdrs, &objp->number)) {
		return (FALSE);
	}
	if (!xdr_char(xdrs, &objp->calibration)) {
		return (FALSE);
	}
	if (!xdr_double(xdrs, &objp->gas_factor)) {
		return (FALSE);
	}
	if (!xdr_opaque(xdrs, (caddr_t)objp->status, 8)) {
		return (FALSE);
	}
	if (!xdr_opaque(xdrs, (caddr_t)objp->error, 8)) {
		return (FALSE);
	}
	if (!xdr_double(xdrs, &objp->pressure)) {
		return (FALSE);
	}
	return (TRUE);
}

long
xdr_length_DevVgcPiraniGauge (objp)
	DevVgcPiraniGauge *objp;
{
	long	length = 0;

        length = length + xdr_length_DevChar (&objp->type);
        length = length + xdr_length_DevChar (&objp->number);
        length = length + xdr_length_DevChar (&objp->calibration);
        length = length + xdr_length_DevDouble (&objp->gas_factor);
	length = length + 8;
	length = length + 8;
        length = length + xdr_length_DevDouble (&objp->pressure);

	return (length);
}





bool_t
xdr_DevVgcPenningGauge(xdrs, objp)
	XDR *xdrs;
	DevVgcPenningGauge *objp;
{
	if (!xdr_char(xdrs, &objp->type)) {
		return (FALSE);
	}
	if (!xdr_char(xdrs, &objp->number)) {
		return (FALSE);
	}
	if (!xdr_char(xdrs, &objp->filter)) {
		return (FALSE);
	}
	if (!xdr_int(xdrs, &objp->start_time)) {
		return (FALSE);
	}
	if (!xdr_char(xdrs, &objp->calibration)) {
		return (FALSE);
	}
	if (!xdr_double(xdrs, &objp->min_current)) {
		return (FALSE);
	}
	if (!xdr_opaque(xdrs, (caddr_t)objp->status, 8)) {
		return (FALSE);
	}
	if (!xdr_opaque(xdrs, (caddr_t)objp->error, 8)) {
		return (FALSE);
	}
	if (!xdr_double(xdrs, &objp->pressure)) {
		return (FALSE);
	}
	return (TRUE);
}

long
xdr_length_DevVgcPenningGauge (objp)
	DevVgcPenningGauge *objp;
{
	long	length = 0;

        length = length + xdr_length_DevChar (&objp->type);
        length = length + xdr_length_DevChar (&objp->number);
        length = length + xdr_length_DevChar (&objp->filter);
        length = length + xdr_length_DevLong ((long *)&objp->start_time);
        length = length + xdr_length_DevChar (&objp->calibration);
        length = length + xdr_length_DevDouble (&objp->min_current);
	length = length + 8;
	length = length + 8;
        length = length + xdr_length_DevDouble (&objp->pressure);

	return (length);
}





bool_t
xdr_DevVgcRelay(xdrs, objp)
	XDR *xdrs;
	DevVgcRelay *objp;
{
	if (!xdr_char(xdrs, &objp->letter)) {
		return (FALSE);
	}
	if (!xdr_char(xdrs, &objp->status)) {
		return (FALSE);
	}
	if (!xdr_double(xdrs, &objp->setpoint)) {
		return (FALSE);
	}
	if (!xdr_char(xdrs, &objp->ass_gauge)) {
		return (FALSE);
	}
	return (TRUE);
}

long
xdr_length_DevVgcRelay (objp)
	DevVgcRelay *objp;
{
	long	length = 0;

        length = length + xdr_length_DevChar (&objp->letter);
        length = length + xdr_length_DevChar (&objp->status);
        length = length + xdr_length_DevDouble (&objp->setpoint);
        length = length + xdr_length_DevChar (&objp->ass_gauge);

	return (length);
}




bool_t
xdr_DevVgcSystem(xdrs, objp)
	XDR *xdrs;
	DevVgcSystem *objp;
{
	if (!xdr_char(xdrs, &objp->interlock)) {
		return (FALSE);
	}
	if (!xdr_char(xdrs, &objp->relay_conf)) {
		return (FALSE);
	}
	if (!xdr_char(xdrs, &objp->cold_cathode)) {
		return (FALSE);
	}
	if (!xdr_opaque(xdrs, (caddr_t)objp->ROM_version, 4)) {
		return (FALSE);
	}
	return (TRUE);
}

long
xdr_length_DevVgcSystem (objp)
	DevVgcSystem *objp;
{
	long	length = 0;

        length = length + xdr_length_DevChar (&objp->interlock);
        length = length + xdr_length_DevChar (&objp->relay_conf);
        length = length + xdr_length_DevChar (&objp->cold_cathode);
	length = length + 4;

	return (length);
}




bool_t
xdr_DevVgcController(xdrs, objp)
	XDR *xdrs;
	DevVgcController *objp;
{
	if (!xdr_vector(xdrs, (char *)objp->pirani, 2, sizeof(DevVgcPiraniGauge), (xdrproc_t)xdr_DevVgcPiraniGauge)) {
		return (FALSE);
	}
	if (!xdr_vector(xdrs, (char *)objp->penning, 4, sizeof(DevVgcPenningGauge), (xdrproc_t)xdr_DevVgcPenningGauge)) {
		return (FALSE);
	}
	if (!xdr_vector(xdrs, (char *)objp->relay, 12, sizeof(DevVgcRelay), (xdrproc_t)xdr_DevVgcRelay)) {
		return (FALSE);
	}
	if (!xdr_int(xdrs, &objp->nb_pir)) {
		return (FALSE);
	}
	if (!xdr_int(xdrs, &objp->nb_pen)) {
		return (FALSE);
	}
	if (!xdr_int(xdrs, &objp->nb_relay)) {
		return (FALSE);
	}
	if (!xdr_DevVgcSystem(xdrs, &objp->syst)) {
		return (FALSE);
	}
	if (!xdr_opaque(xdrs, (caddr_t)objp->status, 8)) {
		return (FALSE);
	}
	if (!xdr_opaque(xdrs, (caddr_t)objp->error, 8)) {
		return (FALSE);
	}
	if (!xdr_opaque(xdrs, (caddr_t)objp->relay_status, 16)) {
		return (FALSE);
	}
	return (TRUE);
}

long
xdr_length_DevVgcController (objp)
	DevVgcController *objp;
{
	long    type_length;
	long	length = 0;

	/* length of two DevVgcPiraniGauge structures */
	if ( (type_length = xdr_length_DevVgcPiraniGauge (&objp->pirani[0])) 
		== -1 )
		return (-1);
	length = length + 2 * type_length;

	/* length of four DevVgcPenningGauge structures */
	if ( (type_length = xdr_length_DevVgcPenningGauge (&objp->penning[0])) 
		== -1 )
		return (-1);
	length = length + 4 * type_length;

	/* length of twelve DevVgcRelay structures */
	if ( (type_length = xdr_length_DevVgcRelay (&objp->relay[0])) 
		== -1 )
		return (-1);
	length = length + 12 * type_length;

        length = length + xdr_length_DevLong ((long *)&objp->nb_pir);
        length = length + xdr_length_DevLong ((long *)&objp->nb_pen);
	length = length + xdr_length_DevLong ((long *)&objp->nb_relay);
	if ( (type_length = xdr_length_DevVgcSystem (&objp->syst)) == -1 )
		return (-1);
	length = length + type_length;
	length = length + 8;
	length = length + 8;
	length = length + 16;

	return (length);
}
