
/*+*******************************************************************

 File:          vgc_xdr.h

 Project:       Device Servers with sun-rpc

 Description:   Include file for XDR definitions of the
		Vacuum Gauge Controller data types.

 Author(s):  	Jens Meyer

 Original:	July 1992


 $Revision: 5.21 $
 $Date: 2001/11/12 10:01:38 $
 $Author: goetz $

 $Log:	vgc_xdr.h,v $
 * Revision 5.21  2001/11/12  10:01:38  10:01:38  goetz (Andy Goetz)
 * updated C port for Windows 95/98/NT using Visual C++ 6
 * 
 Revision 5.20  2001/01/08 12:17:37  goetz
 added patch by B.Pedersen to support querying events

 Revision 5.19  2000/10/02 12:08:48  goetz
 removed stderr from api_xdr.c

 Revision 5.18  1999/07/08 14:10:49  goetz
 changed _LPfd_set type for Linux in macros.h

 Revision 5.17  1998/05/25 17:59:51  klotz
 fixed C++ prototypes in api_xdr.h

 Revision 5.16  1998/04/29 10:24:13  goetz
 macros.h - added __STDCPP__ for HP C++ compiler (aCC)

 * Revision 5.15  97/12/01  15:22:50  15:22:50  klotz (W.D. Klotz)
 * WIN_NT_95_released_NOV_97
 * 
 * Revision 4.34  97/01/30  13:58:44  13:58:44  goetz (Andy Goetz)
 * removed dev_printdebug() from DevXdrKernel.h
 * 
 * Revision 4.33  97/01/09  10:08:49  10:08:49  goetz (Andy Goetz)
 * (xdrproc_t) castings added to maxe_xdr, ram_xdr, thc_xdr, seism_xdr
 * 
 * Revision 4.32  97/01/08  16:48:39  16:48:39  goetz (Andy Goetz)
 * Ported to Linux (2.0.9)
 * 
 Revision 4.31  1996/11/18 17:28:54  goetz
 Check

 * Revision 4.28  96/10/21  16:22:37  16:22:37  taurel (E.Taurel)
 * Check_in_after_port_to_OS9/ISP_2.1_and_OS9/RPC1.4
 * 
 * Revision 4.27  96/09/17  16:46:07  16:46:07  klotz (W.D. Klotz)
 * WD Klotz: checked NT build
 * 
 * Revision 4.26  96/07/19  10:01:07  10:01:07  taurel (E.Taurel)
 * Some_change_in_macros.h_for_the_API_port_to_OS-9_Ultra_C++
 * 
 * Revision 4.25  96/06/07  16:23:11  16:23:11  meyer (J.Meyer)
 * Corrected_elif_to_else_in_macros.h
 * 
 * Revision 4.24  96/06/05  15:01:48  15:01:48  meyer (J.Meyer)
 * Corrected_macros.h
 * 
 * Revision 4.23  96/06/03  13:10:25  13:10:25  meyer (J.Meyer)
 * Cleaned-up_MSDOS_and_added_porting_options_for_Windows_NT.
 * 
 * Revision 4.22  96/05/23  11:07:33  11:07:33  taurel (E.Taurel)
 * Added_some_definitions_for_C++_in_API_xdr.h_file
 * 
 * Revision 4.21  96/05/06  18:37:43  18:37:43  meyer (J.Meyer)
 * Fortran_compatibility_for:_dev_xdr.h,macros.h,maxe_xdr.h
 * 
 * Revision 4.20  96/02/27  13:31:43  13:31:43  meyer (J.Meyer)
 * Deleted_Cross_References_To_DSAPI_Library
 * 
 * Revision 4.19  96/01/11  17:40:28  17:40:28  meyer (Jens Meyer)
 * Added_#define_PORTMAP_to_macros.h.
 * 
 * Revision 4.18  95/12/21  10:33:44  10:33:44  meyer (Jens Meyer)
 * Corrected length calculation for D_VAR_MSTATARR.
 * 
 * Revision 4.17  95/08/02  16:05:20  16:05:20  meyer (Jens Meyer)
 * Corrected DevXdrKernel.h after C++ implementation.
 * 
 * Revision 4.15  95/03/02  10:28:08  10:28:08  meyer (Jens Meyer)
 * Added D_VAR_SFRPARR type to the kernel.
 * 
 * Revision 4.14  95/02/20  09:57:04  09:57:04  meyer (Jens Meyer)
 * Passed the compilers for HPUX, SUNOS and UCC after the first windows check in.
 * 
 * Revision 4.13  95/02/10  17:19:15  17:19:15  meyer (Jens Meyer)
 * Deleted
 * 
 * Revision 4.12  95/02/01  14:27:45  14:27:45  klotz (W.D. Klotz)
 * WDK: first successfull compile of dbase, api, xdr on WIN16/3.1
 * 
 * Revision 4.11  95/01/03  13:19:35  13:19:35  meyer (Jens Meyer)
 * Repared bug in dev_cmd_query() for version 3!
 * 
 * Revision 4.10  94/12/08  15:25:07  15:25:07  meyer (Jens Meyer)
 * Changed _manager_data in API_xdr and added old version to API_xdr_vers3.
 * 
 * Revision 4.9  94/11/28  17:04:28  17:04:28  meyer (Jens Meyer)
 * Data types for compatibility with library version 3.x
 * 
 * Revision 4.8  94/08/16  16:59:44  16:59:44  meyer (Jens Meyer)
 * Corrected error in ws_xdr.h
 * 
 * Revision 4.7  94/08/16  16:34:39  16:34:39  meyer (Jens Meyer)
 * Added define for MAX_RESOURCE_FIELD_LENGTH to macros.h
 * 
 * Revision 4.6  94/08/12  15:07:55  15:07:55  meyer (Jens Meyer)
 * Added valriable arguments to all API RPC structures.
 * 
 * Revision 4.5  94/07/20  18:15:55  18:15:55  meyer (Jens Meyer)
 * Changed include files in macros.h!
 * 
 * Revision 4.4  94/07/20  08:56:31  08:56:31  meyer (Jens Meyer)
 * All XDR functions with prototypes!
 * 
 * Revision 4.3  94/07/18  18:51:03  18:51:03  meyer (Jens Meyer)
 * Had to change macros.h, because #define must be in the first column!
 * 
 * Revision 4.2  94/07/18  18:22:59  18:22:59  meyer (Jens Meyer)
 * First test with PC macros for the XDR kernel.
 * 
 * Revision 4.1  94/05/02  10:50:56  10:50:56  meyer (Jens Meyer)
 * For Security System without connection count.
 * 
 * Revision 4.0  94/03/14  18:17:40  18:17:40  meyer (Jens Meyer)
 * Library version with Security System.
 * 
 * Revision 3.50  94/03/12  14:36:33  14:36:33  meyer (Jens Meyer)
 * Changed API xdr structures for security.
 * 
 * Revision 3.35  94/03/03  10:52:19  10:52:19  taurel (Emmanuel TAUREL)
 * Added unsigned long array type in the XDRkernel
 * 
 * Revision 3.34  94/03/03  10:29:09  10:29:09  taurel (Emmanuel TAUREL)
 * Added the unsigned long array type in
 * XDR kernel (LC and ET).
 * 
 * Revision 3.33  94/01/12  16:34:34  16:34:34  meyer (Jens Meyer)
 * Global XDR type array for data collector access
 * 
 * Revision 3.31  93/12/02  09:39:13  09:39:13  meyer (Jens Meyer)
 * New release with small XDR data type kernel.
 * 
 * Revision 1.1  93/12/01  14:57:09  14:57:09  meyer (Jens Meyer)
 * Initial revision
 * 

 Copyright (c) 1990 by European Synchrotron Radiation Facility,
		       Grenoble, France

*******************************************************************-*/

#ifndef _vgc_xdr_h
#define _vgc_xdr_h

/*
 * definitions for vacuum gauge controller types
 */

struct DevVgcStat {
	char status[8];
	char error[8];
};
typedef struct DevVgcStat 	DevVgcStat;
bool_t 	_DLLFunc xdr_DevVgcStat PT_((XDR *xdrs, DevVgcStat *objp));
long   	_DLLFunc xdr_length_DevVgcStat PT_((DevVgcStat *objp));
#define D_VGC_STATUS            16
#define LOAD_VGC_STATUS(A)      xdr_load_type ( D_VGC_STATUS, \
                                                xdr_DevVgcStat, \
                                                sizeof(DevVgcStat), \
                                                xdr_length_DevVgcStat, \
                                                A )

struct DevVgcGauge {
	char status[8];
	char error[8];
	char relay_status[16];
	char type;
	char number;
	char gauge_status[8];
	char gauge_error[8];
	double pressure;
};
typedef struct DevVgcGauge 	DevVgcGauge;
bool_t 	_DLLFunc xdr_DevVgcGauge PT_((XDR *xdrs, DevVgcGauge *objp));
long   	_DLLFunc xdr_length_DevVgcGauge PT_((DevVgcGauge *objp));
#define D_VGC_GAUGE             17
#define LOAD_VGC_GAUGE(A)       xdr_load_type ( D_VGC_GAUGE, \
                                                xdr_DevVgcGauge, \
                                                sizeof(DevVgcGauge), \
                                                xdr_length_DevVgcGauge, \
                                                A )


struct DevVgcPiraniGauge {
	char type;
	char number;
	char calibration;
	double gas_factor;
	char status[8];
	char error[8];
	double pressure;
};
typedef struct DevVgcPiraniGauge DevVgcPiraniGauge;
bool_t 	_DLLFunc xdr_DevVgcPiraniGauge
		 PT_((XDR *xdrs, DevVgcPiraniGauge *objp));
long   	_DLLFunc xdr_length_DevVgcPiraniGauge
		 PT_((DevVgcPiraniGauge *objp));


struct DevVgcPenningGauge {
	char type;
	char number;
	char filter;
	int start_time;
	char calibration;
	double min_current;
	char status[8];
	char error[8];
	double pressure;
};
typedef struct DevVgcPenningGauge DevVgcPenningGauge;
bool_t 	_DLLFunc xdr_DevVgcPenningGauge
		 PT_((XDR *xdrs, DevVgcPenningGauge *objp));
long   	_DLLFunc xdr_length_DevVgcPenningGauge
		 PT_((DevVgcPenningGauge *objp));


struct DevVgcRelay {
	char letter;
	char status;
	double setpoint;
	char ass_gauge;
};
typedef struct DevVgcRelay 	DevVgcRelay;
bool_t 	_DLLFunc xdr_DevVgcRelay PT_((XDR *xdrs, DevVgcRelay *objp));
long   	_DLLFunc xdr_length_DevVgcRelay PT_((DevVgcRelay *objp));


struct DevVgcSystem {
	char interlock;
	char relay_conf;
	char cold_cathode;
	char ROM_version[4];
};
typedef struct DevVgcSystem 	DevVgcSystem;
bool_t 	_DLLFunc xdr_DevVgcSystem PT_((XDR *xdrs, DevVgcSystem *objp));
long   	_DLLFunc xdr_length_DevVgcSystem PT_((DevVgcSystem *objp));


struct DevVgcController {
	DevVgcPiraniGauge pirani[2];
	DevVgcPenningGauge penning[4];
	DevVgcRelay relay[12];
	int nb_pir;
	int nb_pen;
	int nb_relay;
	DevVgcSystem syst;
	char status[8];
	char error[8];
	char relay_status[16];
};
typedef struct DevVgcController DevVgcController;
bool_t 	_DLLFunc xdr_DevVgcController
		 PT_((XDR *xdrs, DevVgcController *objp));
long   	_DLLFunc xdr_length_DevVgcController
		PT_((DevVgcController *objp));
#define D_VGC_CONTROLLER        18
#define LOAD_VGC_CONTROLLER(A)  xdr_load_type ( D_VGC_CONTROLLER, \
                                                xdr_DevVgcController, \
                                                sizeof(DevVgcController), \
                                                xdr_length_DevVgcController, \
                                                A )
#endif /* _vgc_xdr_h */
