
/*+*******************************************************************

 File:          pin_xdr.h

 Project:       Device Servers with sun-rpc

 Description:   xdr structure to read without argin argument the whole
                state of the Pinhole device.

 Author(s):  	Gilbert Pepellin

 Original:	June 1993


 $Revision: 5.21 $
 $Date: 2001/11/12 10:01:38 $

 $Author: goetz $

 $Log:	pin_xdr.h,v $
 * Revision 5.21  2001/11/12  10:01:38  10:01:38  goetz (Andy Goetz)
 * updated C port for Windows 95/98/NT using Visual C++ 6
 * 
 Revision 5.20  2001/01/08 12:17:37  goetz
 added patch by B.Pedersen to support querying events

 Revision 5.19  2000/10/02 12:08:48  goetz
 removed stderr from api_xdr.c

 Revision 5.18  1999/07/08 14:10:49  goetz
 changed _LPfd_set type for Linux in macros.h

 Revision 5.17  1998/05/25 18:00:01  klotz
 fixed C++ prototypes in api_xdr.h

 Revision 5.16  1998/04/29 10:24:24  goetz
 macros.h - added __STDCPP__ for HP C++ compiler (aCC)

 * Revision 5.15  97/12/01  15:22:36  15:22:36  klotz (W.D. Klotz)
 * WIN_NT_95_released_NOV_97
 * 
 * Revision 4.34  97/01/30  13:58:51  13:58:51  goetz (Andy Goetz)
 * removed dev_printdebug() from DevXdrKernel.h
 * 
 * Revision 4.33  97/01/09  10:08:55  10:08:55  goetz (Andy Goetz)
 * (xdrproc_t) castings added to maxe_xdr, ram_xdr, thc_xdr, seism_xdr
 * 
 * Revision 4.32  97/01/08  16:48:47  16:48:47  goetz (Andy Goetz)
 * Ported to Linux (2.0.9)
 * 
 Revision 4.31  1996/11/18 17:29:02  goetz
 Check

 * Revision 4.28  96/10/21  16:22:49  16:22:49  taurel (E.Taurel)
 * Check_in_after_port_to_OS9/ISP_2.1_and_OS9/RPC1.4
 * 
 * Revision 4.27  96/09/17  16:45:57  16:45:57  klotz (W.D. Klotz)
 * WD Klotz: checked NT build
 * 
 * Revision 4.26  96/07/19  10:01:13  10:01:13  taurel (E.Taurel)
 * Some_change_in_macros.h_for_the_API_port_to_OS-9_Ultra_C++
 * 
 * Revision 4.25  96/06/07  16:23:18  16:23:18  meyer (J.Meyer)
 * Corrected_elif_to_else_in_macros.h
 * 
 * Revision 4.24  96/06/05  15:01:54  15:01:54  meyer (J.Meyer)
 * Corrected_macros.h
 * 
 * Revision 4.23  96/06/03  13:10:32  13:10:32  meyer (J.Meyer)
 * Cleaned-up_MSDOS_and_added_porting_options_for_Windows_NT.
 * 
 * Revision 4.22  96/05/23  11:07:39  11:07:39  taurel (E.Taurel)
 * Added_some_definitions_for_C++_in_API_xdr.h_file
 * 
 * Revision 4.21  96/05/06  18:37:49  18:37:49  meyer (J.Meyer)
 * Fortran_compatibility_for:_dev_xdr.h,macros.h,maxe_xdr.h
 * 
 * Revision 4.20  96/02/27  13:31:49  13:31:49  meyer (J.Meyer)
 * Deleted_Cross_References_To_DSAPI_Library
 * 
 * Revision 4.19  96/01/11  17:40:35  17:40:35  meyer (Jens Meyer)
 * Added_#define_PORTMAP_to_macros.h.
 * 
 * Revision 4.18  95/12/21  10:33:57  10:33:57  meyer (Jens Meyer)
 * Corrected length calculation for D_VAR_MSTATARR.
 * 
 * Revision 4.17  95/08/02  16:05:26  16:05:26  meyer (Jens Meyer)
 * Corrected DevXdrKernel.h after C++ implementation.
 * 
 * Revision 4.15  95/03/02  10:28:26  10:28:26  meyer (Jens Meyer)
 * Added D_VAR_SFRPARR type to the kernel.
 * 
 * Revision 4.14  95/02/20  09:57:30  09:57:30  meyer (Jens Meyer)
 * Passed the compilers for HPUX, SUNOS and UCC after the first windows check in.
 * 
 * Revision 4.13  95/02/10  17:19:32  17:19:32  meyer (Jens Meyer)
 * Deleted
 * 
 * Revision 4.12  95/02/01  14:27:36  14:27:36  klotz (W.D. Klotz)
 * WDK: first successfull compile of dbase, api, xdr on WIN16/3.1
 * 
 * Revision 4.11  95/01/03  13:19:53  13:19:53  meyer (Jens Meyer)
 * Repared bug in dev_cmd_query() for version 3!
 * 
 * Revision 4.10  94/12/08  15:25:19  15:25:19  meyer (Jens Meyer)
 * Changed _manager_data in API_xdr and added old version to API_xdr_vers3.
 * 
 * Revision 4.9  94/11/28  17:04:44  17:04:44  meyer (Jens Meyer)
 * Data types for compatibility with library version 3.x
 * 
 * Revision 4.8  94/08/16  16:59:56  16:59:56  meyer (Jens Meyer)
 * Corrected error in ws_xdr.h
 * 
 * Revision 4.7  94/08/16  16:34:53  16:34:53  meyer (Jens Meyer)
 * Added define for MAX_RESOURCE_FIELD_LENGTH to macros.h
 * 
 * Revision 4.6  94/08/12  15:08:08  15:08:08  meyer (Jens Meyer)
 * Added valriable arguments to all API RPC structures.
 * 
 * Revision 4.5  94/07/20  18:16:07  18:16:07  meyer (Jens Meyer)
 * Changed include files in macros.h!
 * 
 * Revision 4.4  94/07/20  08:56:22  08:56:22  meyer (Jens Meyer)
 * All XDR functions with prototypes!
 * 
 * Revision 4.3  94/07/18  18:51:17  18:51:17  meyer (Jens Meyer)
 * Had to change macros.h, because #define must be in the first column!
 * 
 * Revision 4.2  94/07/18  18:22:50  18:22:50  meyer (Jens Meyer)
 * First test with PC macros for the XDR kernel.
 * 
 * Revision 4.1  94/05/02  10:51:09  10:51:09  meyer (Jens Meyer)
 * For Security System without connection count.
 * 
 * Revision 4.0  94/03/14  18:17:52  18:17:52  meyer (Jens Meyer)
 * Library version with Security System.
 * 
 * Revision 3.50  94/03/12  14:36:46  14:36:46  meyer (Jens Meyer)
 * Changed API xdr structures for security.
 * 
 * Revision 3.35  94/03/03  10:52:31  10:52:31  taurel (Emmanuel TAUREL)
 * Added unsigned long array type in the XDRkernel
 * 
 * Revision 3.34  94/03/03  10:29:21  10:29:21  taurel (Emmanuel TAUREL)
 * Added the unsigned long array type in
 * XDR kernel (LC and ET).
 * 
 * Revision 3.33  94/01/12  16:34:50  16:34:50  meyer (Jens Meyer)
 * Global XDR type array for data collector access
 * 
 * Revision 3.31  93/12/02  09:39:30  09:39:30  meyer (Jens Meyer)
 * New release with small XDR data type kernel.
 * 
 * Revision 1.1  93/12/01  12:38:40  12:38:40  meyer (Jens Meyer)
 * Initial revision
 * 


 Copyright (c) 1992 by European Synchrotron Radiation Facility,
		       Grenoble, France

*******************************************************************-*/

#ifndef _pin_xdr_h
#define _pin_xdr_h

/*
 *  Head structure definition;
 */
struct pin_head {
       long main_st; /* The main device state  :
                         DEVON      : all is good for you
                         DEVWARNING : at least on Maxe acces failed or
                                      one basic device is DEVFAULT.
                         DEVFAULT   : fatal error occured. 
                      */

       long dev_diag; /* device diagnostic. When main_st is not DEVON
                         The bits are numbered 0 to 11 from the right and
                          the value 1 corresponds to an error state.

                          bit 0   :  ReadState    Z1 axis failed.
                          bit 1   :  ReadPosition Z1 axis failed. 
                          bit 2   :  ReadSwitches Z1 axis failed.

                          bit 3   :  ReadState    Z2 axis failed.
                          bit 4   :  ReadPosition Z2 axis failed. 
                          bit 5   :  ReadSwitches Z2 axis failed.

                          bit 6   :  ReadState    TX axis failed.
                          bit 7   :  ReadPosition TX axis failed.
                          bit 8   :  ReadSwitches TX axis failed.

                          bit 9   :  ReadState    TT axis failed.
                          bit 10  :  ReadPosition TT axis failed.
                          bit 11  :  ReadSwitches TT axis failed

                      */       

        long tuned;   /* 1 if the whole component is TUNED (ie the three
                            axes are TUNED
                         0 if at least one axis is NOTTUNED
                      */

        long mode;    /* defines the current operation mode 
                           0 if CALIBRATION mode
                           1 if ALIGNMENT    mode
                           2 if OPERATION   mode
                      */

};
typedef struct pin_head 	pin_head ;
bool_t 	_DLLFunc xdr_pin_head  PT_((XDR *xdrs, pin_head *objp));
long   	_DLLFunc xdr_length_pin_head  PT_((pin_head *objp));


/*
  axis structure definition
*/
struct axis_state { 
       long unit;        /* current unit: STEPS | MM (for Z1,Z2,and TX axes)
                                          STEPS | DEGREE (for TT axis) */  
       long moving;      /* DEVMOVING | DEVON | DEVFAULT */
       float mot_pos;    /* motor position in axis current unit */
       float enc_pos;    /* encoder position in axis current unit */
       long  switch_st;  /* LIMITSOFF | NEGATLIMIT | POSITLIMIT */
       long tuned;       /* TUNED | NOTTUNED */
};
typedef struct axis_state 	axis_state;
bool_t 	_DLLFunc xdr_axis_state  PT_((XDR *xdrs, axis_state *objp));
long   	_DLLFunc xdr_length_axis_state  PT_((axis_state *objp));


/*
  whole component structure definition
*/
struct DevPinState { 
       pin_head pin_head;
       axis_state z1_state;
       axis_state z2_state;
       axis_state tx_state;
       axis_state tt_state;      
};
typedef struct DevPinState  	DevPinState;
bool_t 	_DLLFunc xdr_DevPinState  PT_((XDR *xdrs, DevPinState *objp));
long   	_DLLFunc xdr_length_DevPinState  PT_((DevPinState *objp));
#define D_PINSTATE_TYPE         67
#define LOAD_PINSTATE_TYPE(A)   xdr_load_type ( D_PINSTATE_TYPE, \
                                                xdr_DevPinState, \
                                                sizeof(DevPinState), \
                                                xdr_length_DevPinState, \
                                                A )
#endif /* _pin_xdr_h */




