/*+*******************************************************************
 File:          icv101_xdr.h
 Project:       Device Servers with sun-rpc
 Description:   Include file for XDR definitions
		of the icv101 data types.
 Author(s):  	Timo Mettala
 Original:	March 1993

 $Revision $
 $Date: 2001/11/12 10:01:38 $
 $Author: goetz $
 $Log:	icv101_xdr.h,v $
 * Revision 5.21  2001/11/12  10:01:38  10:01:38  goetz (Andy Goetz)
 * updated C port for Windows 95/98/NT using Visual C++ 6
 * 
 Revision 5.20  2001/01/08 12:17:37  goetz
 added patch by B.Pedersen to support querying events

 Revision 5.19  2000/10/02 12:08:48  goetz
 removed stderr from api_xdr.c

 Revision 5.18  1999/07/08 14:10:49  goetz
 changed _LPfd_set type for Linux in macros.h

 Revision 5.17  1998/05/25 17:59:59  klotz
 fixed C++ prototypes in api_xdr.h

 Revision 5.16  1998/04/29 10:24:22  goetz
 macros.h - added __STDCPP__ for HP C++ compiler (aCC)

 * Revision 5.15  97/12/01  15:22:25  15:22:25  klotz (W.D. Klotz)
 * WIN_NT_95_released_NOV_97
 * 
 * Revision 4.34  97/01/30  13:58:50  13:58:50  goetz (Andy Goetz)
 * removed dev_printdebug() from DevXdrKernel.h
 * 
 * Revision 4.33  97/01/09  10:08:54  10:08:54  goetz (Andy Goetz)
 * (xdrproc_t) castings added to maxe_xdr, ram_xdr, thc_xdr, seism_xdr
 * 
 * Revision 4.32  97/01/08  16:48:45  16:48:45  goetz (Andy Goetz)
 * Ported to Linux (2.0.9)
 * 
 Revision 4.31  1996/11/18 17:29:00  goetz
 Check

 * Revision 4.28  96/10/21  16:22:46  16:22:46  taurel (E.Taurel)
 * Check_in_after_port_to_OS9/ISP_2.1_and_OS9/RPC1.4
 * 
 * Revision 4.27  96/09/17  16:45:50  16:45:50  klotz (W.D. Klotz)
 * WD Klotz: checked NT build
 * 
 * Revision 4.26  96/07/19  10:01:12  10:01:12  taurel (E.Taurel)
 * Some_change_in_macros.h_for_the_API_port_to_OS-9_Ultra_C++
 * 
 * Revision 4.25  96/06/07  16:23:17  16:23:17  meyer (J.Meyer)
 * Corrected_elif_to_else_in_macros.h
 * 
 * Revision 4.24  96/06/05  15:01:53  15:01:53  meyer (J.Meyer)
 * Corrected_macros.h
 * 
 * Revision 4.23  96/06/03  13:10:31  13:10:31  meyer (J.Meyer)
 * Cleaned-up_MSDOS_and_added_porting_options_for_Windows_NT.
 * 
 * Revision 4.22  96/05/23  11:07:38  11:07:38  taurel (E.Taurel)
 * Added_some_definitions_for_C++_in_API_xdr.h_file
 * 
 * Revision 4.21  96/05/06  18:37:47  18:37:47  meyer (J.Meyer)
 * Fortran_compatibility_for:_dev_xdr.h,macros.h,maxe_xdr.h
 * 
 * Revision 4.20  96/02/27  13:31:48  13:31:48  meyer (J.Meyer)
 * Deleted_Cross_References_To_DSAPI_Library
 * 
 * Revision 4.19  96/01/11  17:40:34  17:40:34  meyer (Jens Meyer)
 * Added_#define_PORTMAP_to_macros.h.
 * 
 * Revision 4.18  95/12/21  10:33:55  10:33:55  meyer (Jens Meyer)
 * Corrected length calculation for D_VAR_MSTATARR.
 * 
 * Revision 4.17  95/08/02  16:05:25  16:05:25  meyer (Jens Meyer)
 * Corrected DevXdrKernel.h after C++ implementation.
 * 
 * Revision 4.15  95/03/02  10:28:23  10:28:23  meyer (Jens Meyer)
 * Added D_VAR_SFRPARR type to the kernel.
 * 
 * Revision 4.14  95/02/20  09:57:25  09:57:25  meyer (Jens Meyer)
 * Passed the compilers for HPUX, SUNOS and UCC after the first windows check in.
 * 
 * Revision 4.13  95/02/10  17:19:29  17:19:29  meyer (Jens Meyer)
 * Deleted
 * 
 * Revision 4.12  95/02/01  14:27:31  14:27:31  klotz (W.D. Klotz)
 * WDK: first successfull compile of dbase, api, xdr on WIN16/3.1
 * 
 * Revision 4.11  95/01/03  13:19:49  13:19:49  meyer (Jens Meyer)
 * Repared bug in dev_cmd_query() for version 3!
 * 
 * Revision 4.10  94/12/08  15:25:17  15:25:17  meyer (Jens Meyer)
 * Changed _manager_data in API_xdr and added old version to API_xdr_vers3.
 * 
 * Revision 4.9  94/11/28  17:04:41  17:04:41  meyer (Jens Meyer)
 * Data types for compatibility with library version 3.x
 * 
 * Revision 4.8  94/08/16  16:59:54  16:59:54  meyer (Jens Meyer)
 * Corrected error in ws_xdr.h
 * 
 * Revision 4.7  94/08/16  16:34:51  16:34:51  meyer (Jens Meyer)
 * Added define for MAX_RESOURCE_FIELD_LENGTH to macros.h
 * 
 * Revision 4.6  94/08/12  15:08:05  15:08:05  meyer (Jens Meyer)
 * Added valriable arguments to all API RPC structures.
 * 
 * Revision 4.5  94/07/20  18:16:05  18:16:05  meyer (Jens Meyer)
 * Changed include files in macros.h!
 * 
 * Revision 4.4  94/07/20  08:56:17  08:56:17  meyer (Jens Meyer)
 * All XDR functions with prototypes!
 * 
 * Revision 4.3  94/07/18  18:51:14  18:51:14  meyer (Jens Meyer)
 * Had to change macros.h, because #define must be in the first column!
 * 
 * Revision 4.2  94/07/18  18:22:44  18:22:44  meyer (Jens Meyer)
 * First test with PC macros for the XDR kernel.
 * 
 * Revision 4.1  94/05/02  10:51:07  10:51:07  meyer (Jens Meyer)
 * For Security System without connection count.
 * 
 * Revision 4.0  94/03/14  18:17:50  18:17:50  meyer (Jens Meyer)
 * Library version with Security System.
 * 
 * Revision 3.50  94/03/12  14:36:44  14:36:44  meyer (Jens Meyer)
 * Changed API xdr structures for security.
 * 
 * Revision 3.35  94/03/03  10:52:29  10:52:29  taurel (Emmanuel TAUREL)
 * Added unsigned long array type in the XDRkernel
 * 
 * Revision 3.34  94/03/03  10:29:19  10:29:19  taurel (Emmanuel TAUREL)
 * Added the unsigned long array type in
 * XDR kernel (LC and ET).
 * 
 * Revision 3.33  94/01/12  16:34:47  16:34:47  meyer (Jens Meyer)
 * Global XDR type array for data collector access
 * 
 * Revision 3.31  93/12/02  09:39:27  09:39:27  meyer (Jens Meyer)
 * New release with small XDR data type kernel.
 * 
 * Revision 1.1  93/11/16  17:34:36  17:34:36  meyer (Jens Meyer)
 * Initial revision
 * 

 Copyright (c) 1993 by European Synchrotron Radiation Facility,
		       Grenoble, France
*******************************************************************-*/

#ifndef _icv101_xdr_h
#define _icv101_xdr_h

/*
 *  definitions for icv101 type D_VAR_PATTERNARR
 */

struct DevPattern {
	short  channel;
	short  gain;
	short  end;
};
typedef struct DevPattern 	DevPattern;
bool_t 	_DLLFunc xdr_DevPattern PT_((XDR *xdrs, DevPattern *objp));


struct DevVarPatternArray {
	u_int 		length;
	DevPattern  	*sequence;
};
typedef struct DevVarPatternArray DevVarPatternArray;
bool_t 	_DLLFunc xdr_DevVarPatternArray
		 PT_((XDR *xdrs, DevVarPatternArray *objp));
#define D_VAR_PATTERNARR        56
#define LOAD_VAR_PATTERNARR(A)  xdr_load_type (D_VAR_PATTERNARR, \
                                               xdr_DevVarPatternArray, \
                                               sizeof(DevVarPatternArray), \
                                               NULL, \
                                               A )


/*
 *  definitions for icv101 type D_ICV_MODE
 */

struct DevIcv101Mode {
       long external_stop;
       long external_start;
       long continuous;
       long main_frequency;
       long sub_frequency;
       long npfs2;
       long npost;
};
typedef struct DevIcv101Mode 	DevIcv101Mode;
bool_t 	_DLLFunc xdr_DevIcv101Mode PT_((XDR *xdrs, DevIcv101Mode *objp));
#define D_ICV_MODE              57
#define LOAD_ICV_MODE(A)  	xdr_load_type (D_ICV_MODE, \
                                               xdr_DevIcv101Mode, \
                                               sizeof(DevIcv101Mode), \
                                               NULL, \
                                               A )
	  
#endif /* _icv101_xdr_h */
