
/*+*******************************************************************

 File:          _xdr.h

 Project:       Device Servers with sun-rpc

 Description:   Include file for XDR definitions
		data types.

 Author(s):  	Jens Meyer

 Original:	July 1992


 $Revision: 5.21 $
 $Date: 2001/11/12 10:01:38 $

 $Author: goetz $

 $Log:	grp_xdr.h,v $
 * Revision 5.21  2001/11/12  10:01:38  10:01:38  goetz (Andy Goetz)
 * updated C port for Windows 95/98/NT using Visual C++ 6
 * 
 Revision 5.20  2001/01/08 12:17:37  goetz
 added patch by B.Pedersen to support querying events

 Revision 5.19  2000/10/02 12:08:48  goetz
 removed stderr from api_xdr.c

 Revision 5.18  1999/07/08 14:10:49  goetz
 changed _LPfd_set type for Linux in macros.h

 Revision 5.17  1998/05/25 18:00:00  klotz
 fixed C++ prototypes in api_xdr.h

 Revision 5.16  1998/04/29 10:24:23  goetz
 macros.h - added __STDCPP__ for HP C++ compiler (aCC)

 * Revision 5.15  97/12/01  15:22:23  15:22:23  klotz (W.D. Klotz)
 * WIN_NT_95_released_NOV_97
 * 
 * Revision 4.34  97/01/30  13:58:51  13:58:51  goetz (Andy Goetz)
 * removed dev_printdebug() from DevXdrKernel.h
 * 
 * Revision 4.33  97/01/09  10:08:55  10:08:55  goetz (Andy Goetz)
 * (xdrproc_t) castings added to maxe_xdr, ram_xdr, thc_xdr, seism_xdr
 * 
 * Revision 4.32  97/01/08  16:48:46  16:48:46  goetz (Andy Goetz)
 * Ported to Linux (2.0.9)
 * 
 Revision 4.31  1996/11/18 17:29:02  goetz
 Check

 * Revision 4.28  96/10/21  16:22:48  16:22:48  taurel (E.Taurel)
 * Check_in_after_port_to_OS9/ISP_2.1_and_OS9/RPC1.4
 * 
 * Revision 4.27  96/09/17  16:45:47  16:45:47  klotz (W.D. Klotz)
 * WD Klotz: checked NT build
 * 
 * Revision 4.26  96/07/19  10:01:13  10:01:13  taurel (E.Taurel)
 * Some_change_in_macros.h_for_the_API_port_to_OS-9_Ultra_C++
 * 
 * Revision 4.25  96/06/07  16:23:17  16:23:17  meyer (J.Meyer)
 * Corrected_elif_to_else_in_macros.h
 * 
 * Revision 4.24  96/06/05  15:01:53  15:01:53  meyer (J.Meyer)
 * Corrected_macros.h
 * 
 * Revision 4.23  96/06/03  13:10:31  13:10:31  meyer (J.Meyer)
 * Cleaned-up_MSDOS_and_added_porting_options_for_Windows_NT.
 * 
 * Revision 4.22  96/05/23  11:07:38  11:07:38  taurel (E.Taurel)
 * Added_some_definitions_for_C++_in_API_xdr.h_file
 * 
 * Revision 4.21  96/05/06  18:37:48  18:37:48  meyer (J.Meyer)
 * Fortran_compatibility_for:_dev_xdr.h,macros.h,maxe_xdr.h
 * 
 * Revision 4.20  96/02/27  13:31:48  13:31:48  meyer (J.Meyer)
 * Deleted_Cross_References_To_DSAPI_Library
 * 
 * Revision 4.19  96/01/11  17:40:34  17:40:34  meyer (Jens Meyer)
 * Added_#define_PORTMAP_to_macros.h.
 * 
 * Revision 4.18  95/12/21  10:33:56  10:33:56  meyer (Jens Meyer)
 * Corrected length calculation for D_VAR_MSTATARR.
 * 
 * Revision 4.17  95/08/02  16:05:26  16:05:26  meyer (Jens Meyer)
 * Corrected DevXdrKernel.h after C++ implementation.
 * 
 * Revision 4.15  95/03/02  10:28:24  10:28:24  meyer (Jens Meyer)
 * Added D_VAR_SFRPARR type to the kernel.
 * 
 * Revision 4.14  95/02/20  09:57:28  09:57:28  meyer (Jens Meyer)
 * Passed the compilers for HPUX, SUNOS and UCC after the first windows check in.
 * 
 * Revision 4.13  95/02/10  17:19:31  17:19:31  meyer (Jens Meyer)
 * Deleted
 * 
 * Revision 4.12  95/02/01  14:27:27  14:27:27  klotz (W.D. Klotz)
 * WDK: first successfull compile of dbase, api, xdr on WIN16/3.1
 * 
 * Revision 4.11  95/01/03  13:19:50  13:19:50  meyer (Jens Meyer)
 * Repared bug in dev_cmd_query() for version 3!
 * 
 * Revision 4.10  94/12/08  15:25:18  15:25:18  meyer (Jens Meyer)
 * Changed _manager_data in API_xdr and added old version to API_xdr_vers3.
 * 
 * Revision 4.9  94/11/28  17:04:42  17:04:42  meyer (Jens Meyer)
 * Data types for compatibility with library version 3.x
 * 
 * Revision 4.8  94/08/16  16:59:55  16:59:55  meyer (Jens Meyer)
 * Corrected error in ws_xdr.h
 * 
 * Revision 4.7  94/08/16  16:34:52  16:34:52  meyer (Jens Meyer)
 * Added define for MAX_RESOURCE_FIELD_LENGTH to macros.h
 * 
 * Revision 4.6  94/08/12  15:08:06  15:08:06  meyer (Jens Meyer)
 * Added valriable arguments to all API RPC structures.
 * 
 * Revision 4.5  94/07/20  18:16:06  18:16:06  meyer (Jens Meyer)
 * Changed include files in macros.h!
 * 
 * Revision 4.4  94/07/20  08:56:15  08:56:15  meyer (Jens Meyer)
 * All XDR functions with prototypes!
 * 
 * Revision 4.3  94/07/18  18:51:16  18:51:16  meyer (Jens Meyer)
 * Had to change macros.h, because #define must be in the first column!
 * 
 * Revision 4.2  94/07/18  18:22:41  18:22:41  meyer (Jens Meyer)
 * First test with PC macros for the XDR kernel.
 * 
 * Revision 4.1  94/05/02  10:51:08  10:51:08  meyer (Jens Meyer)
 * For Security System without connection count.
 * 
 * Revision 4.0  94/03/14  18:17:51  18:17:51  meyer (Jens Meyer)
 * Library version with Security System.
 * 
 * Revision 3.50  94/03/12  14:36:45  14:36:45  meyer (Jens Meyer)
 * Changed API xdr structures for security.
 * 
 * Revision 3.35  94/03/03  10:52:30  10:52:30  taurel (Emmanuel TAUREL)
 * Added unsigned long array type in the XDRkernel
 * 
 * Revision 3.34  94/03/03  10:29:20  10:29:20  taurel (Emmanuel TAUREL)
 * Added the unsigned long array type in
 * XDR kernel (LC and ET).
 * 
 * Revision 3.33  94/01/12  16:34:48  16:34:48  meyer (Jens Meyer)
 * Global XDR type array for data collector access
 * 
 * Revision 3.31  93/12/02  09:39:28  09:39:28  meyer (Jens Meyer)
 * New release with small XDR data type kernel.
 * 
 * Revision 1.2  93/12/01  18:06:26  18:06:26  meyer (Jens Meyer)
 * *** empty log message ***
 * 
 * Revision 1.1  93/11/16  17:26:47  17:26:47  meyer (Jens Meyer)
 * Initial revision
 * 

 Copyright (c) 1990 by European Synchrotron Radiation Facility,
		       Grenoble, France

*******************************************************************-*/

#ifndef _grp_xdr_h
#define _grp_xdr_h


struct Frame {
	double		value;
	short		output;
	short		pause;
};
typedef struct Frame 		Frame;
bool_t 	_DLLFunc xdr_Frame  PT_((XDR *xdrs, Frame *objp));
long   	_DLLFunc xdr_length_Frame  PT_((Frame *objp));


struct FramePair {
	Frame		dead;
	Frame		live;
};
typedef struct FramePair 	FramePair;
bool_t 	_DLLFunc xdr_FramePair  PT_((XDR *xdrs, FramePair *objp));
long    _DLLFunc xdr_length_FramePair  PT_((FramePair *objp));


struct DevGrpFramePair {
	u_int		nb_framepair;
	FramePair	framepair;
};
typedef struct DevGrpFramePair 	DevGrpFramePair;
bool_t 	_DLLFunc xdr_DevGrpFramePair PT_((XDR *xdrs, DevGrpFramePair *objp));
long   	_DLLFunc xdr_length_DevGrpFramePair  PT_((DevGrpFramePair *objp));
#define D_GRPFP_TYPE            65
#define LOAD_GRPFP_TYPE(A)      xdr_load_type ( D_GRPFP_TYPE, \
                                                xdr_DevGrpFramePair, \
                                                sizeof(DevGrpFramePair), \
                                                xdr_length_DevGrpFramePair, \
                                                A )


struct DevGrpFramePairArray {
	u_int		length;
	DevGrpFramePair	*sequence;
};
typedef struct DevGrpFramePairArray DevGrpFramePairArray;
bool_t 	_DLLFunc xdr_DevGrpFramePairArray
		 PT_((XDR *xdrs, DevGrpFramePairArray *objp));
long   	_DLLFunc xdr_length_DevGrpFramePairArray
		 PT_((DevGrpFramePairArray *objp));
#define D_VAR_GRPFPARR          66
#define LOAD_VAR_GRPFPARR(A)    xdr_load_type ( D_VAR_GRPFPARR, \
                                            xdr_DevGrpFramePairArray, \
                                            sizeof(DevGrpFramePairArray), \
                                            xdr_length_DevGrpFramePairArray, \
                                            A )
#endif /* _grp_xdr_h */

