
/*+*******************************************************************

 File:          dev_xdr.h

 Project:       Device Servers with sun-rpc

 Description:   Include file for general XDR definitions
		and the list of all available data types.

 Author(s):  	Jens Meyer

 Original:	January 1991


 $Revision: 5.21 $
 $Date: 2001/11/12 10:01:38 $

 $Author: goetz $

 $Log:	dev_xdr.h,v $
 * Revision 5.21  2001/11/12  10:01:38  10:01:38  goetz (Andy Goetz)
 * updated C port for Windows 95/98/NT using Visual C++ 6
 * 
 Revision 5.20  2001/01/08 12:17:37  goetz
 added patch by B.Pedersen to support querying events

 Revision 5.19  2000/10/02 12:08:48  goetz
 removed stderr from api_xdr.c

 Revision 5.18  1999/07/08 14:10:49  goetz
 changed _LPfd_set type for Linux in macros.h

 Revision 5.17  1998/05/25 17:59:50  klotz
 fixed C++ prototypes in api_xdr.h

 Revision 5.16  1998/04/29 10:24:12  goetz
 macros.h - added __STDCPP__ for HP C++ compiler (aCC)

 * Revision 5.15  97/12/01  15:22:18  15:22:18  klotz (W.D. Klotz)
 * WIN_NT_95_released_NOV_97
 * 
 * Revision 4.34  97/01/30  13:58:43  13:58:43  goetz (Andy Goetz)
 * removed dev_printdebug() from DevXdrKernel.h
 * 
 * Revision 4.33  97/01/09  10:08:48  10:08:48  goetz (Andy Goetz)
 * (xdrproc_t) castings added to maxe_xdr, ram_xdr, thc_xdr, seism_xdr
 * 
 * Revision 4.32  97/01/08  16:48:38  16:48:38  goetz (Andy Goetz)
 * Ported to Linux (2.0.9)
 * 
 Revision 4.31  1996/11/18 17:28:53  goetz
 Check

 * Revision 4.30  96/10/25  13:58:01  13:58:01  goetz (Andy Goetz)
 * added extern "C" at beginning and end of file (for C++)
 * 
 Revision 4.29  1996/10/25 13:12:10  goetz
 added extern "C" to xdr_length_DevChar prototype (for C++)

 Revision 4.28  1996/10/21 16:22:36  taurel
 Check_in_after_port_to_OS9/ISP_2.1_and_OS9/RPC1.4

 * Revision 4.27  96/09/17  16:45:44  16:45:44  klotz (W.D. Klotz)
 * WD Klotz: checked NT build
 * 
 * Revision 4.26  96/07/19  10:01:07  10:01:07  taurel (E.Taurel)
 * Some_change_in_macros.h_for_the_API_port_to_OS-9_Ultra_C++
 * 
 * Revision 4.25  96/06/07  16:23:11  16:23:11  meyer (J.Meyer)
 * Corrected_elif_to_else_in_macros.h
 * 
 * Revision 4.24  96/06/05  15:01:47  15:01:47  meyer (J.Meyer)
 * Corrected_macros.h
 * 
 * Revision 4.23  96/06/03  13:10:24  13:10:24  meyer (J.Meyer)
 * Cleaned-up_MSDOS_and_added_porting_options_for_Windows_NT.
 * 
 * Revision 4.22  96/05/23  11:07:32  11:07:32  taurel (E.Taurel)
 * Added_some_definitions_for_C++_in_API_xdr.h_file
 * 
 * Revision 4.21  96/05/06  18:37:42  18:37:42  meyer (J.Meyer)
 * Fortran_compatibility_for:_dev_xdr.h,macros.h,maxe_xdr.h
 * 
 * Revision 4.20  96/02/27  13:31:42  13:31:42  meyer (J.Meyer)
 * Deleted_Cross_References_To_DSAPI_Library
 *
 * Revision 4.19  96/01/11  17:40:28  17:40:28  meyer (Jens Meyer)
 * Added_#define_PORTMAP_to_macros.h.
 *
 * Revision 4.18  95/12/21  10:33:42  10:33:42  meyer (Jens Meyer)
 * Corrected length calculation for D_VAR_MSTATARR.
 *
 * Revision 4.17  95/08/02  16:05:20  16:05:20  meyer (Jens Meyer)
 * Corrected DevXdrKernel.h after C++ implementation.
 *
 * Revision 4.15  95/03/02  10:28:07  10:28:07  meyer (Jens Meyer)
 * Added D_VAR_SFRPARR type to the kernel.
 * 
 * Revision 4.14  95/02/20  09:57:01  09:57:01  meyer (Jens Meyer)
 * Passed the compilers for HPUX, SUNOS and UCC after the first windows check in.
 * 
 * Revision 4.13  95/02/10  17:19:13  17:19:13  meyer (Jens Meyer)
 * Deleted
 * 
 * Revision 4.12  95/02/01  14:27:18  14:27:18  klotz (W.D. Klotz)
 * WDK: first successfull compile of dbase, api, xdr on WIN16/3.1
 * 
 * Revision 4.11  95/01/03  13:19:33  13:19:33  meyer (Jens Meyer)
 * Repared bug in dev_cmd_query() for version 3!
 * 
 * Revision 4.10  94/12/08  15:25:05  15:25:05  meyer (Jens Meyer)
 * Changed _manager_data in API_xdr and added old version to API_xdr_vers3.
 * 
 * Revision 4.9  94/11/28  17:04:27  17:04:27  meyer (Jens Meyer)
 * Data types for compatibility with library version 3.x
 * 
 * Revision 4.8  94/08/16  16:59:42  16:59:42  meyer (Jens Meyer)
 * Corrected error in ws_xdr.h
 * 
 * Revision 4.7  94/08/16  16:34:37  16:34:37  meyer (Jens Meyer)
 * Added define for MAX_RESOURCE_FIELD_LENGTH to macros.h
 * 
 * Revision 4.6  94/08/12  15:07:53  15:07:53  meyer (Jens Meyer)
 * Added valriable arguments to all API RPC structures.
 * 
 * Revision 4.5  94/07/20  18:15:53  18:15:53  meyer (Jens Meyer)
 * Changed include files in macros.h!
 * 
 * Revision 4.4  94/07/20  08:56:07  08:56:07  meyer (Jens Meyer)
 * All XDR functions with prototypes!
 * 
 * Revision 4.3  94/07/18  18:51:01  18:51:01  meyer (Jens Meyer)
 * Had to change macros.h, because #define must be in the first column!
 * 
 * Revision 4.2  94/07/18  18:22:33  18:22:33  meyer (Jens Meyer)
 * First test with PC macros for the XDR kernel.
 * 
 * Revision 4.1  94/05/02  10:50:54  10:50:54  meyer (Jens Meyer)
 * For Security System without connection count.
 * 
 * Revision 4.0  94/03/14  18:17:39  18:17:39  meyer (Jens Meyer)
 * Library version with Security System.
 * 
 * Revision 3.50  94/03/12  14:36:32  14:36:32  meyer (Jens Meyer)
 * Changed API xdr structures for security.
 * 
 * Revision 3.35  94/03/03  10:52:17  10:52:17  taurel (Emmanuel TAUREL)
 * Added unsigned long array type in the XDRkernel
 * 
 * Revision 3.34  94/03/03  10:29:08  10:29:08  taurel (Emmanuel TAUREL)
 * Added the unsigned long array type in
 * XDR kernel (LC and ET).
 * 
 * Revision 3.33  94/01/12  16:34:32  16:34:32  meyer (Jens Meyer)
 * Global XDR type array for data collector access
 * 
 * Revision 3.31  93/12/02  09:39:11  09:39:11  meyer (Jens Meyer)
 * New release with small XDR data type kernel.
 * 

 Copyright (c) 1990 by European Synchrotron Radiation Facility,
		       Grenoble, France

*******************************************************************-*/

#ifndef _dev_xdr_h
#define _dev_xdr_h

#include <macros.h>

#ifdef __cplusplus
extern "C" {
#endif

#if !defined(FORTRAN)
typedef char	DevChar;
long    	_DLLFunc xdr_length_DevChar PT_((char *objp));
#endif /* FORTRAN */
                                                                         
/* 
 *  device server types which will be used to pass 
 *  device server arguments.
 */

#if !defined(FORTRAN)
typedef void			DevVoid;
long    			_DLLFunc xdr_length_DevVoid PT_((void *objp));
#endif /* FORTRAN */
#define D_VOID_TYPE             0
#if !defined(FORTRAN)
#define LOAD_VOID_TYPE(A)	xdr_load_type (	D_VOID_TYPE, \
						(DevDataFunction) xdr_void, \
						0, \
						xdr_length_DevVoid, \
						A )

typedef char			DevBoolean;
long    			_DLLFunc xdr_length_DevBoolean
				         PT_((char *objp));
#endif /* FORTRAN */
#define	D_BOOLEAN_TYPE		1
#if !defined(FORTRAN)
#define LOAD_BOOLEAN_TYPE(A)	xdr_load_type (	D_BOOLEAN_TYPE, \
						(DevDataFunction) xdr_char, \
						sizeof(DevBoolean), \
						xdr_length_DevBoolean, \
						A )

typedef unsigned short      	DevUShort;
long                        	_DLLFunc xdr_length_DevUShort
					 PT_((unsigned short *objp));
#endif /* FORTRAN */
#define D_USHORT_TYPE       	70
#if !defined(FORTRAN)
#define LOAD_USHORT_TYPE(A) 	xdr_load_type (D_USHORT_TYPE, \
                                               (DevDataFunction) xdr_u_short, \
                                               sizeof(DevUShort), \
                                               xdr_length_DevUShort, \
                                               A)


typedef short			DevShort;
long  				_DLLFunc xdr_length_DevShort
					 PT_((short *objp));
#endif /* FORTRAN */
#define D_SHORT_TYPE            2
#if !defined(FORTRAN)
#define LOAD_SHORT_TYPE(A)	xdr_load_type (	D_SHORT_TYPE, \
						(DevDataFunction) xdr_short, \
						sizeof(DevShort), \
						xdr_length_DevShort, \
						A )

typedef unsigned long      	DevULong;
long                        	_DLLFunc xdr_length_DevULong
					 PT_((unsigned long *objp));
#endif /* FORTRAN */
#define D_ULONG_TYPE       	71
#if !defined(FORTRAN)
#define LOAD_ULONG_TYPE(A) 	xdr_load_type (D_ULONG_TYPE, \
                                               (DevDataFunction) xdr_u_long, \
                                               sizeof(DevULong), \
                                               xdr_length_DevULong, \
                                               A)


typedef	long			DevLong;
long    			_DLLFunc xdr_length_DevLong PT_((long *objp));
#endif /* FORTRAN */
#define D_LONG_TYPE             3
#if !defined(FORTRAN)
#define LOAD_LONG_TYPE(A)	xdr_load_type (	D_LONG_TYPE, \
						(DevDataFunction) xdr_long, \
						sizeof(DevLong), \
						xdr_length_DevLong, \
						A )

typedef float			DevFloat;
long    			_DLLFunc xdr_length_DevFloat
					 PT_((float *objp));
#endif /* FORTRAN */
#define D_FLOAT_TYPE            4
#if !defined(FORTRAN)
#define LOAD_FLOAT_TYPE(A)	xdr_load_type (	D_FLOAT_TYPE, \
						(DevDataFunction) xdr_float, \
						sizeof(DevFloat), \
						xdr_length_DevFloat, \
						A )

typedef double			DevDouble;
long    			_DLLFunc xdr_length_DevDouble
					 PT_((double *objp));
#endif /* FORTRAN */
#define D_DOUBLE_TYPE           5
#if !defined(FORTRAN)
#define LOAD_DOUBLE_TYPE(A)	xdr_load_type (	D_DOUBLE_TYPE, \
						(DevDataFunction) xdr_double, \
						sizeof(DevDouble), \
						xdr_length_DevDouble, \
						A )

typedef char   			*DevString;
bool_t 				_DLLFunc xdr_DevString
					 PT_((XDR *xdrs, char **objp));
long   			        _DLLFunc xdr_length_DevString
					 PT_((char **objp));
#endif /* FORTRAN */
#define D_STRING_TYPE           6
#if !defined(FORTRAN)
#define LOAD_STRING_TYPE(A)	xdr_load_type (	D_STRING_TYPE, \
						(DevDataFunction) xdr_wrapstring, \
						sizeof(DevString), \
						xdr_length_DevString, \
						A )


struct DevIntFloat {
	long  state;
	float value;
};
typedef struct DevIntFloat 	DevIntFloat;
bool_t 	_DLLFunc xdr_DevIntFloat PT_((XDR *xdrs, DevIntFloat *objp));
long    _DLLFunc xdr_length_DevIntFloat PT_((DevIntFloat *objp));
#endif /* FORTRAN */
#define D_INT_FLOAT_TYPE        27
#if !defined(FORTRAN)
#define LOAD_INT_FLOAT_TYPE(A)	xdr_load_type (	D_INT_FLOAT_TYPE, \
						(DevDataFunction) xdr_DevIntFloat, \
						sizeof(DevIntFloat), \
						xdr_length_DevIntFloat, \
						A )


struct DevFloatReadPoint {
	float set;
	float read;
};
typedef struct DevFloatReadPoint DevFloatReadPoint;
bool_t 	_DLLFunc xdr_DevFloatReadPoint
		 PT_((XDR *xdrs, DevFloatReadPoint *objp));
long    _DLLFunc xdr_length_DevFloatReadPoint
		 PT_((DevFloatReadPoint *objp));
#endif /* FORTRAN */
#define D_FLOAT_READPOINT       7
#if !defined(FORTRAN)
#define LOAD_FLOAT_READPOINT(A)	xdr_load_type (	D_FLOAT_READPOINT, \
						(DevDataFunction) xdr_DevFloatReadPoint, \
						sizeof(DevFloatReadPoint), \
						xdr_length_DevFloatReadPoint, \
						A )


struct DevStateFloatReadPoint {
	short state;
	float set;
	float read;
};
typedef struct DevStateFloatReadPoint DevStateFloatReadPoint;
bool_t 	_DLLFunc xdr_DevStateFloatReadPoint
		 PT_((XDR *xdrs, DevStateFloatReadPoint *objp));
long    _DLLFunc xdr_length_DevStateFloatReadPoint
	         PT_((DevStateFloatReadPoint *objp));
#endif /* FORTRAN */
#define D_STATE_FLOAT_READPOINT       8
#if !defined(FORTRAN)
#define LOAD_STATE_FLOAT_READPOINT(A) xdr_load_type (D_STATE_FLOAT_READPOINT, \
					(DevDataFunction) xdr_DevStateFloatReadPoint, \
					sizeof(DevStateFloatReadPoint), \
					xdr_length_DevStateFloatReadPoint, \
					A )


struct DevLongReadPoint {
	long set;
	long read;
};
typedef struct DevLongReadPoint 	DevLongReadPoint;
bool_t 	_DLLFunc xdr_DevLongReadPoint
		 PT_((XDR *xdrs, DevLongReadPoint *objp));
long    _DLLFunc xdr_length_DevLongReadPoint
		 PT_((DevLongReadPoint *objp));
#endif /* FORTRAN */
#define D_LONG_READPOINT        	22
#if !defined(FORTRAN)
#define LOAD_LONG_READPOINT(A)    	xdr_load_type (D_LONG_READPOINT, \
						(DevDataFunction) xdr_DevLongReadPoint, \
						sizeof(DevLongReadPoint), \
						xdr_length_DevLongReadPoint, \
						A )


struct DevDoubleReadPoint {
	double set;
	double read;
};
typedef struct DevDoubleReadPoint 	DevDoubleReadPoint;
bool_t 	_DLLFunc xdr_DevDoubleReadPoint
		 PT_((XDR *xdrs, DevDoubleReadPoint *objp));
long    _DLLFunc xdr_length_DevDoubleReadPoint
		 PT_((DevDoubleReadPoint *objp));
#endif /* FORTRAN */
#define D_DOUBLE_READPOINT      	23
#if !defined(FORTRAN)
#define LOAD_DOUBLE_READPOINT(A)    	xdr_load_type (D_DOUBLE_READPOINT, \
						(DevDataFunction) xdr_DevDoubleReadPoint, \
						sizeof(DevDoubleReadPoint), \
						xdr_length_DevDoubleReadPoint, \
						A )


/*
 * variable length array types
 */

struct DevVarCharArray {
	u_int length;
	char  *sequence;
};
typedef struct DevVarCharArray 		DevVarCharArray;
bool_t 	_DLLFunc xdr_DevVarCharArray
		 PT_((XDR *xdrs, DevVarCharArray *objp));
long   	_DLLFunc xdr_length_DevVarCharArray
		  PT_((DevVarCharArray *objp));
#endif /* FORTRAN */
#define D_VAR_CHARARR           	9
#if !defined(FORTRAN)
#define LOAD_VAR_CHARARR(A)   		xdr_load_type (D_VAR_CHARARR, \
						(DevDataFunction) xdr_DevVarCharArray, \
						sizeof(DevVarCharArray), \
						xdr_length_DevVarCharArray, \
						A )


struct DevVarStringArray {
	u_int 	  length;
	DevString *sequence;
};
typedef struct DevVarStringArray 	DevVarStringArray;
bool_t 	_DLLFunc xdr_DevVarStringArray
		 PT_((XDR *xdrs, DevVarStringArray *objp));
long   	_DLLFunc xdr_length_DevVarStringArray
		 PT_((DevVarStringArray *objp));
#endif /* FORTRAN */
#define D_VAR_STRINGARR         	24
#if !defined(FORTRAN)
#define LOAD_VAR_STRINGARR(A)         	xdr_load_type (D_VAR_STRINGARR, \
						(DevDataFunction) xdr_DevVarStringArray, \
						sizeof(DevVarStringArray), \
						xdr_length_DevVarStringArray, \
						A )

/*
 *  Unsigned short array
 */

struct DevVarUShortArray {
  	u_int   length;
  	u_short *sequence;
};
typedef struct DevVarUShortArray 	DevVarUShortArray;
bool_t  _DLLFunc xdr_DevVarUShortArray
		 PT_((XDR *xdrs, DevVarUShortArray *objp));
long    _DLLFunc xdr_length_DevVarUShortArray
		 PT_((DevVarUShortArray *objp));

#endif /* FORTRAN */
#define D_VAR_USHORTARR      		72 
#if !defined(FORTRAN)
#define LOAD_VAR_USHORTARR(A) 		xdr_load_type (D_VAR_USHORTARR, \
                                                (DevDataFunction) xdr_DevVarUShortArray, \
                                                sizeof(DevVarUShortArray),\
                                                xdr_length_DevVarUShortArray, \
                                                A)


struct DevVarShortArray {
	u_int length;
	short *sequence;
};
typedef struct DevVarShortArray 	DevVarShortArray;
bool_t	_DLLFunc xdr_DevVarShortArray
		 PT_((XDR *xdrs, DevVarShortArray *objp));
long   	_DLLFunc xdr_length_DevVarShortArray
		 PT_((DevVarShortArray *objp));
#endif /* FORTRAN */
#define D_VAR_SHORTARR          	10
#if !defined(FORTRAN)
#define LOAD_VAR_SHORTARR(A)         	xdr_load_type (D_VAR_SHORTARR, \
						(DevDataFunction) xdr_DevVarShortArray, \
						sizeof(DevVarShortArray), \
						xdr_length_DevVarShortArray, \
						A )

/*
 *  Unsigned long array
 */

struct DevVarULongArray {
	u_int length;
	unsigned long *sequence;
};
typedef struct DevVarULongArray		DevVarULongArray;
bool_t	_DLLFunc xdr_DevVarULongArray
		 PT_((XDR *xdrs, DevVarULongArray *objp));
long	_DLLFunc xdr_length_DevVarULongArray
		 PT_((DevVarULongArray *objp));
#endif /* FORTRAN */
#define D_VAR_ULONGARR			69
#if !defined(FORTRAN)
#define LOAD_VAR_ULONGARR(A)        	xdr_load_type (D_VAR_ULONGARR, \
						(DevDataFunction) xdr_DevVarULongArray, \
						sizeof(DevVarULongArray), \
						xdr_length_DevVarULongArray,\
						A )


struct DevVarLongArray {
	u_int length;
	long  *sequence;
};
typedef struct DevVarLongArray 		DevVarLongArray;
bool_t 	_DLLFunc xdr_DevVarLongArray
		 PT_((XDR *xdrs, DevVarLongArray *objp));
long   	_DLLFunc xdr_length_DevVarLongArray
		 PT_((DevVarLongArray *objp));
#endif /* FORTRAN */
#define D_VAR_LONGARR           	11
#if !defined(FORTRAN)
#define LOAD_VAR_LONGARR(A)         	xdr_load_type (D_VAR_LONGARR, \
						(DevDataFunction) xdr_DevVarLongArray, \
						sizeof(DevVarLongArray), \
						xdr_length_DevVarLongArray, \
						A )


struct DevVarFloatArray {
	u_int length;
	float *sequence;
};
typedef struct DevVarFloatArray 	DevVarFloatArray;
bool_t 	_DLLFunc xdr_DevVarFloatArray
		 PT_((XDR *xdrs, DevVarFloatArray *objp));
long   	_DLLFunc xdr_length_DevVarFloatArray
		 PT_((DevVarFloatArray *objp));
#endif /* FORTRAN */
#define D_VAR_FLOATARR          	12
#if !defined(FORTRAN)
#define LOAD_VAR_FLOATARR(A)         	xdr_load_type (D_VAR_FLOATARR, \
						(DevDataFunction) xdr_DevVarFloatArray, \
						sizeof(DevVarFloatArray), \
						xdr_length_DevVarFloatArray, \
						A )


struct DevVarDoubleArray {
	u_int length;
	double *sequence;
};
typedef struct DevVarDoubleArray 	DevVarDoubleArray;
bool_t 	_DLLFunc xdr_DevVarDoubleArray
		 PT_((XDR *xdrs, DevVarDoubleArray *objp));
long   	_DLLFunc xdr_length_DevVarDoubleArray
		  PT_((DevVarDoubleArray *objp));
#endif /* FORTRAN */
#define D_VAR_DOUBLEARR         	68
#if !defined(FORTRAN)
#define LOAD_VAR_DOUBLEARR(A)         	xdr_load_type (D_VAR_DOUBLEARR, \
						(DevDataFunction) xdr_DevVarDoubleArray, \
						sizeof(DevVarDoubleArray), \
						xdr_length_DevVarDoubleArray,\
						A )


struct DevVarFloatReadPointArray {
	u_int 		  length;
	DevFloatReadPoint *sequence;
};
typedef struct DevVarFloatReadPointArray DevVarFloatReadPointArray;
bool_t 	_DLLFunc xdr_DevVarFloatReadPointArray
		 PT_((XDR *xdrs, DevVarFloatReadPointArray *objp));
long   	_DLLFunc xdr_length_DevVarFloatReadPointArray
		 PT_((DevVarFloatReadPointArray *objp));
#endif /* FORTRAN */
#define D_VAR_FRPARR            	25
#if !defined(FORTRAN)
#define LOAD_VAR_FRPARR(A)         	xdr_load_type (D_VAR_FRPARR, \
					  (DevDataFunction) xdr_DevVarFloatReadPointArray, \
					  sizeof(DevVarFloatReadPointArray), \
					  xdr_length_DevVarFloatReadPointArray,\
					  A )


struct DevVarStateFloatReadPointArray {
	u_int 		        length;
	DevStateFloatReadPoint *sequence;
};
typedef struct DevVarStateFloatReadPointArray DevVarStateFloatReadPointArray;
bool_t 	_DLLFunc xdr_DevVarStateFloatReadPointArray
		 PT_((XDR *xdrs, DevVarStateFloatReadPointArray *objp));
long   	_DLLFunc xdr_length_DevVarStateFloatReadPointArray
		 PT_((DevVarStateFloatReadPointArray *objp));
#endif /* FORTRAN */
#define D_VAR_SFRPARR           73
#if !defined(FORTRAN)
#define LOAD_VAR_SFRPARR(A)     xdr_load_type (D_VAR_SFRPARR, \
				(DevDataFunction) xdr_DevVarStateFloatReadPointArray, \
				sizeof(DevVarStateFloatReadPointArray), \
				xdr_length_DevVarStateFloatReadPointArray,\
				A )



struct DevVarLongReadPointArray {
	u_int 		  length;
	DevLongReadPoint  *sequence;
};
typedef struct DevVarLongReadPointArray DevVarLongReadPointArray;
bool_t  _DLLFunc xdr_DevVarLongReadPointArray
		 PT_((XDR *xdrs, DevVarLongReadPointArray *objp));
long   	_DLLFunc xdr_length_DevVarLongReadPointArray
		 PT_((DevVarLongReadPointArray *objp));
#endif /* FORTRAN */
#define D_VAR_LRPARR            	45
#if !defined(FORTRAN)
#define LOAD_VAR_LRPARR(A)         	xdr_load_type (D_VAR_LRPARR, \
					  (DevDataFunction) xdr_DevVarLongReadPointArray, \
					  sizeof(DevVarLongReadPointArray), \
					  xdr_length_DevVarLongReadPointArray, \
					  A)


/* 
 *  Opaque data type to transfer blocks of data
 */

struct DevOpaque {
	u_int	length;
	char    *sequence;
};
typedef struct DevOpaque 		DevOpaque;
bool_t 					_DLLFunc xdr_DevOpaque
					PT_((XDR *xdrs, DevOpaque *objp));
bool_t 					_DLLFunc xdr_DevOpaqueRaw
					PT_((XDR *xdrs, DevOpaque *objp));
long   					_DLLFunc xdr_length_DevOpaque
					PT_((DevOpaque *objp));
#endif /* FORTRAN */
#define D_OPAQUE_TYPE           	47
#if !defined(FORTRAN)
#define LOAD_OPAQUE_TYPE(A)        	xdr_load_type (D_OPAQUE_TYPE, \
						(DevDataFunction) xdr_DevOpaque, \
						sizeof(DevOpaque), \
						xdr_length_DevOpaque,\
						A )
#endif /* FORTRAN */

#ifdef __cplusplus
}
#endif

#endif /* _dev_xdr_h */
