
/*+*******************************************************************

 File:          bpss_xdr.h

 Project:       Device Servers with sun-rpc

 Description:   Include file for XDR definitions
		of the Booster Powersupply System
		data types.

 Author(s):  	Jens Meyer

 Original:	July 1992


 $Revision: 5.21 $
 $Date: 2001/11/12 10:01:38 $

 $Author: goetz $

 $Log:	bpss_xdr.h,v $
 * Revision 5.21  2001/11/12  10:01:38  10:01:38  goetz (Andy Goetz)
 * updated C port for Windows 95/98/NT using Visual C++ 6
 * 
 Revision 5.20  2001/01/08 12:17:37  goetz
 added patch by B.Pedersen to support querying events

 Revision 5.19  2000/10/02 12:08:48  goetz
 removed stderr from api_xdr.c

 Revision 5.18  1999/07/08 14:10:49  goetz
 changed _LPfd_set type for Linux in macros.h

 Revision 5.17  1998/05/25 17:59:53  klotz
 fixed C++ prototypes in api_xdr.h

 Revision 5.16  1998/04/29 10:24:15  goetz
 macros.h - added __STDCPP__ for HP C++ compiler (aCC)

 * Revision 5.15  97/12/01  15:22:16  15:22:16  klotz (W.D. Klotz)
 * WIN_NT_95_released_NOV_97
 * 
 * Revision 4.34  97/01/30  13:58:47  13:58:47  goetz (Andy Goetz)
 * removed dev_printdebug() from DevXdrKernel.h
 * 
 * Revision 4.33  97/01/09  10:08:50  10:08:50  goetz (Andy Goetz)
 * (xdrproc_t) castings added to maxe_xdr, ram_xdr, thc_xdr, seism_xdr
 * 
 * Revision 4.32  97/01/08  16:48:40  16:48:40  goetz (Andy Goetz)
 * Ported to Linux (2.0.9)
 * 
 Revision 4.31  1996/11/18 17:28:55  goetz
 Check

 * Revision 4.28  96/10/21  16:22:40  16:22:40  taurel (E.Taurel)
 * Check_in_after_port_to_OS9/ISP_2.1_and_OS9/RPC1.4
 * 
 * Revision 4.27  96/09/17  16:45:41  16:45:41  klotz (W.D. Klotz)
 * WD Klotz: checked NT build
 * 
 * Revision 4.26  96/07/19  10:01:09  10:01:09  taurel (E.Taurel)
 * Some_change_in_macros.h_for_the_API_port_to_OS-9_Ultra_C++
 * 
 * Revision 4.25  96/06/07  16:23:13  16:23:13  meyer (J.Meyer)
 * Corrected_elif_to_else_in_macros.h
 * 
 * Revision 4.24  96/06/05  15:01:49  15:01:49  meyer (J.Meyer)
 * Corrected_macros.h
 * 
 * Revision 4.23  96/06/03  13:10:27  13:10:27  meyer (J.Meyer)
 * Cleaned-up_MSDOS_and_added_porting_options_for_Windows_NT.
 * 
 * Revision 4.22  96/05/23  11:07:34  11:07:34  taurel (E.Taurel)
 * Added_some_definitions_for_C++_in_API_xdr.h_file
 * 
 * Revision 4.21  96/05/06  18:37:44  18:37:44  meyer (J.Meyer)
 * Fortran_compatibility_for:_dev_xdr.h,macros.h,maxe_xdr.h
 * 
 * Revision 4.20  96/02/27  13:31:44  13:31:44  meyer (J.Meyer)
 * Deleted_Cross_References_To_DSAPI_Library
 * 
 * Revision 4.19  96/01/11  17:40:29  17:40:29  meyer (Jens Meyer)
 * Added_#define_PORTMAP_to_macros.h.
 * 
 * Revision 4.18  95/12/21  10:33:47  10:33:47  meyer (Jens Meyer)
 * Corrected length calculation for D_VAR_MSTATARR.
 * 
 * Revision 4.17  95/08/02  16:05:22  16:05:22  meyer (Jens Meyer)
 * Corrected DevXdrKernel.h after C++ implementation.
 * 
 * Revision 4.15  95/03/02  10:28:11  10:28:11  meyer (Jens Meyer)
 * Added D_VAR_SFRPARR type to the kernel.
 * 
 * Revision 4.14  95/02/20  09:57:09  09:57:09  meyer (Jens Meyer)
 * Passed the compilers for HPUX, SUNOS and UCC after the first windows check in.
 * 
 * Revision 4.13  95/02/10  17:19:18  17:19:18  meyer (Jens Meyer)
 * Deleted
 * 
 * Revision 4.12  95/02/01  14:27:22  14:27:22  klotz (W.D. Klotz)
 * WDK: first successfull compile of dbase, api, xdr on WIN16/3.1
 * 
 * Revision 4.11  95/01/03  13:19:38  13:19:38  meyer (Jens Meyer)
 * Repared bug in dev_cmd_query() for version 3!
 * 
 * Revision 4.10  94/12/08  15:25:09  15:25:09  meyer (Jens Meyer)
 * Changed _manager_data in API_xdr and added old version to API_xdr_vers3.
 * 
 * Revision 4.9  94/11/28  17:04:31  17:04:31  meyer (Jens Meyer)
 * Data types for compatibility with library version 3.x
 * 
 * Revision 4.8  94/08/16  16:59:46  16:59:46  meyer (Jens Meyer)
 * Corrected error in ws_xdr.h
 * 
 * Revision 4.7  94/08/16  16:34:41  16:34:41  meyer (Jens Meyer)
 * Added define for MAX_RESOURCE_FIELD_LENGTH to macros.h
 * 
 * Revision 4.6  94/08/12  15:07:57  15:07:57  meyer (Jens Meyer)
 * Added valriable arguments to all API RPC structures.
 * 
 * Revision 4.5  94/07/20  18:15:57  18:15:57  meyer (Jens Meyer)
 * Changed include files in macros.h!
 * 
 * Revision 4.4  94/07/20  08:56:10  08:56:10  meyer (Jens Meyer)
 * All XDR functions with prototypes!
 * 
 * Revision 4.3  94/07/18  18:51:05  18:51:05  meyer (Jens Meyer)
 * Had to change macros.h, because #define must be in the first column!
 * 
 * Revision 4.2  94/07/18  18:22:37  18:22:37  meyer (Jens Meyer)
 * First test with PC macros for the XDR kernel.
 * 
 * Revision 4.1  94/05/02  10:50:58  10:50:58  meyer (Jens Meyer)
 * For Security System without connection count.
 * 
 * Revision 4.0  94/03/14  18:17:42  18:17:42  meyer (Jens Meyer)
 * Library version with Security System.
 * 
 * Revision 3.50  94/03/12  14:36:35  14:36:35  meyer (Jens Meyer)
 * Changed API xdr structures for security.
 * 
 * Revision 3.35  94/03/03  10:52:21  10:52:21  taurel (Emmanuel TAUREL)
 * Added unsigned long array type in the XDRkernel
 * 
 * Revision 3.34  94/03/03  10:29:12  10:29:12  taurel (Emmanuel TAUREL)
 * Added the unsigned long array type in
 * XDR kernel (LC and ET).
 * 
 * Revision 3.33  94/01/12  16:34:36  16:34:36  meyer (Jens Meyer)
 * Global XDR type array for data collector access
 *
 * Revision 3.31  93/12/02  09:39:16  09:39:16  meyer (Jens Meyer)
 * New release with small XDR data type kernel.
 * 
 * Revision 1.2  93/12/01  17:17:49  17:17:49  meyer (Jens Meyer)
 * *** empty log message ***
 * 
 * Revision 1.1  93/11/16  16:55:31  16:55:31  meyer (Jens Meyer)
 * Initial revision
 * 

 Copyright (c) 1990 by European Synchrotron Radiation Facility,
		       Grenoble, France

*******************************************************************-*/

#ifndef _bpss_xdr_h
#define _bpss_xdr_h


/*
 *  definition for booster power supplies system
 */
struct DevStateIndic {
		short State;
		short Indic;
		     };
typedef struct DevStateIndic 	DevStateIndic;
bool_t 	_DLLFunc xdr_DevStateIndic PT_((XDR *xdrs, DevStateIndic *objp));
long   	_DLLFunc xdr_length_DevStateIndic PT_((DevStateIndic *objp));
#define D_STATE_INDIC           34
#define LOAD_STATE_INDIC(A)     xdr_load_type ( D_STATE_INDIC, \
                                                xdr_DevStateIndic, \
                                                sizeof(DevStateIndic), \
                                                xdr_length_DevStateIndic, \
                                                A )

struct DevBpssState {
		short Ac;
		short Dc;
		    };
typedef struct DevBpssState 	DevBpssState;
bool_t 	_DLLFunc xdr_DevBpssState PT_((XDR *xdrs, DevBpssState *objp));
long   	_DLLFunc xdr_length_DevBpssState PT_((DevBpssState *objp));
#define D_BPSS_STATE            35
#define LOAD_BPSS_STATE(A)      xdr_load_type ( D_BPSS_STATE, \
                                                xdr_DevBpssState, \
                                                sizeof(DevBpssState), \
                                                xdr_length_DevBpssState, \
                                                A )



struct DevBpssLine {
		float Set;
		float Read;
		short Control;
		short Alarm;
		     };
typedef struct DevBpssLine 	DevBpssLine;
bool_t 	_DLLFunc xdr_DevBpssLine PT_((XDR *xdrs, DevBpssLine *objp));
long   	_DLLFunc xdr_length_DevBpssLine PT_((DevBpssLine *objp));
#define D_BPSS_LINE             41
#define LOAD_BPSS_LINE(A)      xdr_load_type ( D_BPSS_LINE, \
                                                xdr_DevBpssLine, \
                                                sizeof(DevBpssLine), \
                                                xdr_length_DevBpssLine, \
                                                A )

struct DevBpssReadPoint {
		 DevBpssLine IACinv;
		 DevBpssLine IACmag;
		 DevBpssLine IDCmag;
		 DevBpssLine Period;
		 DevBpssLine PhLag;
                 float      PhLagUI;
                 float      VACinv;
                 float      VDCmag;
                 float      CapTemp;
                 float      ChokeTemp;
		 float	    Temperature[8];
		 DevBpssState State;
		 DevBpssState ExtState;
		 DevBpssState Faults[32];
		 short	    Master;
			};
typedef struct DevBpssReadPoint DevBpssReadPoint;
bool_t 	_DLLFunc xdr_DevBpssReadPoint
		 PT_((XDR *xdrs, DevBpssReadPoint *objp));
long   	_DLLFunc xdr_length_DevBpssReadPoint PT_((DevBpssReadPoint *objp));
#define D_BPSS_READPOINT        36
#define LOAD_BPSS_READPOINT(A)  xdr_load_type ( D_BPSS_READPOINT, \
                                                xdr_DevBpssReadPoint, \
                                                sizeof(DevBpssReadPoint), \
                                                xdr_length_DevBpssReadPoint, \
                                                A )

#endif /* _bpss_xdr_h */

