
/*+*******************************************************************

 File:          API_xdr_vers3.h

 Project:       Device Servers with sun-rpc

 Description:   xdr definitinos for all services in the
		applications programmers interface for the old
		version 3. This file is needed for compatibility
		reasons.

 Author(s):	Jens Meyer

 Original:	November 1994


$Revision: 5.21 $
$Date: 2001/11/12 10:01:38 $

$Author: goetz $

$Log:	API_xdr_vers3.h,v $
 * Revision 5.21  2001/11/12  10:01:38  10:01:38  goetz (Andy Goetz)
 * updated C port for Windows 95/98/NT using Visual C++ 6
 * 
Revision 5.20  2001/01/08 12:17:37  goetz
added patch by B.Pedersen to support querying events

Revision 5.19  2000/10/02 12:08:48  goetz
removed stderr from api_xdr.c

Revision 5.18  1999/07/08 14:10:49  goetz
changed _LPfd_set type for Linux in macros.h

Revision 5.17  1998/05/25 17:59:49  klotz
fixed C++ prototypes in api_xdr.h

Revision 5.16  1998/04/29 10:24:11  goetz
macros.h - added __STDCPP__ for HP C++ compiler (aCC)

 * Revision 5.15  97/12/01  15:22:11  15:22:11  klotz (W.D. Klotz)
 * WIN_NT_95_released_NOV_97
 * 
 * Revision 4.34  97/01/30  13:58:43  13:58:43  goetz (Andy Goetz)
 * removed dev_printdebug() from DevXdrKernel.h
 * 
 * Revision 4.33  97/01/09  10:08:48  10:08:48  goetz (Andy Goetz)
 * (xdrproc_t) castings added to maxe_xdr, ram_xdr, thc_xdr, seism_xdr
 * 
 * Revision 4.32  97/01/08  16:48:37  16:48:37  goetz (Andy Goetz)
 * Ported to Linux (2.0.9)
 * 
Revision 4.31  1996/11/18 17:28:53  goetz
Check

 * Revision 4.28  96/10/21  16:22:35  16:22:35  taurel (E.Taurel)
 * Check_in_after_port_to_OS9/ISP_2.1_and_OS9/RPC1.4
 * 
 * Revision 4.27  96/09/17  16:45:34  16:45:34  klotz (W.D. Klotz)
 * WD Klotz: checked NT build
 * 
 * Revision 4.26  96/07/19  10:01:06  10:01:06  taurel (E.Taurel)
 * Some_change_in_macros.h_for_the_API_port_to_OS-9_Ultra_C++
 * 
 * Revision 4.25  96/06/07  16:23:10  16:23:10  meyer (J.Meyer)
 * Corrected_elif_to_else_in_macros.h
 * 
 * Revision 4.24  96/06/05  15:01:46  15:01:46  meyer (J.Meyer)
 * Corrected_macros.h
 * 
 * Revision 4.23  96/06/03  13:10:24  13:10:24  meyer (J.Meyer)
 * Cleaned-up_MSDOS_and_added_porting_options_for_Windows_NT.
 * 
 * Revision 4.22  96/05/23  11:07:32  11:07:32  taurel (E.Taurel)
 * Added_some_definitions_for_C++_in_API_xdr.h_file
 * 
 * Revision 4.21  96/05/06  18:37:41  18:37:41  meyer (J.Meyer)
 * Fortran_compatibility_for:_dev_xdr.h,macros.h,maxe_xdr.h
 * 
 * Revision 4.20  96/02/27  13:31:42  13:31:42  meyer (J.Meyer)
 * Deleted_Cross_References_To_DSAPI_Library
 * 
 * Revision 4.19  96/01/11  17:40:27  17:40:27  meyer (Jens Meyer)
 * Added_#define_PORTMAP_to_macros.h.
 * 
 * Revision 4.18  95/12/21  10:33:41  10:33:41  meyer (Jens Meyer)
 * Corrected length calculation for D_VAR_MSTATARR.
 * 
 * Revision 4.17  95/08/02  16:05:19  16:05:19  meyer (Jens Meyer)
 * Corrected DevXdrKernel.h after C++ implementation.
 * 
 * Revision 4.15  95/03/02  10:28:05  10:28:05  meyer (Jens Meyer)
 * Added D_VAR_SFRPARR type to the kernel.
 * 
 * Revision 4.14  95/02/20  09:56:59  09:56:59  meyer (Jens Meyer)
 * Passed the compilers for HPUX, SUNOS and UCC after the first windows check in.
 * 
 * Revision 4.13  95/02/10  17:19:12  17:19:12  meyer (Jens Meyer)
 * Deleted
 * 
 * Revision 4.12  95/02/01  14:27:49  14:27:49  klotz (W.D. Klotz)
 * WDK: first successfull compile of dbase, api, xdr on WIN16/3.1
 * 
 * Revision 4.11  95/01/03  13:19:32  13:19:32  meyer (Jens Meyer)
 * Repared bug in dev_cmd_query() for version 3!
 * 
 * Revision 4.10  94/12/08  15:25:04  15:25:04  meyer (Jens Meyer)
 * Changed _manager_data in API_xdr and added old version to API_xdr_vers3.
 * 
 * Revision 4.9  94/11/28  17:04:25  17:04:25  meyer (Jens Meyer)
 * Data types for compatibility with library version 3.x
 * 
 * Revision 1.1  94/11/28  17:01:24  17:01:24  meyer (Jens Meyer)
 * Initial revision
 * 

 Copyright (c) 1990 by European Synchrotron Radiation Facility,
		       Grenoble, France

*******************************************************************-*/

#ifndef _api_xdr_vers3_h
#define _api_xdr_vers3_h

/*
 *  standart header string to use "what" or "ident".
 */
#ifdef _IDENT
static char API_xdrh[] =
"@(#)$Header: API_xdr_vers3.h,v 5.21 2001/11/12 10:01:38 goetz Rel $";
#endif /* _IDENT */


#include <macros.h>


/*
 *  xdr data structures used in the dev_putget(),
 *  dev_put() and dev_putget_raw() calls.
 */

struct _server_data_3 {
 	long ds_id;
	long cmd;
	long argin_type;
	long argout_type;
	DevArgument argin;
};
typedef struct _server_data_3 _server_data_3;


struct _client_data_3 {
  	long status;
	long error;
	long argout_type;
	DevArgument argout;
};
typedef struct _client_data_3 _client_data_3;



struct _client_raw_data_3 {
  	long status;
	long error;
	long ser_argout_type;
	long deser_argout_type;
	long xdr_length;
	DevArgument argout;
};
typedef struct _client_raw_data_3 _client_raw_data_3;




/*
 *  internal structures for device services
 */

struct _dev_import_in_3 {
        char *device_name;
};
typedef struct _dev_import_in_3 _dev_import_in_3;


struct _dev_import_out_3 {
        char server_name[LONG_NAME_SIZE];
	long ds_id;
	long status;
	long error;
};
typedef struct _dev_import_out_3 _dev_import_out_3;


struct _dev_free_in_3 {
	long ds_id;
};
typedef struct _dev_free_in_3 _dev_free_in_3;


struct _dev_free_out_3 {
	long status;
	long error;
};
typedef struct _dev_free_out_3 _dev_free_out_3;


/*
 *  structures for dev_cmd_query()
 */

struct _dev_query_in_3 {
  	long                ds_id;
};
typedef struct _dev_query_in_3 _dev_query_in_3;


struct _dev_query_out_3 {
  	u_int           length;
  	_dev_cmd_info   *sequence;
  	char            class_name [20];
  	long            error;
  	long            status;
};
typedef struct _dev_query_out_3 _dev_query_out_3;


struct _manager_data_3 {
        _register_data  msg_info;
        _register_data  db_info;
        long    status;
        long    error;
};
typedef struct _manager_data_3 _manager_data_3;

					 
					 
#ifdef __cplusplus
extern "C" {
#endif					 					 
bool_t _DLLFunc xdr__server_data_3 PT_((XDR *xdrs,_server_data_3 *objp));
bool_t _DLLFunc xdr__client_data_3 PT_((XDR *xdrs, 
					_client_data_3 *objp));
bool_t _DLLFunc xdr__client_raw_data_3 PT_((XDR *xdrs,
					    _client_raw_data_3 *objp));
bool_t _DLLFunc xdr__dev_import_in_3 PT_((XDR *xdrs, 
					  _dev_import_in_3 *objp));
bool_t _DLLFunc xdr__dev_import_out_3 PT_((XDR *xdrs, 
					   _dev_import_out_3 *objp));
bool_t _DLLFunc xdr__dev_free_in_3 PT_((XDR *xdrs,
					_dev_free_in_3 *objp));
bool_t _DLLFunc xdr__dev_free_out_3 PT_((XDR *xdrs,
					 _dev_free_out_3 *objp));
bool_t _DLLFunc xdr__dev_query_in_3 PT_((XDR *xdrs, 
					 _dev_query_in_3 *objp));
bool_t _DLLFunc xdr__dev_query_out_3 PT_((XDR *xdrs, 
					  _dev_query_out_3 *objp));
#ifdef __cplusplus
#ifdef _UCC
bool_t _DLLFunc xdr__manager_data_3 (...); 
#else
bool_t _DLLFunc xdr__manager_data_3 PT_((XDR *xdrs, 
					 _manager_data_3 *objp));
#endif /* _UCC */
#else
bool_t _DLLFunc xdr__manager_data_3 PT_((XDR *xdrs, 
					 _manager_data_3 *objp));
#endif /* __cplusplus */

#ifdef __cplusplus
}
#endif
					
#endif /* _api_xdr_vers3_h */
