
/*+*******************************************************************

 File:          API_xdr.h

 Project:       Device Servers with sun-rpc

 Description:   xdr definitinos for all services in the
		applications programmers interface.

 Author(s):	Jens Meyer

 Original:	January 1991


$Revision: 5.21 $
$Date: 2001/11/12 10:01:38 $

$Author: goetz $

$Log:	API_xdr.h,v $
 * Revision 5.21  2001/11/12  10:01:38  10:01:38  goetz (Andy Goetz)
 * updated C port for Windows 95/98/NT using Visual C++ 6
 * 
Revision 5.20  2001/01/08 12:17:37  goetz
added patch by B.Pedersen to support querying events

Revision 8.31  2000/07/28 09:59:53  dserver
BP: added dev_query_event to get event parameters
    -> new data struture  for event list in server
       events have to be registered by the server,
       similar to commands.

Revision 5.19  2000/10/02 12:08:48  goetz
removed stderr from api_xdr.c

Revision 5.18  1999/07/08 14:10:49  goetz
changed _LPfd_set type for Linux in macros.h

Revision 5.17  1998/05/25 17:59:48  klotz
fixed C++ prototypes in api_xdr.h

Revision 5.16  1998/04/29 10:24:10  goetz
macros.h - added __STDCPP__ for HP C++ compiler (aCC)

 * Revision 5.15  97/12/01  15:21:51  15:21:51  klotz (W.D. Klotz)
 * WIN_NT_95_released_NOV_97
 * 
 * Revision 4.34  97/01/30  13:58:42  13:58:42  goetz (Andy Goetz)
 * removed dev_printdebug() from DevXdrKernel.h
 * 
 * Revision 4.33  97/01/09  10:08:47  10:08:47  goetz (Andy Goetz)
 * (xdrproc_t) castings added to maxe_xdr, ram_xdr, thc_xdr, seism_xdr
 * 
 * Revision 4.32  97/01/08  16:48:37  16:48:37  goetz (Andy Goetz)
 * Ported to Linux (2.0.9)
 * 
Revision 4.31  1996/11/18 17:28:52  goetz
Check

 * Revision 4.28  96/10/21  16:22:34  16:22:34  taurel (E.Taurel)
 * Check_in_after_port_to_OS9/ISP_2.1_and_OS9/RPC1.4
 * 
 * Revision 4.27  96/09/17  16:45:14  16:45:14  klotz (W.D. Klotz)
 * WD Klotz: checked NT build
 * 
 * Revision 4.26  96/07/19  10:01:06  10:01:06  taurel (E.Taurel)
 * Some_change_in_macros.h_for_the_API_port_to_OS-9_Ultra_C++
 * 
 * Revision 4.25  96/06/07  16:23:10  16:23:10  meyer (J.Meyer)
 * Corrected_elif_to_else_in_macros.h
 * 
 * Revision 4.24  96/06/05  15:01:46  15:01:46  meyer (J.Meyer)
 * Corrected_macros.h
 * 
 * Revision 4.23  96/06/03  13:10:23  13:10:23  meyer (J.Meyer)
 * Cleaned-up_MSDOS_and_added_porting_options_for_Windows_NT.
 * 
 * Revision 4.22  96/05/23  11:07:31  11:07:31  taurel (E.Taurel)
 * Added_some_definitions_for_C++_in_API_xdr.h_file
 * 
 * Revision 4.21  96/05/06  18:37:41  18:37:41  meyer (J.Meyer)
 * Fortran_compatibility_for:_dev_xdr.h,macros.h,maxe_xdr.h
 * 
 * Revision 4.20  96/02/27  13:31:42  13:31:42  meyer (J.Meyer)
 * Deleted_Cross_References_To_DSAPI_Library
 * 
 * Revision 4.19  96/01/11  17:40:27  17:40:27  meyer (Jens Meyer)
 * Added_#define_PORTMAP_to_macros.h.
 * 
 * Revision 4.18  95/12/21  10:33:41  10:33:41  meyer (Jens Meyer)
 * Corrected length calculation for D_VAR_MSTATARR.
 * 
 * Revision 4.17  95/08/02  16:05:19  16:05:19  meyer (Jens Meyer)
 * Corrected DevXdrKernel.h after C++ implementation.
 * 
 * Revision 4.15  95/03/02  10:28:04  10:28:04  meyer (Jens Meyer)
 * Added D_VAR_SFRPARR type to the kernel.
 * 
 * Revision 4.14  95/02/20  09:56:57  09:56:57  meyer (Jens Meyer)
 * Passed the compilers for HPUX, SUNOS and UCC after the first windows check in.
 * 
 * Revision 4.13  95/02/10  17:19:11  17:19:11  meyer (Jens Meyer)
 * Deleted
 * 
 * Revision 4.12  95/02/01  14:27:15  14:27:15  klotz (W.D. Klotz)
 * WDK: first successfull compile of dbase, api, xdr on WIN16/3.1
 * 
 * Revision 4.11  95/01/03  13:19:31  13:19:31  meyer (Jens Meyer)
 * Repared bug in dev_cmd_query() for version 3!
 * 
 * Revision 4.10  94/12/08  15:25:04  15:25:04  meyer (Jens Meyer)
 * Changed _manager_data in API_xdr and added old version to API_xdr_vers3.
 * 
 * Revision 4.9  94/11/28  17:04:24  17:04:24  meyer (Jens Meyer)
 * Data types for compatibility with library version 3.x
 * 
 * Revision 4.8  94/08/16  16:59:41  16:59:41  meyer (Jens Meyer)
 * Corrected error in ws_xdr.h
 * 
 * Revision 4.7  94/08/16  16:34:36  16:34:36  meyer (Jens Meyer)
 * Added define for MAX_RESOURCE_FIELD_LENGTH to macros.h
 * 
 * Revision 4.6  94/08/12  15:07:52  15:07:52  meyer (Jens Meyer)
 * Added valriable arguments to all API RPC structures.
 * 
 * Revision 4.5  94/07/20  18:15:51  18:15:51  meyer (Jens Meyer)
 * Changed include files in macros.h!
 * 
 * Revision 4.4  94/07/20  08:56:05  08:56:05  meyer (Jens Meyer)
 * All XDR functions with prototypes!
 * 
 * Revision 4.3  94/07/18  18:51:00  18:51:00  meyer (Jens Meyer)
 * Had to change macros.h, because #define must be in the first column!
 * 
 * Revision 4.2  94/07/18  18:22:30  18:22:30  meyer (Jens Meyer)
 * First test with PC macros for the XDR kernel.
 * 
 * Revision 4.1  94/05/02  10:50:53  10:50:53  meyer (Jens Meyer)
 * For Security System without connection count.
 * 
 * Revision 4.0  94/03/14  18:17:38  18:17:38  meyer (Jens Meyer)
 * Library version with Security System.
 * 
 * Revision 3.50  94/03/12  14:36:31  14:36:31  meyer (Jens Meyer)
 * Changed API xdr structures for security.
 * 
 * Revision 3.35  94/03/03  10:52:16  10:52:16  taurel (Emmanuel TAUREL)
 * Added unsigned long array type in the XDRkernel
 * 
 * Revision 3.34  94/03/03  10:29:07  10:29:07  taurel (Emmanuel TAUREL)
 * Added the unsigned long array type in
 * XDR kernel (LC and ET).
 * 
 * Revision 3.33  94/01/12  16:34:31  16:34:31  meyer (Jens Meyer)
 * Global XDR type array for data collector access
 * 
 * Revision 3.31  93/12/02  09:39:07  09:39:07  meyer (Jens Meyer)
 * New release with small XDR data type kernel.
 * 
 * Revision 3.24  93/10/29  17:03:53  17:03:53  meyer (Jens Meyer)
 * Added length calculation for Rad. Monitor types
 * 
 * Revision 3.23  93/10/13  12:58:21  12:58:21  meyer (Jens Meyer)
 * Changed structures in pin_xdr.*
 * 
 * Revision 3.22  93/08/25  09:40:18  09:40:18  meyer (Jens Meyer)
 * Length calculation of D_VAR_MSTATARR was deleted in revision 3.14
 * 
 * Revision 3.21  93/06/25  11:16:28  11:16:28  meyer (Jens Meyer)
 * Corrected bug in BPM length calculation
 * 
 * Revision 3.20  93/06/24  18:10:38  18:10:38  meyer (Jens Meyer)
 * BPM XDR-length calculation
 * 
 * Revision 3.17  93/06/24  18:08:37  18:08:37  meyer (Jens Meyer)
 * New Pinhole XDR Types.
 * 
 * Revision 3.16  93/06/07  09:05:09  09:05:09  meyer (Jens Meyer)
 * Added GRP xdr types.
 * 
 * Revision 3.15  93/06/04  14:12:37  14:12:37  domingue ( Marie-Christine Dominguez)
 * Changed m4_xdr types.
 * 
 * Revision 3.14  93/05/27  12:59:15  12:59:15  meyer (Jens Meyer)
 * Added m4_xdr types and corrected icv101_xdr.
 * 
 * Revision 3.13  93/05/13  11:14:15  11:14:15  taurel (Emmanuel TAUREL)
 * Fix bug in daemon_data xdr function
 * 
 * Revision 3.12  93/04/28  08:28:45  08:28:45  meyer (Jens Meyer)
 * Added length calculation for BPSS structures
 * 
 * Revision 3.11  93/03/11  16:53:32  16:53:32  meyer (Jens Meyer)
 * Corrected length calculation for D_VAR_MSTATARR
 * 
 * Revision 3.10  93/03/10  08:45:06  08:45:06  meyer (Jens Meyer)
 * Added new type D_VAR_MSTATARR.
 * 

 Copyright (c) 1990 by European Synchrotron Radiation Facility,
		       Grenoble, France

*******************************************************************-*/

#ifndef _api_xdr_h
#define _api_xdr_h

/*
 *  standart header string to use "what" or "ident".
 */
#ifdef _IDENT
static char API_xdrh[] =
"@(#)$Header: API_xdr.h,v 5.21 2001/11/12 10:01:38 goetz Rel $";
#endif /* _IDENT */


#include <macros.h>

/*
 * Structures for variable argument passing for API calls.
 * Will avoid recompilation of the system when adding variables.
 */

struct DevVarArgument {
	long 		argument_type;
	DevArgument 	argument;
};
typedef struct DevVarArgument DevVarArgument;

struct DevVarArgumentArray {
        u_int 		length;
        DevVarArgument  *sequence;
};
typedef struct DevVarArgumentArray DevVarArgumentArray;

/*
 *  xdr data structures used in the dev_putget(),
 *  dev_put() and dev_putget_raw() calls.
 */

struct _server_data {
 	long ds_id;
	long cmd;
	long argin_type;
	long argout_type;
	DevArgument argin;
 	long access_right;
 	long client_id;
	DevVarArgumentArray var_argument;
};
typedef struct _server_data _server_data;


struct _client_data {
  	long status;
	long error;
	long argout_type;
	DevArgument argout;
	DevVarArgumentArray var_argument;
};
typedef struct _client_data _client_data;



struct _client_raw_data {
  	long status;
	long error;
	long ser_argout_type;
	long deser_argout_type;
	long xdr_length;
	DevArgument argout;
	DevVarArgumentArray var_argument;
};
typedef struct _client_raw_data _client_raw_data;




/*
 *  internal structures for device services
 */

struct _dev_import_in {
        char *device_name;
	long access_right;
	long client_id;
	long connection_id;
	DevVarArgumentArray var_argument;
};
typedef struct _dev_import_in _dev_import_in;


struct _dev_import_out {
	char server_name[LONG_NAME_SIZE];
	long ds_id;
	long status;
	long error;
	DevVarArgumentArray var_argument;
};
typedef struct _dev_import_out _dev_import_out;


struct _dev_free_in {
	long ds_id;
	long access_right;
	long client_id;
	DevVarArgumentArray var_argument;
};
typedef struct _dev_free_in _dev_free_in;


struct _dev_free_out {
	long status;
	long error;
	DevVarArgumentArray var_argument;
};
typedef struct _dev_free_out _dev_free_out;


struct _server_admin {
	long cmd;
	long debug_bits;
};
typedef struct _server_admin _server_admin;



/*
 *  structures for dev_cmd_query()
 */

struct _dev_query_in {
  	long                ds_id;
	DevVarArgumentArray var_argument;
};
typedef struct _dev_query_in _dev_query_in;


struct _dev_cmd_info {
	long  cmd;
  	long  in_type;
  	long  out_type;
};
typedef struct _dev_cmd_info _dev_cmd_info;


struct _dev_event_info {
	long  event;
  	long  out_type;
};
typedef struct _dev_event_info _dev_event_info;

struct _dev_query_out {
  	u_int           length;
  	_dev_cmd_info   *sequence;
  	char            class_name [SHORT_NAME_SIZE];
  	long            error;
  	long            status;
	DevVarArgumentArray var_argument;
};
typedef struct _dev_query_out _dev_query_out;

/*
 * structure for query event
 */

struct _dev_queryevent_out {
  	u_int           length;
  	_dev_event_info   *sequence;
  	char            class_name [SHORT_NAME_SIZE];
  	long            error;
  	long            status;
	DevVarArgumentArray var_argument;
};
typedef struct _dev_queryevent_out _dev_queryevent_out;

/*
 *  structures for message service
 */

struct _msg_data {
	char *devserver_name;
  	char *host_name;
	long  prog_number;
  	char *display;
	short type_of_message;
 	char *message_buffer;
};
typedef struct _msg_data _msg_data;


struct _msg_out {
	long status;
	long error;
};
typedef struct _msg_out _msg_out;


/*
 *  structures for network manager services
 */

struct _register_data {
	char    *host_name;
	long    prog_number;
	long    vers_number;
};
typedef struct _register_data _register_data;


struct _manager_data {
	_register_data  msg_info;
	_register_data  db_info;
	long    status;
	long    error;
	long	security;
	DevVarArgumentArray var_argument;
};
typedef struct _manager_data _manager_data;


struct _msg_manager_data {
	char    *dshome;
	char    *display;
};
typedef struct _msg_manager_data _msg_manager_data;					   
					   
#ifdef __cplusplus
extern "C" {
#endif					   
bool_t _DLLFunc xdr_DevVarArgument 
		PT_((XDR *xdrs, DevVarArgument *objp));
bool_t  _DLLFunc xdr_DevVarArgumentArray
                 PT_((XDR *xdrs, DevVarArgumentArray *objp));
bool_t _DLLFunc xdr__register_data PT_((XDR *xdrs, _register_data *objp));
bool_t _DLLFunc xdr__manager_data PT_((XDR *xdrs, _manager_data *objp));
bool_t _DLLFunc xdr__server_data PT_((XDR *xdrs, _server_data *objp));
bool_t _DLLFunc xdr__client_data PT_((XDR *xdrs, _client_data *objp));
bool_t _DLLFunc xdr__client_raw_data PT_((XDR *xdrs,_client_raw_data *objp));
bool_t _DLLFunc xdr__dev_import_in PT_((XDR *xdrs, _dev_import_in *objp));
bool_t _DLLFunc xdr__dev_import_out PT_((XDR *xdrs, _dev_import_out *objp));
bool_t _DLLFunc xdr__dev_free_in PT_((XDR *xdrs, _dev_free_in *objp));
bool_t _DLLFunc xdr__dev_free_out PT_((XDR *xdrs, _dev_free_out *objp));
bool_t _DLLFunc xdr__server_admin PT_((XDR *xdrs, _server_admin *objp));
bool_t _DLLFunc xdr__dev_query_in PT_((XDR *xdrs, _dev_query_in *objp));
bool_t _DLLFunc xdr__dev_cmd_info PT_((XDR *xdrs, _dev_cmd_info *objp));
bool_t _DLLFunc xdr__dev_query_out PT_((XDR *xdrs, _dev_query_out *objp));
bool_t _DLLFunc xdr__msg_data PT_((XDR *xdrs, _msg_data *objp));
bool_t _DLLFunc xdr__msg_out PT_((XDR *xdrs, _msg_out *objp));
bool_t _DLLFunc xdr__dev_event_info PT_((XDR *xdrs, _dev_event_info *objp));
bool_t _DLLFunc xdr__msg_manager_data PT_((XDR *xdrs,
					   _msg_manager_data *objp));
bool_t _DLLFunc xdr__dev_queryevent_out PT_((XDR *xdrs, _dev_queryevent_out *objp));
#ifdef __cplusplus
}
#endif

#endif /* _api_xdr_h */
