/****************************************************************************

 File          :   asc_api.h

 Project       :   ASCII based interface to device server API

 Description   :   The interface file (header file) for the library

 Author        :   Faranguiss Poncet

 Original      :   November 1996

 $Revision: 1.8 $                               $Author: poncet $
 $Date: 98/06/16 17:08:22 $                                     $State: Rel $

 $Log:	asc_api.h,v $
 * Revision 1.8  98/06/16  17:08:22  17:08:22  poncet (F.Poncet)
 * Updated to give the resource for lib path from s700 to hpux10.2.
 * 
 * Revision 1.7  97/04/10  15:45:13  15:45:13  poncet (F.Poncet)
 * y
 * Added dev_free_ascii to free a device server handle by an external call.
 * 
 * Revision 1.6  97/03/21  14:34:11  14:34:11  poncet (F.Poncet)
 * Changed ASC_HPUX_DEF_PATH and ASC_SOLARIS_DEF_PATH in asc_api.h file from
 * the absolute path file name to only the name of the library such as
 * "libascapi.sl" or "libascapi.so".
 * Recompiled with the same change in the tc_api.h.
 * These changes lead to be independent of the place where these libraries
 * are installed at runtime. The only thing to do is to set the environment
 * variables SHLIB_PATH (for HPUX) or LD_LIBRARY_PATH (for Solaris).
 * 
 * Revision 1.5  97/02/18  13:43:13  13:43:13  poncet (F.Poncet)
 * File not changed. Archived for compatible revision numbers.
 * 
 * Revision 1.4  97/01/21  15:54:11  15:54:11  poncet (F.Poncet)
 * File rearchived to initialize the first officially released version.
 * 
 * Revision 1.4  97/01/10  13:11:27  13:11:27  poncet (F.Poncet)
 * File unchanged. Archived for compatible revision numbers.
 * 
 * Revision 1.3  97/01/08  14:03:06  14:03:06  poncet (F.Poncet)
 * The name of the three functions have changed from (asc_dev_get, asc_dev_put,
 * asc_dev_putget) to (dev_get_ascii, dev_put_ascii, dev_putget_ascii)
 * respectively.
 * 
 * Revision 1.2  97/01/07  17:44:18  17:44:18  poncet (F.Poncet)
 * The two functions : "asc_dev_put" and "asc_dev_putget" have been added.
 * 
 * Revision 1.1  96/11/25  18:30:29  18:30:29  poncet (F.Poncet)
 * Initial revision
 * 

 Copyright (c) 1996 by European Synchrotron Radiation Facility,
                       Grenoble, France

                       All Rights Reserved

****************************************************************************/


#ifndef _ascapi_h
#define _ascapi_h

#define ASC_HPUX_DEF_PATH      "libascapi.sl"
#define ASC_SOLARIS_DEF_PATH   "libascapi.so"


#define ASC_GET_FUNCTION       "dev_get_ascii"
#define ASC_PUT_FUNCTION       "dev_put_ascii"
#define ASC_PUTGET_FUNCTION    "dev_putget_ascii"
#define ASC_FREE_FUNCTION      "dev_free_ascii"




long dev_get_ascii(char *dev_name, char *cmd_name,
                                   char **out_arg, char **str_err);


long dev_put_ascii(char *dev_name, char *cmd_name, char *in_arg,
                                   char **str_err);



long dev_putget_ascii(char *dev_name, char *cmd_name, char *in_arg,
                                      char **out_arg, char **str_err);


long dev_free_ascii(char *dev_name, char **str_err);


#endif /* _ascapi_h */
