
/*********************************************************************

 File:          ManagerP.h

 Project:       Device Servers with sun-rpc

 Description:   Private include file for the network manager

 Author(s):     Jens Meyer

 Original:      January 1991


 $Revision: 4.11 $
 $Date: 20/0./3. 5.:7.:3. $

 $Author: taurel $

 $Log:	ManagerP.h,v $
 * Revision 4.11  20/0./3.  5.:7.:3.  5.:7.:3.  taurel (E.Taurel)
 * Remove the chmod for unix operating system
 * 
 * Revision 4.10  99/11/21  20:36:15  20:36:15  goetz (Andy Goetz)
 * calling svc_destroy() before execv() for database and message server (M.Diehl patch)
 * 
 Revision 4.9  1999/08/04 11:55:08  goetz
 fixed bug in initialisation of config_flags to initialise only 7 fields

 Revision 4.8  1999/03/10 14:11:50  taurel
 Added new env. variables for ORACLE db

 * Revision 4.7  98/10/15  16:56:56  16:56:56  taurel (E.Taurel)
 * Some
 * 
 * Revision 4.6  98/10/15  16:53:37  16:53:37  taurel (Emmanuel Taurel)
 * Added a new -oracle option
 * 
 * Revision 4.4  96/01/16  11:00:01  11:00:01  meyer (J.Meyer)
 * Added environment variable DBHOME for RTDB startup.
 * 
 * Revision 4.3  96/01/11  10:17:50  10:17:50  taurel (Emmanuel TAUREL)
 * Change the dbase path in the include file.
 * 
 * Revision 4.2  95/01/04  16:28:30  16:28:30  meyer (Jens Meyer)
 * Version ported to solaris2.
 * 
 * Revision 4.1  94/12/19  17:01:41  17:01:41  meyer (Jens Meyer)
 * Tested for RTDB and DBM.
 * 
 * Revision 4.0  94/12/12  11:31:31  11:31:31  meyer (Jens Meyer)
 * Version with security tested for RTDB
 * 
 * Revision 3.3  92/11/16  19:19:10  19:19:10  meyer (Jens Meyer)
 * Corrected compile options for s700 version
 * 
 * Revision 3.2  92/11/10  11:27:28  11:27:28  meyer (Jens Meyer)
 * Corrected directory path to system/bin
 * 
 * Revision 3.1  92/11/10  11:14:26  11:14:26  meyer (Jens Meyer)
 * Corrected
 * 
 * Revision 3.0  92/11/10  10:57:46  10:57:46  meyer (Jens Meyer)
 * Unique
 * 

 Copyright (c) 1990 by European Synchrotron Radiation Facility,
		       Grenoble, France

		       All Rights Reserved
*********************************************************************/

#ifndef _ManagerP_h
#define _ManagerP_h

extern void	unreg_server ();

/*
 *  definitions for the static database server
 */
	/*
	 * Definitions for RTDB database
	 */
	static char	*db_server         = "dbsu_server";
	static char   	*db_name           = "Set_bdd";

	/*
	 * Definitions for DBM database
	 */
	static char     *dbm_server 	    = "dbm_server";
	static char   	*dbm_name           = "dbm";
	
	/*
	 * Definition for ORACLE database
	 */
	static char 	*ora_server	    = "db_server";
	static char 	*ora_name	    = "res";
	static char	*ora_tns	    = "/usr/local/oracle";


typedef struct 	{
		short	msg_server;
		short	db_server;
		short	startup;
		short	security;
		short	request_log;
		short	rtdb;
		short	oracle;
		} config_flags;

typedef struct 	{
		char 	host_name [32];
		long 	prog_number;
		long 	vers_number;
		} server_conf;
		
#endif /* _ManagerP_h */

