/* $Log:	dcwr_clnt.c,v $
 * Revision 4.8  99/06/02  12:59:18  12:59:18  taurel (E.Taurel)
 * No change, checked-in only for correct verion number
 * 
 * Revision 4.7  99/06/02  12:44:06  12:44:06  taurel (E.Taurel)
 * Fix bug with DC time for dc_devget_history
 * 
 * Revision 4.6  98/11/10  15:09:43  15:09:43  taurel (E.Taurel)
 * No change in lib. Only add func def. in dc.h include file
 * 
 * Revision 4.5  98/10/20  13:58:19  13:58:19  taurel (E.Taurel)
 * Fix a memory laek in the dc_devgetm function
 * 
 * Revision 4.4  98/09/03  10:41:46  10:41:46  taurel (E.Taurel)
 * Change dc_muli_nethost definition in dchist_cli.c file
 * 
 * Revision 4.3  98/09/02  09:24:09  09:24:09  taurel (E.Taurel)
 * Adapted to any number of nethosts
 * 
 * Revision 4.2  98/08/25  10:05:20  10:05:20  klotz (W.D. Klotz)
 * Version_used_for_NT
 * 
 * Revision 4.1  96/12/31  15:21:38  15:21:38  taurel (E.Taurel)
 * Remove .esrf.fr at the end of nethost before any connection to server
 * 
 * Revision 4.0  96/12/06  11:24:08  11:24:08  taurel (E.Taurel)
 * Multi-nethost release of dc library
 * 
 * Revision 3.4  96/11/25  15:23:04  15:23:04  klotz (W.D. Klotz)
 * untested NT compile
 * 
 * Revision 3.3  96/01/05  16:04:24  16:04:24  taurel (E.Taurel)
 * Ported to Solaris in compatibility mode.
 * 
 * Revision 3.2  93/12/02  18:00:20  18:00:20  taurel (Emmanuel TAUREL)
 * Add a function to call the RPC_CHECK procedure. Add also the management
 * of the RPC_CANTSEND error.
 * 
 * Revision 3.1  93/06/14  17:37:20  17:37:20  taurel (Emmanuel Taurel)
 * Added the new dc_devget_history call and some new tests if call to
 * server fails.
 * 
 * Revision 3.0  93/05/17  17:49:24  17:49:24  taurel (Emmanuel Taurel)
 * Modified to port the dc system to SUN (without RTDB).
 * 
 * Revision 1.1  93/02/04  09:22:59  09:22:59  taurel (Emmanuel Taurel)
 * Initial revision
 *  */

#include <API.h>
#include <ApiP.h>
#include <DevErrors.h>
#include <Admin.h>
#include <dc_xdr.h>

#ifndef NULL
#define NULL  0
#endif  /* NULL */

static struct timeval TIMEOUT = { 3, 0 };

dc_xdr_error *
dc_open_1(argp,clnt,perr)
	dc_open_in *argp;
	CLIENT *clnt;
	long *perr;
{
	static dc_xdr_error res;
	enum clnt_stat clnt_stat;

	memset((char *)&res, 0, sizeof(res));

	clnt_stat = clnt_call(clnt, DC_OPEN,(xdrproc_t)xdr_dc_open_in, (caddr_t)argp,(xdrproc_t)xdr_dc_xdr_error, (caddr_t)&res, TIMEOUT);
	if (clnt_stat != RPC_SUCCESS) {
		dev_printdebug(DBG_ERROR,"dc_open clnt_call returned : %s\n",clnt_sperrno(clnt_stat));
		if (clnt_stat == RPC_TIMEDOUT)
			*perr = DcErr_RPCTimedOut;
		else if (clnt_stat == RPC_CANTRECV || clnt_stat == RPC_CANTSEND)
			*perr = DcErr_CantContactServer;
		else
			*perr = DcErr_RPCreception;
		return (NULL);
				    }
	return (&res);
}




dc_xdr_error *
dc_close_1(argp,clnt,perr)
	name_arr *argp;
	CLIENT *clnt;
	long *perr;
{
	static dc_xdr_error res;
	enum clnt_stat clnt_stat;

	memset((char *)&res, 0, sizeof(res));

	clnt_stat = clnt_call(clnt, DC_CLOSE,(xdrproc_t)xdr_name_arr, (caddr_t)argp,(xdrproc_t)xdr_dc_xdr_error, (caddr_t)&res, TIMEOUT);
	if (clnt_stat != RPC_SUCCESS) {
		dev_printdebug(DBG_ERROR,"dc_close clnt_call returned : %s\n",clnt_sperrno(clnt_stat));
		if (clnt_stat == RPC_TIMEDOUT)
			*perr = DcErr_RPCTimedOut;
		else if (clnt_stat == RPC_CANTRECV || clnt_stat == RPC_CANTSEND)
			*perr = DcErr_CantContactServer;
		else
			*perr = DcErr_RPCreception;
		return (NULL);
					}
	return (&res);
}



dc_xdr_error *
dc_dataput_1(argp,clnt,perr)
	dev_datarr *argp;
	CLIENT *clnt;
	long *perr;
{
	static dc_xdr_error res;
	enum clnt_stat clnt_stat;

	memset((char *)&res, 0, sizeof(res));

	clnt_stat = clnt_call(clnt, DC_DATAPUT,(xdrproc_t)xdr_dev_datarr, (caddr_t)argp,(xdrproc_t)xdr_dc_xdr_error, (caddr_t)&res, TIMEOUT);
	if (clnt_stat != RPC_SUCCESS) {
		dev_printdebug(DBG_ERROR,"dc_dataput clnt_call returned : %s\n",clnt_sperrno(clnt_stat));
		if (clnt_stat == RPC_TIMEDOUT)
			*perr = DcErr_RPCTimedOut;
		else if (clnt_stat == RPC_CANTRECV || clnt_stat == RPC_CANTSEND)
			*perr = DcErr_CantContactServer;
		else
			*perr = DcErr_RPCreception;
		return (NULL);
					}
	return (&res);
}




dc_infox_back *
dc_info_1(argp,clnt,perr)
	void *argp;
	CLIENT *clnt;
	long *perr;
{
	static dc_infox_back res;
	enum clnt_stat clnt_stat;

	memset((char *)&res, 0, sizeof(res));

	clnt_stat = clnt_call(clnt, DC_INFO,(xdrproc_t)xdr_void, argp,(xdrproc_t)xdr_dc_infox_back, (caddr_t)&res, TIMEOUT);
	if (clnt_stat != RPC_SUCCESS) {
		dev_printdebug(DBG_ERROR,"dc_info clnt_call returned : %s\n",clnt_sperrno(clnt_stat));
		if (clnt_stat == RPC_TIMEDOUT)
			*perr = DcErr_RPCTimedOut;
		else if (clnt_stat == RPC_CANTRECV || clnt_stat == RPC_CANTSEND)
			*perr = DcErr_CantContactServer;
		else
			*perr = DcErr_RPCreception;
		return (NULL);
					}
	return (&res);
}



dc_devallx_back *
dc_devall_1(argp,clnt,perr)
	void *argp;
	CLIENT *clnt;
	long *perr;
{
	static dc_devallx_back res;
	enum clnt_stat clnt_stat;

	memset((char *)&res, 0, sizeof(res));

	clnt_stat = clnt_call(clnt, DC_DEVALL,(xdrproc_t)xdr_void, argp,(xdrproc_t)xdr_dc_devallx_back, (caddr_t)&res, TIMEOUT);
	if (clnt_stat != RPC_SUCCESS) {
		dev_printdebug(DBG_ERROR,"dc_devall clnt_call returned : %s\n",clnt_sperrno(clnt_stat));
		if (clnt_stat == RPC_TIMEDOUT)
			*perr = DcErr_RPCTimedOut;
		else if (clnt_stat == RPC_CANTRECV || clnt_stat == RPC_CANTSEND)
			*perr = DcErr_CantContactServer;
		else
			*perr = DcErr_RPCreception;
		return (NULL);
					}
	return (&res);
}




dc_devinfx_back *
dc_devinfo_1(argp,clnt,perr)
	name *argp;
	CLIENT *clnt;
	long *perr;
{
	static dc_devinfx_back res;
	enum clnt_stat clnt_stat;

	memset((char *)&res, 0, sizeof(res));

	clnt_stat = clnt_call(clnt, DC_DEVINFO,(xdrproc_t)xdr_name, (caddr_t)argp,(xdrproc_t)xdr_dc_devinfx_back, (caddr_t)&res, TIMEOUT);
	if (clnt_stat != RPC_SUCCESS) {
		dev_printdebug(DBG_ERROR,"dc_devinfo clnt_call returned : %s\n",clnt_sperrno(clnt_stat));
		if (clnt_stat == RPC_TIMEDOUT)
			*perr = DcErr_RPCTimedOut;
		else if (clnt_stat == RPC_CANTRECV || clnt_stat == RPC_CANTSEND)
			*perr = DcErr_CantContactServer;
		else
			*perr = DcErr_RPCreception;
		return (NULL);
					}
	return (&res);
}



int dc_rpcwr_check_clnt_1(clnt,res,perr)
	CLIENT *clnt;
	long *perr;
	char **res;
{
	enum clnt_stat clnt_stat;

	clnt_stat = clnt_call(clnt, RPC_CHECK,(xdrproc_t)xdr_void, NULL,(xdrproc_t)xdr_wrapstring,(caddr_t)res, TIMEOUT);
	if (clnt_stat != RPC_SUCCESS) {
		dev_printdebug(DBG_ERROR,"rpc_check clnt_call returned : %s\n",clnt_sperrno(clnt_stat));
		if (clnt_stat == RPC_TIMEDOUT)
			*perr = DcErr_RPCTimedOut;
		else if (clnt_stat == RPC_CANTRECV || clnt_stat == RPC_CANTSEND)
			*perr = DcErr_CantContactServer;
		else
			*perr = DcErr_RPCreception;
		return (-1);
				      }
	return (0);
}
