/* $Log:	dcwr_xdr.c,v $
 * Revision 3.19  99/07/05  14:24:30  14:24:30  taurel (E.Taurel)
 * Porte dto new release of gettranscienr_ut. I don't understand how it worked
 * before !!
 * 
 * Revision 3.18  99/06/02  16:06:30  16:06:30  taurel (E.Taurel)
 * Fix bug when transferring time for dc_devget_history
 * 
 * Revision 3.17  99/02/08  15:23:48  15:23:48  taurel (E.Taurel)
 * No change done
 * 
 * Revision 3.16  96/12/06  11:30:15  11:30:15  taurel (E.Taurel)
 * Adapted to new directory structure and incl. files
 * 
 * Revision 3.15  96/11/25  15:23:04  15:23:04  klotz (W.D. Klotz)
 * untested NT compile
 * 
 * Revision 3.14  96/06/14  11:25:44  11:25:44  taurel (E.Taurel)
 * In the still updated test, now manage the case where the update
 * period is 0. This means that no tests are needed.
 * 
 * Revision 3.13  96/02/28  09:13:12  09:13:12  taurel (Emmanuel TAUREL)
 * Ported to Solaris.
 * 
 * Revision 3.12  96/01/05  16:07:06  16:07:06  taurel (Emmanuel TAUREL)
 * Checked out for the two XDR files which have been
 * modified for the library port to Solaris (compatibility mode only).
 * 
 * Revision 3.11  95/12/15  17:26:33  17:26:33  taurel (Emmanuel TAUREL)
 * Check out for debug purpose. No change.
 * 
 * Revision 3.10  95/10/10  14:08:17  14:08:17  taurel (Emmanuel TAUREL)
 * Return date in the dc_devget_history function even if the command failed.
 * 
 * Revision 3.3  93/10/11  09:21:03  09:21:03  taurel (Emmanuel TAUREL)
 * Modified for the dc_info command. In the beam line control system, the device
 * domain name is not predictable.
 * 
 * Revision 3.2  93/09/30  08:50:46  08:50:46  taurel (Emmanuel Taurel)
 * Updated for the DS_WARNING stuff.
 * 
 * Revision 3.1  93/08/13  08:41:34  08:41:34  taurel (Emmanuel Taurel)
 * This file has been check out just for test purpose. Nothing has been changed.
 * 
 * Revision 3.0  93/05/17  17:45:38  17:45:38  taurel (Emmanuel Taurel)
 * Modified to port the dc system to SUN (without RTDB).
 * 
 * Revision 1.1  93/02/04  09:23:41  09:23:41  taurel (Emmanuel Taurel)
 * Initial revision
 *  */

#include <API.h>
#include <dcwr_xdr.h>

#include <DserverTeams.h>
static const unsigned int maxi=(unsigned int)~0;

bool_t
xdr_dc_cmd_x(xdrs, objp)
	XDR *xdrs;
	dc_cmd_x *objp;
{
	if (!xdr_int(xdrs, &objp->cmd)) {
		return (FALSE);
	}
	if (!xdr_int(xdrs, &objp->cmd_argout)) {
		return (FALSE);
	}
	return (TRUE);
}




bool_t
xdr_dc_dev_x(xdrs, objp)
	XDR *xdrs;
	dc_dev_x *objp;
{
	if (!xdr_string(xdrs, &objp->dev_name, 24)) {
		return (FALSE);
	}
	if (!xdr_int(xdrs, &objp->poll_int)) {
		return (FALSE);
	}
	if (!xdr_array(xdrs, (caddr_t *)&objp->dc_cmd_ax.dc_cmd_ax_val, (u_int *)&objp->dc_cmd_ax.dc_cmd_ax_len, maxi, sizeof(dc_cmd_x), (xdrproc_t)xdr_dc_cmd_x)) {
		return (FALSE);
	}
	return (TRUE);
}




bool_t
xdr_dc_open_in(xdrs, objp)
	XDR *xdrs;
	dc_open_in *objp;
{
	if (!xdr_array(xdrs, (caddr_t *)&objp->dc_open_in_val, (u_int *)&objp->dc_open_in_len, maxi, sizeof(dc_dev_x), (xdrproc_t)xdr_dc_dev_x)) {
		return (FALSE);
	}
	return (TRUE);
}


bool_t
xdr_dc_xdr_error(xdrs, objp)
	XDR *xdrs;
	dc_xdr_error *objp;
{
	if (!xdr_int(xdrs, &objp->error_code)) {
		return (FALSE);
	}
	if (!xdr_int(xdrs, &objp->dev_error)) {
		return (FALSE);
	}
	return (TRUE);
}



bool_t
xdr_name(xdrs, objp)
	XDR *xdrs;
	name *objp;
{
	if (!xdr_string(xdrs, objp, 256)) {
		return (FALSE);
	}
	return (TRUE);
}




bool_t
xdr_name_arr(xdrs, objp)
	XDR *xdrs;
	name_arr *objp;
{
	if (!xdr_array(xdrs, (caddr_t *)&objp->name_arr_val, (u_int *)&objp->name_arr_len, maxi, sizeof(name), (xdrproc_t)xdr_name)) {
		return (FALSE);
	}
	return (TRUE);
}



bool_t
xdr_cmd_dat(xdrs, objp)
	XDR *xdrs;
	cmd_dat *objp;
{
	if (!xdr_int(xdrs, &objp->xcmd)) {
		return (FALSE);
	}
	if (!xdr_long(xdrs, &objp->xcmd_error)) {
		return (FALSE);
	}
	if (!xdr_int(xdrs, &objp->xcmd_time)) {
		return (FALSE);
	}
	if (objp->xcmd_error == 0) {
	if (!xdr_bytes(xdrs, (char **)&objp->xsequence.xsequence_val, (u_int *)&objp->xsequence.xsequence_len, maxi)) {
		return (FALSE);
	}
				   }
	else if (((objp->xcmd_error >> DS_CAT_SHIFT) & DS_CAT_MASK) == WarningError) {
	if (!xdr_bytes(xdrs, (char **)&objp->xsequence.xsequence_val, (u_int *)&objp->xsequence.xsequence_len, maxi)) {
		return (FALSE);
	}
	}
	return (TRUE);
}




bool_t
xdr_dev_dat(xdrs, objp)
	XDR *xdrs;
	dev_dat *objp;
{
	if (!xdr_string(xdrs, &objp->xdev_name, 24)) {
		return (FALSE);
	}
	if (!xdr_array(xdrs, (caddr_t *)&objp->xcmd_dat.xcmd_dat_val, (u_int *)&objp->xcmd_dat.xcmd_dat_len, maxi, sizeof(cmd_dat), (xdrproc_t)xdr_cmd_dat)) {
		return (FALSE);
	}
	return (TRUE);
}




bool_t
xdr_dev_datarr(xdrs, objp)
	XDR *xdrs;
	dev_datarr *objp;
{
	if (!xdr_array(xdrs, (caddr_t *)&objp->dev_datarr_val, (u_int *)&objp->dev_datarr_len, maxi, sizeof(dev_dat), (xdrproc_t)xdr_dev_dat)) {
		return (FALSE);
	}
	return (TRUE);
}



bool_t
xdr_dom_x(xdrs, objp)
	XDR *xdrs;
	dom_x *objp;
{
	if (!xdr_string(xdrs, &objp->dom_name, 20)) {
		return (FALSE);
	}
	if (!xdr_int(xdrs,&objp->dom_nb_dev)) {
		return (FALSE);
	}
	return (TRUE);
}




bool_t
xdr_dc_infox(xdrs, objp)
	XDR *xdrs;
	dc_infox *objp;
{
	if (!xdr_u_int(xdrs, &objp->free_mem)) {
		return (FALSE);
	}
	if (!xdr_u_int(xdrs, &objp->mem)) {
		return (FALSE);
	}
	if (!xdr_int(xdrs, &objp->nb_dev)) {
		return (FALSE);
	}
	if (!xdr_array(xdrs,(caddr_t *)&objp->dom_ax.dom_ax_val,
			(u_int *)&objp->dom_ax.dom_ax_len,maxi,
			sizeof(dom_x),(xdrproc_t)xdr_dom_x)) {
		return (FALSE);
	}
	return (TRUE);
}




bool_t
xdr_dc_infox_back(xdrs, objp)
	XDR *xdrs;
	dc_infox_back *objp;
{
	if (!xdr_int(xdrs, &objp->err_code)) {
		return (FALSE);
	}
	if (!xdr_dc_infox(xdrs, &objp->back)) {
		return (FALSE);
	}
	return (TRUE);
}



bool_t
xdr_dc_devallx_back(xdrs, objp)
	XDR *xdrs;
	dc_devallx_back *objp;
{
	if (!xdr_int(xdrs, &objp->err_code)) {
		return (FALSE);
	}
	if (!xdr_name_arr(xdrs, &objp->dev_name)) {
		return (FALSE);
	}
	return (TRUE);
}



bool_t
xdr_cmd_infox(xdrs, objp)
	XDR *xdrs;
	cmd_infox *objp;
{
	if (!xdr_int(xdrs, &objp->cmdx)) {
		return (FALSE);
	}
	if (!xdr_int(xdrs, &objp->cmd_argoutx)) {
		return (FALSE);
	}
	if (!xdr_int(xdrs, &objp->cmd_timex)) {
		return (FALSE);
	}
	return (TRUE);
}




bool_t
xdr_dev_infx(xdrs, objp)
	XDR *xdrs;
	dev_infx *objp;
{
	if (!xdr_array(xdrs, (caddr_t *)&objp->cmd_dev.cmd_dev_val, (u_int *)&objp->cmd_dev.cmd_dev_len, maxi, sizeof(cmd_infox), (xdrproc_t)xdr_cmd_infox)) {
		return (FALSE);
	}
	if (!xdr_int(xdrs, &objp->pollx)) {
		return (FALSE);
	}
	if (!xdr_u_int(xdrs, &objp->diff_time)) {
		return (FALSE);
	}
	if (!xdr_u_int(xdrs, &objp->ptr_offset)) {
		return (FALSE);
	}
	if (!xdr_u_int(xdrs, &objp->data_offset)) {
		return (FALSE);
	}
	if (!xdr_u_int(xdrs, &objp->data_base)) {
		return (FALSE);
	}
	if (!xdr_vector(xdrs, (char *)objp->deltax, 5, sizeof(int), (xdrproc_t)xdr_int)) {
		return (FALSE);
	}
	return (TRUE);
}




bool_t
xdr_dc_devinfx_back(xdrs, objp)
	XDR *xdrs;
	dc_devinfx_back *objp;
{
	if (!xdr_int(xdrs, &objp->err_code)) {
		return (FALSE);
	}
	if (!xdr_dev_infx(xdrs, &objp->device)) {
		return (FALSE);
	}
	return (TRUE);
}


