static char RcsId[] = "@(#)$Header: dc_devinf.c,v 3.19 99/07/05 14:24:15 taurel Rel $";

/* $Log:	dc_devinf.c,v $
 * Revision 3.19  99/07/05  14:24:15  14:24:15  taurel (E.Taurel)
 * Porte dto new release of gettranscienr_ut. I don't understand how it worked
 * before !!
 * 
 * Revision 3.18  99/06/02  16:06:22  16:06:22  taurel (E.Taurel)
 * Fix bug when transferring time for dc_devget_history
 * 
 * Revision 3.17  99/02/08  15:23:35  15:23:35  taurel (E.Taurel)
 * No change done
 * 
 * Revision 3.16  96/12/06  11:30:11  11:30:11  taurel (E.Taurel)
 * Adapted to new directory structure and incl. files
 * 
 * Revision 3.15  96/11/04  16:50:04  16:50:04  taurel (E.Taurel)
 * Change in the db_register function to fulfill
 * db software release 5 (process name).
 * 
 * Revision 3.14  96/06/14  11:25:41  11:25:41  taurel (E.Taurel)
 * In the still updated test, now manage the case where the update
 * period is 0. This means that no tests are needed.
 * 
 * Revision 3.13  96/02/28  09:13:09  09:13:09  taurel (Emmanuel TAUREL)
 * Ported to Solaris.
 * 
 * Revision 3.12  96/01/05  16:07:03  16:07:03  taurel (Emmanuel TAUREL)
 * Checked out for the two XDR files which have been
 * modified for the library port to Solaris (compatibility mode only).
 * 
 * Revision 3.11  95/12/15  17:26:29  17:26:29  taurel (Emmanuel TAUREL)
 * Check out for debug purpose. No change.
 * 
 * Revision 3.10  95/10/10  14:08:14  14:08:14  taurel (Emmanuel TAUREL)
 * Return date in the dc_devget_history function even if the command failed.
 * 
 * Revision 3.1  93/10/06  10:10:07  10:10:07  taurel (Emmanuel TAUREL)
 * This file was check out only for test purpose, nothing has changed.
 * 
 * Revision 3.0  93/05/17  17:42:53  17:42:53  taurel (Emmanuel Taurel)
 * Modified to port the dc system to SUN (without RTDB).
 * 
 * Revision 1.1  93/02/04  10:23:26  10:23:26  taurel (Emmanuel Taurel)
 * Initial revision
 *  */

#include <API.h>
#include <DevErrors.h>

#include <dc_xdr.h>
#include <dcP.h>

#include <stdlib.h>

/* Some global variables */

/* Variables defined in dc_svc.c */

extern hash_info mem;

extern char *addr_ptr,*addr_alloc,*addr_data;
extern int dat_size,alloc_size,ptr_size;

extern int req_call;



/****************************************************************************
*                                                                           *
*		Server code for dc_devinfo function                         *
*                               ----------                                  *
*                                                                           *
*    Function rule : To return to the client a structure with different     *
*		     information about a device which is defined in the dc  *
*		     These information are :				    *
*			- The commands, their argout and the time used to   *
*			  execute them used to poll the device              *
*			- The poll interval				    *
*			- The offset in the pointer and data shared segment *
*			  memories					    *
*			- The time interval between the last six poll       *
*                                                                           *
*    Argin : No argin							    *
*                                                                           *
*    Argout : No argout                                                     *
*                                                                           *
****************************************************************************/

dc_devinfx_back *dc_devinfo_1(rece)
char **rece;
{
	int i,resu,nb_cmd,ind,ind1,k;
	static dc_devinfx_back retinf;
	static cmd_infox cmd1[10];
	unsigned int off;
	char d_name[60];
	long error;
	int_level *int_array;
	unsigned int *ptr,*tmp_ptr;
	int nb_tot;
	dc_dev_param data;
	dc_dev_param *array;
	unsigned int time_now;
	struct timeval time;
	struct timezone tzone;

/* Miscellaneous initialization */

	retinf.err_code = 0;
	retinf.device.cmd_dev.cmd_dev_len = 0;
	retinf.device.cmd_dev.cmd_dev_val = cmd1;

	nb_tot = mem.hash_table_size + mem.cellar_size;

#ifdef DEBUG
	printf("Executing dc_devinfo request for %s\n",*rece);
#endif /* DEBUG */

/* Init the number of request to 1 for this call */

	req_call  = 1;

/* Try to retrieve a record in the device_info part of the pointers area
   with the saem device name */

	strcpy(d_name,*rece);
	resu = search_dev(d_name,&data,&mem,&ind,&error);

/* Search error */

	if (resu == -1) {
		if (error != DcErr_DeviceNotInPtrsMemory) {
			retinf.err_code = error;	
			return(&retinf);
							}

/* Device does not exists in database */

		else {
			retinf.err_code = DcErr_DeviceNotDefined;
			return(&retinf);
		     }
			}

/* The device exists */

/* Init the array of cmd_infox structures in the structure sent back to 
   caller */

	nb_cmd = data.nb_cmd;
	for (i = 0;i <nb_cmd;i++) {
		retinf.device.cmd_dev.cmd_dev_val[i].cmdx = data.poll_cmd[i].cmd;
		retinf.device.cmd_dev.cmd_dev_val[i].cmd_argoutx = data.poll_cmd[i].argout;
		retinf.device.cmd_dev.cmd_dev_val[i].cmd_timex = data.poll_cmd[i].cmd_time;
				 }
	retinf.device.cmd_dev.cmd_dev_len = nb_cmd;
		
/* Init polling intervall */

	retinf.device.pollx = data.poll_freq;

/* Are some data available ? */

	if (data.ind_read == 0 && data.ind_write == 0)
		retinf.device.data_base = 0;
	else {

/* Compute the offset to the last pointer for this device */

		off = ((HIST * sizeof(unsigned int *)) * ind) + (nb_tot * sizeof(dc_dev_param));
		retinf.device.ptr_offset = off + (sizeof(unsigned int *) * data.ind_read);

/* Compute offset to data buffer */

		array = (dc_dev_param *)addr_ptr;
		int_array = (int_level *)&array[nb_tot];
		ptr = int_array[ind].data_buf[data.ind_read];
		retinf.device.data_offset = (unsigned int)((char *)ptr - addr_data);
		retinf.device.data_base = (unsigned int)addr_data;

/* Compute the interval between the last five records */

		ind1 = data.ind_read;
		for (k = 0;k < 5;k++) {
			ind1--;
			if (ind1 < 0)
				ind1 = HIST - 1;
			if (int_array[ind].data_buf[ind1] == NULL) {
				while(k < 5) {
					retinf.device.deltax[k] = 0;
					k++;
					     }
				break;
								    }
			tmp_ptr = int_array[ind].data_buf[ind1];
			retinf.device.deltax[k] = ptr[0] - tmp_ptr[0];
			ptr = tmp_ptr;
				  	}

/* Compute time between the last data update and the actual time */

		gettimeofday(&time,&tzone);
		time_now = ((time.tv_sec - TIME_OFF) * 10) + (time.tv_usec / 100000);
		retinf.device.diff_time = time_now - data.time;

		}

/* Leave server */

	return(&retinf);

}
