static char RcsId[]           = 
"@(#)$Header: DevServerSignal.c,v 3.10 92/10/05 10:43:08 meyer Rel $";

/*+*******************************************************************

 File:          DevServerSignal.c

 Project:       Device Servers with SUN-RPC

 Description:   Device server signal handling function ds__signal
		gives a unique signal handling interface in UNIX
		style for servers running under HPUX, SUN and OS9.

 Author(s):	Jens Meyer

 Original:	June 1991


 $Revision: 3.10 $
 $Date: 92/10/05 10:43:08 $
 $Author: meyer $

 $Log:	DevServerSignal.c,v $
 * Revision 3.10  92/10/05  10:43:08  10:43:08  meyer (J.Meyer)
 * Correction of bug in db_dev_import().
 * 
 * Revision 3.9  92/09/04  13:20:38  13:20:38  meyer ()
 * Changed client handle initialisation
 * 
 * Revision 3.8  92/09/04  10:58:20  10:58:20  meyer ()
 * Changed retry for lost connection from 2 to 3.
 * 
 * Revision 3.7  92/09/03  15:19:21  15:19:21  meyer ()
 * Corrected bug in dev_import and added <dc.h> to API.h
 * 
 * Revision 3.6  92/08/28  08:37:53  08:37:53  meyer ()
 * corrected an other bug in check_rpc_connection()
 * 
 * Revision 3.5  92/08/26  17:12:56  17:12:56  meyer ()
 * Corrected close of socket in rpc_check_host()
 * 
 * Revision 3.4  92/08/13  16:58:57  16:58:57  meyer ()
 * Added dev_putget_raw() and opaque data type
 * 
 * Revision 3.3  92/07/22  10:13:29  10:13:29  meyer ()
 * Recuperation of RPC connections and TCP protocol
 * 
 * Revision 3.2  92/04/06  19:25:30  19:25:30  meyer ()
 * devserver.dev_type as an array of characters
 * 
 * Revision 3.1  92/04/03  09:42:55  09:42:55  meyer ()
 * Deleted pointer test for device type variable
 * 
 * Revision 3.0  92/04/03  09:35:02  09:35:02  meyer ()
 * New major library release (3.x)
 * 
 * Revision 2.5  92/02/17  15:39:37  15:39:37  meyer ()
 * First released version of API-LIB with version number 2.5
 * 
 * Revision 2.2  91/10/14  14:07:11  14:07:11  meyer ()
 * corrected identification header.
 * 
 * Revision 2.1  91/10/02  16:05:25  16:05:25  meyer ()
 * Installed ANSI prototyping and standart headers.
 * 
 * Revision 1.2  91/09/27  16:22:01  16:22:01  meyer ()
 * added ANSI prototyping and RCS header.
 * 
 * Revision 1.1  91/06/25  11:05:09  11:05:09  meyer ()
 * Initial revision
 * 

 Copyright (c) 1990 by  European Synchrotron Radiation Facility,
			Grenoble, France

*******************************************************************-*/

#include <DevServer.h>
#include <DevErrors.h>
#include <DevSignal.h>

/*
 *  table of signal handler pointers
 */

void 	(*sig_tab [NUSIG])() = {SIG_DFL};



#ifdef __STDC__
long ds__signal (int sig, void (*action)(), long *error)
#else
/**/
long ds__signal (sig, action, error)
/*+**********************************************************************
 Function   :  	extern long ds__signal()

 Description: 	A general device server signal handling interface for
		HPUX, SUN and OS9. Based on the UNIX way of treating
		signals.
		Activated signal handling funcion pointers are stored 
		in the global pointer table sig_tab.
		Actions like SIG_DFL and SIG_IGN are available for
		all systems.
		The related include file : DevSignal.h

 Arg(s) In  :	int sig          - signal
            :	void (*action)() - pointer to function that will be
				   called upon the receipt of signal sig.

 Arg(s) Out :   long *error - Will contain an appropriate error
			      code if the corresponding call
			      returns a non-zero value.

 Return(s)  :   DS_OK or DS_NOTOK
***********************************************************************-*/
	int	sig;		/* */
	void	(*action)();	/* */
	long	*error;		/* */
#endif /* __STDC__ */



{
	*error = 0;

	/*
	 *  check limits for valid signals
	 */

#ifdef unix
	if ( sig<1 || sig>=NUSIG)
#endif /* unix */
#ifndef unix
	if ( sig<0 || sig>=NUSIG)
#endif /* unix */
	   {
	   *error = DevErr_SignalOutOfRange;
	   return (-1);
	   }

	/*
	 *  store action in global table and acitvate
	 *  the handler.
	 */

	sig_tab[sig] 	= action;

#ifdef unix
	/*
	 *  check that the main quit signals will not be deactivated
	 */

	if ( action == SIG_DFL || action == SIG_IGN)
	   {
	   if ( sig!=SIGHUP && sig!=SIGINT && sig!=SIGQUIT && sig!=SIGTERM )
	      {
	      if ( signal (sig, action) == SIG_ERR )
		 {
	         *error = DevErr_CannotSetSignalHandler;
	         return (-1);
		 }
	      }
	   }
	else
	   {
	   /*
	    *  activate signal
	    */

	   if ( signal (sig, main_signal_handler) == SIG_ERR )
	      {
	      *error = DevErr_CannotSetSignalHandler;
	      return (-1);
	      }
	   }
#endif /* unix */

	return (0);
}




#ifdef __STDC__
void main_signal_handler (int signo)
#else
/**/
void main_signal_handler (signo)
/*+**********************************************************************
 Function   : 	extern void main_signal_handler ()

 Description:	A global device server signal handler which catches
		in any case all main quit/kill signals for a proper
		server exit and executes all other signal actions
		activated by  ds__signal() calls.

 Arg(s) In  :	int signo - signal

 Arg(s) Out : 	none

 Return(s)  :   DS_OK or DS_NOTOK
***********************************************************************-*/
	int     signo;		/* */
#endif /* __STDC__ */

{
	/*
	 *  check limits for valid signals
	 */

#ifdef unix
	if ( signo<1 || signo>=NUSIG)
#endif /* unix */
#ifndef unix
	if ( signo<0 || signo>=NUSIG)
#endif /* unix */
	   {
	   return;
	   }
	
 	/*
	 *  call of internal device server signal handling function
	 *  related to signo.
	 */

	if ( sig_tab[signo] != (void (*) ()) SIG_DFL && 
	     sig_tab[signo] != (void (*) ()) SIG_IGN )
	   {
	   sig_tab[signo] (signo);
	   }

	/*
	 *  filter signals for quitting the server
	 */

	if (signo==SIGQUIT || signo==SIGINT || signo==SIGHUP ||
	    signo==SIGTERM)
     	   {
      	   unregister_server ();
	   }

#ifdef unix
	/* 
	 *  Set up signal handler again
	 */

	(void) signal (signo, main_signal_handler);
#endif /* unix */

}

