//
// Debug and printf support
//
/*
  $Header: NT_debug.h,v 5.15.1.2 97/12/19 13:11:12 klotz Rel $
  $Author: klotz $
  $Date$
  $Locker:  $
  $Log:	NT_debug.h,v $
 * Revision 5.15.1.2  97/12/19  13:11:12  13:11:12  klotz (W.D. Klotz)
 * gMWndTxtDisplay_shifted_to_DevServerMain
 * 

*/

#ifndef _debug_h
#define _debug_h
#ifdef __cplusplus
extern "C" {
#endif

extern void cdecl DbgOut(LPSTR lpFormat, ...);
extern HWND ConstructDbgCon(HINSTANCE hInst, HWND hWnd, char* appName);
extern void SetDebugLevel(int i);
extern int GetDebugLevel();

#ifdef WIN32
#define dprintf  DbgOut    // replaces stdio printf for windows
#else
#define dprintf printf
#endif

extern DWORD   gdEval;
extern int giDebugLevel;     // 0 is default 

#define dprintf1 if (giDebugLevel >= 1) DbgOut
#define dprintf2 if (giDebugLevel >= 2) DbgOut
#define dprintf3 if (giDebugLevel >= 3) DbgOut
#define dprintf4 if (giDebugLevel >= 4) DbgOut

#ifdef _DEBUG

	extern void __AssertMsg(LPSTR exp ,LPSTR file, int line);

    #define A_SSERT(exp) \
        ((exp) ? (void)0 : __AssertMsg((LPSTR)(#exp), (LPSTR)__FILE__, __LINE__))
    #define E_VAL(exp) \
        (gdEval=(DWORD)(exp), (gdEval) ? (void)0 : __AssertMsg((LPSTR)(#exp), (LPSTR)__FILE__, __LINE__), gdEval)

  #else // not _DEBUG

    #define A_SSERT(exp) 0
    #define E_VAL(exp) (exp)

/*
    #define dprintf1 if (0) ((int (*)(char *, ...)) 0)
    #define dprintf2 if (0) ((int (*)(char *, ...)) 0)
    #define dprintf3 if (0) ((int (*)(char *, ...)) 0)
    #define dprintf4 if (0) ((int (*)(char *, ...)) 0)
*/

#endif // _DEBUG

#ifdef __cplusplus
}
#endif

#endif  // _debug_h