static char RcsId[] = "$Header: db_servunreg.cpp,v 6.0 98/08/14 10:58:30 taurel Rel $";

/* $Log:	db_servunreg.cpp,v $
Revision 6.0  98/08/14  10:58:30  10:58:30  taurel (E.Taurel)
New utilities release which are server oriented
 */

/* TACO include file */

#include <API.h>

/* Include files */

#include <string.h>

#include <iostream.h>
#include <string>


/****************************************************************************
*                                                                           *
*		Code for db_servunreg command                               *
*                        ------------                                       *
*                                                                           *
*    Command rule : To unregister a device server from the static database. *
*                                                                           *
*    Synopsis : db_servunreg [ full device server name ]                    *
*                                                                           *
****************************************************************************/


int main(int argc,char *argv[])
{
	long i;
	long error,res;
	db_devinfo_call info;

/* Argument test and device name structure*/

	if (argc != 2)
	{
		cerr << "db_servunreg usage : db_servunreg <full device server name>" << endl;
		exit(-1);
	}

	string full_ds_name(argv[1]);

#ifdef DEBUG
	cout  << "Server name : " << full_ds_name << endl;
#endif /* DEBUG */

	i = 0;
	NB_CHAR(i,full_ds_name.c_str(),'/');
	if (i != 1)
	{
		cerr << "db_servunreg : Bad full device server name" << endl;
		exit(-1);
	}

//
// Extract device server and personal name from full device server
// name
//

	string::size_type pos,start;

	if ((pos = full_ds_name.find('/')) == string::npos)
	{
		cout << "db_servunreg : Can't split full device server" << endl;
		exit(-1);
	}
	
	string ds_name(full_ds_name,0,pos);
	
	pos++;
	start = pos;	
	string pers_name(full_ds_name,start,full_ds_name.size() - start);
	
#ifdef DEBUG
	cout << "DS name : " << ds_name << endl;
	cout << "Pers. name : " << pers_name << endl;
#endif /* DEBUG */
		
//
// Connect to database server
//

	if (db_import(&error) == -1)
	{
		cerr << "db_devinfo : Impossible to connect to database server" << endl;
		exit(-1);
	}

//
// Ask database server to unregister server
//

	res = db_servunreg(ds_name.c_str(),pers_name.c_str(),&error);	

//
// Display error message if the call fails
//

	if (res == -1)
	{
		if (error == DbErr_DeviceServerNotDefined)
		{
			cout << "The device server " << full_ds_name << " does not have any device in the database" << endl;
		}
		else
		{
			cerr << "The call to database server failed with error " << error << endl;
			cerr << "Error message : " << dev_error_str(error) << endl;
		}
		exit(-1);
	}
}


