static char RcsId[] = "$Header: db_read.cpp,v 6.4 99/07/06 08:54:50 taurel Exp $";

/* $Log:	db_read.cpp,v $
Revision 6.4  99/07/06  08:54:50  08:54:50  taurel (Emmanuel Taurel)
Remove all access inside the dbm structure (no pagf anymore)

Revision 6.3  99/06/16  15:56:35  15:56:35  taurel (Emmanuel Taurel)
Added calls to db server in order to close db server connection to
db files. This is mandatory for LINUX.

Revision 6.2  98/08/21  15:26:03  15:26:03  taurel (Emmanuel Taurel)
strcmp function returns int and not a pointer !!

Revision 6.1  98/08/21  14:12:20  14:12:20  taurel (E.Taurel)
Change the main function declarationin order to have HP compiler quiet.

Revision 6.0  98/08/14  10:58:40  10:58:40  taurel (E.Taurel)
New utilities release which are server oriented
 */


#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <sys/wait.h>

#define _db_setup_h
#include <API.h>
#undef _db_setup_h
#include "db_setup.h"

/* For database only */

#include <sys/types.h>
#include <sys/ipc.h>
#include <sys/shm.h>

#include <fcntl.h>
#include <ndbm.h>

/* Function definitions */

int db_read(char *,char *);

/* Global variables definitions */

int line_ptr;


/****************************************************************************
*                                                                           *
*		Code for db_read command 				    *
*                        -------                                            *
*                                                                           *
*    Command rule : To read all device servers and resources of a domain    *
*		    (table) or all domains (tables)                         *
*                   in the order they are stored in dbm database.           *
*                   The database directory has to be given by the           *
*                   environment variable DBM_DIR.                           *
*                                                                           *
*    Synopsis : db_read [domain/all]                                        *
*                                                                           *
****************************************************************************/

int main(int argc,char *argv[])
{
	char *ptr;
	char *tbeg, *tend;
	int diff;
	char dbm_dir[80];
	int flags;
	char dbm_file[100];
	FILE *fop;
	int i,j,l;
	char domain[24];
	int res_num[MAXDOMAIN];
	char TblName[MAXDOMAIN][12];
	char tblname[MAXDOMAIN][14];
	int TblNum = 0;
	int names = False;
	int ps_names = False;

/* Argument test and domain name modification */

	if (argc != 2)
	{
		fprintf(stderr,"%s usage: %s <domain name/all>\n",argv[0],argv[0]);
		exit(-1);
	}

	l = strlen(argv[1]);
	for (i=0;i<l;i++) 
		domain[i] = argv[1][i];
	domain[l] = '\0';

/* If all domains are asked, force all to be in upper case letters */
	
	if (strcasecmp(domain,"all") == 0)
		strcpy(domain,"ALL");

/* Find the dbm_database table names */        

	if ((ptr = (char *)getenv("DBTABLES")) == NULL)
	{
		fprintf(stderr,"db_read: Can't find environment variable DBTABLES\n");
		exit(-1);
	}

	tbeg = ptr;
	while ((tend = (char *)strchr(tbeg,',')) != NULL)
	{
		diff = (unsigned int)(tend++ - tbeg);
		strncpy(TblName[TblNum], tbeg, diff);
		TblName[TblNum][diff] = '\0';
		TblNum++;
		tbeg = tend;
	}
	strcpy (TblName[TblNum++], tbeg);
	
/* Change the database table names to lowercase letter names and check if there 
   is a names and ps_names tables defined */

	for (i = 0;i < TblNum;i++)
	{
		for (j = 0;j < (int)strlen(TblName[i]);j++)
			tblname[i][j] = tolower(TblName[i][j]);
		tblname[i][j] = '\0';
		if (strcmp(tblname[i],"names") == 0)
			names = True;
		if (strcmp(tblname[i],"ps_names") == 0)
			ps_names = True;
	}

/* If no names or ps_names tables are defined, add them to the list */

	if (names == False)
	{
		strcpy(tblname[TblNum],"names");
		TblNum++;
	}
	if (ps_names == False)
	{
		strcpy(tblname[TblNum],"ps_names");
		TblNum++;
	}	
	
/* Take the environment variable DBM_DIR */

	if ((ptr = getenv("DBM_DIR")) == NULL)
	{
		fprintf(stderr,"db_read: Can't find environment variable DBM_DIR \n");
		exit(-1);
	}
	strcpy(dbm_dir, ptr);

	if (strncmp(dbm_dir+strlen(dbm_dir)-1, "/", 1) != 0) 
		strcat(dbm_dir, "/");

/* Read the database tables of the database */
	
   	for (i=0;i<TblNum;i++)
	{
		if ((strcmp(domain,tblname[i])*strcmp(domain,"ALL")) == 0 )
		{
			strcpy(dbm_file, dbm_dir);
			strcat(dbm_file, tblname[i]);
			res_num[i] = db_read(dbm_file,tblname[i]);
		}
	}
	
}


int db_read(char *dbm_file,char *TblName)
{
	int flags = O_RDONLY;
	DBM *tab_tid;
	datum key, key_out;
	datum content, content_out;
	int res_num = 0;
	long err;
#ifdef linux
	static long connected = False;
#endif /* linux */
	
	key_out.dptr = (char *)malloc(MAX_KEY);
	content_out.dptr = (char *)malloc(MAX_CONT);


#ifdef linux

/* Connect process to db if it is not already done */

	if (connected == False)
	{
		if (db_import(&err) != 0)
		{
			fprintf(stderr,"db_read: can't connect to database server\n");
			exit(-1);
		}
		connected = True;
	}
	
/* Ask server to disconnect from DBM files */

	if (db_svc_close(&err) == -1)
	{
		fprintf(stderr,"db_read: Server failed when tries to disconnect to DBM files\n");
		exit(-1);
	}	
#endif /* linux */

/* Open database file */

	tab_tid = dbm_open(dbm_file, flags, (int)0666);

	if (tab_tid == NULL)
	{
		fprintf(stderr,"db_read: Can't open %s table\n",dbm_file);
#ifdef linux
/* Ask server to disconnect from DBM files */

		if (db_svc_reopen(&err) == -1)
		{
			fprintf(stderr,"db_read: Server failed when tries to reconnect to DBM files\n");
		}	
#endif /* linux */		
		exit(-1);
	}	

/* Display table contents */

	for (key = dbm_firstkey(tab_tid); key.dptr != NULL;key = dbm_nextkey(tab_tid))
	{
	
		content = dbm_fetch(tab_tid, key);
	
		if (content.dptr != NULL)
		{
			res_num++;
			strncpy(content_out.dptr, content.dptr, content.dsize);
			content_out.dptr[content.dsize] = '\0';
			strncpy(key_out.dptr, key.dptr, key.dsize);
			key_out.dptr[key.dsize] = '\0';
			printf("%s: %s:  %s\n", TblName, key_out.dptr, content_out.dptr);
		}
	}
	
/* Close database */

	dbm_close(tab_tid);

	free(key_out.dptr);
	free(content_out.dptr);
	
#ifdef linux
/* Ask server to reconnect to DBM files */

	if (db_svc_reopen(&err) == -1)
	{
		fprintf(stderr,"db_read: Server failed when tries to reconnect to DBM files\n");
		exit(-1);
	}	
#endif /* linux */
	
	return(res_num);
}
