package beamlinercp;


import java.awt.Color;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.image.BufferedImage;

import java.io.BufferedReader;
import java.io.InputStreamReader;

import javax.swing.ImageIcon;
import javax.swing.JLabel;

import org.eclipse.swt.SWT;
import org.eclipse.swt.awt.SWT_AWT;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;

import org.eclipse.ui.part.ViewPart;

import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.plot.PiePlot;
import org.jfree.chart.ChartFrame;

import org.jfree.data.category.DefaultCategoryDataset;
import org.jfree.data.general.DefaultPieDataset;



public class StorageView extends ViewPart 
{
	public static final String ID = "beamlinercp.StorageView";
	private Composite top = null;
	private JFreeChart inhouseUsage = null;
	private JFreeChart externalUsage = null;
	private JFreeChart experiments = null;
	private JLabel lblChart1;
	private JLabel lblChart2;
	private JLabel lblChart3;
	private Runnable timer;
	private boolean stop = false;
	private boolean init = false;
	private Composite swtAwtComponent;
	
	/**
	 * createPartControl
	 * @param parent - main Composite
	 */
	public void createPartControl(Composite parent) 
	{
		top = new Composite(parent, SWT.NONE);
		top.setLayout(new FillLayout());

	    update();
		timer.run();
	}

	public void setFocus() 
	{
	}
	
	/**
	 * getValues
	 * @param str - string that is to be parsed
	 * @return - parsed string divided into shorter parts
	 */
	private String[] getValues(String str)
	{
		String valueArr[] = new String[5];
		int j = 0;
		String tmpArr[] = str.split(" ");
		for(int i = 0; i< tmpArr.length; i++)
			if(tmpArr[i].length() != 0 && tmpArr[i].length() != 1)
			{
				valueArr[j] = tmpArr[i];
				j++;
			}	
		return valueArr;
	}

	
	/**
	 * updatePieCharts
	 */
	private void updatePieCharts()
	{
		String s = "", out = "", externalStr = "", inhouseStr = "";
		String ex[], in[];
		float exU = 0, exF = 0, inU = 0, inF = 0;
		
		 try 
		 {
			 Process p = Runtime.getRuntime().exec("rsh -l opid11 crunch cd /data/opid11/inhouse; rsh -l opid11 crunch cd /data/opid11/external; rsh -l opid11 crunch df -h");
			 BufferedReader stdInput = new BufferedReader(new InputStreamReader(p.getInputStream()));

			 while ((s = stdInput.readLine()) != null)
				 out += s;
		 }
		 catch (Exception e) 
		 {
			 System.out.println(e);
		 }

		externalStr = out.substring(out.indexOf("id11srv2ge1.esrf.fr:/qt_opid11ext/external") , out.indexOf("/mntdirect/_data_opid11_external"));
		inhouseStr = out.substring(out.indexOf("id11srvge1.esrf.fr:/qt_opid11inh/inhouse") , out.indexOf("/mntdirect/_data_opid11_inhouse"));

		ex = getValues(externalStr);
		in = getValues(inhouseStr);
 
		if(ex[3].endsWith("G"))
			exF = Float.parseFloat(ex[3].substring(0, ex[3].length()-1));
		else if(ex[3].endsWith("T"))
			exF = Float.parseFloat(ex[3].substring(0, ex[3].length()-1)) * 1000;
		else if(ex[3].endsWith("M"))
			exF = Float.parseFloat(ex[3].substring(0, ex[3].length()-1)) / 1000;
		else if(ex[3].endsWith("K"))
			exF = Float.parseFloat(ex[3].substring(0, ex[3].length()-1)) / 1000000;
		
		if(ex[2].endsWith("G"))
			exU = Float.parseFloat(ex[2].substring(0, ex[2].length()-1));
		else if(ex[2].endsWith("T"))
			exU = Float.parseFloat(ex[2].substring(0, ex[2].length()-1)) * 1000;
		else if(ex[2].endsWith("M"))
			exU = Float.parseFloat(ex[2].substring(0, ex[2].length()-1)) / 1000;
		else if(ex[2].endsWith("K"))
			exF = Float.parseFloat(ex[2].substring(0, ex[2].length()-1)) / 1000000;


		DefaultPieDataset pieDataset = new DefaultPieDataset();
		pieDataset.setValue("used [GB]", exU);
		pieDataset.setValue("free [GB]", exF);
		externalUsage = ChartFactory.createPieChart3D
		("disk used for external",   		  // Title
				pieDataset,                   // Dataset
				false,                        // Show legend
				true,                         // Use tooltips
				false);                       // Configure chart to generate URLs?
				
		PiePlot plot2 = (PiePlot) externalUsage.getPlot();
		plot2.setSectionPaint(0, Color.red);
		plot2.setSectionPaint(1, Color.green);

        	
		if(in[3].endsWith("G"))
			inF = Float.parseFloat(in[3].substring(0, in[3].length()-1));
		else if(in[3].endsWith("T"))
			inF = Float.parseFloat(in[3].substring(0, in[3].length()-1)) * 1000;
		else if(in[3].endsWith("M"))
			inF = Float.parseFloat(in[3].substring(0, in[3].length()-1)) / 1000;
		else if(in[3].endsWith("K"))
			inF = Float.parseFloat(in[3].substring(0, in[3].length()-1)) / 1000000;
    		
		if(in[2].endsWith("G"))
			inU = Float.parseFloat(in[2].substring(0, in[2].length()-1));
		else if(in[2].endsWith("T"))
			inU = Float.parseFloat(in[2].substring(0, in[2].length()-1)) * 1000;
		else if(in[2].endsWith("M"))
			inU = Float.parseFloat(in[2].substring(0, in[2].length()-1)) / 1000;
		else if(in[2].endsWith("K"))
			exF = Float.parseFloat(in[2].substring(0, in[2].length()-1)) / 1000000;

		DefaultPieDataset pieDataset2 = new DefaultPieDataset();
		pieDataset2.setValue("used [GB]", inU);
		pieDataset2.setValue("free [GB]", inF);
		inhouseUsage = ChartFactory.createPieChart3D
			("disk used for inhouse",      // Title
			pieDataset2,                   // Dataset
			false,                         // Show legend
			true,                          // Use tooltips
			false);                        // Configure chart to generate URLs?
        	     
		PiePlot plot3 = (PiePlot) inhouseUsage.getPlot();
		plot3.setSectionPaint(0, Color.red);
		plot3.setSectionPaint(1, Color.green);
	}
	
	/**
	 * updateBarChart
	 */
	private void updateBarChart() 
	{
		String s = "", out = "", tmpName = "";
		String extDir[];
		float tmpSize = 0;
		
		try 
		{
			Process p = Runtime.getRuntime().exec("rsh -l opid11 crunch cd /data/opid11/external; rsh -l opid11 crunch du -h --max-depth=1 /mntdirect/_data_opid11_external");
			BufferedReader stdInput = new BufferedReader(new 
					InputStreamReader(p.getInputStream()));

			while ((s = stdInput.readLine()) != null) 
			{
				out += s;
				out += "@@";
			}
		     
		}
		catch (Exception e) 
		{
			System.out.println(e);
		}
		 
		extDir = out.split("@@");

		DefaultCategoryDataset dataset = new DefaultCategoryDataset();
		        
		for(int i = 0; i < extDir.length - 1; i++)
		{
			tmpName = extDir[i].substring(extDir[i].indexOf("/mntdirect/_data_opid11_external") 
					+ "/mntdirect/_data_opid11_external".length() + 1);    		           	

			if(tmpName.equals("DataRestored") || tmpName.startsWith("."))
				continue;

			if(extDir[i].substring(0, extDir[i].indexOf("\t")).endsWith("K"))
				tmpSize = Float.parseFloat(extDir[i].substring(0, extDir[i].indexOf("\t")-1))/1000;
			if(extDir[i].substring(0, extDir[i].indexOf("\t")).endsWith("M"))
				tmpSize = (int)Float.parseFloat(extDir[i].substring(0, extDir[i].indexOf("\t")-1));
			if(extDir[i].substring(0, extDir[i].indexOf("\t")).endsWith("T"))
				tmpSize = (int)Float.parseFloat(extDir[i].substring(0, extDir[i].indexOf("\t")-1))*1000000;
			if(extDir[i].substring(0, extDir[i].indexOf("\t")).endsWith("G"))
				tmpSize = (int)Float.parseFloat(extDir[i].substring(0, extDir[i].indexOf("\t")-1))*1000;
			
			dataset.setValue(tmpSize, "Size", tmpName); 
		}

		experiments = ChartFactory.createBarChart3D(
				"External experiments",
				"", 
				"Size [MB]", 
				dataset, PlotOrientation.HORIZONTAL,
				false, 
				true, 
				false);
	}
	
	/**
	 * drawCharts
	 */
	private void drawCharts()
	{
		if(init == false)
		{
			swtAwtComponent = new Composite(top, SWT.EMBEDDED);
			java.awt.Frame frame = SWT_AWT.new_Frame( swtAwtComponent );
			javax.swing.JPanel panel = new javax.swing.JPanel( );
			BufferedImage image1 = experiments.createBufferedImage(700,200);
			BufferedImage image2 = externalUsage.createBufferedImage(350,200);
			BufferedImage image3 = inhouseUsage.createBufferedImage(350,200);
			
			lblChart1 = new JLabel();
			lblChart2 = new JLabel();
			lblChart3 = new JLabel();
			
			lblChart1.setIcon(new ImageIcon(image1));
			lblChart2.setIcon(new ImageIcon(image2));
			lblChart3.setIcon(new ImageIcon(image3));
	
			panel.add(lblChart2);
			panel.add(lblChart3);
			panel.add(lblChart1);
	
			frame.add(panel);
	
			addMouseClickedListener(lblChart1, experiments, "External experiments");
			addMouseClickedListener(lblChart2, externalUsage, "External");
			addMouseClickedListener(lblChart3, inhouseUsage, "Inhouse");
	
			
			stabilizeSize();
		}
		else
		{
			lblChart1.removeAll();
			lblChart2.removeAll();
			lblChart3.removeAll();
			
			lblChart1.setIcon(new ImageIcon(experiments.createBufferedImage((int)(swtAwtComponent.getSize().x),(int)(1.5*swtAwtComponent.getSize().y/2))));
			lblChart2.setIcon(new ImageIcon(externalUsage.createBufferedImage((int)(0.85*swtAwtComponent.getSize().x/2),(int)(0.5*swtAwtComponent.getSize().y/2))));
			lblChart3.setIcon(new ImageIcon(inhouseUsage.createBufferedImage((int)(0.85*swtAwtComponent.getSize().x/2),(int)(0.5*swtAwtComponent.getSize().y/2))));
		}
		
		
		
	}
	
	/**
	 * addMouseClickedListener
	 * @param label - where the listener should be added
	 * @param chart - which chart should be displayed
	 * @param name - a name for the chart
	 */
	private void addMouseClickedListener(JLabel label, final JFreeChart chart, final String name)
	{
		label.addMouseListener(new MouseListener()
		{
			public void mouseReleased(MouseEvent event)
			{
			}
			public void mousePressed(MouseEvent event)
			{
			}
			public void mouseEntered(MouseEvent event)
			{
			}
			public void mouseExited(MouseEvent event)
			{
			}
			public void mouseClicked(MouseEvent event)
			{
				ChartFrame frame = new ChartFrame(name, chart);
		        frame.pack();
		        frame.setVisible(true);
			}
		});
		
	}
	
	/**
	 * stabilizeSize
	 * @param swtAwtComponent - the main composite for charts
	 */
	private void stabilizeSize()
	{
		swtAwtComponent.addControlListener(new ControlListener()
		{
			public void controlResized(ControlEvent event)
			{

				lblChart1.removeAll();
				lblChart2.removeAll();
				lblChart3.removeAll();
				
				BufferedImage image1;
				BufferedImage image2;
				BufferedImage image3;
				
				if(swtAwtComponent.getSize().x == 0 || swtAwtComponent.getSize().y == 0)
				{
					image1 = experiments.createBufferedImage(100,100);
					image2 = externalUsage.createBufferedImage(100,100);
					image3 = inhouseUsage.createBufferedImage(100,100);
				}
				else
				{
					image1 = experiments.createBufferedImage((int)(swtAwtComponent.getSize().x),(int)(1.5*swtAwtComponent.getSize().y/2));
					image2 = externalUsage.createBufferedImage((int)(0.85*swtAwtComponent.getSize().x/2),(int)(0.5*swtAwtComponent.getSize().y/2));
					image3 = inhouseUsage.createBufferedImage((int)(0.85*swtAwtComponent.getSize().x/2),(int)(0.5*swtAwtComponent.getSize().y/2));
				}
				
				lblChart1.setIcon(new ImageIcon(image1));
				lblChart2.setIcon(new ImageIcon(image2));
				lblChart3.setIcon(new ImageIcon(image3));
			}
			public void controlMoved(ControlEvent event)
			{
			}
		});
	}
	
	
	private void update()
	{
		
		
		final int time = 100000;
        timer = new Runnable () 
        {
        	public void run () {
        		if(stop)
        			return;
        		stop = true;
        		
        		updateAllCharts();
        		top.getDisplay().timerExec(time, this);
        	}
        };
	}
	
	private void updateAllCharts()
	{
		updatePieCharts();
		updateBarChart();
		drawCharts();
		init = true;
		stop = false;
	}
	
}  