package beamlinercp;

import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;

import org.eclipse.ui.part.ViewPart;

public class ShutterView extends ViewPart 
{

	public static String ID = "beamlinercp.ShutterView";
	private Composite top = null;
	private Image closed;
	private Image open;  //  @jve:decl-index=0:
	private Image moving;
	private Image fault;
	private Label l3;
	private Button b3;
	private Image locked;  //  @jve:decl-index=0:
	private Image unlocked;
	
	/**
	 * This is a callback that will allow us
	 * to create the viewer and initialize it.
	 */
	public void createPartControl(Composite parent) 
	{
        top = new Composite(parent, SWT.NONE);
        top.setLayout(new GridLayout());
        
		closed = new Image(Display.getCurrent(), "/home/lslezak/Desktop/img/Closedneon.gif");
		open = new Image(Display.getCurrent(), "/home/lslezak/Desktop/img/Openneon.gif");
		moving = new Image(Display.getCurrent(), "/home/lslezak/Desktop/img/moving.gif");
		fault = new Image(Display.getCurrent(), "/home/lslezak/Desktop/img/error.gif");
		locked = new Image(Display.getCurrent(), "/home/lslezak/Desktop/img/locked2.jpg");
		unlocked = new Image(Display.getCurrent(), "/home/lslezak/Desktop/img/unlocked2.jpg");
        
        createShutterComposite();
        createOtherComposite();
	}


	private void createShutterComposite() {
		Composite shutterComposite = new Composite(top, SWT.NONE);
		GridLayout gL = new GridLayout();
		gL.numColumns = 4;
		gL.makeColumnsEqualWidth = true;
		shutterComposite.setLayout(new FillLayout());
		shutterComposite.setLayoutData(new GridData(GridData.FILL_BOTH));
		
		
		Group g1 = new Group(shutterComposite, SWT.NONE);
		g1.setText("Safety Shutter 1");
		g1.setLayout(new FillLayout());

		Group g2 = new Group(shutterComposite, SWT.NONE);
		g2.setText("Safety Shutter 2");
		g2.setLayout(new FillLayout());

		Group g3 = new Group(shutterComposite, SWT.NONE);
		g3.setText("White Beam");

		g3.setLayout(new FillLayout());
		Group g4 = new Group(shutterComposite, SWT.NONE);
		g4.setText("Front End");

		g4.setLayout(new FillLayout());
		
		final Label l1 = new Label(g1, SWT.CENTER);
		l1.setImage(closed);
		
		final Label l2 = new Label(g2, SWT.CENTER);
		l2.setImage(open);
		l3 = new Label(g3, SWT.CENTER);
		l3.setImage(fault);
		final Label l4 = new Label(g4, SWT.CENTER);
		l4.setImage(moving);
		
		setToolTipText(l1);
		setToolTipText(l2);
		setToolTipText(l3);
		setToolTipText(l4);
		
		l1.addMouseListener(new MouseListener() 
		{
			public void mouseDown(MouseEvent event)
			{
			}
			
			public void mouseUp(MouseEvent event)
			{
				if(b3.getSelection() == false)
					if(l1.getImage() == open)
						l1.setImage(closed);
					else if((l1.getImage() == closed))
						l1.setImage(open);
				
				setToolTipText(l1);
			}
			
			public void mouseDoubleClick(MouseEvent event)
			{
			}
		});
		
		l2.addMouseListener(new MouseListener() 
		{
			public void mouseDown(MouseEvent event)
			{
			}
			
			public void mouseUp(MouseEvent event)
			{
				if(b3.getSelection() == false)
					if(l2.getImage() == open)
						l2.setImage(closed);
					else if((l2.getImage() == closed))
						l2.setImage(open);
				
				setToolTipText(l2);
			}
			
			public void mouseDoubleClick(MouseEvent event)
			{
			}
		});
		
		l3.addMouseListener(new MouseListener() 
		{
			public void mouseDown(MouseEvent event)
			{
			}
			
			public void mouseUp(MouseEvent event)
			{
				if(b3.getSelection() == false)
					if(l3.getImage() == open)
						l3.setImage(closed);
					else if((l3.getImage() == closed))
						l3.setImage(open);
				
				setToolTipText(l3);
			}
			
			public void mouseDoubleClick(MouseEvent event)
			{
			}
		});
		
		
		l4.addMouseListener(new MouseListener() 
		{
			public void mouseDown(MouseEvent event)
			{
			}
			
			public void mouseUp(MouseEvent event)
			{
				if(b3.getSelection() == false)
					if(l4.getImage() == open)
						l4.setImage(closed);
					else if((l4.getImage() == closed))
						l4.setImage(open);
				
				setToolTipText(l4);
			}
			
			public void mouseDoubleClick(MouseEvent event)
			{
			}
		});
		
		
		
	}

	
	private void createOtherComposite() 
	{
		Composite otherComposite = new Composite(top, SWT.NONE);
		GridLayout gL = new GridLayout();
		gL.numColumns = 3;
		gL.makeColumnsEqualWidth = true;
		otherComposite.setLayout(new FillLayout());
		otherComposite.setLayoutData(new GridData(GridData.FILL_BOTH));
		
		
		Group g1 = new Group(otherComposite, SWT.NONE);
		g1.setText("Mode of Operation");
		g1.setLayout(new FillLayout(SWT.VERTICAL));

		Group g2 = new Group(otherComposite, SWT.NONE);
		g2.setText("RV");
		g2.setLayout(new FillLayout());

		Group g3 = new Group(otherComposite, SWT.NONE);
		g3.setText("Lock");
		g3.setLayout(new FillLayout());

		final Button b1 = new Button(g1, SWT.RADIO);
		b1.setText("MONOCHROMATIC");
		final Button b2 = new Button(g1, SWT.RADIO);
		b2.setText("WHITE");
		b2.setSelection(true);
		final Label l1 = new Label(g2, SWT.CENTER);
		l1.setImage(closed);
		b3 = new Button(g3, SWT.CHECK|SWT.CENTER);
		b3.setImage(unlocked);

		setToolTipText(l1);
		if(b3.getImage() == locked)
			b3.setToolTipText("click here to unlock");
		else if(b3.getImage() == unlocked)
			b3.setToolTipText("click here to lock");
		
		l1.addMouseListener(new MouseListener() 
		{
			public void mouseDown(MouseEvent event)
			{
			}
			
			public void mouseUp(MouseEvent event)
			{
				if(b3.getSelection() == false)
					if(l1.getImage() == open)
						l1.setImage(closed);
					else
						l1.setImage(open);
				
				setToolTipText(l1);
			}
			
			public void mouseDoubleClick(MouseEvent event)
			{
			}
		});
		

		
		b1.addSelectionListener(new SelectionListener() 
		{
			public void widgetDefaultSelected(SelectionEvent event)
			{	
			}
			
			public void widgetSelected(SelectionEvent event)
			{	
				if(b1.getSelection() == false)
					l3.setEnabled(true);
				else if(b2.getSelection() == true)
					l3.setEnabled(false);
			}
		});
		
		
		b2.addSelectionListener(new SelectionListener() 
		{
			public void widgetDefaultSelected(SelectionEvent event)
			{	
			}
			
			public void widgetSelected(SelectionEvent event)
			{	
				if(b2.getSelection() == false)
					l3.setEnabled(false);
				else if(b1.getSelection() == true)
					l3.setEnabled(true);
			}
		});
		
		b3.addSelectionListener(new SelectionListener() 
		{
			public void widgetDefaultSelected(SelectionEvent event)
			{	
			}
			
			public void widgetSelected(SelectionEvent event)
			{					
				if(b3.getSelection() == false)
				{
					b1.setEnabled(true);
					b2.setEnabled(true);
					b3.setImage(unlocked);
				}
				else
				{
					b1.setEnabled(false);
					b2.setEnabled(false);
					b3.setImage(locked);
				}
				
				if(b3.getImage() == locked)
					b3.setToolTipText("click here to unlock");
				else if(b3.getImage() == unlocked)
					b3.setToolTipText("click here to lock");
			}
		});
		
	}
	
	private void setToolTipText(Label label)
	{
		if(label.getImage() == open)
			label.setToolTipText("click here to close");
		else if(label.getImage() == closed)
			label.setToolTipText("click here to open");
		else
			label.setToolTipText("the state can't be changed");
	}
	
	/**
	 * Passing the focus request to the viewer's control.
	 */
	public void setFocus() {    
	}
};