package beamlinercp;

import org.eclipse.jface.wizard.WizardPage
;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;

public class Sample1 extends WizardPage {

	private Text nameText;
	private Text descriptionText;


	public Sample1() {
		super("Sample1");
	}
	
	public void createControl(Composite parent) 
	{
		Composite composite = new Composite(parent, SWT.NONE);
		GridLayout gL = new GridLayout();
		composite.setLayout(gL);
		Label label = new Label(composite, SWT.NONE);
		label.setText("Name");
		nameText = new Text(composite, SWT.BORDER);
		nameText.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));

		Label label2 = new Label(composite, SWT.NONE);
		label2.setText("Description");
		descriptionText = new Text(composite, SWT.BORDER|SWT.MULTI);
		descriptionText.setLayoutData(new GridData(GridData.FILL_BOTH));

		
		
		
		
		nameText.addListener(SWT.Verify, new Listener() 
		{
			public void handleEvent(Event e) 
			{
				String string = e.text;
				char[] chars = new char[string.length()];
				string.getChars(0, chars.length, chars, 0);
				for (int i = 0; i < chars.length; i++) 
				{
					if ((' ' <= chars[i] && chars[i] <= ',') || ('.' <= chars[i] && chars[i] <= '/') || (':' <= chars[i] && chars[i] <= '@') || ('[' <= chars[i] && chars[i] <= '^') || chars[i] == '`' || ('{' <= chars[i] && chars[i] <= '~')) {
						e.doit = false;
						return;
					}
				}
            }
		});
		
		nameText.addKeyListener(new KeyListener()
		{
			
			public void keyPressed(KeyEvent event)
			{
			}
			
			public void keyReleased(KeyEvent event)
			{
				if(nameText.getCaretPosition() == 0 && getErrorMessage().equals("OK"))					
				{
					setErrorMessage("New sample needs a NAME");
				}
				else if(nameText.getCaretPosition() != 0 && getErrorMessage().equals("New sample needs a NAME"))		
				{
					setErrorMessage("OK");
					
				}
			
			}
		});
				
		
		setControl(composite);
		
		return;
	}
	
	public String toString() 
	{
		
		return "SAMPLE NAME: " + nameText.getText() + "\nDESCRIPTION: " + descriptionText.getText();
	}
	
	public boolean isFinished()
	{
		if(nameText.getText().equals(""))
			return false;
		return true;
	}

	
	
	
	
	
	
	
}
