package beamlinercp;

import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.Wizard;

public class NewSampleWizard extends Wizard implements INewWizard {

	private Sample1 sample1;

	public NewSampleWizard() {
	}
	
	public void init(IWorkbench workbench, IStructuredSelection selection) {
		setWindowTitle("New Sample");
		setNeedsProgressMonitor(true);
		setDefaultPageImageDescriptor(ImageDescriptor.createFromImage(new Image(Display.getCurrent(), "/home/lslezak/Desktop/img/help_hand.gif")));

	}
	
	public boolean performFinish() {
		
		System.out.println(sample1.toString());
	
		if(sample1.isFinished())
			return true;
		else
		{
			sample1.setErrorMessage("New sample needs a NAME");
			return false;
		}
	}
	
	public void addPages() {
		sample1 = new Sample1();
		sample1.setTitle("Create a new sample");
		sample1.setDescription("Choose the name and short description of the sample");
		addPage(sample1);
	}

		
	
}
