package beamlinercp;

import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.Wizard;

public class NewExperimentWizard extends Wizard implements INewWizard {

	private Experiment1 experiment1;

	public NewExperimentWizard() {
	}
	
	public void init(IWorkbench workbench, IStructuredSelection selection) {
		setWindowTitle("New Experiment");
		setNeedsProgressMonitor(true);
		setDefaultPageImageDescriptor(ImageDescriptor.createFromImage(new Image(Display.getCurrent(), "/home/lslezak/Desktop/img/help_hand.gif")));

	}
	
	public boolean performFinish() {
		
		System.out.println(experiment1.toString());
	
		if(experiment1.isFinished())
			return true;
		else
		{
			experiment1.setErrorMessage("New sample needs a NAME");
			return false;
		}
	}
	
	public void addPages() {
		experiment1 = new Experiment1();
		experiment1.setTitle("Create a new experiment");
		experiment1.setDescription("Choose a type of the new experiment");
		addPage(experiment1);
	}

		
	
}
