package beamlinercp;

import org.eclipse.jface.wizard.WizardPage;

import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;


public class Movie4 extends WizardPage {

	public Movie4() {
		super("Movie4");
	}
	
	public void createControl(Composite parent) 
	{
		Composite composite = new Composite(parent, SWT.NONE);
		GridLayout gL = new GridLayout();
		gL.numColumns = 2;
		composite.setLayout(gL);

		Label labelX = new Label(composite, SWT.NONE);
		labelX.setText("X dimension of the movie:");
	    Text textX = new Text(composite, SWT.BORDER);
	    textX.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));
	    
		Label labelY = new Label(composite, SWT.NONE);
		labelY.setText("Y dimension of the movie:");
	    Text textY = new Text(composite, SWT.BORDER);
	    textY.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));
	    
		Label labelS = new Label(composite, SWT.NONE);
	    labelS.setText("Step size for skipping files:");
	    Text textS = new Text(composite, SWT.BORDER);
	    textS.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));
	    
		Label labelN = new Label(composite, SWT.NONE);
	    labelN.setText("Name for the output file:");
	    Text textN = new Text(composite, SWT.BORDER);
	    textN.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));
	    
	    
		textN.addListener(SWT.Verify, new Listener() 
		{
			public void handleEvent(Event e) 
			{
				String string = e.text;
				char[] chars = new char[string.length()];
				string.getChars(0, chars.length, chars, 0);
				for (int i = 0; i < chars.length; i++) 
				{
					if ((' ' <= chars[i] && chars[i] <= ',') || ('.' <= chars[i] && chars[i] <= '/') || (':' <= chars[i] && chars[i] <= '@') || ('[' <= chars[i] && chars[i] <= '^') || chars[i] == '`' || ('{' <= chars[i] && chars[i] <= '~')) 
					{
						e.doit = false;
						return;
					}
				}
            }
		});

		
		textX.addListener(SWT.Verify, listener);
		textY.addListener(SWT.Verify, listener);
		textS.addListener(SWT.Verify, listener);	
				

		
		setControl(composite);
		
		return;
	}

    
	Listener listener = new Listener() 
	{
		public void handleEvent(Event e) 
		{
			String string = e.text;
			char[] chars = new char[string.length()];
			string.getChars(0, chars.length, chars, 0);
			for (int i = 0; i < chars.length; i++) 
			{
				if (!('0' <= chars[i] && chars[i] <= '9')) 
				{
					e.doit = false;
					return;
				}
			}
	    }
	};
	
	
	
}
