package beamlinercp;

import java.io.File;

import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;


public class Movie1 extends WizardPage 
{


	public Movie1() 
	{
		super("Movie1");
	}
	
	public void createControl(Composite parent) 
	{
		Composite composite = new Composite(parent, SWT.NONE);
		composite.setLayout(new FillLayout());
		createTree(composite);

		setControl(composite);
		return;
	}

	
	 /**
	  * createTree
	  */
	 private void createTree(Composite composite)
	 {
		 final Tree tree = new Tree(composite, SWT.BORDER);
		 

		 File main = new File("/mnt");
		 File roots[] = main.listFiles();
		 
		 for (int i = 0; i < roots.length; i++) 
		 {
			 TreeItem root = new TreeItem(tree, 0);
			 root.setText(roots[i].toString());
			 root.setData(roots[i]);
			 new TreeItem(root, 0);
		 }
		 
		 tree.addListener(SWT.Expand, new Listener() 
		 {
			 public void handleEvent(final Event event) 
			 {
				 final TreeItem root = (TreeItem) event.item;
				 TreeItem[] items = root.getItems();
				 for (int i = 0; i < items.length; i++) 
				 {
					 if (items[i].getData() != null)
						 return;
					 items[i].dispose();
				 }
				 File file = (File) root.getData();
				 File[] files = file.listFiles();
				 if (files == null)
					 return;
				 for (int i = 0; i < files.length; i++) 
				 {
					 if(files[i].isDirectory() == false)
						 continue;
		        	
					 TreeItem item = new TreeItem(root, 0);
					 item.setText(files[i].getName());
					 item.setData(files[i]);
					 if (files[i].isDirectory()) 
					 {
						 new TreeItem(item, 0);
					 }
				 } 	  
			 }
		 });

	 }
	
	
}
