package beamlinercp;


import org.eclipse.ui.part.ViewPart;

import org.eclipse.swt.SWT;
import org.eclipse.swt.awt.SWT_AWT;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Spinner;

import java.awt.Color;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.BasicStroke;
import java.awt.image.BufferedImage;

import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.Axis;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.ThermometerPlot;
import org.jfree.data.general.DefaultValueDataset;
import org.jfree.chart.ChartFactory;
import org.jfree.data.category.DefaultCategoryDataset;
import org.jfree.ui.RectangleInsets;
import org.jfree.chart.ChartFrame;

import java.util.Calendar;

import javax.swing.ImageIcon;
import javax.swing.JLabel;


public class LinkamView extends ViewPart 
{
	public static final String ID = "beamlinercp.LinkamView";
	private Composite top = null;
	private Runnable timer;
	private DefaultValueDataset dataset;
	private DefaultCategoryDataset chartDataset;
	private ThermometerPlot plot;
	private JFreeChart chart;
	private JFreeChart tempChart;
	private Composite swtAwtComponent;
	private JLabel lblChart;
	private BufferedImage image;
	private short temp = 0;
	private boolean control = false;
	private String startTime = null;
	
	/**
	 * This is a callback that will allow us to create the viewer and initialize
	 * it.
	 */
	public void createPartControl(Composite parent) 
	{
		top = new Composite(parent, SWT.NONE);
        top.setLayout(new FillLayout());

        createControls();
        createThermometer();

        createChart();
        
		update();
		timer.run();
        
	}

	/**
	 * Passing the focus request to the viewer's control.
	 */
	public void setFocus() 
	{
	}

	/**
	 * This method initializes composite1	
	 *
	 */
	private void createControls() 
	{
		Composite composite = new Composite(top, SWT.NONE);
		RowLayout rL = new RowLayout(SWT.VERTICAL);
		rL.fill = true;
		rL.wrap = false;
		rL.spacing = 40;
		composite.setLayout(rL);

		
		createCompositeSpinners(composite);
		createCompositeButtons(composite);
	}

	
	private void createCompositeSpinners(Composite composite) 
	{
		Composite compositeS = new Composite(composite, SWT.NONE);
		compositeS.setLayout(new FillLayout(SWT.VERTICAL));
	
		createRate(compositeS);
		createLimit(compositeS);
		
	}
	
	private void createRate(Composite composite)
	{
		
		Group group = new Group(composite, SWT.NONE);
		group.setText("rate");
		RowLayout rL = new RowLayout();
		rL.fill = true;
		group.setLayout(rL);
		
		final Spinner spinner = new Spinner(group, SWT.NONE);
		spinner.setMinimum(1);
		spinner.setMaximum(100);
		spinner.setSelection(10);
		Button button = new Button(group, SWT.ARROW | SWT.RIGHT);
		
		button.addSelectionListener(new SelectionListener() 
		{
			
			public void widgetSelected(SelectionEvent event)
			{
				spinner.setBackground(top.getDisplay().getSystemColor(SWT.COLOR_YELLOW));
			}
			
			public void widgetDefaultSelected(SelectionEvent event)
			{
			}
		});
		
		
		spinner.addModifyListener(new ModifyListener() 
		{
			
			public void modifyText(ModifyEvent event)
			{
				spinner.setBackground(top.getDisplay().getSystemColor(SWT.COLOR_WHITE));
			}
			
		});
	}

	/**
	 * This method initializes group1	
	 *
	 */
	private void createLimit(Composite composite) 
	{
		Group group = new Group(composite, SWT.NONE);
		group.setText("limit");

		RowLayout rL = new RowLayout();
		rL.fill = true;
		group.setLayout(rL);
		
		final Spinner spinner = new Spinner(group, SWT.NONE);
		spinner.setMinimum(0);
		spinner.setMaximum(999);
		spinner.setSelection(300);
		Button button = new Button(group, SWT.ARROW|SWT.RIGHT);

		button.addSelectionListener(new SelectionListener() 
		{
			
			public void widgetSelected(SelectionEvent event)
			{
				spinner.setBackground(top.getDisplay().getSystemColor(SWT.COLOR_YELLOW));
			}
			
			public void widgetDefaultSelected(SelectionEvent event)
			{
			}
		});
		
		
		spinner.addModifyListener(new ModifyListener() 
		{
			
			public void modifyText(ModifyEvent event)
			{
				spinner.setBackground(top.getDisplay().getSystemColor(SWT.COLOR_WHITE));
			}
		});
	}


	/**
	 * This method initializes composite29	
	 *
	 */
	private void createCompositeButtons(Composite composite) 
	{
		Composite compositeB = new Composite(composite, SWT.NONE);
		FillLayout fL = new FillLayout(SWT.VERTICAL);
		fL.spacing = 5;
		compositeB.setLayout(fL);
		
		final Button buttonSTA = new Button(compositeB, SWT.NONE);
		buttonSTA.setText("START");
		final Button buttonSTO = new Button(compositeB, SWT.NONE);
		buttonSTO.setText("STOP");
		final Button buttonHOL = new Button(compositeB, SWT.NONE);
		buttonHOL.setText("HOLD");
		
		buttonSTA.addSelectionListener(new SelectionListener() 
		{
			
			public void widgetSelected(SelectionEvent event)
			{
				control = true;
				Calendar calendar = Calendar.getInstance();
				String hour, minute, second;
				
				if(calendar.get(calendar.SECOND)<10)
					second = "0"+calendar.get(calendar.SECOND);
				else
					second = ""+calendar.get(calendar.SECOND);
				
				if(calendar.get(calendar.MINUTE)<10)
					minute = "0"+calendar.get(calendar.MINUTE);
				else
					minute = ""+calendar.get(calendar.MINUTE);
				
				if(calendar.get(calendar.HOUR_OF_DAY)<10)
					hour = "0"+calendar.get(calendar.HOUR_OF_DAY);
				else
					hour = ""+calendar.get(calendar.HOUR_OF_DAY);
	
				CategoryPlot plot = tempChart.getCategoryPlot();
				Axis axis = plot.getDomainAxis();
				axis.setTickLabelsVisible(false);
				axis.setLabel("START: "+startTime+"                  CURRENT TIME: "+hour+":"+minute+":"+second);
				
				startTime = hour+":"+minute+":"+second;
			}
			
			public void widgetDefaultSelected(SelectionEvent event)
			{
			}
		});


		buttonSTO.addSelectionListener(new SelectionListener() 
		{
	
			public void widgetSelected(SelectionEvent event)
			{
				control = false;
				chartDataset.clear();
				CategoryPlot plot = tempChart.getCategoryPlot();
				Axis axis = plot.getDomainAxis();
				axis.setLabel("");
			}
	
			public void widgetDefaultSelected(SelectionEvent event)
			{
			}
		});

		
		buttonHOL.addSelectionListener(new SelectionListener() 
		{
			
			public void widgetSelected(SelectionEvent event)
			{
				control = false;
			}
	
			public void widgetDefaultSelected(SelectionEvent event)
			{
			}
		});
		
	}

	private void createThermometer()
	{
        dataset = new DefaultValueDataset(new Double(83.0));

        plot = new ThermometerPlot(dataset);
        chart = new JFreeChart("",  
        		JFreeChart.DEFAULT_TITLE_FONT,
        		plot,       
        		false);          

        plot.setRange(0, 1000);
        plot.setInsets(new RectangleInsets(-3, -1, 0, 0));
    	plot.setSubrange(ThermometerPlot.NORMAL, 0.0, 400.0);
    	plot.setSubrange(ThermometerPlot.WARNING, 400.0, 700.0);
    	plot.setSubrange(ThermometerPlot.CRITICAL, 700.0, 1000.0);

        plot.setThermometerStroke(new BasicStroke(2.0f));
        plot.setThermometerPaint(Color.black);

        Color background = new Color(234,233,231);
        
        plot.setBackgroundPaint(background);
        chart.setBorderVisible(false);
        
        
        swtAwtComponent = new Composite(top, SWT.EMBEDDED);
        java.awt.Frame frame = SWT_AWT.new_Frame( swtAwtComponent );
        javax.swing.JPanel panel = new javax.swing.JPanel( );
		panel.setBackground(background);
		image = chart.createBufferedImage(150,280);
		lblChart = new JLabel();
		lblChart.setIcon(new ImageIcon(image));
		panel.add(lblChart);
		frame.add(panel);

		
		
		lblChart.addMouseListener(new MouseListener()
		{
			public void mouseReleased(MouseEvent event)
			{
			}
			public void mousePressed(MouseEvent event)
			{
			}
			public void mouseEntered(MouseEvent event)
			{
			}
			public void mouseExited(MouseEvent event)
			{
			}
			public void mouseClicked(MouseEvent event)
			{
				ChartFrame framec = new ChartFrame("Temperature", tempChart);
		        framec.pack();
		        framec.setVisible(true);
			}
		});

		
		swtAwtComponent.addControlListener(new ControlListener()
		{
			public void controlResized(ControlEvent event)
			{

				lblChart.removeAll();

				BufferedImage image;

				if(swtAwtComponent.getSize().x == 0 || swtAwtComponent.getSize().y == 0)
				{
					image = chart.createBufferedImage(100,100);

				}
				else
				{
					image = chart.createBufferedImage(150,(int)(0.95*swtAwtComponent.getSize().y));
				}
				
				lblChart.setIcon(new ImageIcon(image));

			}
			public void controlMoved(ControlEvent event)
			{
			}
		});
	}
	
	
	
	
	private void createChart()
	{
		
		chartDataset = new DefaultCategoryDataset();
		tempChart = ChartFactory.createLineChart(
				"Linkam temperature", 
				"", 
				"Temperature",
				chartDataset, 
				PlotOrientation.VERTICAL, 
				false, true, false);

	}
	
	
	private void update() 
	{
		final int time = 500;
        timer = new Runnable () 
        {
        	public void run () 
        	{
        		if(control)
        			updateTemp();
        		top.getDisplay().timerExec(time, this);
        	}
        };
		
	}
	
	private void updateTemp() 
	{

		int rand = (int)(Math.random()*10);

		if(dataset.getValue().intValue() >= 990)
			temp = 0;
		else if(dataset.getValue().intValue() <= 10)
			temp = 1;
	
		if(temp == 0)
			dataset.setValue(dataset.getValue().intValue() - rand);
		else if(temp == 1)
			dataset.setValue(dataset.getValue().intValue() + rand);
	
		
		
		plot = new ThermometerPlot(dataset);
		chart = new JFreeChart("",  
				JFreeChart.DEFAULT_TITLE_FONT,
				plot,  
				false);         
	
		plot.setRange(0, 1000);
		plot.setInsets(new RectangleInsets(-3, -1, 0, 0));
	
		plot.setSubrange(ThermometerPlot.NORMAL, 0.0, 400.0);
		plot.setSubrange(ThermometerPlot.WARNING, 400.0, 700.0);
		plot.setSubrange(ThermometerPlot.CRITICAL, 700.0, 1000.0);
	
		plot.setThermometerStroke(new BasicStroke(2.0f));
		plot.setThermometerPaint(Color.black);
		
		Color background = new Color(234,233,231);
		plot.setBackgroundPaint(background);
		chart.setBackgroundPaint(background);
		chart.setBorderVisible(false);
	
		lblChart.removeAll();
		image = chart.createBufferedImage(150,(int)(0.95*swtAwtComponent.getSize().y));
		lblChart.setIcon(new ImageIcon(image));
	
	
		//chart ...
		Calendar calendar = Calendar.getInstance();
		String hour, minute, second;
		
		if(calendar.get(calendar.SECOND)<10)
			second = "0"+calendar.get(calendar.SECOND);
		else
			second = ""+calendar.get(calendar.SECOND);
		
		if(calendar.get(calendar.MINUTE)<10)
			minute = "0"+calendar.get(calendar.MINUTE);
		else
			minute = ""+calendar.get(calendar.MINUTE);
		
		if(calendar.get(calendar.HOUR_OF_DAY)<10)
			hour = "0"+calendar.get(calendar.HOUR_OF_DAY);
		else
			hour = ""+calendar.get(calendar.HOUR_OF_DAY);
		
	
		
		chartDataset.addValue(dataset.getValue().intValue(), "Linkam", hour+":"+minute+":"+second);
		
		CategoryPlot plot = tempChart.getCategoryPlot();
		Axis axis = plot.getDomainAxis();
		axis.setTickLabelsVisible(false);
		axis.setLabel("START: "+startTime+"                  CURRENT TIME: "+hour+":"+minute+":"+second);
		
	}

	
	
}