package beamlinercp;

import org.eclipse.ui.part.ViewPart;

import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.RowLayout;



public class ExperimentStatusView extends ViewPart 
{
	public static final String ID = "beamlinercp.ExperimentStatusView";
	private Composite top = null;
	private Font font = null;


	/**
	 * createPartControl
	 */
	public void createPartControl(Composite parent) 
	{
        top = new Composite(parent, SWT.NONE);
        RowLayout gL = new RowLayout();
        gL.pack = false;
        gL.fill = true;
        top.setLayout(new FillLayout(SWT.VERTICAL));
     
        font = new Font(Display.getDefault(), "Sans", 12, SWT.BOLD);
        
        createCompositeUp();
        createCompositeDown();
	}

	/**
	 * Passing the focus request to the viewer's control.
	 */
	public void setFocus() 
	{
	}

	/**
	 * createComposite
	 */
	private void createCompositeUp() 
	{
		Composite composite = new Composite(top, SWT.NONE);
		composite.setLayout(new FillLayout());
		
		createNmber(composite);
		createInvestigator(composite);
		createSample(composite);
		createLocalContact(composite);
	}

	/**
	 * createComposite1
	 */
	private void createCompositeDown() 
	{
		Composite composite = new Composite(top, SWT.NONE);
		composite.setLayout(new FillLayout());
		
		createStart(composite);
		createEnd(composite);
	}
	
	/**
	 * createGroup
	 */
	private void createNmber(Composite composite) 
	{
		Group group = new Group(composite, SWT.NONE);
		group.setText("number");
		group.setLayout(new FillLayout());
		
		Label l = new Label(group, SWT.CENTER);
		l.setText("me024");
		l.setFont(font);
		l.setForeground(top.getDisplay().getSystemColor(SWT.COLOR_RED));
	}

	/**
	 * createGroup1
	 */
	private void createInvestigator(Composite composite) 
	{
		Group group = new Group(composite, SWT.NONE);
		group.setText("investigator");
		group.setLayout(new FillLayout());

		Label l = new Label(group, SWT.CENTER);
		l.setText("Withers");
		l.setFont(font);
		l.setForeground(top.getDisplay().getSystemColor(SWT.COLOR_RED));
	}

	/**
	 * createGroup2
	 */
	private void createSample(Composite composite) 
	{
		Group group = new Group(composite, SWT.NONE);
		group.setText("sample");
		group.setLayout(new FillLayout());

		Label l = new Label(group, SWT.CENTER);
		l.setText("au1");
		l.setFont(font);
		l.setForeground(top.getDisplay().getSystemColor(SWT.COLOR_RED));
	}


	/**
	 * createGroup4
	 */
	private void createLocalContact(Composite composite) 
	{
		Group group = new Group(composite, SWT.NONE);
		group.setText("local contact");
		group.setLayout(new FillLayout());

		Label l = new Label(group, SWT.CENTER);
		l.setText("Goetz");
		l.setFont(font);
		l.setForeground(top.getDisplay().getSystemColor(SWT.COLOR_RED));
	}

	/**
	 * createGroup5
	 */
	private void createStart(Composite composite) 
	{
		Group group = new Group(composite, SWT.NONE);
		group.setText("start");
		group.setLayout(new FillLayout());
		
		Label l = new Label(group, SWT.CENTER);
		l.setText("18:03:12 19.05.2006");
		l.setFont(font);
		l.setForeground(top.getDisplay().getSystemColor(SWT.COLOR_RED));

	}

	/**
	 * createGroup6
	 */
	private void createEnd(Composite composite) 
	{
		Group group = new Group(composite, SWT.NONE);
		group.setText("end");
		group.setLayout(new FillLayout());
		
		Label l = new Label(group, SWT.CENTER);
		l.setText("14:43:23 21.05.2006");
		l.setFont(font);
		l.setForeground(top.getDisplay().getSystemColor(SWT.COLOR_RED));
	}
	
}  