package beamlinercp;

import java.io.File;

import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;

public class Experiment1 extends WizardPage {


	private Button inB;
	private Button exB;
	private Table table;
	private Composite composite;


	public Experiment1() {
		super("Experiment1");
	}
	
	public void createControl(Composite parent) 
	{
		composite = new Composite(parent, SWT.NONE);
		GridLayout gL = new GridLayout();
		composite.setLayout(gL);
		Label label = new Label(composite, SWT.NONE);
		label.setText("Type:");
		inB = new Button(composite, SWT.RADIO);
		inB.setText("inhouse");
		exB = new Button(composite, SWT.RADIO);
		exB.setText("external");
		
		Label sepL = new Label(composite, SWT.SEPARATOR|SWT.HORIZONTAL);
		sepL.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));
		
		table = new Table(composite, SWT.SINGLE|SWT.BORDER );
	    table.setLayoutData(new GridData(GridData.FILL_BOTH));
	    table.setBackground(parent.getDisplay().getSystemColor(SWT.COLOR_TITLE_INACTIVE_BACKGROUND));
	   
		
		inB.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));
		
		inB.addSelectionListener(new SelectionListener() {
			
			public void widgetSelected(SelectionEvent event)
			{
				setRootDirectory(new File("/mnt/inhouse"));
				setDescription("Choose one of possibly inhouse experiments");
			}
			
			public void widgetDefaultSelected(SelectionEvent event)
			{
				
			}
			
		});


		exB.addSelectionListener(new SelectionListener() {
			
			public void widgetSelected(SelectionEvent event)
			{
				setRootDirectory(new File("/mnt/external"));
				setDescription("Choose one of possibly external experiments");
			}
			
			public void widgetDefaultSelected(SelectionEvent event)
			{
				
			}
			
		});
		
		
		
		setControl(composite);
		
		return;
	}
	
	
	/**
	 * setRootDirectory 
	 */
	 private void setRootDirectory(File dir) 
	 {
		 if(! (dir.exists() && dir.isDirectory()))
			 throw new IllegalArgumentException("Invalid directory. ");

		 table.removeAll();
		    
		 int tmp = 0;
		 File[] files = dir.listFiles();
		 
		 for(int i=0; files != null && i < files.length; i++) 
		 {
			 File file = files[i];
			 TableItem item;

			tmp++;

			item = new TableItem(table, SWT.NULL);
			item.setText(file.getName());
		      
			item.setBackground(tmp % 2 == 0 ? composite.getDisplay().getSystemColor(SWT.COLOR_WHITE) :
				composite.getDisplay().getSystemColor(SWT.COLOR_TITLE_INACTIVE_BACKGROUND));    
		 }

	 }
	
	
	
	public String toString() {
		if(inB.getSelection())
			return "INHOUSE" + "\nExperiment: " + table.getItem(table.getSelectionIndex());
		return "EXTERNAL" + "\nExperiment: " + table.getItem(table.getSelectionIndex());
	}
	
	public boolean isFinished()
	{
		if(table.getItem(table.getSelectionIndex()) == null)
			return false;
		return true;
	}

	
	
	
	
	
	
	
}
