package beamlinercp;

import java.io.BufferedReader;
import java.io.File;
import java.io.InputStreamReader;

import org.eclipse.jface.resource.ImageRegistry;

import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridLayout;

import org.eclipse.ui.part.ViewPart;


public class DisplayView extends ViewPart 
{
	public static final String ID = "beamlinercp.DisplayMovieView";
	private SashForm top = null;
	private SashForm sash = null;
	private Browser browser = null;
	private Composite composite = null;
	private Table table = null;
	private String glob_path = null;
	private Tree tree = null;
	private Composite topG = null;
	private Label labelInfo = null;
	private Label nameL = null;
	private Label dateL = null;
	private Button gifB = null;
	private Button edfB = null;
	
	
	/**
	 * createPartControl
	 */
	public void createPartControl(Composite parent) {
		topG = new Composite(parent, SWT.NONE);
		topG.setLayout(new FillLayout());
		
        top = new SashForm(topG, SWT.NONE);
        
        GridLayout gL = new GridLayout();
        gL.numColumns = 3;
        top.setLayout(gL);

        createTable();
        createTreeBrowser();   
	}

	/**
	 * Passing the focus request to the viewer's control.
	 */
	public void setFocus() 
	{
	}

	/**
	 * createTreeBrowser
	 */
	private void createTreeBrowser() {
		sash = new SashForm(top, SWT.None);
		sash.setLayout(new FillLayout(SWT.VERTICAL));
		sash.setOrientation(SWT.VERTICAL);
		
		createTree();
        createBrowser();
	}
	

	/**
	 * createBrowser
	 */
	private void createBrowser() 
	{
		Group compBrowser = new Group(sash, SWT.NONE);
		compBrowser.setText(".::DISPLAY::.");
		compBrowser.setLayout(new GridLayout());
		
		nameL = new Label(compBrowser, SWT.CENTER);
		nameL.setFont(new Font(Display.getDefault(), "Sans", 10, SWT.BOLD));
		nameL.setForeground(top.getDisplay().getSystemColor(SWT.COLOR_BLUE));
		nameL.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));
		dateL = new Label(compBrowser, SWT.CENTER);
		dateL.setFont(new Font(Display.getDefault(), "Sans", 10, SWT.NONE));
		dateL.setForeground(top.getDisplay().getSystemColor(SWT.COLOR_BLUE));
		dateL.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));
		
		browser = new Browser(compBrowser, SWT.BORDER);
		browser.setLayoutData(new GridData(GridData.FILL_BOTH));
		browser.setUrl("/home/lslezak/Desktop/img/preview.gif");

		Button b = new Button(compBrowser, SWT.PUSH);
		b.setText("+");
		b.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));
		
		b.addMouseListener(new MouseListener() 
		{
			public void mouseDoubleClick(MouseEvent e) 
			{
		    }
		      
			public void mouseUp(MouseEvent e) 
			{
				Shell dialog = new Shell(top.getShell(), SWT.APPLICATION_MODAL|SWT.DIALOG_TRIM);	
				dialog.setSize(545, 560);
				dialog.setLayout(new FillLayout());
		
				Browser browser = new Browser(dialog, SWT.NONE);
				browser.setUrl(glob_path + "/" + table.getItem(table.getSelectionIndex()).getText());
					  
				dialog.open();
			}
			  
			public void mouseDown(MouseEvent e) 
			{
			}
		      
		});
	}

	/**
	 * createTable
	 */
	private void createTable() 
	{
		composite = new Composite(top, SWT.NONE);
		composite.setLayout(new GridLayout());
		composite.setLayoutData(new GridData(GridData.FILL_BOTH));

		Composite filterComp = new Composite(composite, SWT.NONE);
		filterComp.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));
		filterComp.setLayout(new FillLayout());
		gifB = new Button(filterComp, SWT.CHECK);
		gifB.setText("gif");
		gifB.setSelection(true);
		edfB = new Button(filterComp, SWT.CHECK);
		edfB.setText("edf");
		edfB.setSelection(true);
		    
		table = new Table(composite, SWT.SINGLE|SWT.BORDER );
		table.setLayoutData(new GridData(GridData.FILL_BOTH));
	    
		labelInfo = new Label(composite, SWT.NONE);
		labelInfo.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));
		    

		table.addSelectionListener(new SelectionListener()
		{
			public void widgetSelected(SelectionEvent event)
			{
				String s = "", out = "";
				
				browser.setUrl(glob_path + "/" + ((TableItem)event.item).getText());
   		
				nameL.setText(((TableItem)event.item).getText());
				if(((TableItem)event.item).getText().endsWith(".edf"))
				{
					try 
					{
		    	            
						Process p = Runtime.getRuntime().exec("cat " + (glob_path + "/" + ((TableItem)event.item).getText()));
						BufferedReader stdInput = new BufferedReader(new 
		    		                 InputStreamReader(p.getInputStream()));

						while ((s = stdInput.readLine()) != null) 
							out += s;          
					}
					catch (Exception e) 
					{
						System.out.println(e);
					}
		    		 
		    		 
					int begining = out.indexOf("DATE (scan begin)");
					begining = out.indexOf("=", begining) + 2;
					int end = out.indexOf(";", begining) - 1;
					dateL.setText(out.substring(begining, end));
		    		 
		    		}
		    		else
		    			dateL.setText("");
		    	}
		    	public void widgetDefaultSelected(SelectionEvent event)
		    	{
		    	}
		    	
		    });
		    

		    gifB.addSelectionListener(new SelectionListener()
		    {
		    	public void widgetSelected(SelectionEvent event)
		    	{
		    		setRootDirectory(new File(glob_path));
		    	}
		    	public void widgetDefaultSelected(SelectionEvent event)
		    	{
		    	}
		    });
		    

		    edfB.addSelectionListener(new SelectionListener()
		    {
		    	public void widgetSelected(SelectionEvent event)
		    	{
		    		setRootDirectory(new File(glob_path));
		    	}
		    	public void widgetDefaultSelected(SelectionEvent event)
		    	{
		    	}
		    });
	}


	/**
	 * setRootDirectory 
	 */
	 private void setRootDirectory(File dir) 
	 {
		 if(! (dir.exists() && dir.isDirectory()))
			 throw new IllegalArgumentException("Invalid directory. ");

		 table.removeAll();
		    
		 int gif = 0, edf = 0, tmp = 0;
		 File[] files = dir.listFiles();
		 
		 for(int i=0; files != null && i < files.length; i++) 
		 {
			 File file = files[i];
			 TableItem item;
		      
			 if(file.getName().endsWith(".gif") || file.getName().endsWith(".edf"))
			 {

				 if(file.getName().endsWith(".gif") && gifB.getSelection() == false)
					 continue;
				 if(file.getName().endsWith(".edf") && edfB.getSelection() == false)
					 continue;

				 tmp++;

				 item = new TableItem(table, SWT.NULL);
				 item.setText(file.getName());
		      
				 item.setBackground(tmp % 2 == 0 ? top.getDisplay().getSystemColor(SWT.COLOR_WHITE) :
					 top.getDisplay().getSystemColor(SWT.COLOR_TITLE_INACTIVE_BACKGROUND));
		    	
				 if(file.getName().endsWith(".gif"))
				 {
					 gif++;
					 item.setImage(new Image(Display.getCurrent(), "/home/lslezak/Desktop/img/gif.gif"));
				 }
				 else
				 {
					 edf++;
					 item.setImage(new Image(Display.getCurrent(), "/home/lslezak/Desktop/img/edf.gif"));
				 }
		 
			 }	     
		 }
		    
		    
		 if(gif == 0)
		 {
			 if(edf == 0)
				 labelInfo.setText("");
			 else
				 labelInfo.setText(edf + " edf file(s)");
		 }
		 else
		 {
			 if(edf == 0)
				 labelInfo.setText(gif + " gif file(s)");
			 else
				 labelInfo.setText(gif + " gif file(s),  " + edf + " edf file(s)");
		 }
	 }
	
	 
	 
	 
	 /**
	  * createTree
	  */
	 private void createTree()
	 {
		 tree = new Tree(sash, SWT.BORDER);

		 File main = new File("/mnt");
		 File roots[] = main.listFiles();
		 
		 for (int i = 0; i < roots.length; i++) 
		 {
			 TreeItem root = new TreeItem(tree, 0);
			 root.setText(roots[i].toString());
			 root.setData(roots[i]);
			 new TreeItem(root, 0);
		 }
		 
		 tree.addListener(SWT.Expand, new Listener() 
		 {
			 public void handleEvent(final Event event) 
			 {
				 final TreeItem root = (TreeItem) event.item;
				 TreeItem[] items = root.getItems();
				 for (int i = 0; i < items.length; i++) 
				 {
					 if (items[i].getData() != null)
						 return;
					 items[i].dispose();
				 }
				 File file = (File) root.getData();
				 File[] files = file.listFiles();
				 if (files == null)
					 return;
				 for (int i = 0; i < files.length; i++) 
				 {
					 if(files[i].isDirectory() == false)
						 continue;
		        	
					 TreeItem item = new TreeItem(root, 0);
					 item.setText(files[i].getName());
					 item.setData(files[i]);
					 if (files[i].isDirectory()) 
					 {
						 new TreeItem(item, 0);
					 }
				 } 	        
			 }
		 });
		 
		 tree.addSelectionListener(new SelectionListener()
		 {
			 public void widgetSelected(SelectionEvent event)
			 {
		    		
				 TreeItem item = (TreeItem)event.item;
				 String path = item.getText();	  
				 do
				 {
					 if(item.getText().equals("/mnt/inhouse") || item.getText().equals("/mnt/external"))
						 break; 
					 item = item.getParentItem();
					 path = item.getText() + "/" + path;
				 }
				 while(true);
		    		
				 setRootDirectory(new File(path));
				 glob_path = path;
		    		
				 if(table.getItemCount() == 0)
					 browser.setUrl("/home/lslezak/Desktop/img/preview.gif");
			 }
		    	
		    	public void widgetDefaultSelected(SelectionEvent event)
		    	{
		    	}
		 });
		 
	 }
	 

}