package beamlinercp;

import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.window.ApplicationWindow;
import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.ui.part.ViewPart;

import fr.esrf.Tango.DevFailed;
import fr.esrf.TangoApi.DeviceData;
import fr.esrf.TangoApi.DeviceProxy;
import fr.esrf.TangoDs.Except;

/**
 * @author gotz
 *
 */
public class DiodemuxView extends ViewPart {
	public static final String ID = "beamlinercp.DiodemuxView";
	
	public static DiodemuxView thisView = null;

	DeviceProxy wagobox;
	int diode[] = new int[16];
	private Group[] outputGroup = new Group[4];
	private boolean[] outputEnabled = new boolean[4];
	private Label[] outputLabel = new Label[4];
	private Button[] diodeButton = new Button[16];
	private String[] inputString = new String[4];
	private String[] outputString = new String[4];
	private Display display;
	private boolean displayLock;
	
	Listener listener = new Listener() {

		public void handleEvent(Event event) {
			for (int i_out = 0; i_out < 4; i_out++) {
				for (int i_in = 0; i_in < 4; i_in++) {
					if (event.widget == diodeButton[i_out*4+i_in]) {
						short[] digi_out_array = new short[3];
						try {
							DeviceData digi_out = new DeviceData();
							digi_out_array[0] = (short) (i_in*4+i_out+1);
							digi_out_array[1] = 0;
							if (diodeButton[i_out*4+i_in].getSelection()) {
								digi_out_array[2] = 1;
								diode[i_out*4+i_in] = 1;
							} else {
								digi_out_array[2] = 0;
								diode[i_out*4+i_in] = 0;
							}
							digi_out.insert(digi_out_array);
							wagobox.command_inout("DevWriteDigi", digi_out);
						} catch (DevFailed e) {
							Except.print_exception(e);
						}
					}
				}
			}
			
		}
		
	};
	/**
	 * This method initializes diodeGroup	
	 *
	 */    
	private void createDiodeGroup(Composite parent) {
		Composite top = new Composite(parent, SWT.NONE);
		top.setLayout(new FillLayout());
		
		Label[] separatorLabel = new Label[4];
		inputString[0] = "Diode 1";
		inputString[1] = "Diode 2";
		inputString[2] = "Diode 3";
		inputString[3] = "Diode 4";
		outputString[0] = "Diode 1";
		outputString[1] = "Diode 2";
		outputString[2] = "Diode 3";
		outputString[3] = "Diode 4";
		outputEnabled[0] = true;
		outputEnabled[1] = true;
		outputEnabled[2] = true;
		outputEnabled[3] = true;
		displayLock = true;
	/*	inputString[0] = store.getString(PreferenceConstants.P_INPUT_1);
		inputString[1] = store.getString(PreferenceConstants.P_INPUT_2);
		inputString[2] = store.getString(PreferenceConstants.P_INPUT_3);
		inputString[3] = store.getString(PreferenceConstants.P_INPUT_4);
		outputString[0] = store.getString(PreferenceConstants.P_OUTPUT_1);
		outputString[1] = store.getString(PreferenceConstants.P_OUTPUT_2);
		outputString[2] = store.getString(PreferenceConstants.P_OUTPUT_3);
		outputString[3] = store.getString(PreferenceConstants.P_OUTPUT_4);
		outputEnabled[0] = store.getBoolean(PreferenceConstants.P_ENABLE_1);
		outputEnabled[1] = store.getBoolean(PreferenceConstants.P_ENABLE_2);
		outputEnabled[2] = store.getBoolean(PreferenceConstants.P_ENABLE_3);
		outputEnabled[3] = store.getBoolean(PreferenceConstants.P_ENABLE_4);
		displayLock = store.getBoolean(PreferenceConstants.P_LOCK);
*/		for (int i_out = 0; i_out < 4; i_out++) {
			outputGroup[i_out] = new Group(top, SWT.NONE);
			Layout rowLayout = new GridLayout();
			outputGroup[i_out].setLayout(rowLayout);
			outputGroup[i_out].setBounds(new org.eclipse.swt.graphics.Rectangle(0,0,400,150));
			outputLabel[i_out] = new Label(outputGroup[i_out], SWT.NONE);
			outputLabel[i_out].setBounds(0,0,40,150);
			outputLabel[i_out].setText(outputString[i_out]);
			outputLabel[i_out].setAlignment(SWT.CENTER);
			separatorLabel[i_out] = new Label(outputGroup[i_out], SWT.SEPARATOR | SWT.HORIZONTAL);
			separatorLabel[i_out].setBounds(0,0,40,150);
			for (int i_in = 0; i_in < 4; i_in++) {
				diodeButton[i_out * 4 + i_in] = new Button(outputGroup[i_out], SWT.RADIO);
				diodeButton[i_out*4 + i_in].setBounds(0,0,40,150);
				diodeButton[i_out * 4 + i_in].setText(inputString[i_in]);
				if (diode[i_out * 4 + i_in] == (short) 1)
					diodeButton[i_out * 4 + i_in].setSelection(true);
				diodeButton[i_out*4+i_in].addListener(SWT.Selection, listener);
			}
			enableOutput(i_out+1,outputEnabled[i_out]);
		}
// only uncomment this once I have found out how to update the status line at startup
//		lockDisplay(displayLock);
	}
	
	/**
	 * change label of corresponding input
	 * 
	 * @param input
	 * @param label
	 */
	public void setInputLabel(int input, String label) {
		String bla ;
		if (input > 0 && input < 5)
		{ 
			for (int i_out=0; i_out<4; i_out++)
			{
				diodeButton[i_out*4+input-1].setText(label);
			}
		}
	}
	
	/**
	 * change output labels
	 * 
	 * @param output
	 * @param label
	 */
	public void setOutputLabel(int output, String label) {
		if (output > 0 && output < 5)
		{
			outputLabel[output-1].setText(label);
		}
	}

	/**
	 * enable/disable output
	 * 
	 * @param output
	 * @param enabled
	 */
	public void enableOutput(int output, boolean enabled) {
		outputEnabled[output-1] = enabled;
		if (output > 0 && output < 5)
		{
			outputGroup[output-1].setEnabled(enabled);
			outputLabel[output-1].setEnabled(enabled);
			if (enabled)
			{
				outputLabel[output-1].setText(outputString[output-1]);
			}
			else
			{
				outputLabel[output-1].setText("output disabled");
			}
			for (int i_in=0; i_in<4; i_in++)
			{
				diodeButton[(output-1)*4+i_in].setEnabled(enabled);
			}
		}
	}
	
	public void lockDisplay(boolean lock)
	{
		for (int i_out=0; i_out<4; i_out++)
		{
			boolean enable = !lock;
			if (outputEnabled[i_out])
			{
				outputGroup[i_out].setEnabled(enable);
				outputLabel[i_out].setEnabled(enable);
				for (int i_in=0; i_in<4; i_in++)
				{
					diodeButton[i_out*4+i_in].setEnabled(enable);
				}
			}
		}
/*		if (lock) {
			((ApplicationWindow) (DiodemuxPlugin.getDefault()).getWorkbench()
					.getActiveWorkbenchWindow())
					.setStatus("Locked - use Edit -> Preferences to unlock");
		} else {
			((ApplicationWindow) (DiodemuxPlugin.getDefault()).getWorkbench()
					.getActiveWorkbenchWindow())
					.setStatus(" ");
		}
*/	}

	private void initialize() {
		thisView = this;
		/*try {
			wagobox = new DeviceProxy("taco:id11/wago/mux");
			// to avoid timeouts set the protocol to TCP
			wagobox.set_rpc_protocol(fr.esrf.TacoApi.TacoDevice.PROTOCOL_TCP);
			readDiode();
		} catch (DevFailed e) {
			System.out.println("initialize(): could not create device proxy");
			Except.print_exception(e);
		}*/
	}

	/**
	 * This is a callback that will allow us to create the viewer and initialize
	 * it.
	 */
	public void createPartControl(Composite parent) {
		display = parent.getDisplay();
		initialize();
		createDiodeGroup(parent);
		updateDiode(parent);
	}

	synchronized private void readDiode()
	{
		/*	for (int i = 1; i < 17; i++) {
				try {
					DeviceData digi_in = new DeviceData();
					digi_in.insert((short)i);
					DeviceData digi_out = wagobox.command_inout("DevReadNoCacheDigi", digi_in);
					short digi_out_array[];
					digi_out_array = digi_out.extractShortArray();
					diode[i - 1] = digi_out_array[0];
				} catch (DevFailed e) {
					System.out.println("readDiode(): could not read diode "+String.valueOf(i));
					 Except.print_exception_stack(e);
				}
			}*/
	}

	
	/**
	 * drawDiode() - will populate the buttons with the current selections
	 * 				 Note that the diode values are read with the outputs
	 * 				 index changing first while the buttons are created
	 * 				 with the input index changing first - i.e. the two
	 * 				 arrays are transposed wrt to each other.
	 * 
	 */
	synchronized private void drawDiode() {
		for (int i_out = 0; i_out < 4; i_out++) {
			for (int i_in = 0; i_in < 4; i_in++) {
				if (diode[i_in*4 + i_out] == (short) 1) {
					if (!diodeButton[i_out*4 + i_in].isDisposed()) {
						diodeButton[i_out*4 + i_in].setSelection(true);
					}
				} else {
					if (!diodeButton[i_out*4 + i_in].isDisposed()) {
						diodeButton[i_out*4 + i_in].setSelection(false);
					}
				}
			}
		}
	}
	
	private void updateDiode(Composite parent) {
/*		final int time = 1000;
		
// timer thread to update the diode mux gui asynchronously
		
		Runnable timer = new Runnable () {
			public void run () {
				readDiode();
				drawDiode();
				display.timerExec (time, this);
			}
		};

		display.timerExec (time, timer);*/
	}
	
	/**
	 * Passing the focus request to the viewer's control.
	 */
	public void setFocus() {
		outputGroup[0].setFocus();
	}
}